// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import { readOnlyBinaryProperty, readOnlyProperty, frozenClass, } from './immutable_class';
import { needs } from './needs';
export class EncryptedDataKey {
    constructor(edkInput) {
        const { providerInfo, providerId, encryptedDataKey, rawInfo } = edkInput;
        needs(typeof providerInfo === 'string' &&
            providerInfo &&
            typeof providerId === 'string' &&
            providerId &&
            encryptedDataKey instanceof Uint8Array &&
            encryptedDataKey.byteLength, 'Malformed encrypted data key');
        readOnlyProperty(this, 'providerInfo', providerInfo);
        readOnlyProperty(this, 'providerId', providerId);
        readOnlyBinaryProperty(this, 'encryptedDataKey', encryptedDataKey);
        if (rawInfo instanceof Uint8Array) {
            readOnlyBinaryProperty(this, 'rawInfo', rawInfo);
        }
        else {
            readOnlyProperty(this, 'rawInfo', undefined);
        }
        Object.setPrototypeOf(this, EncryptedDataKey.prototype);
        Object.freeze(this);
    }
}
frozenClass(EncryptedDataKey);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5jcnlwdGVkX2RhdGFfa2V5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2VuY3J5cHRlZF9kYXRhX2tleS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxvRUFBb0U7QUFDcEUsc0NBQXNDO0FBRXRDLE9BQU8sRUFDTCxzQkFBc0IsRUFDdEIsZ0JBQWdCLEVBQ2hCLFdBQVcsR0FDWixNQUFNLG1CQUFtQixDQUFBO0FBQzFCLE9BQU8sRUFBRSxLQUFLLEVBQUUsTUFBTSxTQUFTLENBQUE7QUFnQy9CLE1BQU0sT0FBTyxnQkFBZ0I7SUFNM0IsWUFBWSxRQUEyQjtRQUNyQyxNQUFNLEVBQUUsWUFBWSxFQUFFLFVBQVUsRUFBRSxnQkFBZ0IsRUFBRSxPQUFPLEVBQUUsR0FBRyxRQUFRLENBQUE7UUFDeEUsS0FBSyxDQUNILE9BQU8sWUFBWSxLQUFLLFFBQVE7WUFDOUIsWUFBWTtZQUNaLE9BQU8sVUFBVSxLQUFLLFFBQVE7WUFDOUIsVUFBVTtZQUNWLGdCQUFnQixZQUFZLFVBQVU7WUFDdEMsZ0JBQWdCLENBQUMsVUFBVSxFQUM3Qiw4QkFBOEIsQ0FDL0IsQ0FBQTtRQUVELGdCQUFnQixDQUFDLElBQUksRUFBRSxjQUFjLEVBQUUsWUFBWSxDQUFDLENBQUE7UUFDcEQsZ0JBQWdCLENBQUMsSUFBSSxFQUFFLFlBQVksRUFBRSxVQUFVLENBQUMsQ0FBQTtRQUNoRCxzQkFBc0IsQ0FBQyxJQUFJLEVBQUUsa0JBQWtCLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQTtRQUNsRSxJQUFJLE9BQU8sWUFBWSxVQUFVLEVBQUU7WUFDakMsc0JBQXNCLENBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRSxPQUFPLENBQUMsQ0FBQTtTQUNqRDthQUFNO1lBQ0wsZ0JBQWdCLENBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRSxTQUFTLENBQUMsQ0FBQTtTQUM3QztRQUVELE1BQU0sQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLGdCQUFnQixDQUFDLFNBQVMsQ0FBQyxDQUFBO1FBQ3ZELE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUE7SUFDckIsQ0FBQztDQUNGO0FBRUQsV0FBVyxDQUFDLGdCQUFnQixDQUFDLENBQUEifQ==