/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.cluster;

import java.util.Objects;
import org.opensearch.client.cluster.RemoteConnectionInfo;

public class ProxyModeInfo
implements RemoteConnectionInfo.ModeInfo {
    static final String NAME = "proxy";
    static final String PROXY_ADDRESS = "proxy_address";
    static final String SERVER_NAME = "server_name";
    static final String NUM_PROXY_SOCKETS_CONNECTED = "num_proxy_sockets_connected";
    static final String MAX_PROXY_SOCKET_CONNECTIONS = "max_proxy_socket_connections";
    private final String address;
    private final String serverName;
    private final int maxSocketConnections;
    private final int numSocketsConnected;

    ProxyModeInfo(String address, String serverName, int maxSocketConnections, int numSocketsConnected) {
        this.address = address;
        this.serverName = serverName;
        this.maxSocketConnections = maxSocketConnections;
        this.numSocketsConnected = numSocketsConnected;
    }

    @Override
    public boolean isConnected() {
        return this.numSocketsConnected > 0;
    }

    @Override
    public String modeName() {
        return NAME;
    }

    public String getAddress() {
        return this.address;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getMaxSocketConnections() {
        return this.maxSocketConnections;
    }

    public int getNumSocketsConnected() {
        return this.numSocketsConnected;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyModeInfo otherProxy = (ProxyModeInfo)o;
        return this.maxSocketConnections == otherProxy.maxSocketConnections && this.numSocketsConnected == otherProxy.numSocketsConnected && Objects.equals(this.address, otherProxy.address) && Objects.equals(this.serverName, otherProxy.serverName);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.serverName, this.maxSocketConnections, this.numSocketsConnected);
    }

    public String toString() {
        return "ProxyModeInfo{address='" + this.address + "', serverName='" + this.serverName + "', maxSocketConnections=" + this.maxSocketConnections + ", numSocketsConnected=" + this.numSocketsConnected + "}";
    }
}

