/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.changes.GitChangeUtils;
import git4idea.i18n.GitBundle;
import git4idea.index.GitFileStatus;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class GitChangesCollector {
    private static final Logger LOG = Logger.getInstance(GitChangesCollector.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myVcsRoot;
    private final VcsRevisionNumber myHead;
    private final Collection<Change> myChanges;

    @NotNull
    static GitChangesCollector collect(@NotNull Project project, @NotNull GitRepository repository2, @NotNull List<GitFileStatus> changes) throws VcsException {
        if (project == null) {
            GitChangesCollector.$$$reportNull$$$0(0);
        }
        if (repository2 == null) {
            GitChangesCollector.$$$reportNull$$$0(1);
        }
        if (changes == null) {
            GitChangesCollector.$$$reportNull$$$0(2);
        }
        VcsRevisionNumber head = GitChangesCollector.getHead(repository2);
        GitChangesCollector collector = new GitChangesCollector(project, repository2.getRoot(), head);
        collector.collectChanges(changes);
        GitChangesCollector gitChangesCollector = collector;
        if (gitChangesCollector == null) {
            GitChangesCollector.$$$reportNull$$$0(3);
        }
        return gitChangesCollector;
    }

    @NotNull
    VcsRevisionNumber getHead() {
        VcsRevisionNumber vcsRevisionNumber = this.myHead;
        if (vcsRevisionNumber == null) {
            GitChangesCollector.$$$reportNull$$$0(4);
        }
        return vcsRevisionNumber;
    }

    @NotNull
    Collection<Change> getChanges() {
        Collection<Change> collection = this.myChanges;
        if (collection == null) {
            GitChangesCollector.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private GitChangesCollector(@NotNull Project project, @NotNull VirtualFile root, @NotNull VcsRevisionNumber head) {
        if (project == null) {
            GitChangesCollector.$$$reportNull$$$0(6);
        }
        if (root == null) {
            GitChangesCollector.$$$reportNull$$$0(7);
        }
        if (head == null) {
            GitChangesCollector.$$$reportNull$$$0(8);
        }
        this.myChanges = new HashSet<Change>();
        this.myProject = project;
        this.myVcsRoot = root;
        this.myHead = head;
    }

    private void collectChanges(List<GitFileStatus> changes) throws VcsException {
        ArrayList<FilePath> bothModifiedPaths = new ArrayList<FilePath>();
        for (GitFileStatus change : changes) {
            char xStatus = change.getIndex();
            char yStatus = change.getWorkTree();
            FilePath filepath = change.getPath();
            FilePath oldFilepath = change.getOrigPath();
            switch (xStatus) {
                case ' ': {
                    if (yStatus == 'M') {
                        this.reportModified(filepath);
                        break;
                    }
                    if (yStatus == 'D') {
                        this.reportDeleted(filepath);
                        break;
                    }
                    if (yStatus == 'A' || yStatus == 'C') {
                        this.reportAdded(filepath);
                        break;
                    }
                    if (yStatus == 'T') {
                        this.reportTypeChanged(filepath);
                        break;
                    }
                    if (yStatus == 'U') {
                        this.reportConflict(filepath);
                        break;
                    }
                    if (yStatus == 'R') {
                        this.reportRename(filepath, oldFilepath);
                        break;
                    }
                    GitChangesCollector.throwStatus(xStatus, yStatus);
                    break;
                }
                case 'M': {
                    if (yStatus == 'M') {
                        bothModifiedPaths.add(filepath);
                        break;
                    }
                    if (yStatus == ' ' || yStatus == 'T') {
                        this.reportModified(filepath);
                        break;
                    }
                    if (yStatus == 'D') {
                        this.reportDeleted(filepath);
                        break;
                    }
                    GitChangesCollector.throwStatus(xStatus, yStatus);
                    break;
                }
                case 'A': 
                case 'C': {
                    if (yStatus == 'M' || yStatus == ' ' || yStatus == 'T') {
                        this.reportAdded(filepath);
                        break;
                    }
                    if (yStatus == 'D') break;
                    if (yStatus == 'U') {
                        this.reportConflict(filepath);
                        break;
                    }
                    if (yStatus == 'A') {
                        this.reportConflict(filepath);
                        break;
                    }
                    GitChangesCollector.throwStatus(xStatus, yStatus);
                    break;
                }
                case 'D': {
                    if (yStatus == 'M' || yStatus == ' ' || yStatus == 'T') {
                        this.reportDeleted(filepath);
                        break;
                    }
                    if (yStatus == 'U') {
                        this.reportConflict(filepath);
                        break;
                    }
                    if (yStatus == 'D') {
                        this.reportConflict(filepath);
                        break;
                    }
                    if (yStatus == 'C') {
                        this.reportModified(filepath);
                        break;
                    }
                    if (yStatus == 'R') {
                        this.reportRename(filepath, oldFilepath);
                        break;
                    }
                    if (yStatus == 'A') {
                        this.reportModified(filepath);
                        break;
                    }
                    GitChangesCollector.throwStatus(xStatus, yStatus);
                    break;
                }
                case 'U': {
                    if (yStatus == 'U' || yStatus == 'T') {
                        this.reportConflict(filepath);
                        break;
                    }
                    if (yStatus == 'A') {
                        this.reportConflict(filepath);
                        break;
                    }
                    if (yStatus == 'D') {
                        this.reportConflict(filepath);
                        break;
                    }
                    GitChangesCollector.throwStatus(xStatus, yStatus);
                    break;
                }
                case 'R': {
                    if (yStatus == 'D') {
                        this.reportDeleted(oldFilepath);
                        break;
                    }
                    if (yStatus == ' ' || yStatus == 'M' || yStatus == 'T') {
                        this.reportRename(filepath, oldFilepath);
                        break;
                    }
                    GitChangesCollector.throwStatus(xStatus, yStatus);
                    break;
                }
                case 'T': {
                    if (yStatus == ' ' || yStatus == 'M') {
                        this.reportTypeChanged(filepath);
                        break;
                    }
                    if (yStatus == 'D') {
                        this.reportDeleted(filepath);
                        break;
                    }
                    if (yStatus == 'T') {
                        this.reportConflict(filepath);
                        break;
                    }
                    GitChangesCollector.throwStatus(xStatus, yStatus);
                    break;
                }
                default: {
                    GitChangesCollector.throwStatus(xStatus, yStatus);
                }
            }
        }
        this.collectStagedUnstagedModifications(bothModifiedPaths);
    }

    private void collectStagedUnstagedModifications(@NotNull List<FilePath> bothModifiedPaths) throws VcsException {
        if (bothModifiedPaths == null) {
            GitChangesCollector.$$$reportNull$$$0(9);
        }
        if (bothModifiedPaths.isEmpty()) {
            return;
        }
        Collection<GitChangeUtils.GitDiffChange> changes = GitChangeUtils.getWorkingTreeChanges(this.myProject, this.myVcsRoot, bothModifiedPaths, false);
        HashSet<FilePath> expectedPaths = new HashSet<FilePath>(bothModifiedPaths);
        for (GitChangeUtils.GitDiffChange change : changes) {
            FilePath filePath = change.getFilePath();
            if (!expectedPaths.contains(filePath)) continue;
            this.reportModified(filePath);
        }
    }

    @NotNull
    static VcsRevisionNumber getHead(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitChangesCollector.$$$reportNull$$$0(10);
        }
        repository2.update();
        String rev = repository2.getCurrentRevision();
        Object object = rev != null ? new GitRevisionNumber(rev) : VcsRevisionNumber.NULL;
        if (object == null) {
            GitChangesCollector.$$$reportNull$$$0(11);
        }
        return object;
    }

    private static void throwStatus(char xStatus, char yStatus) throws VcsException {
        throw new VcsException(GitBundle.message("status.exception.message.unexpected.xstatus.ystatus", Character.valueOf(xStatus), Character.valueOf(yStatus)));
    }

    private void reportModified(FilePath filepath) {
        ContentRevision before = GitContentRevision.createRevision(filepath, this.myHead, this.myProject);
        ContentRevision after = GitContentRevision.createRevision(filepath, null, this.myProject);
        this.reportChange(FileStatus.MODIFIED, before, after);
    }

    private void reportTypeChanged(FilePath filepath) {
        ContentRevision before = GitContentRevision.createRevision(filepath, this.myHead, this.myProject);
        ContentRevision after = GitContentRevision.createRevisionForTypeChange(filepath, null, this.myProject);
        this.reportChange(FileStatus.MODIFIED, before, after);
    }

    private void reportAdded(FilePath filepath) {
        ContentRevision before = null;
        ContentRevision after = GitContentRevision.createRevision(filepath, null, this.myProject);
        this.reportChange(FileStatus.ADDED, before, after);
    }

    private void reportDeleted(FilePath filepath) {
        ContentRevision before = GitContentRevision.createRevision(filepath, this.myHead, this.myProject);
        ContentRevision after = null;
        this.reportChange(FileStatus.DELETED, before, after);
    }

    private void reportRename(FilePath filepath, FilePath oldFilepath) {
        ContentRevision before = GitContentRevision.createRevision(oldFilepath, this.myHead, this.myProject);
        ContentRevision after = GitContentRevision.createRevision(filepath, null, this.myProject);
        this.reportChange(FileStatus.MODIFIED, before, after);
    }

    private void reportConflict(FilePath filepath) {
        ContentRevision before = GitContentRevision.createRevision(filepath, this.myHead, this.myProject);
        ContentRevision after = GitContentRevision.createRevision(filepath, null, this.myProject);
        this.reportChange(FileStatus.MERGED_WITH_CONFLICTS, before, after);
    }

    private void reportChange(FileStatus status, ContentRevision before, ContentRevision after) {
        this.myChanges.add(new Change(before, after, status));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/status/GitChangesCollector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "head";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bothModifiedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/status/GitChangesCollector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 4: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHead";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectStagedUnstagedModifications";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHead";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 11 -> new IllegalStateException(string);
        };
    }
}

