# ruff: noqa: F401
"""The DuckDB Python Package.

This module re-exports the DuckDB C++ extension (`_duckdb`) and provides DuckDB's public API.

Note:
- Some symbols exposed here are implementation details of DuckDB's C++ engine.
- They are kept for backwards compatibility but are not considered stable API.
- Future versions may move them into submodules with deprecation warnings.
"""

from _duckdb import (
    BinderException,
    CaseExpression,
    CatalogException,
    CoalesceOperator,
    ColumnExpression,
    ConnectionException,
    ConstantExpression,
    ConstraintException,
    ConversionException,
    CSVLineTerminator,
    DatabaseError,
    DataError,
    DefaultExpression,
    DependencyException,
    DuckDBPyConnection,
    DuckDBPyRelation,
    Error,
    ExpectedResultType,
    ExplainType,
    Expression,
    FatalException,
    FunctionExpression,
    HTTPException,
    IntegrityError,
    InternalError,
    InternalException,
    InterruptException,
    InvalidInputException,
    InvalidTypeException,
    IOException,
    LambdaExpression,
    NotImplementedException,
    NotSupportedError,
    OperationalError,
    OutOfMemoryException,
    OutOfRangeException,
    ParserException,
    PermissionException,
    ProgrammingError,
    PythonExceptionHandling,
    RenderMode,
    SequenceException,
    SerializationException,
    SQLExpression,
    StarExpression,
    Statement,
    StatementType,
    SyntaxException,
    TransactionException,
    TypeMismatchException,
    Warning,
    __formatted_python_version__,
    __git_revision__,
    __interactive__,
    __jupyter__,
    __standard_vector_size__,
    _clean_default_connection,
    aggregate,
    alias,
    apilevel,
    append,
    array_type,
    arrow,
    begin,
    checkpoint,
    close,
    commit,
    connect,
    create_function,
    cursor,
    decimal_type,
    default_connection,
    description,
    df,
    distinct,
    dtype,
    duplicate,
    enum_type,
    execute,
    executemany,
    extract_statements,
    fetch_arrow_table,
    fetch_df,
    fetch_df_chunk,
    fetch_record_batch,
    fetchall,
    fetchdf,
    fetchmany,
    fetchnumpy,
    fetchone,
    filesystem_is_registered,
    filter,
    from_arrow,
    from_csv_auto,
    from_df,
    from_parquet,
    from_query,
    get_table_names,
    install_extension,
    interrupt,
    limit,
    list_filesystems,
    list_type,
    load_extension,
    map_type,
    order,
    paramstyle,
    pl,
    project,
    query,
    query_df,
    query_progress,
    read_csv,
    read_json,
    read_parquet,
    register,
    register_filesystem,
    remove_function,
    rollback,
    row_type,
    rowcount,
    set_default_connection,
    sql,
    sqltype,
    string_type,
    struct_type,
    table,
    table_function,
    tf,
    threadsafety,
    token_type,
    tokenize,
    torch,
    type,
    union_type,
    unregister,
    unregister_filesystem,
    values,
    view,
    write_csv,
)

from duckdb._dbapi_type_object import (
    BINARY,
    DATETIME,
    NUMBER,
    ROWID,
    STRING,
    DBAPITypeObject,
)
from duckdb._version import (
    __duckdb_version__,
    __version__,
    version,
)
from duckdb.value.constant import (
    BinaryValue,
    BitValue,
    BlobValue,
    BooleanValue,
    DateValue,
    DecimalValue,
    DoubleValue,
    FloatValue,
    HugeIntegerValue,
    IntegerValue,
    IntervalValue,
    ListValue,
    LongValue,
    MapValue,
    NullValue,
    ShortValue,
    StringValue,
    StructValue,
    TimestampMilisecondValue,
    TimestampNanosecondValue,
    TimestampSecondValue,
    TimestampTimeZoneValue,
    TimestampValue,
    TimeTimeZoneValue,
    TimeValue,
    UnionType,
    UnsignedBinaryValue,
    UnsignedHugeIntegerValue,
    UnsignedIntegerValue,
    UnsignedLongValue,
    UnsignedShortValue,
    UUIDValue,
    Value,
)

__all__: list[str] = [
    "BinaryValue",
    "BinderException",
    "BitValue",
    "BlobValue",
    "BooleanValue",
    "CSVLineTerminator",
    "CaseExpression",
    "CatalogException",
    "CoalesceOperator",
    "ColumnExpression",
    "ConnectionException",
    "ConstantExpression",
    "ConstraintException",
    "ConversionException",
    "DataError",
    "DatabaseError",
    "DateValue",
    "DecimalValue",
    "DefaultExpression",
    "DependencyException",
    "DoubleValue",
    "DuckDBPyConnection",
    "DuckDBPyRelation",
    "Error",
    "ExpectedResultType",
    "ExplainType",
    "Expression",
    "FatalException",
    "FloatValue",
    "FunctionExpression",
    "HTTPException",
    "HugeIntegerValue",
    "IOException",
    "IntegerValue",
    "IntegrityError",
    "InternalError",
    "InternalException",
    "InterruptException",
    "IntervalValue",
    "InvalidInputException",
    "InvalidTypeException",
    "LambdaExpression",
    "ListValue",
    "LongValue",
    "MapValue",
    "NotImplementedException",
    "NotSupportedError",
    "NullValue",
    "OperationalError",
    "OutOfMemoryException",
    "OutOfRangeException",
    "ParserException",
    "PermissionException",
    "ProgrammingError",
    "PythonExceptionHandling",
    "RenderMode",
    "SQLExpression",
    "SequenceException",
    "SerializationException",
    "ShortValue",
    "StarExpression",
    "Statement",
    "StatementType",
    "StringValue",
    "StructValue",
    "SyntaxException",
    "TimeTimeZoneValue",
    "TimeValue",
    "TimestampMilisecondValue",
    "TimestampNanosecondValue",
    "TimestampSecondValue",
    "TimestampTimeZoneValue",
    "TimestampValue",
    "TransactionException",
    "TypeMismatchException",
    "UUIDValue",
    "UnionType",
    "UnsignedBinaryValue",
    "UnsignedHugeIntegerValue",
    "UnsignedIntegerValue",
    "UnsignedLongValue",
    "UnsignedShortValue",
    "Value",
    "Warning",
    "__formatted_python_version__",
    "__git_revision__",
    "__interactive__",
    "__jupyter__",
    "__standard_vector_size__",
    "__version__",
    "_clean_default_connection",
    "aggregate",
    "alias",
    "apilevel",
    "append",
    "array_type",
    "arrow",
    "begin",
    "checkpoint",
    "close",
    "commit",
    "connect",
    "create_function",
    "cursor",
    "decimal_type",
    "default_connection",
    "description",
    "df",
    "distinct",
    "dtype",
    "duplicate",
    "enum_type",
    "execute",
    "executemany",
    "extract_statements",
    "fetch_arrow_table",
    "fetch_df",
    "fetch_df_chunk",
    "fetch_record_batch",
    "fetchall",
    "fetchdf",
    "fetchmany",
    "fetchnumpy",
    "fetchone",
    "filesystem_is_registered",
    "filter",
    "from_arrow",
    "from_csv_auto",
    "from_df",
    "from_parquet",
    "from_query",
    "get_table_names",
    "install_extension",
    "interrupt",
    "limit",
    "list_filesystems",
    "list_type",
    "load_extension",
    "map_type",
    "order",
    "paramstyle",
    "paramstyle",
    "pl",
    "project",
    "query",
    "query_df",
    "query_progress",
    "read_csv",
    "read_json",
    "read_parquet",
    "register",
    "register_filesystem",
    "remove_function",
    "rollback",
    "row_type",
    "rowcount",
    "set_default_connection",
    "sql",
    "sqltype",
    "string_type",
    "struct_type",
    "table",
    "table_function",
    "tf",
    "threadsafety",
    "threadsafety",
    "token_type",
    "tokenize",
    "torch",
    "type",
    "union_type",
    "unregister",
    "unregister_filesystem",
    "values",
    "view",
    "write_csv",
]
