/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_CLIENT_PROTOCOL_H
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_treeland_foreign_toplevel_manager_v1 The treeland_foreign_toplevel_manager_v1 protocol
 * @section page_ifaces_treeland_foreign_toplevel_manager_v1 Interfaces
 * - @subpage page_iface_treeland_foreign_toplevel_manager_v1 - foreign toplevel manager
 * - @subpage page_iface_treeland_foreign_toplevel_handle_v1 - An opened toplevel
 * - @subpage page_iface_treeland_dock_preview_context_v1 - handle dock preview
 * @section page_copyright_treeland_foreign_toplevel_manager_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_dock_preview_context_v1;
struct treeland_foreign_toplevel_handle_v1;
struct treeland_foreign_toplevel_manager_v1;
struct wl_output;
struct wl_seat;
struct wl_surface;

#ifndef TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_INTERFACE
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_foreign_toplevel_manager_v1 treeland_foreign_toplevel_manager_v1
 * @section page_iface_treeland_foreign_toplevel_manager_v1_desc Description
 *
 * This interface allows a client to get toplevel some info.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_foreign_toplevel_manager_v1_api API
 * See @ref iface_treeland_foreign_toplevel_manager_v1.
 */
/**
 * @defgroup iface_treeland_foreign_toplevel_manager_v1 The treeland_foreign_toplevel_manager_v1 interface
 *
 * This interface allows a client to get toplevel some info.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_foreign_toplevel_manager_v1_interface;
#endif
#ifndef TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_INTERFACE
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_INTERFACE
/**
 * @page page_iface_treeland_foreign_toplevel_handle_v1 treeland_foreign_toplevel_handle_v1
 * @section page_iface_treeland_foreign_toplevel_handle_v1_desc Description
 *
 * A treeland_foreign_toplevel_handle_v1 object represents an opened toplevel window. Each
 * app may have multiple opened toplevels.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_foreign_toplevel_handle_v1_api API
 * See @ref iface_treeland_foreign_toplevel_handle_v1.
 */
/**
 * @defgroup iface_treeland_foreign_toplevel_handle_v1 The treeland_foreign_toplevel_handle_v1 interface
 *
 * A treeland_foreign_toplevel_handle_v1 object represents an opened toplevel window. Each
 * app may have multiple opened toplevels.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_foreign_toplevel_handle_v1_interface;
#endif
#ifndef TREELAND_DOCK_PREVIEW_CONTEXT_V1_INTERFACE
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_dock_preview_context_v1 treeland_dock_preview_context_v1
 * @section page_iface_treeland_dock_preview_context_v1_desc Description
 *
 * This interface allows dock set windows preview.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_dock_preview_context_v1_api API
 * See @ref iface_treeland_dock_preview_context_v1.
 */
/**
 * @defgroup iface_treeland_dock_preview_context_v1 The treeland_dock_preview_context_v1 interface
 *
 * This interface allows dock set windows preview.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_dock_preview_context_v1_interface;
#endif

/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 * @struct treeland_foreign_toplevel_manager_v1_listener
 */
struct treeland_foreign_toplevel_manager_v1_listener {
	/**
	 * a toplevel has been created
	 *
	 * This event is emitted whenever a new toplevel window is
	 * created. It is emitted for all toplevels, regardless of the app
	 * that has created them.
	 *
	 * All initial details of the toplevel(title, app_id, states, etc.)
	 * will be sent immediately after this event via the corresponding
	 * events in treeland_foreign_toplevel_handle_v1.
	 */
	void (*toplevel)(void *data,
			 struct treeland_foreign_toplevel_manager_v1 *treeland_foreign_toplevel_manager_v1,
			 struct treeland_foreign_toplevel_handle_v1 *toplevel);
	/**
	 * the compositor has finished with the toplevel manager
	 *
	 * This event indicates that the compositor is done sending
	 * events to the treeland_foreign_toplevel_manager_v1. The server
	 * will destroy the object immediately after sending this request,
	 * so it will become invalid and the client should free any
	 * resources associated with it.
	 */
	void (*finished)(void *data,
			 struct treeland_foreign_toplevel_manager_v1 *treeland_foreign_toplevel_manager_v1);
};

/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 */
static inline int
treeland_foreign_toplevel_manager_v1_add_listener(struct treeland_foreign_toplevel_manager_v1 *treeland_foreign_toplevel_manager_v1,
						  const struct treeland_foreign_toplevel_manager_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_foreign_toplevel_manager_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_STOP 0
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_GET_DOCK_PREVIEW_CONTEXT 1

/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_TOPLEVEL_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_FINISHED_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_STOP_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_GET_DOCK_PREVIEW_CONTEXT_SINCE_VERSION 1

/** @ingroup iface_treeland_foreign_toplevel_manager_v1 */
static inline void
treeland_foreign_toplevel_manager_v1_set_user_data(struct treeland_foreign_toplevel_manager_v1 *treeland_foreign_toplevel_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_foreign_toplevel_manager_v1, user_data);
}

/** @ingroup iface_treeland_foreign_toplevel_manager_v1 */
static inline void *
treeland_foreign_toplevel_manager_v1_get_user_data(struct treeland_foreign_toplevel_manager_v1 *treeland_foreign_toplevel_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_foreign_toplevel_manager_v1);
}

static inline uint32_t
treeland_foreign_toplevel_manager_v1_get_version(struct treeland_foreign_toplevel_manager_v1 *treeland_foreign_toplevel_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_manager_v1);
}

/** @ingroup iface_treeland_foreign_toplevel_manager_v1 */
static inline void
treeland_foreign_toplevel_manager_v1_destroy(struct treeland_foreign_toplevel_manager_v1 *treeland_foreign_toplevel_manager_v1)
{
	wl_proxy_destroy((struct wl_proxy *) treeland_foreign_toplevel_manager_v1);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 *
 * Indicates the client no longer wishes to receive events for new toplevels.
 * However the compositor may emit further toplevel_created events, until
 * the finished event is emitted.
 *
 * The client must not send any more requests after this one.
 */
static inline void
treeland_foreign_toplevel_manager_v1_stop(struct treeland_foreign_toplevel_manager_v1 *treeland_foreign_toplevel_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_foreign_toplevel_manager_v1,
			 TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_STOP, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_manager_v1), 0);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_manager_v1
 */
static inline struct treeland_dock_preview_context_v1 *
treeland_foreign_toplevel_manager_v1_get_dock_preview_context(struct treeland_foreign_toplevel_manager_v1 *treeland_foreign_toplevel_manager_v1, struct wl_surface *relative_surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_foreign_toplevel_manager_v1,
			 TREELAND_FOREIGN_TOPLEVEL_MANAGER_V1_GET_DOCK_PREVIEW_CONTEXT, &treeland_dock_preview_context_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_manager_v1), 0, relative_surface, NULL);

	return (struct treeland_dock_preview_context_v1 *) id;
}

#ifndef TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * types of states on the toplevel
 *
 * The different states that a toplevel can have. These have the same meaning
 * as the states with the same names defined in xdg-toplevel
 */
enum treeland_foreign_toplevel_handle_v1_state {
	/**
	 * the toplevel is maximized
	 */
	TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_MAXIMIZED = 0,
	/**
	 * the toplevel is minimized
	 */
	TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_MINIMIZED = 1,
	/**
	 * the toplevel is active
	 */
	TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ACTIVATED = 2,
	/**
	 * the toplevel is fullscreen
	 */
	TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_FULLSCREEN = 3,
};
#endif /* TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM */

#ifndef TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM
enum treeland_foreign_toplevel_handle_v1_error {
	/**
	 * the provided rectangle is invalid
	 */
	TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_INVALID_RECTANGLE = 0,
};
#endif /* TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM */

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 * @struct treeland_foreign_toplevel_handle_v1_listener
 */
struct treeland_foreign_toplevel_handle_v1_listener {
	/**
	 * Process id of application owning the window has changed
	 *
	 * This event will be sent when the compositor has set the
	 * process id this window belongs to. This should be set once
	 * before the initial_state is sent.
	 */
	void (*pid)(void *data,
		    struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1,
		    uint32_t pid);
	/**
	 * title change
	 *
	 * This event is emitted whenever the title of the toplevel
	 * changes.
	 */
	void (*title)(void *data,
		      struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1,
		      const char *title);
	/**
	 * app-id change
	 *
	 * This event is emitted whenever the app-id of the toplevel
	 * changes.
	 */
	void (*app_id)(void *data,
		       struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1,
		       const char *app_id);
	/**
	 * a stable identifier for a toplevel
	 *
	 * The identifier of each top level and its handle must be
	 * unique. Two different top layers cannot have the same
	 * identifier. This identifier is only valid as long as the top
	 * level is mapped. Identifiers must not be reused if the top level
	 * is not mapped. The compositor must not reuse identifiers to
	 * ensure there are no races when identifiers are shared between
	 * processes.
	 */
	void (*identifier)(void *data,
			   struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1,
			   uint32_t identifier);
	/**
	 * toplevel entered an output
	 *
	 * This event is emitted whenever the toplevel becomes visible on
	 * the given output. A toplevel may be visible on multiple outputs.
	 */
	void (*output_enter)(void *data,
			     struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1,
			     struct wl_output *output);
	/**
	 * toplevel left an output
	 *
	 * This event is emitted whenever the toplevel stops being
	 * visible on the given output. It is guaranteed that an
	 * entered-output event with the same output has been emitted
	 * before this event.
	 */
	void (*output_leave)(void *data,
			     struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1,
			     struct wl_output *output);
	/**
	 * the toplevel state changed
	 *
	 * This event is emitted immediately after the
	 * treeland_foreign_toplevel_handle_v1 is created and each time the
	 * toplevel state changes, either because of a compositor action or
	 * because of a request in this protocol.
	 */
	void (*state)(void *data,
		      struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1,
		      struct wl_array *state);
	/**
	 * all information about the toplevel has been sent
	 *
	 * This event is sent after all changes in the toplevel state
	 * have been sent.
	 *
	 * This allows changes to the treeland_foreign_toplevel_handle_v1
	 * properties to be seen as atomic, even if they happen via
	 * multiple events.
	 */
	void (*done)(void *data,
		     struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1);
	/**
	 * this toplevel has been destroyed
	 *
	 * This event means the toplevel has been destroyed. It is
	 * guaranteed there won't be any more events for this
	 * treeland_foreign_toplevel_handle_v1. The toplevel itself becomes
	 * inert so any requests will be ignored except the destroy
	 * request.
	 */
	void (*closed)(void *data,
		       struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1);
	/**
	 * parent change
	 *
	 * This event is emitted whenever the parent of the toplevel
	 * changes.
	 *
	 * No event is emitted when the parent handle is destroyed by the
	 * client.
	 */
	void (*parent)(void *data,
		       struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1,
		       struct treeland_foreign_toplevel_handle_v1 *parent);
};

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
static inline int
treeland_foreign_toplevel_handle_v1_add_listener(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1,
						 const struct treeland_foreign_toplevel_handle_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_foreign_toplevel_handle_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_MAXIMIZED 0
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_MAXIMIZED 1
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_MINIMIZED 2
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_MINIMIZED 3
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ACTIVATE 4
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSE 5
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_RECTANGLE 6
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_DESTROY 7
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_FULLSCREEN 8
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_FULLSCREEN 9

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_PID_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_TITLE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_APP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_IDENTIFIER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSED_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_PARENT_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_MAXIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_MAXIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_MINIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_MINIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_FULLSCREEN_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 */
#define TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_FULLSCREEN_SINCE_VERSION 1

/** @ingroup iface_treeland_foreign_toplevel_handle_v1 */
static inline void
treeland_foreign_toplevel_handle_v1_set_user_data(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_foreign_toplevel_handle_v1, user_data);
}

/** @ingroup iface_treeland_foreign_toplevel_handle_v1 */
static inline void *
treeland_foreign_toplevel_handle_v1_get_user_data(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_foreign_toplevel_handle_v1);
}

static inline uint32_t
treeland_foreign_toplevel_handle_v1_get_version(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_handle_v1);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 *
 * Requests that the toplevel be maximized. If the maximized state actually
 * changes, this will be indicated by the state event.
 */
static inline void
treeland_foreign_toplevel_handle_v1_set_maximized(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_foreign_toplevel_handle_v1,
			 TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_MAXIMIZED, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_handle_v1), 0);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 *
 * Requests that the toplevel be unmaximized. If the maximized state actually
 * changes, this will be indicated by the state event.
 */
static inline void
treeland_foreign_toplevel_handle_v1_unset_maximized(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_foreign_toplevel_handle_v1,
			 TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_MAXIMIZED, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_handle_v1), 0);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 *
 * Requests that the toplevel be minimized. If the minimized state actually
 * changes, this will be indicated by the state event.
 */
static inline void
treeland_foreign_toplevel_handle_v1_set_minimized(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_foreign_toplevel_handle_v1,
			 TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_MINIMIZED, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_handle_v1), 0);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 *
 * Requests that the toplevel be unminimized. If the minimized state actually
 * changes, this will be indicated by the state event.
 */
static inline void
treeland_foreign_toplevel_handle_v1_unset_minimized(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_foreign_toplevel_handle_v1,
			 TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_MINIMIZED, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_handle_v1), 0);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 *
 * Request that this toplevel be activated on the given seat.
 * There is no guarantee the toplevel will be actually activated.
 */
static inline void
treeland_foreign_toplevel_handle_v1_activate(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1, struct wl_seat *seat)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_foreign_toplevel_handle_v1,
			 TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_ACTIVATE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_handle_v1), 0, seat);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 *
 * Send a request to the toplevel to close itself. The compositor would
 * typically use a shell-specific method to carry out this request, for
 * example by sending the xdg_toplevel.close event. However, this gives
 * no guarantees the toplevel will actually be destroyed. If and when
 * this happens, the treeland_foreign_toplevel_handle_v1.closed event will
 * be emitted.
 */
static inline void
treeland_foreign_toplevel_handle_v1_close(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_foreign_toplevel_handle_v1,
			 TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_handle_v1), 0);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 *
 * The rectangle of the surface specified in this request corresponds to
 * the place where the app using this protocol represents the given toplevel.
 * It can be used by the compositor as a hint for some operations, e.g
 * minimizing. The client is however not required to set this, in which
 * case the compositor is free to decide some default value.
 *
 * If the client specifies more than one rectangle, only the last one is
 * considered.
 *
 * The dimensions are given in surface-local coordinates.
 * Setting width=height=0 removes the already-set rectangle.
 */
static inline void
treeland_foreign_toplevel_handle_v1_set_rectangle(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1, struct wl_surface *surface, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_foreign_toplevel_handle_v1,
			 TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_RECTANGLE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_handle_v1), 0, surface, x, y, width, height);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 *
 * Destroys the treeland_foreign_toplevel_handle_v1 object.
 *
 * This request should be called either when the client does not want to
 * use the toplevel anymore or after the closed event to finalize the
 * destruction of the object.
 */
static inline void
treeland_foreign_toplevel_handle_v1_destroy(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_foreign_toplevel_handle_v1,
			 TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_handle_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 *
 * Requests that the toplevel be fullscreened on the given output. If the
 * fullscreen state and/or the outputs the toplevel is visible on actually
 * change, this will be indicated by the state and output_enter/leave
 * events.
 *
 * The output parameter is only a hint to the compositor. Also, if output
 * is NULL, the compositor should decide which output the toplevel will be
 * fullscreened on, if at all.
 */
static inline void
treeland_foreign_toplevel_handle_v1_set_fullscreen(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1, struct wl_output *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_foreign_toplevel_handle_v1,
			 TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_SET_FULLSCREEN, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_handle_v1), 0, output);
}

/**
 * @ingroup iface_treeland_foreign_toplevel_handle_v1
 *
 * Requests that the toplevel be unfullscreened. If the fullscreen state
 * actually changes, this will be indicated by the state event.
 */
static inline void
treeland_foreign_toplevel_handle_v1_unset_fullscreen(struct treeland_foreign_toplevel_handle_v1 *treeland_foreign_toplevel_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_foreign_toplevel_handle_v1,
			 TREELAND_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_FULLSCREEN, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_foreign_toplevel_handle_v1), 0);
}

#ifndef TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_ENUM
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_ENUM
/**
 * @ingroup iface_treeland_dock_preview_context_v1
 * types of direction on the dock preview
 *
 */
enum treeland_dock_preview_context_v1_direction {
	/**
	 * top
	 */
	TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_TOP = 0,
	/**
	 * right
	 */
	TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_RIGHT = 1,
	/**
	 * bottom
	 */
	TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_BOTTOM = 2,
	/**
	 * left
	 */
	TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_LEFT = 3,
};
#endif /* TREELAND_DOCK_PREVIEW_CONTEXT_V1_DIRECTION_ENUM */

/**
 * @ingroup iface_treeland_dock_preview_context_v1
 * @struct treeland_dock_preview_context_v1_listener
 */
struct treeland_dock_preview_context_v1_listener {
	/**
	 * enter preview box
	 *
	 * This event is sent after mouse enter preview box.
	 */
	void (*enter)(void *data,
		      struct treeland_dock_preview_context_v1 *treeland_dock_preview_context_v1);
	/**
	 * leave preview box
	 *
	 * This event is sent after mouse leave preview box.
	 */
	void (*leave)(void *data,
		      struct treeland_dock_preview_context_v1 *treeland_dock_preview_context_v1);
};

/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
static inline int
treeland_dock_preview_context_v1_add_listener(struct treeland_dock_preview_context_v1 *treeland_dock_preview_context_v1,
					      const struct treeland_dock_preview_context_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_dock_preview_context_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_SHOW 0
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_SHOW_TOOLTIP 1
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_CLOSE 2
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_DESTROY 3

/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_LEAVE_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_SHOW_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_SHOW_TOOLTIP_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
#define TREELAND_DOCK_PREVIEW_CONTEXT_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_dock_preview_context_v1 */
static inline void
treeland_dock_preview_context_v1_set_user_data(struct treeland_dock_preview_context_v1 *treeland_dock_preview_context_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_dock_preview_context_v1, user_data);
}

/** @ingroup iface_treeland_dock_preview_context_v1 */
static inline void *
treeland_dock_preview_context_v1_get_user_data(struct treeland_dock_preview_context_v1 *treeland_dock_preview_context_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_dock_preview_context_v1);
}

static inline uint32_t
treeland_dock_preview_context_v1_get_version(struct treeland_dock_preview_context_v1 *treeland_dock_preview_context_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_dock_preview_context_v1);
}

/**
 * @ingroup iface_treeland_dock_preview_context_v1
 *
 * X and Y are relative to the relative_surface.
 * surfaces wl_array is identifiers.
 */
static inline void
treeland_dock_preview_context_v1_show(struct treeland_dock_preview_context_v1 *treeland_dock_preview_context_v1, struct wl_array *surfaces, int32_t x, int32_t y, uint32_t direction)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_dock_preview_context_v1,
			 TREELAND_DOCK_PREVIEW_CONTEXT_V1_SHOW, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_dock_preview_context_v1), 0, surfaces, x, y, direction);
}

/**
 * @ingroup iface_treeland_dock_preview_context_v1
 */
static inline void
treeland_dock_preview_context_v1_show_tooltip(struct treeland_dock_preview_context_v1 *treeland_dock_preview_context_v1, const char *tooltip, int32_t x, int32_t y, uint32_t direction)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_dock_preview_context_v1,
			 TREELAND_DOCK_PREVIEW_CONTEXT_V1_SHOW_TOOLTIP, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_dock_preview_context_v1), 0, tooltip, x, y, direction);
}

/**
 * @ingroup iface_treeland_dock_preview_context_v1
 *
 * close preview box
 */
static inline void
treeland_dock_preview_context_v1_close(struct treeland_dock_preview_context_v1 *treeland_dock_preview_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_dock_preview_context_v1,
			 TREELAND_DOCK_PREVIEW_CONTEXT_V1_CLOSE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_dock_preview_context_v1), 0);
}

/**
 * @ingroup iface_treeland_dock_preview_context_v1
 *
 * Destroy the context object.
 */
static inline void
treeland_dock_preview_context_v1_destroy(struct treeland_dock_preview_context_v1 *treeland_dock_preview_context_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_dock_preview_context_v1,
			 TREELAND_DOCK_PREVIEW_CONTEXT_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_dock_preview_context_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
