/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "nsDocShellTelemetryUtils.h"

namespace {

struct LoadErrorTelemetryResult {
  nsresult mValue;
  nsLiteralCString mLabel;
};

static const LoadErrorTelemetryResult sResult[] = {
    {NS_ERROR_UNKNOWN_PROTOCOL, "UNKNOWN_PROTOCOL"_ns},
    {NS_ERROR_FILE_NOT_FOUND, "FILE_NOT_FOUND"_ns},
    {NS_ERROR_FILE_ACCESS_DENIED, "FILE_ACCESS_DENIED"_ns},
    {NS_ERROR_UNKNOWN_HOST, "UNKNOWN_HOST"_ns},
    {NS_ERROR_CONNECTION_REFUSED, "CONNECTION_REFUSED"_ns},
    {NS_ERROR_PROXY_BAD_GATEWAY, "PROXY_BAD_GATEWAY"_ns},
    {NS_ERROR_NET_INTERRUPT, "NET_INTERRUPT"_ns},
    {NS_ERROR_NET_TIMEOUT, "NET_TIMEOUT"_ns},
    {NS_ERROR_PROXY_GATEWAY_TIMEOUT, "P_GATEWAY_TIMEOUT"_ns},
    {NS_ERROR_CSP_FRAME_ANCESTOR_VIOLATION, "CSP_FRAME_ANCEST"_ns},
    {NS_ERROR_CSP_FORM_ACTION_VIOLATION, "CSP_FORM_ACTION"_ns},
    {NS_ERROR_XFO_VIOLATION, "XFO_VIOLATION"_ns},
    {NS_ERROR_PHISHING_URI, "PHISHING_URI"_ns},
    {NS_ERROR_MALWARE_URI, "MALWARE_URI"_ns},
    {NS_ERROR_UNWANTED_URI, "UNWANTED_URI"_ns},
    {NS_ERROR_HARMFUL_URI, "HARMFUL_URI"_ns},
    {NS_ERROR_CONTENT_CRASHED, "CONTENT_CRASHED"_ns},
    {NS_ERROR_FRAME_CRASHED, "FRAME_CRASHED"_ns},
    {NS_ERROR_BUILDID_MISMATCH, "BUILDID_MISMATCH"_ns},
    {NS_ERROR_NET_RESET, "NET_RESET"_ns},
    {NS_ERROR_MALFORMED_URI, "MALFORMED_URI"_ns},
    {NS_ERROR_REDIRECT_LOOP, "REDIRECT_LOOP"_ns},
    {NS_ERROR_UNKNOWN_SOCKET_TYPE, "UNKNOWN_SOCKET"_ns},
    {NS_ERROR_DOCUMENT_NOT_CACHED, "DOCUMENT_N_CACHED"_ns},
    {NS_ERROR_OFFLINE, "OFFLINE"_ns},
    {NS_ERROR_DOCUMENT_IS_PRINTMODE, "DOC_PRINTMODE"_ns},
    {NS_ERROR_PORT_ACCESS_NOT_ALLOWED, "PORT_ACCESS"_ns},
    {NS_ERROR_UNKNOWN_PROXY_HOST, "UNKNOWN_PROXY_HOST"_ns},
    {NS_ERROR_PROXY_CONNECTION_REFUSED, "PROXY_CONNECTION"_ns},
    {NS_ERROR_PROXY_FORBIDDEN, "PROXY_FORBIDDEN"_ns},
    {NS_ERROR_PROXY_NOT_IMPLEMENTED, "P_NOT_IMPLEMENTED"_ns},
    {NS_ERROR_PROXY_AUTHENTICATION_FAILED, "PROXY_AUTH"_ns},
    {NS_ERROR_PROXY_TOO_MANY_REQUESTS, "PROXY_TOO_MANY"_ns},
    {NS_ERROR_INVALID_CONTENT_ENCODING, "CONTENT_ENCODING"_ns},
    {NS_ERROR_UNSAFE_CONTENT_TYPE, "UNSAFE_CONTENT"_ns},
    {NS_ERROR_CORRUPTED_CONTENT, "CORRUPTED_CONTENT"_ns},
    {NS_ERROR_INTERCEPTION_FAILED, "INTERCEPTION_FAIL"_ns},
    {NS_ERROR_NET_INADEQUATE_SECURITY, "INADEQUATE_SEC"_ns},
    {NS_ERROR_BLOCKED_BY_POLICY, "BLOCKED_BY_POLICY"_ns},
    {NS_ERROR_NET_HTTP2_SENT_GOAWAY, "HTTP2_SENT_GOAWAY"_ns},
    {NS_ERROR_NET_HTTP3_PROTOCOL_ERROR, "HTTP3_PROTOCOL"_ns},
    {NS_BINDING_FAILED, "BINDING_FAILED"_ns},
};
}  // anonymous namespace

namespace mozilla {
namespace dom {
nsLiteralCString LoadErrorToTelemetryLabel(nsresult aRv) {
  MOZ_ASSERT(aRv != NS_OK);

  for (const auto& p : sResult) {
    if (p.mValue == aRv) {
      return p.mLabel;
    }
  }
  return "otherError"_ns;
}
}  // namespace dom
}  // namespace mozilla
