//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PSocketProcessParent.h"
#include "mozilla/AntiTrackingIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/FeaturePolicyUtils.h"
#include "mozilla/dom/FetchIPCTypes.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/ipc/ByteBufUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/net/CacheInfoIPCTypes.h"
#include "mozilla/net/ClassOfService.h"
#include "mozilla/net/SocketProcessParent.h"
#include "nsDOMNavigationTiming.h"
#include "nsDocShellLoadState.h"
#include "nsHttp.h"
#include "nsHttpResponseHead.h"
#include "nsID.h"
#include "nsIPropertyBag2.h"

#include "mozilla/net/PDNSRequestParent.h"
#include "mozilla/net/PSocketProcessBridgeParent.h"
#include "mozilla/PProfilerParent.h"
#include "mozilla/net/PWebrtcTCPSocketParent.h"
#include "mozilla/net/PHttpTransactionParent.h"
#include "mozilla/net/PHttpConnectionMgrParent.h"
#include "mozilla/net/PInputChannelThrottleQueueParent.h"
#include "mozilla/net/PAltServiceParent.h"
#include "mozilla/net/PAltSvcTransactionParent.h"
#include "mozilla/net/PTRRServiceParent.h"
#include "mozilla/net/PProxyConfigLookupParent.h"
#include "mozilla/net/PNativeDNSResolverOverrideParent.h"
#include "mozilla/net/PProxyAutoConfigParent.h"
#include "mozilla/net/PSocketProcessBackgroundParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


auto PSocketProcessParent::RecvPWebrtcTCPSocketConstructor(
        PWebrtcTCPSocketParent* actor,
        const mozilla::Maybe<TabId>& tabId) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PSocketProcessParent::RecvPAltServiceConstructor(PAltServiceParent* actor) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PSocketProcessParent::RecvPProxyConfigLookupConstructor(
        PProxyConfigLookupParent* actor,
        nsIURI* aUri,
        const uint32_t& aFlags) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PSocketProcessParent::RecvPDNSRequestConstructor(
        PDNSRequestParent* actor,
        const nsACString& hostName,
        const nsACString& trrServer,
        const int32_t& port,
        const uint16_t& type,
        const OriginAttributes& originAttributes,
        const DNSFlags& flags) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PSocketProcessParent::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PSocketProcessParent::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PSocketProcessParent::PSocketProcessParent() :
    mozilla::ipc::IToplevelProtocol("PSocketProcessParent", kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PSocketProcessParent);
}

PSocketProcessParent::~PSocketProcessParent()
{
    MOZ_COUNT_DTOR(PSocketProcessParent);
}

auto PSocketProcessParent::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess(), "Invalid process for `PSocketProcessParent'");
    AddRef();
}

auto PSocketProcessParent::ActorDealloc() -> void
{
    Release();
}

auto PSocketProcessParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PSocketProcessParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PSocketProcessParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PSocketProcessParent::ManagedPDNSRequestParent(nsTArray<PDNSRequestParent*>& aArr) const -> void
{
    mManagedPDNSRequestParent.ToArray(aArr);
}

auto PSocketProcessParent::ManagedPDNSRequestParent() const -> const ManagedContainer<PDNSRequestParent>&
{
    return mManagedPDNSRequestParent;
}

auto PSocketProcessParent::ManagedPWebrtcTCPSocketParent(nsTArray<PWebrtcTCPSocketParent*>& aArr) const -> void
{
    mManagedPWebrtcTCPSocketParent.ToArray(aArr);
}

auto PSocketProcessParent::ManagedPWebrtcTCPSocketParent() const -> const ManagedContainer<PWebrtcTCPSocketParent>&
{
    return mManagedPWebrtcTCPSocketParent;
}

auto PSocketProcessParent::ManagedPHttpTransactionParent(nsTArray<PHttpTransactionParent*>& aArr) const -> void
{
    mManagedPHttpTransactionParent.ToArray(aArr);
}

auto PSocketProcessParent::ManagedPHttpTransactionParent() const -> const ManagedContainer<PHttpTransactionParent>&
{
    return mManagedPHttpTransactionParent;
}

auto PSocketProcessParent::ManagedPHttpConnectionMgrParent(nsTArray<PHttpConnectionMgrParent*>& aArr) const -> void
{
    mManagedPHttpConnectionMgrParent.ToArray(aArr);
}

auto PSocketProcessParent::ManagedPHttpConnectionMgrParent() const -> const ManagedContainer<PHttpConnectionMgrParent>&
{
    return mManagedPHttpConnectionMgrParent;
}

auto PSocketProcessParent::ManagedPInputChannelThrottleQueueParent(nsTArray<PInputChannelThrottleQueueParent*>& aArr) const -> void
{
    mManagedPInputChannelThrottleQueueParent.ToArray(aArr);
}

auto PSocketProcessParent::ManagedPInputChannelThrottleQueueParent() const -> const ManagedContainer<PInputChannelThrottleQueueParent>&
{
    return mManagedPInputChannelThrottleQueueParent;
}

auto PSocketProcessParent::ManagedPAltServiceParent(nsTArray<PAltServiceParent*>& aArr) const -> void
{
    mManagedPAltServiceParent.ToArray(aArr);
}

auto PSocketProcessParent::ManagedPAltServiceParent() const -> const ManagedContainer<PAltServiceParent>&
{
    return mManagedPAltServiceParent;
}

auto PSocketProcessParent::ManagedPAltSvcTransactionParent(nsTArray<PAltSvcTransactionParent*>& aArr) const -> void
{
    mManagedPAltSvcTransactionParent.ToArray(aArr);
}

auto PSocketProcessParent::ManagedPAltSvcTransactionParent() const -> const ManagedContainer<PAltSvcTransactionParent>&
{
    return mManagedPAltSvcTransactionParent;
}

auto PSocketProcessParent::ManagedPTRRServiceParent(nsTArray<PTRRServiceParent*>& aArr) const -> void
{
    mManagedPTRRServiceParent.ToArray(aArr);
}

auto PSocketProcessParent::ManagedPTRRServiceParent() const -> const ManagedContainer<PTRRServiceParent>&
{
    return mManagedPTRRServiceParent;
}

auto PSocketProcessParent::ManagedPProxyConfigLookupParent(nsTArray<PProxyConfigLookupParent*>& aArr) const -> void
{
    mManagedPProxyConfigLookupParent.ToArray(aArr);
}

auto PSocketProcessParent::ManagedPProxyConfigLookupParent() const -> const ManagedContainer<PProxyConfigLookupParent>&
{
    return mManagedPProxyConfigLookupParent;
}

auto PSocketProcessParent::ManagedPNativeDNSResolverOverrideParent(nsTArray<PNativeDNSResolverOverrideParent*>& aArr) const -> void
{
    mManagedPNativeDNSResolverOverrideParent.ToArray(aArr);
}

auto PSocketProcessParent::ManagedPNativeDNSResolverOverrideParent() const -> const ManagedContainer<PNativeDNSResolverOverrideParent>&
{
    return mManagedPNativeDNSResolverOverrideParent;
}

auto PSocketProcessParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PDNSRequestMsgStart,
        PWebrtcTCPSocketMsgStart,
        PHttpTransactionMsgStart,
        PHttpConnectionMgrMsgStart,
        PInputChannelThrottleQueueMsgStart,
        PAltServiceMsgStart,
        PAltSvcTransactionMsgStart,
        PTRRServiceMsgStart,
        PProxyConfigLookupMsgStart,
        PNativeDNSResolverOverrideMsgStart
    };
    return sIds;
}

auto PSocketProcessParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PDNSRequestMsgStart:
        return (&(mManagedPDNSRequestParent));
    case PWebrtcTCPSocketMsgStart:
        return (&(mManagedPWebrtcTCPSocketParent));
    case PHttpTransactionMsgStart:
        return (&(mManagedPHttpTransactionParent));
    case PHttpConnectionMgrMsgStart:
        return (&(mManagedPHttpConnectionMgrParent));
    case PInputChannelThrottleQueueMsgStart:
        return (&(mManagedPInputChannelThrottleQueueParent));
    case PAltServiceMsgStart:
        return (&(mManagedPAltServiceParent));
    case PAltSvcTransactionMsgStart:
        return (&(mManagedPAltSvcTransactionParent));
    case PTRRServiceMsgStart:
        return (&(mManagedPTRRServiceParent));
    case PProxyConfigLookupMsgStart:
        return (&(mManagedPProxyConfigLookupParent));
    case PNativeDNSResolverOverrideMsgStart:
        return (&(mManagedPNativeDNSResolverOverrideParent));
    default:
        return nullptr;
    }
}

auto PSocketProcessParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PSocketProcessParent::OpenPDNSRequestEndpoint(PDNSRequestParent* aActor) -> ManagedEndpoint<PDNSRequestChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PDNSRequestParent actor");
        return ManagedEndpoint<PDNSRequestChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PDNSRequestParent actor");
        return ManagedEndpoint<PDNSRequestChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PDNSRequestChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessParent::BindPDNSRequestEndpoint(
        ManagedEndpoint<PDNSRequestParent> aEndpoint,
        PDNSRequestParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessParent::OpenPWebrtcTCPSocketEndpoint(PWebrtcTCPSocketParent* aActor) -> ManagedEndpoint<PWebrtcTCPSocketChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PWebrtcTCPSocketParent actor");
        return ManagedEndpoint<PWebrtcTCPSocketChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebrtcTCPSocketParent actor");
        return ManagedEndpoint<PWebrtcTCPSocketChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PWebrtcTCPSocketChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessParent::BindPWebrtcTCPSocketEndpoint(
        ManagedEndpoint<PWebrtcTCPSocketParent> aEndpoint,
        PWebrtcTCPSocketParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessParent::OpenPHttpTransactionEndpoint(PHttpTransactionParent* aActor) -> ManagedEndpoint<PHttpTransactionChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PHttpTransactionParent actor");
        return ManagedEndpoint<PHttpTransactionChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PHttpTransactionParent actor");
        return ManagedEndpoint<PHttpTransactionChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PHttpTransactionChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessParent::BindPHttpTransactionEndpoint(
        ManagedEndpoint<PHttpTransactionParent> aEndpoint,
        PHttpTransactionParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessParent::OpenPHttpConnectionMgrEndpoint(PHttpConnectionMgrParent* aActor) -> ManagedEndpoint<PHttpConnectionMgrChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PHttpConnectionMgrParent actor");
        return ManagedEndpoint<PHttpConnectionMgrChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PHttpConnectionMgrParent actor");
        return ManagedEndpoint<PHttpConnectionMgrChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PHttpConnectionMgrChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessParent::BindPHttpConnectionMgrEndpoint(
        ManagedEndpoint<PHttpConnectionMgrParent> aEndpoint,
        PHttpConnectionMgrParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessParent::OpenPInputChannelThrottleQueueEndpoint(PInputChannelThrottleQueueParent* aActor) -> ManagedEndpoint<PInputChannelThrottleQueueChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PInputChannelThrottleQueueParent actor");
        return ManagedEndpoint<PInputChannelThrottleQueueChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PInputChannelThrottleQueueParent actor");
        return ManagedEndpoint<PInputChannelThrottleQueueChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PInputChannelThrottleQueueChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessParent::BindPInputChannelThrottleQueueEndpoint(
        ManagedEndpoint<PInputChannelThrottleQueueParent> aEndpoint,
        PInputChannelThrottleQueueParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessParent::OpenPAltServiceEndpoint(PAltServiceParent* aActor) -> ManagedEndpoint<PAltServiceChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PAltServiceParent actor");
        return ManagedEndpoint<PAltServiceChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PAltServiceParent actor");
        return ManagedEndpoint<PAltServiceChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PAltServiceChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessParent::BindPAltServiceEndpoint(
        ManagedEndpoint<PAltServiceParent> aEndpoint,
        PAltServiceParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessParent::OpenPAltSvcTransactionEndpoint(PAltSvcTransactionParent* aActor) -> ManagedEndpoint<PAltSvcTransactionChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PAltSvcTransactionParent actor");
        return ManagedEndpoint<PAltSvcTransactionChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PAltSvcTransactionParent actor");
        return ManagedEndpoint<PAltSvcTransactionChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PAltSvcTransactionChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessParent::BindPAltSvcTransactionEndpoint(
        ManagedEndpoint<PAltSvcTransactionParent> aEndpoint,
        PAltSvcTransactionParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessParent::OpenPTRRServiceEndpoint(PTRRServiceParent* aActor) -> ManagedEndpoint<PTRRServiceChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PTRRServiceParent actor");
        return ManagedEndpoint<PTRRServiceChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PTRRServiceParent actor");
        return ManagedEndpoint<PTRRServiceChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PTRRServiceChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessParent::BindPTRRServiceEndpoint(
        ManagedEndpoint<PTRRServiceParent> aEndpoint,
        PTRRServiceParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessParent::OpenPProxyConfigLookupEndpoint(PProxyConfigLookupParent* aActor) -> ManagedEndpoint<PProxyConfigLookupChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PProxyConfigLookupParent actor");
        return ManagedEndpoint<PProxyConfigLookupChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PProxyConfigLookupParent actor");
        return ManagedEndpoint<PProxyConfigLookupChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PProxyConfigLookupChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessParent::BindPProxyConfigLookupEndpoint(
        ManagedEndpoint<PProxyConfigLookupParent> aEndpoint,
        PProxyConfigLookupParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessParent::OpenPNativeDNSResolverOverrideEndpoint(PNativeDNSResolverOverrideParent* aActor) -> ManagedEndpoint<PNativeDNSResolverOverrideChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PNativeDNSResolverOverrideParent actor");
        return ManagedEndpoint<PNativeDNSResolverOverrideChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PNativeDNSResolverOverrideParent actor");
        return ManagedEndpoint<PNativeDNSResolverOverrideChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PNativeDNSResolverOverrideChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PSocketProcessParent::BindPNativeDNSResolverOverrideEndpoint(
        ManagedEndpoint<PNativeDNSResolverOverrideParent> aEndpoint,
        PNativeDNSResolverOverrideParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PSocketProcessParent::SendInit(const SocketPorcessInitAttributes& aAttributes) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_Init(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aAttributes);
    // Sentinel = 'aAttributes'
    ((&(writer__)))->WriteSentinel(442434697);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_Init", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendPreferenceUpdate(const Pref& pref) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_PreferenceUpdate(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), pref);
    // Sentinel = 'pref'
    ((&(writer__)))->WriteSentinel(71958958);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_PreferenceUpdate", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendRequestMemoryReport(
        const uint32_t& generation,
        const bool& anonymize,
        const bool& minimizeMemoryUsage,
        const mozilla::Maybe<FileDescriptor>& DMDFile,
        mozilla::ipc::ResolveCallback<uint32_t>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_RequestMemoryReport(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), generation);
    // Sentinel = 'generation'
    ((&(writer__)))->WriteSentinel(381158445);
    IPC::WriteParam((&(writer__)), anonymize);
    // Sentinel = 'anonymize'
    ((&(writer__)))->WriteSentinel(321127387);
    IPC::WriteParam((&(writer__)), minimizeMemoryUsage);
    // Sentinel = 'minimizeMemoryUsage'
    ((&(writer__)))->WriteSentinel(1321600977);
    IPC::WriteParam((&(writer__)), DMDFile);
    // Sentinel = 'DMDFile'
    ((&(writer__)))->WriteSentinel(143983190);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_RequestMemoryReport", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PSocketProcess::Reply_RequestMemoryReport__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__aGeneration = IPC::ReadParam<uint32_t>(aReader);
            if (!maybe__aGeneration) {
                (aReader)->FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aGeneration = *maybe__aGeneration;
            // Sentinel = 'aGeneration'
            if ((!((aReader)->ReadSentinel(430179438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(aGeneration));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PSocketProcessParent::SendRequestMemoryReport(
        const uint32_t& generation,
        const bool& anonymize,
        const bool& minimizeMemoryUsage,
        const mozilla::Maybe<FileDescriptor>& DMDFile) -> RefPtr<RequestMemoryReportPromise>
{
    RefPtr<MozPromise<uint32_t, ResponseRejectReason, true>::Private> promise__ = new MozPromise<uint32_t, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendRequestMemoryReport(std::move(generation), std::move(anonymize), std::move(minimizeMemoryUsage), std::move(DMDFile), [promise__](uint32_t&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PSocketProcessParent::SendSetOffline(const bool& offline) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_SetOffline(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), offline);
    // Sentinel = 'offline'
    ((&(writer__)))->WriteSentinel(194904804);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_SetOffline", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendSetConnectivity(const bool& connectivity) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_SetConnectivity(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), connectivity);
    // Sentinel = 'connectivity'
    ((&(writer__)))->WriteSentinel(548734240);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_SetConnectivity", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendInitLinuxSandbox(const mozilla::Maybe<FileDescriptor>& sandboxBroker) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_InitLinuxSandbox(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), sandboxBroker);
    // Sentinel = 'sandboxBroker'
    ((&(writer__)))->WriteSentinel(625149269);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_InitLinuxSandbox", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendInitSocketProcessBridgeParent(
        const ProcessId& processId,
        Endpoint<::mozilla::net::PSocketProcessBridgeParent>&& endpoint) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_InitSocketProcessBridgeParent(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), processId);
    // Sentinel = 'processId'
    ((&(writer__)))->WriteSentinel(318243757);
    IPC::WriteParam((&(writer__)), std::move(endpoint));
    // Sentinel = 'endpoint'
    ((&(writer__)))->WriteSentinel(251724642);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_InitSocketProcessBridgeParent", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendInitProfiler(Endpoint<::mozilla::PProfilerChild>&& aEndpoint) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_InitProfiler(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(aEndpoint));
    // Sentinel = 'aEndpoint'
    ((&(writer__)))->WriteSentinel(292225955);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_InitProfiler", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendSocketProcessTelemetryPing() -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_SocketProcessTelemetryPing(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_SocketProcessTelemetryPing", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendPHttpTransactionConstructor(PHttpTransactionParent* actor) -> PHttpTransactionParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PHttpTransactionParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PHttpTransactionParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_PHttpTransactionConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_PHttpTransactionConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PHttpTransactionParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PSocketProcessParent::SendPHttpConnectionMgrConstructor(
        PHttpConnectionMgrParent* actor,
        const HttpHandlerInitArgs& aArgs) -> PHttpConnectionMgrParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PHttpConnectionMgrParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PHttpConnectionMgrParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_PHttpConnectionMgrConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), aArgs);
    // Sentinel = 'aArgs'
    ((&(writer__)))->WriteSentinel(92602863);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_PHttpConnectionMgrConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PHttpConnectionMgrParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PSocketProcessParent::SendUpdateDeviceModelId(const nsACString& aModelId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_UpdateDeviceModelId(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aModelId);
    // Sentinel = 'aModelId'
    ((&(writer__)))->WriteSentinel(226951936);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_UpdateDeviceModelId", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendOnHttpActivityDistributorActivated(const bool& aIsActivated) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_OnHttpActivityDistributorActivated(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aIsActivated);
    // Sentinel = 'aIsActivated'
    ((&(writer__)))->WriteSentinel(496501939);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_OnHttpActivityDistributorActivated", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendOnHttpActivityDistributorObserveProxyResponse(const bool& aIsEnabled) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_OnHttpActivityDistributorObserveProxyResponse(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aIsEnabled);
    // Sentinel = 'aIsEnabled'
    ((&(writer__)))->WriteSentinel(340984777);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_OnHttpActivityDistributorObserveProxyResponse", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendOnHttpActivityDistributorObserveConnection(const bool& aIsEnabled) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_OnHttpActivityDistributorObserveConnection(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aIsEnabled);
    // Sentinel = 'aIsEnabled'
    ((&(writer__)))->WriteSentinel(340984777);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_OnHttpActivityDistributorObserveConnection", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendPInputChannelThrottleQueueConstructor(
        PInputChannelThrottleQueueParent* actor,
        const uint32_t& meanBytesPerSecond,
        const uint32_t& maxBytesPerSecond) -> PInputChannelThrottleQueueParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PInputChannelThrottleQueueParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PInputChannelThrottleQueueParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_PInputChannelThrottleQueueConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), meanBytesPerSecond);
    // Sentinel = 'meanBytesPerSecond'
    ((&(writer__)))->WriteSentinel(1142097708);
    IPC::WriteParam((&(writer__)), maxBytesPerSecond);
    // Sentinel = 'maxBytesPerSecond'
    ((&(writer__)))->WriteSentinel(1032193745);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_PInputChannelThrottleQueueConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PInputChannelThrottleQueueParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PSocketProcessParent::SendPAltSvcTransactionConstructor(
        PAltSvcTransactionParent* actor,
        const HttpConnectionInfoCloneArgs& aConnInfo,
        const uint32_t& aCaps) -> PAltSvcTransactionParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PAltSvcTransactionParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PAltSvcTransactionParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_PAltSvcTransactionConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), aConnInfo);
    // Sentinel = 'aConnInfo'
    ((&(writer__)))->WriteSentinel(284558204);
    IPC::WriteParam((&(writer__)), aCaps);
    // Sentinel = 'aCaps'
    ((&(writer__)))->WriteSentinel(90964457);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_PAltSvcTransactionConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PAltSvcTransactionParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PSocketProcessParent::SendClearSessionCache(
        mozilla::ipc::ResolveCallback<void_t>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_ClearSessionCache(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_ClearSessionCache", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PSocketProcess::Reply_ClearSessionCache__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__ok = IPC::ReadParam<void_t>(aReader);
            if (!maybe__ok) {
                (aReader)->FatalError("Error deserializing 'void_t'");
                return MsgValueError;

            }
            auto& ok = *maybe__ok;
            // Sentinel = 'ok'
            if ((!((aReader)->ReadSentinel(21692635)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'void_t'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(ok));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PSocketProcessParent::SendClearSessionCache() -> RefPtr<ClearSessionCachePromise>
{
    RefPtr<MozPromise<void_t, ResponseRejectReason, true>::Private> promise__ = new MozPromise<void_t, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendClearSessionCache([promise__](void_t&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PSocketProcessParent::SendPTRRServiceConstructor(
        PTRRServiceParent* actor,
        const bool& aCaptiveIsPassed,
        const bool& aParentalControlEnabled,
        mozilla::Span<nsCString const> aDNSSuffixList) -> PTRRServiceParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PTRRServiceParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PTRRServiceParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_PTRRServiceConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), aCaptiveIsPassed);
    // Sentinel = 'aCaptiveIsPassed'
    ((&(writer__)))->WriteSentinel(883689034);
    IPC::WriteParam((&(writer__)), aParentalControlEnabled);
    // Sentinel = 'aParentalControlEnabled'
    ((&(writer__)))->WriteSentinel(1835010341);
    IPC::WriteParam((&(writer__)), aDNSSuffixList);
    // Sentinel = 'aDNSSuffixList'
    ((&(writer__)))->WriteSentinel(636552536);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_PTRRServiceConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PTRRServiceParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PSocketProcessParent::SendPNativeDNSResolverOverrideConstructor(PNativeDNSResolverOverrideParent* actor) -> PNativeDNSResolverOverrideParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PNativeDNSResolverOverrideParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PNativeDNSResolverOverrideParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_PNativeDNSResolverOverrideConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_PNativeDNSResolverOverrideConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PNativeDNSResolverOverrideParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PSocketProcessParent::SendNotifyObserver(
        const nsACString& aTopic,
        const nsAString& aData) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_NotifyObserver(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aTopic);
    // Sentinel = 'aTopic'
    ((&(writer__)))->WriteSentinel(137429601);
    IPC::WriteParam((&(writer__)), aData);
    // Sentinel = 'aData'
    ((&(writer__)))->WriteSentinel(90571228);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_NotifyObserver", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendGetSocketData(
        mozilla::ipc::ResolveCallback<SocketDataArgs>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_GetSocketData(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_GetSocketData", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PSocketProcess::Reply_GetSocketData__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__data = IPC::ReadParam<SocketDataArgs>(aReader);
            if (!maybe__data) {
                (aReader)->FatalError("Error deserializing 'SocketDataArgs'");
                return MsgValueError;

            }
            auto& data = *maybe__data;
            // Sentinel = 'data'
            if ((!((aReader)->ReadSentinel(67109275)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SocketDataArgs'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(data));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PSocketProcessParent::SendGetSocketData() -> RefPtr<GetSocketDataPromise>
{
    RefPtr<MozPromise<SocketDataArgs, ResponseRejectReason, true>::Private> promise__ = new MozPromise<SocketDataArgs, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetSocketData([promise__](SocketDataArgs&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PSocketProcessParent::SendGetDNSCacheEntries(
        mozilla::ipc::ResolveCallback<nsTArray<DNSCacheEntries>>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_GetDNSCacheEntries(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_GetDNSCacheEntries", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PSocketProcess::Reply_GetDNSCacheEntries__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__entries = IPC::ReadParam<nsTArray<DNSCacheEntries>>(aReader);
            if (!maybe__entries) {
                (aReader)->FatalError("Error deserializing 'DNSCacheEntries[]'");
                return MsgValueError;

            }
            auto& entries = *maybe__entries;
            // Sentinel = 'entries'
            if ((!((aReader)->ReadSentinel(199361275)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DNSCacheEntries[]'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(entries));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PSocketProcessParent::SendGetDNSCacheEntries() -> RefPtr<GetDNSCacheEntriesPromise>
{
    RefPtr<MozPromise<nsTArray<DNSCacheEntries>, ResponseRejectReason, true>::Private> promise__ = new MozPromise<nsTArray<DNSCacheEntries>, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetDNSCacheEntries([promise__](nsTArray<DNSCacheEntries>&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PSocketProcessParent::SendGetHttpConnectionData(
        mozilla::ipc::ResolveCallback<nsTArray<HttpRetParams>>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_GetHttpConnectionData(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_GetHttpConnectionData", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PSocketProcess::Reply_GetHttpConnectionData__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__params = IPC::ReadParam<nsTArray<HttpRetParams>>(aReader);
            if (!maybe__params) {
                (aReader)->FatalError("Error deserializing 'HttpRetParams[]'");
                return MsgValueError;

            }
            auto& params = *maybe__params;
            // Sentinel = 'params'
            if ((!((aReader)->ReadSentinel(146997893)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'HttpRetParams[]'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(params));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PSocketProcessParent::SendGetHttpConnectionData() -> RefPtr<GetHttpConnectionDataPromise>
{
    RefPtr<MozPromise<nsTArray<HttpRetParams>, ResponseRejectReason, true>::Private> promise__ = new MozPromise<nsTArray<HttpRetParams>, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetHttpConnectionData([promise__](nsTArray<HttpRetParams>&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PSocketProcessParent::SendGetHttp3ConnectionStatsData(
        mozilla::ipc::ResolveCallback<nsTArray<Http3ConnectionStatsParams>>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_GetHttp3ConnectionStatsData(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_GetHttp3ConnectionStatsData", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PSocketProcess::Reply_GetHttp3ConnectionStatsData__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__params = IPC::ReadParam<nsTArray<Http3ConnectionStatsParams>>(aReader);
            if (!maybe__params) {
                (aReader)->FatalError("Error deserializing 'Http3ConnectionStatsParams[]'");
                return MsgValueError;

            }
            auto& params = *maybe__params;
            // Sentinel = 'params'
            if ((!((aReader)->ReadSentinel(146997893)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Http3ConnectionStatsParams[]'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(params));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PSocketProcessParent::SendGetHttp3ConnectionStatsData() -> RefPtr<GetHttp3ConnectionStatsDataPromise>
{
    RefPtr<MozPromise<nsTArray<Http3ConnectionStatsParams>, ResponseRejectReason, true>::Private> promise__ = new MozPromise<nsTArray<Http3ConnectionStatsParams>, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetHttp3ConnectionStatsData([promise__](nsTArray<Http3ConnectionStatsParams>&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PSocketProcessParent::SendInitProxyAutoConfigChild(Endpoint<::mozilla::net::PProxyAutoConfigChild>&& endpoint) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_InitProxyAutoConfigChild(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(endpoint));
    // Sentinel = 'endpoint'
    ((&(writer__)))->WriteSentinel(251724642);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_InitProxyAutoConfigChild", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendRecheckIPConnectivity() -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_RecheckIPConnectivity(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_RecheckIPConnectivity", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendRecheckDNS() -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_RecheckDNS(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_RecheckDNS", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendFlushFOGData(
        mozilla::ipc::ResolveCallback<ByteBuf>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_FlushFOGData(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_FlushFOGData", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PSocketProcess::Reply_FlushFOGData__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__buf = IPC::ReadParam<ByteBuf>(aReader);
            if (!maybe__buf) {
                (aReader)->FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& buf = *maybe__buf;
            // Sentinel = 'buf'
            if ((!((aReader)->ReadSentinel(41484606)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(buf));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PSocketProcessParent::SendFlushFOGData() -> RefPtr<FlushFOGDataPromise>
{
    RefPtr<MozPromise<ByteBuf, ResponseRejectReason, true>::Private> promise__ = new MozPromise<ByteBuf, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendFlushFOGData([promise__](ByteBuf&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PSocketProcessParent::SendTestTriggerMetrics(
        mozilla::ipc::ResolveCallback<bool>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_TestTriggerMetrics(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_TestTriggerMetrics", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PSocketProcess::Reply_TestTriggerMetrics__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__unused = IPC::ReadParam<bool>(aReader);
            if (!maybe__unused) {
                (aReader)->FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& unused = *maybe__unused;
            // Sentinel = 'unused'
            if ((!((aReader)->ReadSentinel(155517589)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(unused));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PSocketProcessParent::SendTestTriggerMetrics() -> RefPtr<TestTriggerMetricsPromise>
{
    RefPtr<MozPromise<bool, ResponseRejectReason, true>::Private> promise__ = new MozPromise<bool, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendTestTriggerMetrics([promise__](bool&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PSocketProcessParent::SendAddNetAddrOverride(
        const NetAddr& aFrom,
        const NetAddr& aTo) -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_AddNetAddrOverride(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aFrom);
    // Sentinel = 'aFrom'
    ((&(writer__)))->WriteSentinel(94568950);
    IPC::WriteParam((&(writer__)), aTo);
    // Sentinel = 'aTo'
    ((&(writer__)))->WriteSentinel(37552421);


    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_AddNetAddrOverride", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendClearNetAddrOverrides() -> bool
{
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_ClearNetAddrOverrides(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_ClearNetAddrOverrides", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PSocketProcessParent::SendPDNSRequestConstructor(
        PDNSRequestParent* actor,
        const nsACString& hostName,
        const nsACString& trrServer,
        const int32_t& port,
        const uint16_t& type,
        const OriginAttributes& originAttributes,
        const DNSFlags& flags) -> PDNSRequestParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PDNSRequestParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PDNSRequestParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PSocketProcess::Msg_PDNSRequestConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), hostName);
    // Sentinel = 'hostName'
    ((&(writer__)))->WriteSentinel(249627456);
    IPC::WriteParam((&(writer__)), trrServer);
    // Sentinel = 'trrServer'
    ((&(writer__)))->WriteSentinel(320603088);
    IPC::WriteParam((&(writer__)), port);
    // Sentinel = 'port'
    ((&(writer__)))->WriteSentinel(73990598);
    IPC::WriteParam((&(writer__)), type);
    // Sentinel = 'type'
    ((&(writer__)))->WriteSentinel(75760067);
    IPC::WriteParam((&(writer__)), originAttributes);
    // Sentinel = 'originAttributes'
    ((&(writer__)))->WriteSentinel(947259056);
    IPC::WriteParam((&(writer__)), flags);
    // Sentinel = 'flags'
    ((&(writer__)))->WriteSentinel(102171150);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PSocketProcessParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PSocketProcess::Msg_PDNSRequestConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PDNSRequestParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PSocketProcessParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PWebrtcTCPSocketMsgStart:
        static_cast<SocketProcessParent*>(this)->DeallocPWebrtcTCPSocketParent(static_cast<PWebrtcTCPSocketParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PSocketProcessParent::OnMessageReceived(const Message& msg__) -> PSocketProcessParent::Result
{
    IPC::Message::routeid_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PSocketProcess::Msg_InitCrashReporter__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_InitCrashReporter", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aInitArgs = IPC::ReadParam<CrashReporterInitArgs>((&(reader__)));
            if (!maybe__aInitArgs) {
                FatalError("Error deserializing 'CrashReporterInitArgs'");
                return MsgValueError;

            }
            auto& aInitArgs = *maybe__aInitArgs;
            // Sentinel = 'aInitArgs'
            if ((!(((&(reader__)))->ReadSentinel(286327683)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CrashReporterInitArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvInitCrashReporter(std::move(aInitArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_AddMemoryReport__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_AddMemoryReport", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aReport = IPC::ReadParam<MemoryReport>((&(reader__)));
            if (!maybe__aReport) {
                FatalError("Error deserializing 'MemoryReport'");
                return MsgValueError;

            }
            auto& aReport = *maybe__aReport;
            // Sentinel = 'aReport'
            if ((!(((&(reader__)))->ReadSentinel(184025822)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MemoryReport'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvAddMemoryReport(std::move(aReport));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_AccumulateChildHistograms__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_AccumulateChildHistograms", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__accumulations = IPC::ReadParam<nsTArray<HistogramAccumulation>>((&(reader__)));
            if (!maybe__accumulations) {
                FatalError("Error deserializing 'HistogramAccumulation[]'");
                return MsgValueError;

            }
            auto& accumulations = *maybe__accumulations;
            // Sentinel = 'accumulations'
            if ((!(((&(reader__)))->ReadSentinel(632030585)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'HistogramAccumulation[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvAccumulateChildHistograms(std::move(accumulations));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_AccumulateChildKeyedHistograms__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_AccumulateChildKeyedHistograms", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__accumulations = IPC::ReadParam<nsTArray<KeyedHistogramAccumulation>>((&(reader__)));
            if (!maybe__accumulations) {
                FatalError("Error deserializing 'KeyedHistogramAccumulation[]'");
                return MsgValueError;

            }
            auto& accumulations = *maybe__accumulations;
            // Sentinel = 'accumulations'
            if ((!(((&(reader__)))->ReadSentinel(632030585)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'KeyedHistogramAccumulation[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvAccumulateChildKeyedHistograms(std::move(accumulations));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_UpdateChildScalars__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_UpdateChildScalars", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actions = IPC::ReadParam<nsTArray<ScalarAction>>((&(reader__)));
            if (!maybe__actions) {
                FatalError("Error deserializing 'ScalarAction[]'");
                return MsgValueError;

            }
            auto& actions = *maybe__actions;
            // Sentinel = 'actions'
            if ((!(((&(reader__)))->ReadSentinel(193200882)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ScalarAction[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvUpdateChildScalars(std::move(actions));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_UpdateChildKeyedScalars__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_UpdateChildKeyedScalars", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actions = IPC::ReadParam<nsTArray<KeyedScalarAction>>((&(reader__)));
            if (!maybe__actions) {
                FatalError("Error deserializing 'KeyedScalarAction[]'");
                return MsgValueError;

            }
            auto& actions = *maybe__actions;
            // Sentinel = 'actions'
            if ((!(((&(reader__)))->ReadSentinel(193200882)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'KeyedScalarAction[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvUpdateChildKeyedScalars(std::move(actions));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_RecordChildEvents__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_RecordChildEvents", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__events = IPC::ReadParam<nsTArray<ChildEventData>>((&(reader__)));
            if (!maybe__events) {
                FatalError("Error deserializing 'ChildEventData[]'");
                return MsgValueError;

            }
            auto& events = *maybe__events;
            // Sentinel = 'events'
            if ((!(((&(reader__)))->ReadSentinel(149619350)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ChildEventData[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvRecordChildEvents(std::move(events));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_RecordDiscardedData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_RecordDiscardedData", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__data = IPC::ReadParam<DiscardedData>((&(reader__)));
            if (!maybe__data) {
                FatalError("Error deserializing 'DiscardedData'");
                return MsgValueError;

            }
            auto& data = *maybe__data;
            // Sentinel = 'data'
            if ((!(((&(reader__)))->ReadSentinel(67109275)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DiscardedData'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvRecordDiscardedData(std::move(data));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_PWebrtcTCPSocketConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_PWebrtcTCPSocketConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__tabId = IPC::ReadParam<mozilla::Maybe<TabId>>((&(reader__)));
            if (!maybe__tabId) {
                FatalError("Error deserializing 'TabId?'");
                return MsgValueError;

            }
            auto& tabId = *maybe__tabId;
            // Sentinel = 'tabId'
            if ((!(((&(reader__)))->ReadSentinel(99156453)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TabId?'");
                return MsgValueError;
            }
            reader__.EndRead();
            PWebrtcTCPSocketParent* actor = (static_cast<SocketProcessParent*>(this))->AllocPWebrtcTCPSocketParent(tabId);
            if (!actor) {
                NS_WARNING("Cannot bind null PWebrtcTCPSocketParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PWebrtcTCPSocketParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvPWebrtcTCPSocketConstructor(std::move(actor), std::move(tabId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_ObserveHttpActivity__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_ObserveHttpActivity", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aActivityArgs = IPC::ReadParam<HttpActivityArgs>((&(reader__)));
            if (!maybe__aActivityArgs) {
                FatalError("Error deserializing 'HttpActivityArgs'");
                return MsgValueError;

            }
            auto& aActivityArgs = *maybe__aActivityArgs;
            // Sentinel = 'aActivityArgs'
            if ((!(((&(reader__)))->ReadSentinel(599721276)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'HttpActivityArgs'");
                return MsgValueError;
            }
            auto maybe__aActivityType = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aActivityType) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aActivityType = *maybe__aActivityType;
            // Sentinel = 'aActivityType'
            if ((!(((&(reader__)))->ReadSentinel(606340433)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aActivitySubtype = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aActivitySubtype) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aActivitySubtype = *maybe__aActivitySubtype;
            // Sentinel = 'aActivitySubtype'
            if ((!(((&(reader__)))->ReadSentinel(916326043)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aTimestamp = IPC::ReadParam<PRTime>((&(reader__)));
            if (!maybe__aTimestamp) {
                FatalError("Error deserializing 'PRTime'");
                return MsgValueError;

            }
            auto& aTimestamp = *maybe__aTimestamp;
            // Sentinel = 'aTimestamp'
            if ((!(((&(reader__)))->ReadSentinel(367330326)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PRTime'");
                return MsgValueError;
            }
            auto maybe__aExtraSizeData = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aExtraSizeData) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aExtraSizeData = *maybe__aExtraSizeData;
            // Sentinel = 'aExtraSizeData'
            if ((!(((&(reader__)))->ReadSentinel(689833339)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            auto maybe__aExtraStringData = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aExtraStringData) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aExtraStringData = *maybe__aExtraStringData;
            // Sentinel = 'aExtraStringData'
            if ((!(((&(reader__)))->ReadSentinel(905315927)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvObserveHttpActivity(std::move(aActivityArgs), std::move(aActivityType), std::move(aActivitySubtype), std::move(aTimestamp), std::move(aExtraSizeData), std::move(aExtraStringData));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_InitSocketBackground__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_InitSocketBackground", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aEndpoint = IPC::ReadParam<Endpoint<::mozilla::net::PSocketProcessBackgroundParent>>((&(reader__)));
            if (!maybe__aEndpoint) {
                FatalError("Error deserializing 'Endpoint<::mozilla::net::PSocketProcessBackgroundParent>'");
                return MsgValueError;

            }
            auto& aEndpoint = *maybe__aEndpoint;
            // Sentinel = 'aEndpoint'
            if ((!(((&(reader__)))->ReadSentinel(292225955)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Endpoint<::mozilla::net::PSocketProcessBackgroundParent>'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvInitSocketBackground(std::move(aEndpoint));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_PAltServiceConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_PAltServiceConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PAltServiceParent> actor = (static_cast<SocketProcessParent*>(this))->AllocPAltServiceParent();
            if (!actor) {
                NS_WARNING("Cannot bind null PAltServiceParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PAltServiceParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvPAltServiceConstructor(actor);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_PProxyConfigLookupConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_PProxyConfigLookupConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__aUri = IPC::ReadParam<RefPtr<nsIURI>>((&(reader__)));
            if (!maybe__aUri) {
                FatalError("Error deserializing 'nsIURI'");
                return MsgValueError;

            }
            auto& aUri = *maybe__aUri;
            // Sentinel = 'aUri'
            if ((!(((&(reader__)))->ReadSentinel(64225682)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIURI'");
                return MsgValueError;
            }
            auto maybe__aFlags = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aFlags) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aFlags = *maybe__aFlags;
            // Sentinel = 'aFlags'
            if ((!(((&(reader__)))->ReadSentinel(129892943)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PProxyConfigLookupParent> actor = (static_cast<SocketProcessParent*>(this))->AllocPProxyConfigLookupParent(aUri, aFlags);
            if (!actor) {
                NS_WARNING("Cannot bind null PProxyConfigLookupParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PProxyConfigLookupParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvPProxyConfigLookupConstructor(actor, aUri, std::move(aFlags));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_ExcludeHttp2OrHttp3__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_ExcludeHttp2OrHttp3", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aArgs = IPC::ReadParam<HttpConnectionInfoCloneArgs>((&(reader__)));
            if (!maybe__aArgs) {
                FatalError("Error deserializing 'HttpConnectionInfoCloneArgs'");
                return MsgValueError;

            }
            auto& aArgs = *maybe__aArgs;
            // Sentinel = 'aArgs'
            if ((!(((&(reader__)))->ReadSentinel(92602863)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'HttpConnectionInfoCloneArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvExcludeHttp2OrHttp3(std::move(aArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_OnConsoleMessage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_OnConsoleMessage", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aMessage = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__aMessage) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& aMessage = *maybe__aMessage;
            // Sentinel = 'aMessage'
            if ((!(((&(reader__)))->ReadSentinel(233440039)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvOnConsoleMessage(std::move(aMessage));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Msg_FOGData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_FOGData", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__buf = IPC::ReadParam<ByteBuf>((&(reader__)));
            if (!maybe__buf) {
                FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& buf = *maybe__buf;
            // Sentinel = 'buf'
            if ((!(((&(reader__)))->ReadSentinel(41484606)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvFOGData(std::move(buf));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PSocketProcess::Reply_RequestMemoryReport__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PSocketProcess::Msg_RequestMemoryReport", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PSocketProcess::Reply_PHttpTransactionConstructor__ID:
        {
            return MsgProcessed;
        }
    case PSocketProcess::Reply_PHttpConnectionMgrConstructor__ID:
        {
            return MsgProcessed;
        }
    case PSocketProcess::Reply_PInputChannelThrottleQueueConstructor__ID:
        {
            return MsgProcessed;
        }
    case PSocketProcess::Reply_PAltSvcTransactionConstructor__ID:
        {
            return MsgProcessed;
        }
    case PSocketProcess::Reply_ClearSessionCache__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PSocketProcess::Msg_ClearSessionCache", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PSocketProcess::Reply_PTRRServiceConstructor__ID:
        {
            return MsgProcessed;
        }
    case PSocketProcess::Reply_PNativeDNSResolverOverrideConstructor__ID:
        {
            return MsgProcessed;
        }
    case PSocketProcess::Reply_GetSocketData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PSocketProcess::Msg_GetSocketData", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PSocketProcess::Reply_GetDNSCacheEntries__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PSocketProcess::Msg_GetDNSCacheEntries", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PSocketProcess::Reply_GetHttpConnectionData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PSocketProcess::Msg_GetHttpConnectionData", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PSocketProcess::Reply_GetHttp3ConnectionStatsData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PSocketProcess::Msg_GetHttp3ConnectionStatsData", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PSocketProcess::Reply_FlushFOGData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PSocketProcess::Msg_FlushFOGData", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PSocketProcess::Reply_TestTriggerMetrics__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PSocketProcess::Msg_TestTriggerMetrics", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PSocketProcess::Reply_PDNSRequestConstructor__ID:
        {
            return MsgProcessed;
        }
    case PSocketProcess::Msg_PDNSRequestConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PSocketProcess", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PSocketProcessParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PSocketProcess::Msg_PDNSRequestConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__hostName = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__hostName) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& hostName = *maybe__hostName;
            // Sentinel = 'hostName'
            if ((!(((&(reader__)))->ReadSentinel(249627456)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__trrServer = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__trrServer) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& trrServer = *maybe__trrServer;
            // Sentinel = 'trrServer'
            if ((!(((&(reader__)))->ReadSentinel(320603088)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__port = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__port) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& port = *maybe__port;
            // Sentinel = 'port'
            if ((!(((&(reader__)))->ReadSentinel(73990598)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__type = IPC::ReadParam<uint16_t>((&(reader__)));
            if (!maybe__type) {
                FatalError("Error deserializing 'uint16_t'");
                return MsgValueError;

            }
            auto& type = *maybe__type;
            // Sentinel = 'type'
            if ((!(((&(reader__)))->ReadSentinel(75760067)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint16_t'");
                return MsgValueError;
            }
            auto maybe__originAttributes = IPC::ReadParam<OriginAttributes>((&(reader__)));
            if (!maybe__originAttributes) {
                FatalError("Error deserializing 'OriginAttributes'");
                return MsgValueError;

            }
            auto& originAttributes = *maybe__originAttributes;
            // Sentinel = 'originAttributes'
            if ((!(((&(reader__)))->ReadSentinel(947259056)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributes'");
                return MsgValueError;
            }
            auto maybe__flags = IPC::ReadParam<DNSFlags>((&(reader__)));
            if (!maybe__flags) {
                FatalError("Error deserializing 'DNSFlags'");
                return MsgValueError;

            }
            auto& flags = *maybe__flags;
            // Sentinel = 'flags'
            if ((!(((&(reader__)))->ReadSentinel(102171150)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DNSFlags'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PDNSRequestParent> actor = (static_cast<SocketProcessParent*>(this))->AllocPDNSRequestParent(hostName, trrServer, port, type, originAttributes, flags);
            if (!actor) {
                NS_WARNING("Cannot bind null PDNSRequestParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PDNSRequestParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<SocketProcessParent*>(this))->RecvPDNSRequestConstructor(actor, std::move(hostName), std::move(trrServer), std::move(port), std::move(type), std::move(originAttributes), std::move(flags));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PSocketProcessParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PSocketProcessParent::Result
{
    IPC::Message::routeid_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            return MsgDropped;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__, reply__);
    }

    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PSocketProcessParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PSocketProcess'
    (aWriter)->WriteSentinel(680527257);
}

auto ParamTraits<::mozilla::net::PSocketProcessParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PSocketProcess actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PSocketProcess'
    if ((!((aReader)->ReadSentinel(680527257)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PSocketProcess actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PSocketProcessMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PSocketProcess)");

        return {};
    }
    return static_cast<::mozilla::net::PSocketProcessParent*>(actor);
}

} // namespace IPC
