/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-edid-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_edid_descriptor_tag_to_string(FuEdidDescriptorTag val)
{
    if (val == FU_EDID_DESCRIPTOR_TAG_DISPLAY_PRODUCT_SERIAL_NUMBER)
        return "display-product-serial-number";
    if (val == FU_EDID_DESCRIPTOR_TAG_ALPHANUMERIC_DATA_STRING)
        return "alphanumeric-data-string";
    if (val == FU_EDID_DESCRIPTOR_TAG_DISPLAY_RANGE_LIMITS)
        return "display-range-limits";
    if (val == FU_EDID_DESCRIPTOR_TAG_DISPLAY_PRODUCT_NAME)
        return "display-product-name";
    if (val == FU_EDID_DESCRIPTOR_TAG_COLOR_POINT_DATA)
        return "color-point-data";
    if (val == FU_EDID_DESCRIPTOR_TAG_STANDARD_TIMING_IDENTIFICATIONS)
        return "standard-timing-identifications";
    if (val == FU_EDID_DESCRIPTOR_TAG_DISPLAY_COLOR_MANAGEMENT_DATA)
        return "display-color-management-data";
    if (val == FU_EDID_DESCRIPTOR_TAG_CVT_TIMING_CODES)
        return "cvt-timing-codes";
    if (val == FU_EDID_DESCRIPTOR_TAG_ESTABLISHED_TIMINGS)
        return "established-timings";
    if (val == FU_EDID_DESCRIPTOR_TAG_DUMMY_DESCRIPTOR)
        return "dummy-descriptor";
    return NULL;
}
/**
 * fu_struct_edid_descriptor_ref: (skip):
 **/
FuStructEdidDescriptor *
fu_struct_edid_descriptor_ref(FuStructEdidDescriptor *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_edid_descriptor_unref: (skip):
 **/
void
fu_struct_edid_descriptor_unref(FuStructEdidDescriptor *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEdidDescriptor refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_edid_descriptor_new_internal: (skip):
 **/
static FuStructEdidDescriptor *
fu_struct_edid_descriptor_new_internal(void)
{
    FuStructEdidDescriptor *st = g_new0(FuStructEdidDescriptor, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_edid_descriptor_get_kind: (skip):
 **/
guint16
fu_struct_edid_descriptor_get_kind(const FuStructEdidDescriptor *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_edid_descriptor_get_subkind: (skip):
 **/
guint8
fu_struct_edid_descriptor_get_subkind(const FuStructEdidDescriptor *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_edid_descriptor_get_tag: (skip):
 **/
FuEdidDescriptorTag
fu_struct_edid_descriptor_get_tag(const FuStructEdidDescriptor *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_edid_descriptor_get_data: (skip):
 **/
const guint8 *
fu_struct_edid_descriptor_get_data(const FuStructEdidDescriptor *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 13;
    return st->buf->data + 5;
}

/* setters */
/**
 * fu_struct_edid_descriptor_set_kind: (skip):
 **/
void
fu_struct_edid_descriptor_set_kind(FuStructEdidDescriptor *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_edid_descriptor_set_subkind: (skip):
 **/
void
fu_struct_edid_descriptor_set_subkind(FuStructEdidDescriptor *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_edid_descriptor_set_tag: (skip):
 **/
void
fu_struct_edid_descriptor_set_tag(FuStructEdidDescriptor *st, FuEdidDescriptorTag value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_edid_descriptor_set_data: (skip):
 **/
gboolean
fu_struct_edid_descriptor_set_data(FuStructEdidDescriptor *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 5, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_edid_descriptor_new: (skip):
 **/
FuStructEdidDescriptor *
fu_struct_edid_descriptor_new(void)
{
    FuStructEdidDescriptor *st = fu_struct_edid_descriptor_new_internal();
    st->buf = g_byte_array_sized_new(18);
    fu_byte_array_set_size(st->buf, 18, 0x0);
    return st;
}
/**
 * fu_struct_edid_descriptor_to_string: (skip):
 **/
static gchar *
fu_struct_edid_descriptor_to_string(const FuStructEdidDescriptor *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEdidDescriptor:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  kind: 0x%x\n",
                           (guint) fu_struct_edid_descriptor_get_kind(st));
    g_string_append_printf(str, "  subkind: 0x%x\n",
                           (guint) fu_struct_edid_descriptor_get_subkind(st));
    {
        const gchar *tmp = fu_edid_descriptor_tag_to_string(fu_struct_edid_descriptor_get_tag(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  tag: 0x%x [%s]\n", (guint) fu_struct_edid_descriptor_get_tag(st), tmp);
        } else {
            g_string_append_printf(str, "  tag: 0x%x\n", (guint) fu_struct_edid_descriptor_get_tag(st));
        }
    }
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_edid_descriptor_get_data(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  data: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_edid_descriptor_validate_internal(FuStructEdidDescriptor *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_edid_descriptor_parse_internal(FuStructEdidDescriptor *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_edid_descriptor_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_edid_descriptor_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_edid_descriptor_parse_stream: (skip):
 **/
FuStructEdidDescriptor *
fu_struct_edid_descriptor_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEdidDescriptor) st = fu_struct_edid_descriptor_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 18, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEdidDescriptor failed read of 0x%x: ", (guint) 18);
        return NULL;
    }
    if (st->buf->len != 18) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEdidDescriptor requested 0x%x and got 0x%x",
                    (guint) 18,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_edid_descriptor_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_edid_ref: (skip):
 **/
FuStructEdid *
fu_struct_edid_ref(FuStructEdid *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_edid_unref: (skip):
 **/
void
fu_struct_edid_unref(FuStructEdid *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEdid refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_edid_new_internal: (skip):
 **/
static FuStructEdid *
fu_struct_edid_new_internal(void)
{
    FuStructEdid *st = g_new0(FuStructEdid, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_edid_get_manufacturer_name: (skip):
 **/
const guint8 *
fu_struct_edid_get_manufacturer_name(const FuStructEdid *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 2;
    return st->buf->data + 8;
}
/**
 * fu_struct_edid_get_product_code: (skip):
 **/
guint16
fu_struct_edid_get_product_code(const FuStructEdid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_edid_get_serial_number: (skip):
 **/
guint32
fu_struct_edid_get_serial_number(const FuStructEdid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_edid_get_week_of_manufacture: (skip):
 **/
guint8
fu_struct_edid_get_week_of_manufacture(const FuStructEdid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[16];
}
/**
 * fu_struct_edid_get_year_of_manufacture: (skip):
 **/
guint8
fu_struct_edid_get_year_of_manufacture(const FuStructEdid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[17];
}
/**
 * fu_struct_edid_get_edid_version_number: (skip):
 **/
static guint8
fu_struct_edid_get_edid_version_number(const FuStructEdid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[18];
}
/**
 * fu_struct_edid_get_revision_number: (skip):
 **/
guint8
fu_struct_edid_get_revision_number(const FuStructEdid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[19];
}
/**
 * fu_struct_edid_get_data_blocks: (skip):
 **/
const guint8 *
fu_struct_edid_get_data_blocks(const FuStructEdid *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 72;
    return st->buf->data + 54;
}
/**
 * fu_struct_edid_get_extension_block_count: (skip):
 **/
guint8
fu_struct_edid_get_extension_block_count(const FuStructEdid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[126];
}
/**
 * fu_struct_edid_get_checksum: (skip):
 **/
guint8
fu_struct_edid_get_checksum(const FuStructEdid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[127];
}

/* setters */
/**
 * fu_struct_edid_set_manufacturer_name: (skip):
 **/
gboolean
fu_struct_edid_set_manufacturer_name(FuStructEdid *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 8, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_edid_set_product_code: (skip):
 **/
void
fu_struct_edid_set_product_code(FuStructEdid *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_edid_set_serial_number: (skip):
 **/
void
fu_struct_edid_set_serial_number(FuStructEdid *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_edid_set_week_of_manufacture: (skip):
 **/
void
fu_struct_edid_set_week_of_manufacture(FuStructEdid *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[16] = value;
}
/**
 * fu_struct_edid_set_year_of_manufacture: (skip):
 **/
void
fu_struct_edid_set_year_of_manufacture(FuStructEdid *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[17] = value;
}
/**
 * fu_struct_edid_set_edid_version_number: (skip):
 **/
static void
fu_struct_edid_set_edid_version_number(FuStructEdid *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[18] = value;
}
/**
 * fu_struct_edid_set_revision_number: (skip):
 **/
void
fu_struct_edid_set_revision_number(FuStructEdid *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[19] = value;
}
/**
 * fu_struct_edid_set_data_blocks: (skip):
 **/
gboolean
fu_struct_edid_set_data_blocks(FuStructEdid *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 54, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_edid_set_extension_block_count: (skip):
 **/
void
fu_struct_edid_set_extension_block_count(FuStructEdid *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[126] = value;
}
/**
 * fu_struct_edid_set_checksum: (skip):
 **/
void
fu_struct_edid_set_checksum(FuStructEdid *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[127] = value;
}
/**
 * fu_struct_edid_new: (skip):
 **/
FuStructEdid *
fu_struct_edid_new(void)
{
    FuStructEdid *st = fu_struct_edid_new_internal();
    st->buf = g_byte_array_sized_new(128);
    fu_byte_array_set_size(st->buf, 128, 0x0);
    memcpy(st->buf->data + 0x0, "\x00\xFF\xFF\xFF\xFF\xFF\xFF\x00", 8); /* nocheck:blocked */
    fu_struct_edid_set_edid_version_number(st, 0x1);
    fu_struct_edid_set_revision_number(st, 0x3);
    return st;
}
/**
 * fu_struct_edid_to_string: (skip):
 **/
static gchar *
fu_struct_edid_to_string(const FuStructEdid *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEdid:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_edid_get_manufacturer_name(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  manufacturer_name: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  product_code: 0x%x\n",
                           (guint) fu_struct_edid_get_product_code(st));
    g_string_append_printf(str, "  serial_number: 0x%x\n",
                           (guint) fu_struct_edid_get_serial_number(st));
    g_string_append_printf(str, "  week_of_manufacture: 0x%x\n",
                           (guint) fu_struct_edid_get_week_of_manufacture(st));
    g_string_append_printf(str, "  year_of_manufacture: 0x%x\n",
                           (guint) fu_struct_edid_get_year_of_manufacture(st));
    g_string_append_printf(str, "  revision_number: 0x%x\n",
                           (guint) fu_struct_edid_get_revision_number(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_edid_get_data_blocks(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  data_blocks: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  extension_block_count: 0x%x\n",
                           (guint) fu_struct_edid_get_extension_block_count(st));
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_edid_get_checksum(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_edid_validate_internal(FuStructEdid *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (memcmp(st->buf->data + 0, "\x00\xFF\xFF\xFF\xFF\xFF\xFF\x00", 8) != 0) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructEdid.header was not valid");
        return FALSE;
    }
    if (fu_struct_edid_get_edid_version_number(st) != 0x1) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructEdid.edid_version_number was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_edid_parse_internal(FuStructEdid *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_edid_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_edid_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_edid_parse_stream: (skip):
 **/
FuStructEdid *
fu_struct_edid_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEdid) st = fu_struct_edid_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 128, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEdid failed read of 0x%x: ", (guint) 128);
        return NULL;
    }
    if (st->buf->len != 128) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEdid requested 0x%x and got 0x%x",
                    (guint) 128,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_edid_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
