/* ShellWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ShellWindow.vala, do not modify */

/*
 * Copyright 2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <mtk/mtk.h>
#include <glib.h>
#include "gala.h"
#include <float.h>
#include <math.h>
#include <meta/meta-window-actor.h>
#include <meta/window.h>
#include <clutter/clutter.h>
#include <meta/display.h>
#include <meta/compositor-mutter.h>
#include <meta/util.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_POSITIONED_WINDOW (gala_positioned_window_get_type ())
#define GALA_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindow))
#define GALA_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))
#define GALA_IS_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_IS_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_POSITIONED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))

typedef struct _GalaPositionedWindow GalaPositionedWindow;
typedef struct _GalaPositionedWindowClass GalaPositionedWindowClass;
typedef struct _GalaPositionedWindowPrivate GalaPositionedWindowPrivate;

#define GALA_TYPE_SHELL_WINDOW (gala_shell_window_get_type ())
#define GALA_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindow))
#define GALA_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))
#define GALA_IS_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHELL_WINDOW))
#define GALA_IS_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHELL_WINDOW))
#define GALA_SHELL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))

typedef struct _GalaShellWindow GalaShellWindow;
typedef struct _GalaShellWindowClass GalaShellWindowClass;
typedef struct _GalaShellWindowPrivate GalaShellWindowPrivate;
enum  {
	GALA_SHELL_WINDOW_0_PROPERTY,
	GALA_SHELL_WINDOW_RESTORE_PREVIOUS_X11_REGION_PROPERTY,
	GALA_SHELL_WINDOW_HIDE_TARGET_PROPERTY,
	GALA_SHELL_WINDOW_NUM_PROPERTIES
};
static GParamSpec* gala_shell_window_properties[GALA_SHELL_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_SHELL_CLIENTS_MANAGER (gala_shell_clients_manager_get_type ())
#define GALA_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManager))
#define GALA_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManagerClass))
#define GALA_IS_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER))
#define GALA_IS_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHELL_CLIENTS_MANAGER))
#define GALA_SHELL_CLIENTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManagerClass))

typedef struct _GalaShellClientsManager GalaShellClientsManager;
typedef struct _GalaShellClientsManagerClass GalaShellClientsManagerClass;
typedef struct _Block52Data Block52Data;

struct _GalaPositionedWindow {
	GObject parent_instance;
	GalaPositionedWindowPrivate * priv;
};

struct _GalaPositionedWindowClass {
	GObjectClass parent_class;
	void (*get_window_position) (GalaPositionedWindow* self, MtkRectangle* window_rect, gint* x, gint* y);
};

struct _GalaShellWindow {
	GalaPositionedWindow parent_instance;
	GalaShellWindowPrivate * priv;
};

struct _GalaShellWindowClass {
	GalaPositionedWindowClass parent_class;
	void (*propagate) (GalaShellWindow* self, GalaGestureTargetUpdateType update_type, GalaGestureAction action, gdouble progress);
	gdouble (*get_hidden_progress) (GalaShellWindow* self);
};

struct _GalaShellWindowPrivate {
	gboolean _restore_previous_x11_region;
	GalaGestureTarget* _hide_target;
	gdouble multitasking_view_progress;
	gint animations_ongoing;
};

struct _Block52Data {
	int _ref_count_;
	GalaShellWindow* self;
	gboolean visible;
	gboolean animating;
	GalaShellClientsManager* manager;
};

static gint GalaShellWindow_private_offset;
static gpointer gala_shell_window_parent_class = NULL;
static GalaGestureTargetIface * gala_shell_window_gala_gesture_target_parent_iface = NULL;

VALA_EXTERN GType gala_positioned_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPositionedWindow, g_object_unref)
VALA_EXTERN GType gala_shell_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShellWindow, g_object_unref)
VALA_EXTERN void gala_shell_window_propagate (GalaShellWindow* self,
                                  GalaGestureTargetUpdateType update_type,
                                  GalaGestureAction action,
                                  gdouble progress);
VALA_EXTERN gdouble gala_shell_window_get_hidden_progress (GalaShellWindow* self);
static void gala_shell_window_real_propagate (GalaShellWindow* self,
                                       GalaGestureTargetUpdateType update_type,
                                       GalaGestureAction action,
                                       gdouble progress);
static void gala_shell_window_update_visibility (GalaShellWindow* self);
static GalaGestureTarget* gala_shell_window_get_hide_target (GalaShellWindow* self);
static gdouble gala_shell_window_real_get_hidden_progress (GalaShellWindow* self);
VALA_EXTERN GType gala_shell_clients_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShellClientsManager, g_object_unref)
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
VALA_EXTERN MetaWindow* gala_positioned_window_get_window (GalaPositionedWindow* self);
static gboolean gala_shell_window_get_restore_previous_x11_region (GalaShellWindow* self);
VALA_EXTERN GalaShellClientsManager* gala_shell_clients_manager_get_instance (void);
static gboolean __lambda9_ (Block52Data* _data52_,
                     MetaWindow* transient);
VALA_EXTERN gboolean gala_shell_clients_manager_is_itself_positioned (GalaShellClientsManager* self,
                                                          MetaWindow* window);
static gboolean ___lambda9__meta_window_foreach_func (MetaWindow* window,
                                               gpointer self);
VALA_EXTERN GalaShellWindow* gala_shell_window_construct (GType object_type);
VALA_EXTERN GalaPositionedWindow* gala_positioned_window_construct (GType object_type);
VALA_EXTERN void gala_shell_window_set_restore_previous_x11_region (GalaShellWindow* self,
                                                        gboolean value);
VALA_EXTERN void gala_shell_window_set_hide_target (GalaShellWindow* self,
                                        GalaGestureTarget* value);
static void gala_shell_window_finalize (GObject * obj);
static GType gala_shell_window_get_type_once (void);
static void _vala_gala_shell_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_shell_window_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
gala_shell_window_get_instance_private (GalaShellWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GalaShellWindow_private_offset);
}

static void
gala_shell_window_real_propagate (GalaShellWindow* self,
                                  GalaGestureTargetUpdateType update_type,
                                  GalaGestureAction action,
                                  gdouble progress)
{
	switch (update_type) {
		case GALA_GESTURE_TARGET_UPDATE_TYPE_START:
		{
			gint _tmp0_;
			_tmp0_ = self->priv->animations_ongoing;
			self->priv->animations_ongoing = _tmp0_ + 1;
			gala_shell_window_update_visibility (self);
			break;
		}
		case GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE:
		{
			GalaGestureTarget* _tmp1_ = NULL;
			GalaGestureTarget* _tmp2_;
			GalaGestureTarget* _tmp3_;
			if (action == GALA_GESTURE_ACTION_MULTITASKING_VIEW) {
				self->priv->multitasking_view_progress = progress;
			}
			_tmp2_ = gala_shell_window_get_hide_target (self);
			_tmp3_ = _tmp2_;
			_tmp1_ = _tmp3_;
			if (_tmp1_ != NULL) {
				gala_gesture_target_propagate (_tmp1_, GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE, GALA_GESTURE_ACTION_CUSTOM, gala_shell_window_get_hidden_progress (self));
			}
			break;
		}
		case GALA_GESTURE_TARGET_UPDATE_TYPE_END:
		{
			gint _tmp4_;
			_tmp4_ = self->priv->animations_ongoing;
			self->priv->animations_ongoing = _tmp4_ - 1;
			gala_shell_window_update_visibility (self);
			break;
		}
		default:
		{
			break;
		}
	}
}

void
gala_shell_window_propagate (GalaShellWindow* self,
                             GalaGestureTargetUpdateType update_type,
                             GalaGestureAction action,
                             gdouble progress)
{
	GalaShellWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GALA_SHELL_WINDOW_GET_CLASS (self);
	if (_klass_->propagate) {
		_klass_->propagate (self, update_type, action, progress);
	}
}

static gdouble
gala_shell_window_real_get_hidden_progress (GalaShellWindow* self)
{
	gdouble result;
	result = self->priv->multitasking_view_progress;
	return result;
}

gdouble
gala_shell_window_get_hidden_progress (GalaShellWindow* self)
{
	GalaShellWindowClass* _klass_;
	g_return_val_if_fail (self != NULL, 0.0);
	_klass_ = GALA_SHELL_WINDOW_GET_CLASS (self);
	if (_klass_->get_hidden_progress) {
		return _klass_->get_hidden_progress (self);
	}
	return -1.0;
}

static Block52Data*
block52_data_ref (Block52Data* _data52_)
{
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}

static void
block52_data_unref (void * _userdata_)
{
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		GalaShellWindow* self;
		self = _data52_->self;
		_g_object_unref0 (self);
		g_slice_free (Block52Data, _data52_);
	}
}

static gboolean
__lambda9_ (Block52Data* _data52_,
            MetaWindow* transient)
{
	GalaShellWindow* self;
	MetaWindowActor* transient_window_actor = NULL;
	GObject* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MetaWindowActor* _tmp2_;
	gboolean result;
	self = _data52_->self;
	g_return_val_if_fail (transient != NULL, FALSE);
	if (gala_shell_clients_manager_is_itself_positioned (_data52_->manager, transient)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = meta_window_get_compositor_private (transient);
	transient_window_actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, meta_window_actor_get_type (), MetaWindowActor);
	if (_data52_->visible) {
		_tmp1_ = !_data52_->animating;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp2_ = transient_window_actor;
	g_object_set ((ClutterActor*) _tmp2_, "visible", _tmp1_, NULL);
	result = TRUE;
	return result;
}

static gboolean
___lambda9__meta_window_foreach_func (MetaWindow* window,
                                      gpointer self)
{
	gboolean result;
	result = __lambda9_ (self, window);
	return result;
}

static void
gala_shell_window_update_visibility (GalaShellWindow* self)
{
	Block52Data* _data52_;
	MetaWindowActor* window_actor = NULL;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	GObject* _tmp2_;
	gboolean _tmp3_ = FALSE;
	MetaWindowActor* _tmp4_;
	MetaWindowActor* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GalaShellClientsManager* _tmp24_;
	MetaWindow* _tmp25_;
	MetaWindow* _tmp26_;
	g_return_if_fail (self != NULL);
	_data52_ = g_slice_new0 (Block52Data);
	_data52_->_ref_count_ = 1;
	_data52_->self = g_object_ref (self);
	_tmp0_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = meta_window_get_compositor_private (_tmp1_);
	window_actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, meta_window_actor_get_type (), MetaWindowActor);
	_data52_->visible = gala_shell_window_get_hidden_progress (self) < 0.1;
	_data52_->animating = self->priv->animations_ongoing > 0;
	if (_data52_->animating) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = _data52_->visible;
	}
	_tmp4_ = window_actor;
	g_object_set ((ClutterActor*) _tmp4_, "visible", _tmp3_, NULL);
	_tmp5_ = window_actor;
	g_object_get ((ClutterActor*) _tmp5_, "visible", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		MetaWindow* _tmp8_;
		MetaWindow* _tmp9_;
		MetaDisplay* _tmp10_;
		MetaDisplay* _tmp11_;
		_tmp8_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = meta_window_get_display (_tmp9_);
		_tmp11_ = _tmp10_;
		meta_disable_unredirect_for_display (_tmp11_);
	} else {
		MetaWindow* _tmp12_;
		MetaWindow* _tmp13_;
		MetaDisplay* _tmp14_;
		MetaDisplay* _tmp15_;
		_tmp12_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = meta_window_get_display (_tmp13_);
		_tmp15_ = _tmp14_;
		meta_enable_unredirect_for_display (_tmp15_);
	}
	if (!meta_is_wayland_compositor ()) {
		MetaWindowActor* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp16_ = window_actor;
		g_object_get ((ClutterActor*) _tmp16_, "visible", &_tmp17_, NULL);
		_tmp18_ = _tmp17_;
		if (_tmp18_) {
			MetaWindow* _tmp19_;
			MetaWindow* _tmp20_;
			gboolean _tmp21_;
			_tmp19_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = self->priv->_restore_previous_x11_region;
			gala_utils_x11_unset_window_pass_through (_tmp20_, _tmp21_);
		} else {
			MetaWindow* _tmp22_;
			MetaWindow* _tmp23_;
			_tmp22_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
			_tmp23_ = _tmp22_;
			gala_utils_x11_set_window_pass_through (_tmp23_);
		}
	}
	_tmp24_ = gala_shell_clients_manager_get_instance ();
	_data52_->manager = _tmp24_;
	_tmp25_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp26_ = _tmp25_;
	meta_window_foreach_transient (_tmp26_, ___lambda9__meta_window_foreach_func, _data52_);
	block52_data_unref (_data52_);
	_data52_ = NULL;
}

GalaShellWindow*
gala_shell_window_construct (GType object_type)
{
	GalaShellWindow * self = NULL;
	self = (GalaShellWindow*) gala_positioned_window_construct (object_type);
	return self;
}

static gboolean
gala_shell_window_get_restore_previous_x11_region (GalaShellWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_restore_previous_x11_region;
	return result;
}

void
gala_shell_window_set_restore_previous_x11_region (GalaShellWindow* self,
                                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_shell_window_get_restore_previous_x11_region (self);
	if (old_value != value) {
		self->priv->_restore_previous_x11_region = value;
		g_object_notify_by_pspec ((GObject *) self, gala_shell_window_properties[GALA_SHELL_WINDOW_RESTORE_PREVIOUS_X11_REGION_PROPERTY]);
	}
}

static GalaGestureTarget*
gala_shell_window_get_hide_target (GalaShellWindow* self)
{
	GalaGestureTarget* result;
	GalaGestureTarget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hide_target;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gala_shell_window_set_hide_target (GalaShellWindow* self,
                                   GalaGestureTarget* value)
{
	GalaGestureTarget* _tmp0_;
	GalaGestureTarget* _tmp1_ = NULL;
	GalaGestureTarget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_hide_target);
	self->priv->_hide_target = _tmp0_;
	_tmp2_ = self->priv->_hide_target;
	_tmp1_ = _tmp2_;
	if (_tmp1_ != NULL) {
		gala_gesture_target_propagate (_tmp1_, GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE, GALA_GESTURE_ACTION_CUSTOM, gala_shell_window_get_hidden_progress (self));
	}
	g_object_notify_by_pspec ((GObject *) self, gala_shell_window_properties[GALA_SHELL_WINDOW_HIDE_TARGET_PROPERTY]);
}

static void
gala_shell_window_class_init (GalaShellWindowClass * klass,
                              gpointer klass_data)
{
	gala_shell_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaShellWindow_private_offset);
	((GalaShellWindowClass *) klass)->propagate = (void (*) (GalaShellWindow*, GalaGestureTargetUpdateType, GalaGestureAction, gdouble)) gala_shell_window_real_propagate;
	((GalaShellWindowClass *) klass)->get_hidden_progress = (gdouble (*) (GalaShellWindow*)) gala_shell_window_real_get_hidden_progress;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_shell_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_shell_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_shell_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SHELL_WINDOW_RESTORE_PREVIOUS_X11_REGION_PROPERTY, gala_shell_window_properties[GALA_SHELL_WINDOW_RESTORE_PREVIOUS_X11_REGION_PROPERTY] = g_param_spec_boolean ("restore-previous-x11-region", "restore-previous-x11-region", "restore-previous-x11-region", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SHELL_WINDOW_HIDE_TARGET_PROPERTY, gala_shell_window_properties[GALA_SHELL_WINDOW_HIDE_TARGET_PROPERTY] = g_param_spec_object ("hide-target", "hide-target", "hide-target", GALA_TYPE_GESTURE_TARGET, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
gala_shell_window_gala_gesture_target_interface_init (GalaGestureTargetIface * iface,
                                                      gpointer iface_data)
{
	gala_shell_window_gala_gesture_target_parent_iface = g_type_interface_peek_parent (iface);
	iface->propagate = (void (*) (GalaGestureTarget*, GalaGestureTargetUpdateType, GalaGestureAction, gdouble)) gala_shell_window_propagate;
}

static void
gala_shell_window_instance_init (GalaShellWindow * self,
                                 gpointer klass)
{
	self->priv = gala_shell_window_get_instance_private (self);
	self->priv->_restore_previous_x11_region = FALSE;
	self->priv->_hide_target = NULL;
	self->priv->multitasking_view_progress = (gdouble) 0;
	self->priv->animations_ongoing = 0;
}

static void
gala_shell_window_finalize (GObject * obj)
{
	GalaShellWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SHELL_WINDOW, GalaShellWindow);
	_g_object_unref0 (self->priv->_hide_target);
	G_OBJECT_CLASS (gala_shell_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_shell_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaShellWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_shell_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaShellWindow), 0, (GInstanceInitFunc) gala_shell_window_instance_init, NULL };
	static const GInterfaceInfo gala_gesture_target_info = { (GInterfaceInitFunc) gala_shell_window_gala_gesture_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_shell_window_type_id;
	gala_shell_window_type_id = g_type_register_static (GALA_TYPE_POSITIONED_WINDOW, "GalaShellWindow", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (gala_shell_window_type_id, GALA_TYPE_GESTURE_TARGET, &gala_gesture_target_info);
	GalaShellWindow_private_offset = g_type_add_instance_private (gala_shell_window_type_id, sizeof (GalaShellWindowPrivate));
	return gala_shell_window_type_id;
}

GType
gala_shell_window_get_type (void)
{
	static gsize gala_shell_window_type_id__once = 0;
	if (g_once_init_enter (&gala_shell_window_type_id__once)) {
		GType gala_shell_window_type_id;
		gala_shell_window_type_id = gala_shell_window_get_type_once ();
		g_once_init_leave (&gala_shell_window_type_id__once, gala_shell_window_type_id);
	}
	return gala_shell_window_type_id__once;
}

static void
_vala_gala_shell_window_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaShellWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SHELL_WINDOW, GalaShellWindow);
	switch (property_id) {
		case GALA_SHELL_WINDOW_RESTORE_PREVIOUS_X11_REGION_PROPERTY:
		g_value_set_boolean (value, gala_shell_window_get_restore_previous_x11_region (self));
		break;
		case GALA_SHELL_WINDOW_HIDE_TARGET_PROPERTY:
		g_value_set_object (value, gala_shell_window_get_hide_target (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_shell_window_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaShellWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SHELL_WINDOW, GalaShellWindow);
	switch (property_id) {
		case GALA_SHELL_WINDOW_RESTORE_PREVIOUS_X11_REGION_PROPERTY:
		gala_shell_window_set_restore_previous_x11_region (self, g_value_get_boolean (value));
		break;
		case GALA_SHELL_WINDOW_HIDE_TARGET_PROPERTY:
		gala_shell_window_set_hide_target (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

