/* contacts-urls-chunk.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-urls-chunk.vala, do not modify */

/*
 * Copyright (C) 2022 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "contactscore.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CONTACTS_URLS_CHUNK_0_PROPERTY,
	CONTACTS_URLS_CHUNK_PROPERTY_NAME_PROPERTY,
	CONTACTS_URLS_CHUNK_DISPLAY_NAME_PROPERTY,
	CONTACTS_URLS_CHUNK_ICON_NAME_PROPERTY,
	CONTACTS_URLS_CHUNK_NUM_PROPERTIES
};
static GParamSpec* contacts_urls_chunk_properties[CONTACTS_URLS_CHUNK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ContactsUrlsChunkSaveToPersonaData ContactsUrlsChunkSaveToPersonaData;
enum  {
	CONTACTS_URL_0_PROPERTY,
	CONTACTS_URL_RAW_URL_PROPERTY,
	CONTACTS_URL_IS_EMPTY_PROPERTY,
	CONTACTS_URL_ICON_NAME_PROPERTY,
	CONTACTS_URL_NUM_PROPERTIES
};
static GParamSpec* contacts_url_properties[CONTACTS_URL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsUrlsChunkSaveToPersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsUrlsChunk* self;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	GeeSet* afds;
	GeeSet* _tmp2_;
	FolksPersona* _tmp3_;
	FolksPersona* _tmp4_;
	GError* _inner_error0_;
};

struct _ContactsUrlPrivate {
	gchar* _raw_url;
};

static gpointer contacts_urls_chunk_parent_class = NULL;
static gint ContactsUrl_private_offset;
static gpointer contacts_url_parent_class = NULL;

static ContactsBinChunkChild* contacts_urls_chunk_real_create_empty_child (ContactsBinChunk* base);
static void contacts_urls_chunk_real_save_to_persona_data_free (gpointer _data);
static void contacts_urls_chunk_real_save_to_persona (ContactsChunk* base,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean contacts_urls_chunk_real_save_to_persona_co (ContactsUrlsChunkSaveToPersonaData* _data_);
static void contacts_urls_chunk_save_to_persona_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static GObject * contacts_urls_chunk_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static GType contacts_urls_chunk_get_type_once (void);
static void _vala_contacts_urls_chunk_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static gint contacts_url_real_compare_internal (ContactsBinChunkChild* base,
                                         ContactsBinChunkChild* other);
static FolksAbstractFieldDetails* contacts_url_real_create_afd (ContactsBinChunkChild* base);
static ContactsBinChunkChild* contacts_url_real_copy (ContactsBinChunkChild* base);
static GVariant* contacts_url_real_to_gvariant_internal (ContactsBinChunkChild* base);
static void contacts_url_real_apply_gvariant (ContactsBinChunkChild* base,
                                       GVariant* variant);
static void contacts_url_finalize (GObject * obj);
static GType contacts_url_get_type_once (void);
static void _vala_contacts_url_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_contacts_url_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static ContactsBinChunkChild*
contacts_urls_chunk_real_create_empty_child (ContactsBinChunk* base)
{
	ContactsUrlsChunk * self;
	ContactsUrl* _tmp0_;
	ContactsBinChunkChild* result;
	self = (ContactsUrlsChunk*) base;
	_tmp0_ = contacts_url_new ();
	result = (ContactsBinChunkChild*) _tmp0_;
	return result;
}

static void
contacts_urls_chunk_real_save_to_persona_data_free (gpointer _data)
{
	ContactsUrlsChunkSaveToPersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsUrlsChunkSaveToPersonaData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
contacts_urls_chunk_real_save_to_persona (ContactsChunk* base,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	ContactsUrlsChunk * self;
	ContactsUrlsChunkSaveToPersonaData* _data_;
	ContactsUrlsChunk* _tmp0_;
	self = (ContactsUrlsChunk*) base;
	_data_ = g_slice_new0 (ContactsUrlsChunkSaveToPersonaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_urls_chunk_real_save_to_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_urls_chunk_real_save_to_persona_co (_data_);
}

static void
contacts_urls_chunk_save_to_persona_finish (ContactsChunk* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	ContactsUrlsChunkSaveToPersonaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
contacts_urls_chunk_save_to_persona_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	ContactsUrlsChunkSaveToPersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_urls_chunk_real_save_to_persona_co (_data_);
}

static gboolean
contacts_urls_chunk_real_save_to_persona_co (ContactsUrlsChunkSaveToPersonaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = contacts_chunk_get_persona ((ContactsChunk*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, FOLKS_TYPE_URL_DETAILS), "this.persona is UrlDetails", FALSE);
	_data_->_tmp2_ = contacts_bin_chunk_get_abstract_field_details ((ContactsBinChunk*) _data_->self);
	_data_->afds = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEE_TYPE_SET, GeeSet);
	_data_->_tmp3_ = contacts_chunk_get_persona ((ContactsChunk*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	folks_url_details_change_urls (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, FOLKS_TYPE_URL_DETAILS, FolksUrlDetails), _data_->afds, contacts_urls_chunk_save_to_persona_ready, _data_);
	return FALSE;
	_state_1:
	folks_url_details_change_urls_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, FOLKS_TYPE_URL_DETAILS, FolksUrlDetails), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->afds);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->afds);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ContactsUrlsChunk*
contacts_urls_chunk_construct (GType object_type)
{
	ContactsUrlsChunk * self = NULL;
	self = (ContactsUrlsChunk*) contacts_bin_chunk_construct (object_type);
	return self;
}

ContactsUrlsChunk*
contacts_urls_chunk_new (void)
{
	return contacts_urls_chunk_construct (CONTACTS_TYPE_URLS_CHUNK);
}

static const gchar*
contacts_urls_chunk_real_get_property_name (ContactsChunk* base)
{
	const gchar* result;
	ContactsUrlsChunk* self;
	self = (ContactsUrlsChunk*) base;
	result = "urls";
	return result;
}

static const gchar*
contacts_urls_chunk_real_get_display_name (ContactsChunk* base)
{
	const gchar* result;
	ContactsUrlsChunk* self;
	self = (ContactsUrlsChunk*) base;
	result = _ ("URLs");
	return result;
}

static const gchar*
contacts_urls_chunk_real_get_icon_name (ContactsChunk* base)
{
	const gchar* result;
	ContactsUrlsChunk* self;
	self = (ContactsUrlsChunk*) base;
	result = "website-symbolic";
	return result;
}

static GObject *
contacts_urls_chunk_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsUrlsChunk * self;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	parent_class = G_OBJECT_CLASS (contacts_urls_chunk_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_URLS_CHUNK, ContactsUrlsChunk);
	_tmp0_ = contacts_chunk_get_persona ((ContactsChunk*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		FolksPersona* _tmp2_;
		FolksPersona* _tmp3_;
		FolksUrlDetails* url_details = NULL;
		FolksPersona* _tmp4_;
		FolksPersona* _tmp5_;
		_tmp2_ = contacts_chunk_get_persona ((ContactsChunk*) self);
		_tmp3_ = _tmp2_;
		_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, FOLKS_TYPE_URL_DETAILS), "persona is UrlDetails");
		_tmp4_ = contacts_chunk_get_persona ((ContactsChunk*) self);
		_tmp5_ = _tmp4_;
		url_details = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FOLKS_TYPE_URL_DETAILS, FolksUrlDetails);
		{
			GeeIterator* _url_field_it = NULL;
			FolksUrlDetails* _tmp6_;
			GeeSet* _tmp7_;
			GeeSet* _tmp8_;
			GeeIterator* _tmp9_;
			_tmp6_ = url_details;
			_tmp7_ = folks_url_details_get_urls (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
			_url_field_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_;
				FolksUrlFieldDetails* url_field = NULL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				ContactsUrl* url = NULL;
				FolksUrlFieldDetails* _tmp13_;
				ContactsUrl* _tmp14_;
				ContactsUrl* _tmp15_;
				_tmp10_ = _url_field_it;
				if (!gee_iterator_next (_tmp10_)) {
					break;
				}
				_tmp11_ = _url_field_it;
				_tmp12_ = gee_iterator_get (_tmp11_);
				url_field = (FolksUrlFieldDetails*) _tmp12_;
				_tmp13_ = url_field;
				_tmp14_ = contacts_url_new_from_field_details (_tmp13_);
				url = _tmp14_;
				_tmp15_ = url;
				contacts_bin_chunk_add_child ((ContactsBinChunk*) self, (ContactsBinChunkChild*) _tmp15_);
				_g_object_unref0 (url);
				_g_object_unref0 (url_field);
			}
			_g_object_unref0 (_url_field_it);
		}
	}
	contacts_bin_chunk_finish_initialization ((ContactsBinChunk*) self);
	return obj;
}

static void
contacts_urls_chunk_class_init (ContactsUrlsChunkClass * klass,
                                gpointer klass_data)
{
	contacts_urls_chunk_parent_class = g_type_class_peek_parent (klass);
	((ContactsBinChunkClass *) klass)->create_empty_child = (ContactsBinChunkChild* (*) (ContactsBinChunk*)) contacts_urls_chunk_real_create_empty_child;
	((ContactsChunkClass *) klass)->save_to_persona = (void (*) (ContactsChunk*, GAsyncReadyCallback, gpointer)) contacts_urls_chunk_real_save_to_persona;
	((ContactsChunkClass *) klass)->save_to_persona_finish = (void (*) (ContactsChunk*, GAsyncResult*, GError**)) contacts_urls_chunk_save_to_persona_finish;
	CONTACTS_CHUNK_CLASS (klass)->get_property_name = (const gchar* (*) (ContactsChunk*)) contacts_urls_chunk_real_get_property_name;
	CONTACTS_CHUNK_CLASS (klass)->get_display_name = (const gchar* (*) (ContactsChunk*)) contacts_urls_chunk_real_get_display_name;
	CONTACTS_CHUNK_CLASS (klass)->get_icon_name = (const gchar* (*) (ContactsChunk*)) contacts_urls_chunk_real_get_icon_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_urls_chunk_get_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_urls_chunk_constructor;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_URLS_CHUNK_PROPERTY_NAME_PROPERTY, contacts_urls_chunk_properties[CONTACTS_URLS_CHUNK_PROPERTY_NAME_PROPERTY] = g_param_spec_string ("property-name", "property-name", "property-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_URLS_CHUNK_DISPLAY_NAME_PROPERTY, contacts_urls_chunk_properties[CONTACTS_URLS_CHUNK_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_URLS_CHUNK_ICON_NAME_PROPERTY, contacts_urls_chunk_properties[CONTACTS_URLS_CHUNK_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_urls_chunk_instance_init (ContactsUrlsChunk * self,
                                   gpointer klass)
{
}

/**
 * A {@link Chunk} that represents the associated URLs of a contact (similar to
 * {@link Folks.UrlDetails}. Each element is a {@link Contacts.Url}.
 */
 G_GNUC_NO_INLINE static GType
contacts_urls_chunk_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsUrlsChunkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_urls_chunk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsUrlsChunk), 0, (GInstanceInitFunc) contacts_urls_chunk_instance_init, NULL };
	GType contacts_urls_chunk_type_id;
	contacts_urls_chunk_type_id = g_type_register_static (CONTACTS_TYPE_BIN_CHUNK, "ContactsUrlsChunk", &g_define_type_info, 0);
	return contacts_urls_chunk_type_id;
}

GType
contacts_urls_chunk_get_type (void)
{
	static volatile gsize contacts_urls_chunk_type_id__once = 0;
	if (g_once_init_enter (&contacts_urls_chunk_type_id__once)) {
		GType contacts_urls_chunk_type_id;
		contacts_urls_chunk_type_id = contacts_urls_chunk_get_type_once ();
		g_once_init_leave (&contacts_urls_chunk_type_id__once, contacts_urls_chunk_type_id);
	}
	return contacts_urls_chunk_type_id__once;
}

static void
_vala_contacts_urls_chunk_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	ContactsUrlsChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_URLS_CHUNK, ContactsUrlsChunk);
	switch (property_id) {
		case CONTACTS_URLS_CHUNK_PROPERTY_NAME_PROPERTY:
		g_value_set_string (value, contacts_chunk_get_property_name ((ContactsChunk*) self));
		break;
		case CONTACTS_URLS_CHUNK_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, contacts_chunk_get_display_name ((ContactsChunk*) self));
		break;
		case CONTACTS_URLS_CHUNK_ICON_NAME_PROPERTY:
		g_value_set_string (value, contacts_chunk_get_icon_name ((ContactsChunk*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_url_get_instance_private (ContactsUrl* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsUrl_private_offset);
}

ContactsUrl*
contacts_url_construct (GType object_type)
{
	ContactsUrl * self = NULL;
	GeeHashMultiMap* _tmp0_;
	GeeHashMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	self = (ContactsUrl*) contacts_bin_chunk_child_construct (object_type);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	contacts_bin_chunk_child_set_parameters ((ContactsBinChunkChild*) self, (GeeMultiMap*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = contacts_bin_chunk_child_get_parameters ((ContactsBinChunkChild*) self);
	_tmp3_ = _tmp2_;
	gee_multi_map_set (_tmp3_, "type", "PERSONAL");
	return self;
}

ContactsUrl*
contacts_url_new (void)
{
	return contacts_url_construct (CONTACTS_TYPE_URL);
}

ContactsUrl*
contacts_url_construct_from_field_details (GType object_type,
                                           FolksUrlFieldDetails* url_field)
{
	ContactsUrl * self = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	g_return_val_if_fail (url_field != NULL, NULL);
	self = (ContactsUrl*) contacts_bin_chunk_child_construct (object_type);
	_tmp0_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) url_field);
	_tmp1_ = _tmp0_;
	contacts_url_set_raw_url (self, (const gchar*) _tmp1_);
	_tmp2_ = folks_abstract_field_details_get_parameters ((FolksAbstractFieldDetails*) url_field);
	_tmp3_ = _tmp2_;
	contacts_bin_chunk_child_set_parameters ((ContactsBinChunkChild*) self, _tmp3_);
	return self;
}

ContactsUrl*
contacts_url_new_from_field_details (FolksUrlFieldDetails* url_field)
{
	return contacts_url_construct_from_field_details (CONTACTS_TYPE_URL, url_field);
}

static gint
contacts_url_real_compare_internal (ContactsBinChunkChild* base,
                                    ContactsBinChunkChild* other)
{
	ContactsUrl * self;
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
	self = (ContactsUrl*) base;
	g_return_val_if_fail (other != NULL, 0);
	_vala_return_val_if_fail (CONTACTS_IS_URL (other), "other is Url", 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = contacts_url_get_raw_url (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = contacts_url_get_raw_url (G_TYPE_CHECK_INSTANCE_CAST (other, CONTACTS_TYPE_URL, ContactsUrl));
	_tmp4_ = _tmp3_;
	result = _tmp0_ (_tmp2_, _tmp4_);
	return result;
}

/**
   * Tries to return an absolute URL (with a scheme).
   * Since we know contact URL values are for web addresses, we try to fall
   * back to https if there is no known scheme
   */
gchar*
contacts_url_get_absolute_url (ContactsUrl* self)
{
	gchar* scheme = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_url_get_raw_url (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_uri_parse_scheme (_tmp1_);
	scheme = _tmp2_;
	_tmp4_ = scheme;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = contacts_url_get_raw_url (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp7_;
	} else {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = contacts_url_get_raw_url (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("https://", _tmp9_, NULL);
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp10_;
	}
	result = _tmp3_;
	_g_free0 (scheme);
	return result;
}

static FolksAbstractFieldDetails*
contacts_url_real_create_afd (ContactsBinChunkChild* base)
{
	ContactsUrl * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GeeMultiMap* _tmp4_;
	GeeMultiMap* _tmp5_;
	FolksUrlFieldDetails* _tmp6_;
	FolksAbstractFieldDetails* result;
	self = (ContactsUrl*) base;
	_tmp0_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = contacts_url_get_raw_url (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_bin_chunk_child_get_parameters ((ContactsBinChunkChild*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_url_field_details_new (_tmp3_, _tmp5_);
	result = (FolksAbstractFieldDetails*) _tmp6_;
	return result;
}

static ContactsBinChunkChild*
contacts_url_real_copy (ContactsBinChunkChild* base)
{
	ContactsUrl * self;
	ContactsUrl* url = NULL;
	ContactsUrl* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ContactsBinChunkChild* result;
	self = (ContactsUrl*) base;
	_tmp0_ = contacts_url_new ();
	url = _tmp0_;
	_tmp1_ = contacts_url_get_raw_url (self);
	_tmp2_ = _tmp1_;
	contacts_url_set_raw_url (url, _tmp2_);
	contacts_bin_chunk_child_copy_parameters ((ContactsBinChunkChild*) self, (ContactsBinChunkChild*) url);
	result = (ContactsBinChunkChild*) url;
	return result;
}

static GVariant*
contacts_url_real_to_gvariant_internal (ContactsBinChunkChild* base)
{
	ContactsUrl * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* result;
	self = (ContactsUrl*) base;
	_tmp0_ = contacts_url_get_raw_url (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = contacts_bin_chunk_child_parameters_to_gvariant ((ContactsBinChunkChild*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_new ("(sv)", _tmp1_, _tmp3_, NULL);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_variant_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static void
contacts_url_real_apply_gvariant (ContactsBinChunkChild* base,
                                  GVariant* variant)
{
	ContactsUrl * self;
	const GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	gchar* url = NULL;
	GVariant* params_variant = NULL;
	gchar* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	self = (ContactsUrl*) base;
	g_return_if_fail (variant != NULL);
	_tmp0_ = g_variant_get_type (variant);
	_tmp1_ = g_variant_type_new ("(sv)");
	_tmp2_ = _tmp1_;
	_vala_return_if_fail (g_variant_type_equal (_tmp0_, _tmp2_), "variant.get_type ().equal (new VariantType (\"(sv)\"))");
	g_variant_get (variant, "(sv)", &_tmp3_, &_tmp4_, NULL);
	_g_free0 (url);
	url = _tmp3_;
	_g_variant_unref0 (params_variant);
	params_variant = _tmp4_;
	_g_variant_type_free0 (_tmp2_);
	contacts_url_set_raw_url (self, url);
	contacts_bin_chunk_child_apply_gvariant_parameters ((ContactsBinChunkChild*) self, params_variant);
	_g_variant_unref0 (params_variant);
	_g_free0 (url);
}

const gchar*
contacts_url_get_raw_url (ContactsUrl* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_raw_url;
	result = _tmp0_;
	return result;
}

void
contacts_url_set_raw_url (ContactsUrl* self,
                          const gchar* value)
{
	g_return_if_fail (self != NULL);
	contacts_bin_chunk_child_change_string_prop ((ContactsBinChunkChild*) self, "raw-url", &self->priv->_raw_url, value);
	g_object_notify_by_pspec ((GObject *) self, contacts_url_properties[CONTACTS_URL_RAW_URL_PROPERTY]);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
contacts_url_real_get_is_empty (ContactsBinChunkChild* base)
{
	gboolean result;
	ContactsUrl* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	self = (ContactsUrl*) base;
	_tmp0_ = contacts_url_get_raw_url (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_strip (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") == 0;
	_g_free0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static const gchar*
contacts_url_real_get_icon_name (ContactsBinChunkChild* base)
{
	const gchar* result;
	ContactsUrl* self;
	self = (ContactsUrl*) base;
	result = "website-symbolic";
	return result;
}

static void
contacts_url_class_init (ContactsUrlClass * klass,
                         gpointer klass_data)
{
	contacts_url_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsUrl_private_offset);
	((ContactsBinChunkChildClass *) klass)->compare_internal = (gint (*) (ContactsBinChunkChild*, ContactsBinChunkChild*)) contacts_url_real_compare_internal;
	((ContactsBinChunkChildClass *) klass)->create_afd = (FolksAbstractFieldDetails* (*) (ContactsBinChunkChild*)) contacts_url_real_create_afd;
	((ContactsBinChunkChildClass *) klass)->copy = (ContactsBinChunkChild* (*) (ContactsBinChunkChild*)) contacts_url_real_copy;
	((ContactsBinChunkChildClass *) klass)->to_gvariant_internal = (GVariant* (*) (ContactsBinChunkChild*)) contacts_url_real_to_gvariant_internal;
	((ContactsBinChunkChildClass *) klass)->apply_gvariant = (void (*) (ContactsBinChunkChild*, GVariant*)) contacts_url_real_apply_gvariant;
	CONTACTS_BIN_CHUNK_CHILD_CLASS (klass)->get_is_empty = (gboolean (*) (ContactsBinChunkChild*)) contacts_url_real_get_is_empty;
	CONTACTS_BIN_CHUNK_CHILD_CLASS (klass)->get_icon_name = (const gchar* (*) (ContactsBinChunkChild*)) contacts_url_real_get_icon_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_url_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_url_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_url_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_URL_RAW_URL_PROPERTY, contacts_url_properties[CONTACTS_URL_RAW_URL_PROPERTY] = g_param_spec_string ("raw-url", "raw-url", "raw-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_URL_IS_EMPTY_PROPERTY, contacts_url_properties[CONTACTS_URL_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_URL_ICON_NAME_PROPERTY, contacts_url_properties[CONTACTS_URL_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_url_instance_init (ContactsUrl * self,
                            gpointer klass)
{
	gchar* _tmp0_;
	self->priv = contacts_url_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_raw_url = _tmp0_;
}

static void
contacts_url_finalize (GObject * obj)
{
	ContactsUrl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_URL, ContactsUrl);
	_g_free0 (self->priv->_raw_url);
	G_OBJECT_CLASS (contacts_url_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_url_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsUrlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_url_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsUrl), 0, (GInstanceInitFunc) contacts_url_instance_init, NULL };
	GType contacts_url_type_id;
	contacts_url_type_id = g_type_register_static (CONTACTS_TYPE_BIN_CHUNK_CHILD, "ContactsUrl", &g_define_type_info, 0);
	ContactsUrl_private_offset = g_type_add_instance_private (contacts_url_type_id, sizeof (ContactsUrlPrivate));
	return contacts_url_type_id;
}

GType
contacts_url_get_type (void)
{
	static volatile gsize contacts_url_type_id__once = 0;
	if (g_once_init_enter (&contacts_url_type_id__once)) {
		GType contacts_url_type_id;
		contacts_url_type_id = contacts_url_get_type_once ();
		g_once_init_leave (&contacts_url_type_id__once, contacts_url_type_id);
	}
	return contacts_url_type_id__once;
}

static void
_vala_contacts_url_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	ContactsUrl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_URL, ContactsUrl);
	switch (property_id) {
		case CONTACTS_URL_RAW_URL_PROPERTY:
		g_value_set_string (value, contacts_url_get_raw_url (self));
		break;
		case CONTACTS_URL_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) self));
		break;
		case CONTACTS_URL_ICON_NAME_PROPERTY:
		g_value_set_string (value, contacts_bin_chunk_child_get_icon_name ((ContactsBinChunkChild*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_url_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	ContactsUrl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_URL, ContactsUrl);
	switch (property_id) {
		case CONTACTS_URL_RAW_URL_PROPERTY:
		contacts_url_set_raw_url (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

