/* Generated by wayland-scanner 1.24.0 */

#ifndef CONTRAST_CLIENT_PROTOCOL_H
#define CONTRAST_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_contrast The contrast protocol
 * @section page_ifaces_contrast Interfaces
 * - @subpage page_iface_org_kde_kwin_contrast_manager - 
 * - @subpage page_iface_org_kde_kwin_contrast - 
 * @section page_copyright_contrast Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2015 Martin Gräßlin
 * SPDX-FileCopyrightText: 2015 Marco Martin
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_kwin_contrast;
struct org_kde_kwin_contrast_manager;
struct wl_region;
struct wl_surface;

#ifndef ORG_KDE_KWIN_CONTRAST_MANAGER_INTERFACE
#define ORG_KDE_KWIN_CONTRAST_MANAGER_INTERFACE
/**
 * @page page_iface_org_kde_kwin_contrast_manager org_kde_kwin_contrast_manager
 * @section page_iface_org_kde_kwin_contrast_manager_api API
 * See @ref iface_org_kde_kwin_contrast_manager.
 */
/**
 * @defgroup iface_org_kde_kwin_contrast_manager The org_kde_kwin_contrast_manager interface
 */
extern const struct wl_interface org_kde_kwin_contrast_manager_interface;
#endif
#ifndef ORG_KDE_KWIN_CONTRAST_INTERFACE
#define ORG_KDE_KWIN_CONTRAST_INTERFACE
/**
 * @page page_iface_org_kde_kwin_contrast org_kde_kwin_contrast
 * @section page_iface_org_kde_kwin_contrast_api API
 * See @ref iface_org_kde_kwin_contrast.
 */
/**
 * @defgroup iface_org_kde_kwin_contrast The org_kde_kwin_contrast interface
 */
extern const struct wl_interface org_kde_kwin_contrast_interface;
#endif

#define ORG_KDE_KWIN_CONTRAST_MANAGER_CREATE 0
#define ORG_KDE_KWIN_CONTRAST_MANAGER_UNSET 1


/**
 * @ingroup iface_org_kde_kwin_contrast_manager
 */
#define ORG_KDE_KWIN_CONTRAST_MANAGER_CREATE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast_manager
 */
#define ORG_KDE_KWIN_CONTRAST_MANAGER_UNSET_SINCE_VERSION 1

/** @ingroup iface_org_kde_kwin_contrast_manager */
static inline void
org_kde_kwin_contrast_manager_set_user_data(struct org_kde_kwin_contrast_manager *org_kde_kwin_contrast_manager, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_contrast_manager, user_data);
}

/** @ingroup iface_org_kde_kwin_contrast_manager */
static inline void *
org_kde_kwin_contrast_manager_get_user_data(struct org_kde_kwin_contrast_manager *org_kde_kwin_contrast_manager)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_contrast_manager);
}

static inline uint32_t
org_kde_kwin_contrast_manager_get_version(struct org_kde_kwin_contrast_manager *org_kde_kwin_contrast_manager)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_contrast_manager);
}

/** @ingroup iface_org_kde_kwin_contrast_manager */
static inline void
org_kde_kwin_contrast_manager_destroy(struct org_kde_kwin_contrast_manager *org_kde_kwin_contrast_manager)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_kwin_contrast_manager);
}

/**
 * @ingroup iface_org_kde_kwin_contrast_manager
 */
static inline struct org_kde_kwin_contrast *
org_kde_kwin_contrast_manager_create(struct org_kde_kwin_contrast_manager *org_kde_kwin_contrast_manager, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_contrast_manager,
			 ORG_KDE_KWIN_CONTRAST_MANAGER_CREATE, &org_kde_kwin_contrast_interface, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_contrast_manager), 0, NULL, surface);

	return (struct org_kde_kwin_contrast *) id;
}

/**
 * @ingroup iface_org_kde_kwin_contrast_manager
 */
static inline void
org_kde_kwin_contrast_manager_unset(struct org_kde_kwin_contrast_manager *org_kde_kwin_contrast_manager, struct wl_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_contrast_manager,
			 ORG_KDE_KWIN_CONTRAST_MANAGER_UNSET, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_contrast_manager), 0, surface);
}

#define ORG_KDE_KWIN_CONTRAST_COMMIT 0
#define ORG_KDE_KWIN_CONTRAST_SET_REGION 1
#define ORG_KDE_KWIN_CONTRAST_SET_CONTRAST 2
#define ORG_KDE_KWIN_CONTRAST_SET_INTENSITY 3
#define ORG_KDE_KWIN_CONTRAST_SET_SATURATION 4
#define ORG_KDE_KWIN_CONTRAST_RELEASE 5
#define ORG_KDE_KWIN_CONTRAST_SET_FROST 6
#define ORG_KDE_KWIN_CONTRAST_UNSET_FROST 7


/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_SET_REGION_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_SET_CONTRAST_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_SET_INTENSITY_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_SET_SATURATION_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_RELEASE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_SET_FROST_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_UNSET_FROST_SINCE_VERSION 2

/** @ingroup iface_org_kde_kwin_contrast */
static inline void
org_kde_kwin_contrast_set_user_data(struct org_kde_kwin_contrast *org_kde_kwin_contrast, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_contrast, user_data);
}

/** @ingroup iface_org_kde_kwin_contrast */
static inline void *
org_kde_kwin_contrast_get_user_data(struct org_kde_kwin_contrast *org_kde_kwin_contrast)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_contrast);
}

static inline uint32_t
org_kde_kwin_contrast_get_version(struct org_kde_kwin_contrast *org_kde_kwin_contrast)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_contrast);
}

/** @ingroup iface_org_kde_kwin_contrast */
static inline void
org_kde_kwin_contrast_destroy(struct org_kde_kwin_contrast *org_kde_kwin_contrast)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_kwin_contrast);
}

/**
 * @ingroup iface_org_kde_kwin_contrast
 */
static inline void
org_kde_kwin_contrast_commit(struct org_kde_kwin_contrast *org_kde_kwin_contrast)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_contrast,
			 ORG_KDE_KWIN_CONTRAST_COMMIT, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_contrast), 0);
}

/**
 * @ingroup iface_org_kde_kwin_contrast
 */
static inline void
org_kde_kwin_contrast_set_region(struct org_kde_kwin_contrast *org_kde_kwin_contrast, struct wl_region *region)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_contrast,
			 ORG_KDE_KWIN_CONTRAST_SET_REGION, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_contrast), 0, region);
}

/**
 * @ingroup iface_org_kde_kwin_contrast
 */
static inline void
org_kde_kwin_contrast_set_contrast(struct org_kde_kwin_contrast *org_kde_kwin_contrast, wl_fixed_t contrast)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_contrast,
			 ORG_KDE_KWIN_CONTRAST_SET_CONTRAST, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_contrast), 0, contrast);
}

/**
 * @ingroup iface_org_kde_kwin_contrast
 */
static inline void
org_kde_kwin_contrast_set_intensity(struct org_kde_kwin_contrast *org_kde_kwin_contrast, wl_fixed_t intensity)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_contrast,
			 ORG_KDE_KWIN_CONTRAST_SET_INTENSITY, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_contrast), 0, intensity);
}

/**
 * @ingroup iface_org_kde_kwin_contrast
 */
static inline void
org_kde_kwin_contrast_set_saturation(struct org_kde_kwin_contrast *org_kde_kwin_contrast, wl_fixed_t saturation)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_contrast,
			 ORG_KDE_KWIN_CONTRAST_SET_SATURATION, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_contrast), 0, saturation);
}

/**
 * @ingroup iface_org_kde_kwin_contrast
 */
static inline void
org_kde_kwin_contrast_release(struct org_kde_kwin_contrast *org_kde_kwin_contrast)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_contrast,
			 ORG_KDE_KWIN_CONTRAST_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_contrast), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_org_kde_kwin_contrast
 *
 * enables 'frost' variant of contrast effect.
 *
 * 'frost' is an enhanced version of the contrast effect that
 * uses different colour arithmetic to get backgrounds simultaneously
 * higher in contrast and (apparent) transparency.
 *
 * r, g, b, a are channels from 0-255, indicating a colour to use in contrast calculation.
 * should be based off of the "main" background colour of the surface.
 */
static inline void
org_kde_kwin_contrast_set_frost(struct org_kde_kwin_contrast *org_kde_kwin_contrast, int32_t red, int32_t green, int32_t blue, int32_t alpha)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_contrast,
			 ORG_KDE_KWIN_CONTRAST_SET_FROST, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_contrast), 0, red, green, blue, alpha);
}

/**
 * @ingroup iface_org_kde_kwin_contrast
 */
static inline void
org_kde_kwin_contrast_unset_frost(struct org_kde_kwin_contrast *org_kde_kwin_contrast)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_contrast,
			 ORG_KDE_KWIN_CONTRAST_UNSET_FROST, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_contrast), 0);
}

#ifdef  __cplusplus
}
#endif

#endif
