/* GlobalSearchDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from GlobalSearchDialog.vala, do not modify */

/*
* Copyright 2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA.
*
* Authored by: Jeremy Wootten <jeremy@elementaryos.org>
*/

#include "codecore.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <granite.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_0_PROPERTY,
	SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_FOLDER_NAME_PROPERTY,
	SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_IS_REPO_PROPERTY,
	SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_SEARCH_TERM_PROPERTY,
	SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_CASE_SENSITIVE_PROPERTY,
	SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_WHOLEWORD_PROPERTY,
	SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_USE_REGEX_PROPERTY,
	SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_NUM_PROPERTIES
};
static GParamSpec* scratch_dialogs_global_search_dialog_properties[SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _ScratchDialogsGlobalSearchDialogPrivate {
	gchar* _folder_name;
	gboolean _is_repo;
	GraniteValidatedEntry* search_term_entry;
	gboolean _case_sensitive;
	gboolean _wholeword;
	gboolean _use_regex;
};

static gint ScratchDialogsGlobalSearchDialog_private_offset;
static gpointer scratch_dialogs_global_search_dialog_parent_class = NULL;

static GObject * scratch_dialogs_global_search_dialog_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties);
static void _scratch_dialogs_global_search_dialog___lambda96_ (ScratchDialogsGlobalSearchDialog* self);
static void __scratch_dialogs_global_search_dialog___lambda96__gtk_editable_changed (GtkEditable* _sender,
                                                                              gpointer self);
static void scratch_dialogs_global_search_dialog_finalize (GObject * obj);
static GType scratch_dialogs_global_search_dialog_get_type_once (void);
static void _vala_scratch_dialogs_global_search_dialog_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_scratch_dialogs_global_search_dialog_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);

static inline gpointer
scratch_dialogs_global_search_dialog_get_instance_private (ScratchDialogsGlobalSearchDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchDialogsGlobalSearchDialog_private_offset);
}

ScratchDialogsGlobalSearchDialog*
scratch_dialogs_global_search_dialog_construct (GType object_type,
                                                const gchar* folder_name,
                                                gboolean is_repo,
                                                gboolean case_sensitive,
                                                gboolean wholeword,
                                                gboolean use_regex)
{
	ScratchDialogsGlobalSearchDialog * self = NULL;
	g_return_val_if_fail (folder_name != NULL, NULL);
	self = (ScratchDialogsGlobalSearchDialog*) g_object_new (object_type, "folder-name", folder_name, "is-repo", is_repo, "case-sensitive", case_sensitive, "wholeword", wholeword, "use-regex", use_regex, NULL);
	return self;
}

ScratchDialogsGlobalSearchDialog*
scratch_dialogs_global_search_dialog_new (const gchar* folder_name,
                                          gboolean is_repo,
                                          gboolean case_sensitive,
                                          gboolean wholeword,
                                          gboolean use_regex)
{
	return scratch_dialogs_global_search_dialog_construct (SCRATCH_DIALOGS_TYPE_GLOBAL_SEARCH_DIALOG, folder_name, is_repo, case_sensitive, wholeword, use_regex);
}

const gchar*
scratch_dialogs_global_search_dialog_get_folder_name (ScratchDialogsGlobalSearchDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_folder_name;
	result = _tmp0_;
	return result;
}

static void
scratch_dialogs_global_search_dialog_set_folder_name (ScratchDialogsGlobalSearchDialog* self,
                                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_dialogs_global_search_dialog_get_folder_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_folder_name);
		self->priv->_folder_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_global_search_dialog_properties[SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_FOLDER_NAME_PROPERTY]);
	}
}

gboolean
scratch_dialogs_global_search_dialog_get_is_repo (ScratchDialogsGlobalSearchDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_repo;
	return result;
}

static void
scratch_dialogs_global_search_dialog_set_is_repo (ScratchDialogsGlobalSearchDialog* self,
                                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_dialogs_global_search_dialog_get_is_repo (self);
	if (old_value != value) {
		self->priv->_is_repo = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_global_search_dialog_properties[SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_IS_REPO_PROPERTY]);
	}
}

const gchar*
scratch_dialogs_global_search_dialog_get_search_term (ScratchDialogsGlobalSearchDialog* self)
{
	const gchar* result;
	GraniteValidatedEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->search_term_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
scratch_dialogs_global_search_dialog_set_search_term (ScratchDialogsGlobalSearchDialog* self,
                                                      const gchar* value)
{
	GraniteValidatedEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_term_entry;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_global_search_dialog_properties[SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_SEARCH_TERM_PROPERTY]);
}

gboolean
scratch_dialogs_global_search_dialog_get_case_sensitive (ScratchDialogsGlobalSearchDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_case_sensitive;
	return result;
}

static void
scratch_dialogs_global_search_dialog_set_case_sensitive (ScratchDialogsGlobalSearchDialog* self,
                                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_dialogs_global_search_dialog_get_case_sensitive (self);
	if (old_value != value) {
		self->priv->_case_sensitive = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_global_search_dialog_properties[SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_CASE_SENSITIVE_PROPERTY]);
	}
}

gboolean
scratch_dialogs_global_search_dialog_get_wholeword (ScratchDialogsGlobalSearchDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_wholeword;
	return result;
}

static void
scratch_dialogs_global_search_dialog_set_wholeword (ScratchDialogsGlobalSearchDialog* self,
                                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_dialogs_global_search_dialog_get_wholeword (self);
	if (old_value != value) {
		self->priv->_wholeword = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_global_search_dialog_properties[SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_WHOLEWORD_PROPERTY]);
	}
}

gboolean
scratch_dialogs_global_search_dialog_get_use_regex (ScratchDialogsGlobalSearchDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_regex;
	return result;
}

static void
scratch_dialogs_global_search_dialog_set_use_regex (ScratchDialogsGlobalSearchDialog* self,
                                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_dialogs_global_search_dialog_get_use_regex (self);
	if (old_value != value) {
		self->priv->_use_regex = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_global_search_dialog_properties[SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_USE_REGEX_PROPERTY]);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_scratch_dialogs_global_search_dialog___lambda96_ (ScratchDialogsGlobalSearchDialog* self)
{
	GraniteValidatedEntry* _tmp0_;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = self->priv->search_term_entry;
	_tmp1_ = self->priv->search_term_entry;
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	granite_validated_entry_set_is_valid (_tmp0_, _tmp5_ >= 3);
	_tmp6_ = self->priv->_use_regex;
	if (_tmp6_) {
		{
			GRegex* search_regex = NULL;
			GraniteValidatedEntry* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			GRegex* _tmp10_;
			_tmp7_ = self->priv->search_term_entry;
			_tmp8_ = gtk_entry_get_text ((GtkEntry*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_regex_new (_tmp9_, 0, 0, &_inner_error0_);
			search_regex = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_g_regex_unref0 (search_regex);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GraniteValidatedEntry* _tmp11_;
			g_clear_error (&_inner_error0_);
			_tmp11_ = self->priv->search_term_entry;
			granite_validated_entry_set_is_valid (_tmp11_, FALSE);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
__scratch_dialogs_global_search_dialog___lambda96__gtk_editable_changed (GtkEditable* _sender,
                                                                         gpointer self)
{
	_scratch_dialogs_global_search_dialog___lambda96_ ((ScratchDialogsGlobalSearchDialog*) self);
}

static GObject *
scratch_dialogs_global_search_dialog_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchDialogsGlobalSearchDialog * self;
	GApplication* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	GThemedIcon* _tmp3_;
	GThemedIcon* _tmp4_;
	GraniteValidatedEntry* _tmp5_ = NULL;
	gchar* case_text = NULL;
	gchar* _tmp6_;
	gchar* wholeword_text = NULL;
	gchar* _tmp7_;
	gchar* regex_text = NULL;
	gchar* _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GtkBox* box = NULL;
	GtkBox* _tmp20_;
	gboolean _tmp21_;
	GtkBox* _tmp35_;
	GraniteValidatedEntry* _tmp36_;
	GtkBin* _tmp37_;
	GtkBin* _tmp38_;
	GtkBox* _tmp39_;
	GtkBin* _tmp40_;
	GtkBin* _tmp41_;
	GtkButton* search_button = NULL;
	GtkWidget* _tmp42_;
	GtkButton* _tmp43_;
	GtkButton* _tmp44_;
	GtkButton* _tmp45_;
	GtkButton* _tmp46_;
	GtkStyleContext* _tmp47_;
	GraniteValidatedEntry* _tmp48_;
	GtkButton* _tmp49_;
	GraniteValidatedEntry* _tmp50_;
	parent_class = G_OBJECT_CLASS (scratch_dialogs_global_search_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_DIALOGS_TYPE_GLOBAL_SEARCH_DIALOG, ScratchDialogsGlobalSearchDialog);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	_tmp2_ = _tmp1_;
	gtk_window_set_transient_for ((GtkWindow*) self, _tmp2_);
	_tmp3_ = (GThemedIcon*) g_themed_icon_new ("edit-find");
	_tmp4_ = _tmp3_;
	granite_message_dialog_set_image_icon ((GraniteMessageDialog*) self, (GIcon*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = granite_validated_entry_new ();
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp5_, 12);
	gtk_entry_set_width_chars ((GtkEntry*) _tmp5_, 30);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->search_term_entry);
	self->priv->search_term_entry = _tmp5_;
	_tmp6_ = g_strdup ("");
	case_text = _tmp6_;
	_tmp7_ = g_strdup ("");
	wholeword_text = _tmp7_;
	_tmp8_ = g_strdup ("");
	regex_text = _tmp8_;
	_tmp9_ = self->priv->_use_regex;
	if (_tmp9_) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (_ ("The search term will be treated as a regex expression"));
		_g_free0 (regex_text);
		regex_text = _tmp10_;
	} else {
		const gchar* _tmp11_ = NULL;
		gboolean _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_;
		gchar* _tmp16_;
		_tmp12_ = self->priv->_case_sensitive;
		if (_tmp12_) {
			_tmp11_ = _ ("Search will be case sensitive");
		} else {
			_tmp11_ = _ ("Search will be case insensitive");
		}
		_tmp13_ = g_strdup (_tmp11_);
		_g_free0 (case_text);
		case_text = _tmp13_;
		_tmp15_ = self->priv->_wholeword;
		if (_tmp15_) {
			_tmp14_ = _ ("Search will match only whole words");
		} else {
			_tmp14_ = "";
		}
		_tmp16_ = g_strdup (_tmp14_);
		_g_free0 (wholeword_text);
		wholeword_text = _tmp16_;
	}
	_tmp17_ = self->priv->_folder_name;
	_tmp18_ = g_strdup_printf (_ ("Search for text in “%s”"), _tmp17_);
	_tmp19_ = _tmp18_;
	granite_message_dialog_set_primary_text ((GraniteMessageDialog*) self, _tmp19_);
	_g_free0 (_tmp19_);
	granite_message_dialog_set_secondary_text ((GraniteMessageDialog*) self, _ ("The search term must be at least 3 characters long."));
	_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp20_);
	box = _tmp20_;
	_tmp21_ = self->priv->_use_regex;
	if (!_tmp21_) {
		GtkBox* _tmp22_;
		const gchar* _tmp23_;
		GtkLabel* _tmp24_ = NULL;
		GtkLabel* _tmp25_;
		gboolean _tmp26_;
		_tmp22_ = box;
		_tmp23_ = case_text;
		_tmp24_ = (GtkLabel*) gtk_label_new (_tmp23_);
		gtk_widget_set_halign ((GtkWidget*) _tmp24_, GTK_ALIGN_START);
		g_object_ref_sink (_tmp24_);
		_tmp25_ = _tmp24_;
		gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp25_);
		_g_object_unref0 (_tmp25_);
		_tmp26_ = self->priv->_wholeword;
		if (_tmp26_) {
			GtkBox* _tmp27_;
			const gchar* _tmp28_;
			GtkLabel* _tmp29_ = NULL;
			GtkLabel* _tmp30_;
			_tmp27_ = box;
			_tmp28_ = wholeword_text;
			_tmp29_ = (GtkLabel*) gtk_label_new (_tmp28_);
			gtk_widget_set_halign ((GtkWidget*) _tmp29_, GTK_ALIGN_START);
			g_object_ref_sink (_tmp29_);
			_tmp30_ = _tmp29_;
			gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp30_);
			_g_object_unref0 (_tmp30_);
		}
	} else {
		GtkBox* _tmp31_;
		const gchar* _tmp32_;
		GtkLabel* _tmp33_ = NULL;
		GtkLabel* _tmp34_;
		_tmp31_ = box;
		_tmp32_ = regex_text;
		_tmp33_ = (GtkLabel*) gtk_label_new (_tmp32_);
		gtk_widget_set_halign ((GtkWidget*) _tmp33_, GTK_ALIGN_START);
		g_object_ref_sink (_tmp33_);
		_tmp34_ = _tmp33_;
		gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp34_);
		_g_object_unref0 (_tmp34_);
	}
	_tmp35_ = box;
	_tmp36_ = self->priv->search_term_entry;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = granite_message_dialog_get_custom_bin ((GraniteMessageDialog*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = box;
	gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = granite_message_dialog_get_custom_bin ((GraniteMessageDialog*) self);
	_tmp41_ = _tmp40_;
	gtk_widget_show_all ((GtkWidget*) _tmp41_);
	gtk_dialog_add_button ((GtkDialog*) self, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp42_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Search"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_button_get_type (), GtkButton));
	search_button = _tmp43_;
	_tmp44_ = search_button;
	gtk_widget_set_can_default ((GtkWidget*) _tmp44_, TRUE);
	_tmp45_ = search_button;
	g_object_set ((GtkWidget*) _tmp45_, "has-default", TRUE, NULL);
	_tmp46_ = search_button;
	_tmp47_ = gtk_widget_get_style_context ((GtkWidget*) _tmp46_);
	gtk_style_context_add_class (_tmp47_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp48_ = self->priv->search_term_entry;
	_tmp49_ = search_button;
	g_object_bind_property_with_closures ((GObject*) _tmp48_, "is-valid", (GObject*) _tmp49_, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp50_ = self->priv->search_term_entry;
	g_signal_connect_object ((GtkEditable*) _tmp50_, "changed", (GCallback) __scratch_dialogs_global_search_dialog___lambda96__gtk_editable_changed, self, 0);
	_g_object_unref0 (search_button);
	_g_object_unref0 (box);
	_g_free0 (regex_text);
	_g_free0 (wholeword_text);
	_g_free0 (case_text);
	return obj;
}

static void
scratch_dialogs_global_search_dialog_class_init (ScratchDialogsGlobalSearchDialogClass * klass,
                                                 gpointer klass_data)
{
	scratch_dialogs_global_search_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchDialogsGlobalSearchDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_dialogs_global_search_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_dialogs_global_search_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_dialogs_global_search_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_dialogs_global_search_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_FOLDER_NAME_PROPERTY, scratch_dialogs_global_search_dialog_properties[SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_FOLDER_NAME_PROPERTY] = g_param_spec_string ("folder-name", "folder-name", "folder-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_IS_REPO_PROPERTY, scratch_dialogs_global_search_dialog_properties[SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_IS_REPO_PROPERTY] = g_param_spec_boolean ("is-repo", "is-repo", "is-repo", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_SEARCH_TERM_PROPERTY, scratch_dialogs_global_search_dialog_properties[SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_SEARCH_TERM_PROPERTY] = g_param_spec_string ("search-term", "search-term", "search-term", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_CASE_SENSITIVE_PROPERTY, scratch_dialogs_global_search_dialog_properties[SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_CASE_SENSITIVE_PROPERTY] = g_param_spec_boolean ("case-sensitive", "case-sensitive", "case-sensitive", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_WHOLEWORD_PROPERTY, scratch_dialogs_global_search_dialog_properties[SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_WHOLEWORD_PROPERTY] = g_param_spec_boolean ("wholeword", "wholeword", "wholeword", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_USE_REGEX_PROPERTY, scratch_dialogs_global_search_dialog_properties[SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_USE_REGEX_PROPERTY] = g_param_spec_boolean ("use-regex", "use-regex", "use-regex", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
scratch_dialogs_global_search_dialog_instance_init (ScratchDialogsGlobalSearchDialog * self,
                                                    gpointer klass)
{
	self->priv = scratch_dialogs_global_search_dialog_get_instance_private (self);
}

static void
scratch_dialogs_global_search_dialog_finalize (GObject * obj)
{
	ScratchDialogsGlobalSearchDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_DIALOGS_TYPE_GLOBAL_SEARCH_DIALOG, ScratchDialogsGlobalSearchDialog);
	_g_free0 (self->priv->_folder_name);
	_g_object_unref0 (self->priv->search_term_entry);
	G_OBJECT_CLASS (scratch_dialogs_global_search_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scratch_dialogs_global_search_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchDialogsGlobalSearchDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_dialogs_global_search_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchDialogsGlobalSearchDialog), 0, (GInstanceInitFunc) scratch_dialogs_global_search_dialog_instance_init, NULL };
	GType scratch_dialogs_global_search_dialog_type_id;
	scratch_dialogs_global_search_dialog_type_id = g_type_register_static (GRANITE_TYPE_MESSAGE_DIALOG, "ScratchDialogsGlobalSearchDialog", &g_define_type_info, 0);
	ScratchDialogsGlobalSearchDialog_private_offset = g_type_add_instance_private (scratch_dialogs_global_search_dialog_type_id, sizeof (ScratchDialogsGlobalSearchDialogPrivate));
	return scratch_dialogs_global_search_dialog_type_id;
}

GType
scratch_dialogs_global_search_dialog_get_type (void)
{
	static gsize scratch_dialogs_global_search_dialog_type_id__once = 0;
	if (g_once_init_enter (&scratch_dialogs_global_search_dialog_type_id__once)) {
		GType scratch_dialogs_global_search_dialog_type_id;
		scratch_dialogs_global_search_dialog_type_id = scratch_dialogs_global_search_dialog_get_type_once ();
		g_once_init_leave (&scratch_dialogs_global_search_dialog_type_id__once, scratch_dialogs_global_search_dialog_type_id);
	}
	return scratch_dialogs_global_search_dialog_type_id__once;
}

static void
_vala_scratch_dialogs_global_search_dialog_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	ScratchDialogsGlobalSearchDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_DIALOGS_TYPE_GLOBAL_SEARCH_DIALOG, ScratchDialogsGlobalSearchDialog);
	switch (property_id) {
		case SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_FOLDER_NAME_PROPERTY:
		g_value_set_string (value, scratch_dialogs_global_search_dialog_get_folder_name (self));
		break;
		case SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_IS_REPO_PROPERTY:
		g_value_set_boolean (value, scratch_dialogs_global_search_dialog_get_is_repo (self));
		break;
		case SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_SEARCH_TERM_PROPERTY:
		g_value_set_string (value, scratch_dialogs_global_search_dialog_get_search_term (self));
		break;
		case SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_CASE_SENSITIVE_PROPERTY:
		g_value_set_boolean (value, scratch_dialogs_global_search_dialog_get_case_sensitive (self));
		break;
		case SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_WHOLEWORD_PROPERTY:
		g_value_set_boolean (value, scratch_dialogs_global_search_dialog_get_wholeword (self));
		break;
		case SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_USE_REGEX_PROPERTY:
		g_value_set_boolean (value, scratch_dialogs_global_search_dialog_get_use_regex (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_dialogs_global_search_dialog_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	ScratchDialogsGlobalSearchDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_DIALOGS_TYPE_GLOBAL_SEARCH_DIALOG, ScratchDialogsGlobalSearchDialog);
	switch (property_id) {
		case SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_FOLDER_NAME_PROPERTY:
		scratch_dialogs_global_search_dialog_set_folder_name (self, g_value_get_string (value));
		break;
		case SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_IS_REPO_PROPERTY:
		scratch_dialogs_global_search_dialog_set_is_repo (self, g_value_get_boolean (value));
		break;
		case SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_SEARCH_TERM_PROPERTY:
		scratch_dialogs_global_search_dialog_set_search_term (self, g_value_get_string (value));
		break;
		case SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_CASE_SENSITIVE_PROPERTY:
		scratch_dialogs_global_search_dialog_set_case_sensitive (self, g_value_get_boolean (value));
		break;
		case SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_WHOLEWORD_PROPERTY:
		scratch_dialogs_global_search_dialog_set_wholeword (self, g_value_get_boolean (value));
		break;
		case SCRATCH_DIALOGS_GLOBAL_SEARCH_DIALOG_USE_REGEX_PROPERTY:
		scratch_dialogs_global_search_dialog_set_use_regex (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

