/* VirtualizingListBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from VirtualizingListBox.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2018 elementary LLC. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_VIRTUALIZING_LIST_BOX (virtualizing_list_box_get_type ())
#define VIRTUALIZING_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIRTUALIZING_LIST_BOX, VirtualizingListBox))
#define VIRTUALIZING_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIRTUALIZING_LIST_BOX, VirtualizingListBoxClass))
#define IS_VIRTUALIZING_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIRTUALIZING_LIST_BOX))
#define IS_VIRTUALIZING_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIRTUALIZING_LIST_BOX))
#define VIRTUALIZING_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIRTUALIZING_LIST_BOX, VirtualizingListBoxClass))

typedef struct _VirtualizingListBox VirtualizingListBox;
typedef struct _VirtualizingListBoxClass VirtualizingListBoxClass;
typedef struct _VirtualizingListBoxPrivate VirtualizingListBoxPrivate;

#define TYPE_VIRTUALIZING_LIST_BOX_ROW (virtualizing_list_box_row_get_type ())
#define VIRTUALIZING_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIRTUALIZING_LIST_BOX_ROW, VirtualizingListBoxRow))
#define VIRTUALIZING_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIRTUALIZING_LIST_BOX_ROW, VirtualizingListBoxRowClass))
#define IS_VIRTUALIZING_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIRTUALIZING_LIST_BOX_ROW))
#define IS_VIRTUALIZING_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIRTUALIZING_LIST_BOX_ROW))
#define VIRTUALIZING_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIRTUALIZING_LIST_BOX_ROW, VirtualizingListBoxRowClass))

typedef struct _VirtualizingListBoxRow VirtualizingListBoxRow;
typedef struct _VirtualizingListBoxRowClass VirtualizingListBoxRowClass;
typedef VirtualizingListBoxRow* (*VirtualizingListBoxRowFactoryMethod) (GObject* item, VirtualizingListBoxRow* old_widget, gpointer user_data);

#define TYPE_VIRTUALIZING_LIST_BOX_MODEL (virtualizing_list_box_model_get_type ())
#define VIRTUALIZING_LIST_BOX_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIRTUALIZING_LIST_BOX_MODEL, VirtualizingListBoxModel))
#define VIRTUALIZING_LIST_BOX_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIRTUALIZING_LIST_BOX_MODEL, VirtualizingListBoxModelClass))
#define IS_VIRTUALIZING_LIST_BOX_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIRTUALIZING_LIST_BOX_MODEL))
#define IS_VIRTUALIZING_LIST_BOX_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIRTUALIZING_LIST_BOX_MODEL))
#define VIRTUALIZING_LIST_BOX_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIRTUALIZING_LIST_BOX_MODEL, VirtualizingListBoxModelClass))

typedef struct _VirtualizingListBoxModel VirtualizingListBoxModel;
typedef struct _VirtualizingListBoxModelClass VirtualizingListBoxModelClass;
enum  {
	VIRTUALIZING_LIST_BOX_0_PROPERTY,
	VIRTUALIZING_LIST_BOX_MODEL_PROPERTY,
	VIRTUALIZING_LIST_BOX_VADJUSTMENT_PROPERTY,
	VIRTUALIZING_LIST_BOX_SELECTED_ROW_WIDGET_PROPERTY,
	VIRTUALIZING_LIST_BOX_HADJUSTMENT_PROPERTY,
	VIRTUALIZING_LIST_BOX_HSCROLL_POLICY_PROPERTY,
	VIRTUALIZING_LIST_BOX_VSCROLL_POLICY_PROPERTY,
	VIRTUALIZING_LIST_BOX_ACTIVATE_ON_SINGLE_CLICK_PROPERTY,
	VIRTUALIZING_LIST_BOX_SELECTION_MODE_PROPERTY,
	VIRTUALIZING_LIST_BOX_SELECTED_ROW_PROPERTY,
	VIRTUALIZING_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
#define __vala_GdkEventSequence_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventSequence_free (var), NULL)))
enum  {
	VIRTUALIZING_LIST_BOX_ROW_ACTIVATED_SIGNAL,
	VIRTUALIZING_LIST_BOX_ROW_SELECTED_SIGNAL,
	VIRTUALIZING_LIST_BOX_SELECTED_ROWS_CHANGED_SIGNAL,
	VIRTUALIZING_LIST_BOX_NUM_SIGNALS
};
static guint virtualizing_list_box_signals[VIRTUALIZING_LIST_BOX_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _VirtualizingListBox {
	GtkContainer parent_instance;
	VirtualizingListBoxPrivate * priv;
	VirtualizingListBoxRowFactoryMethod factory_func;
	gpointer factory_func_target;
	GDestroyNotify factory_func_target_destroy_notify;
};

struct _VirtualizingListBoxClass {
	GtkContainerClass parent_class;
};

struct _VirtualizingListBoxPrivate {
	VirtualizingListBoxModel* _model;
	GtkAdjustment* _vadjustment;
	GtkAdjustment* _hadjustment;
	GtkScrollablePolicy _hscroll_policy;
	GtkScrollablePolicy _vscroll_policy;
	gboolean _activate_on_single_click;
	GtkSelectionMode _selection_mode;
	gdouble _bin_y_diff;
	GObject* _selected_row;
	GeeArrayList* current_widgets;
	GeeArrayList* recycled_widgets;
	GdkWindow* bin_window;
	guint shown_to;
	guint shown_from;
	gboolean block;
	gint last_valid_widget_height;
	VirtualizingListBoxRow* active_row;
	GtkGestureMultiPress* multipress;
};

static gint VirtualizingListBox_private_offset;
static gpointer virtualizing_list_box_parent_class = NULL;
static GtkScrollableInterface * virtualizing_list_box_gtk_scrollable_parent_iface = NULL;

VALA_EXTERN GType virtualizing_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VirtualizingListBox, g_object_unref)
VALA_EXTERN GType virtualizing_list_box_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VirtualizingListBoxRow, g_object_unref)
VALA_EXTERN GType virtualizing_list_box_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VirtualizingListBoxModel, g_object_unref)
static void virtualizing_list_box_real_realize (GtkWidget* base);
static void virtualizing_list_box_real_size_allocate (GtkWidget* base,
                                               GtkAllocation* allocation);
static void virtualizing_list_box_position_children (VirtualizingListBox* self);
static void virtualizing_list_box_update_bin_window (VirtualizingListBox* self,
                                              gint new_bin_height);
VALA_EXTERN GtkAdjustment* virtualizing_list_box_get_vadjustment (VirtualizingListBox* self);
static void virtualizing_list_box_configure_adjustment (VirtualizingListBox* self);
static void virtualizing_list_box_ensure_visible_widgets (VirtualizingListBox* self,
                                                   gboolean model_changed);
static void virtualizing_list_box_real_map (GtkWidget* base);
static void virtualizing_list_box_real_remove (GtkContainer* base,
                                        GtkWidget* w);
static void virtualizing_list_box_real_forall_internal (GtkContainer* base,
                                                 gboolean include_internals,
                                                 GtkCallback callback,
                                                 gpointer callback_target);
static GType virtualizing_list_box_real_child_type (GtkContainer* base);
static VirtualizingListBoxRow* virtualizing_list_box_get_widget (VirtualizingListBox* self,
                                                          guint index);
VALA_EXTERN VirtualizingListBoxModel* virtualizing_list_box_get_model (VirtualizingListBox* self);
VALA_EXTERN gboolean virtualizing_list_box_model_get_item_selected (VirtualizingListBoxModel* self,
                                                        GObject* item);
VALA_EXTERN void virtualizing_list_box_row_set_model_item (VirtualizingListBoxRow* self,
                                               GObject* value);
static void virtualizing_list_box_on_items_changed (VirtualizingListBox* self,
                                             guint position,
                                             guint removed,
                                             guint added);
static gboolean virtualizing_list_box_get_bin_window_full (VirtualizingListBox* self);
static void virtualizing_list_box_remove_all_widgets (VirtualizingListBox* self);
static inline gint virtualizing_list_box_widget_y (VirtualizingListBox* self,
                                     gint index);
static gint virtualizing_list_box_get_widget_height (VirtualizingListBox* self,
                                              GtkWidget* w);
static gint virtualizing_list_box_get_bin_y (VirtualizingListBox* self);
static void virtualizing_list_box_remove_child_internal (VirtualizingListBox* self,
                                                  VirtualizingListBoxRow* widget);
static void virtualizing_list_box_on_adjustment_value_changed (VirtualizingListBox* self);
static void virtualizing_list_box_on_adjustment_page_size_changed (VirtualizingListBox* self);
static void virtualizing_list_box_set_value (VirtualizingListBox* self,
                                      gdouble v);
static void virtualizing_list_box_insert_child_internal (VirtualizingListBox* self,
                                                  VirtualizingListBoxRow* widget,
                                                  gint index);
static gboolean virtualizing_list_box_remove_top_widgets (VirtualizingListBox* self,
                                                   gint* bin_height);
static gdouble virtualizing_list_box_get_bin_y_diff (VirtualizingListBox* self);
static void virtualizing_list_box_set_bin_y_diff (VirtualizingListBox* self,
                                           gdouble value);
static gboolean virtualizing_list_box_insert_top_widgets (VirtualizingListBox* self,
                                                   gint* bin_height);
static gboolean virtualizing_list_box_remove_bottom_widgets (VirtualizingListBox* self,
                                                      gint* bin_height);
static gboolean virtualizing_list_box_insert_bottom_widgets (VirtualizingListBox* self,
                                                      gint* bin_height);
VALA_EXTERN guint virtualizing_list_box_model_get_n_items (VirtualizingListBoxModel* self);
static gint virtualizing_list_box_estimated_widget_height (VirtualizingListBox* self);
static guint virtualizing_list_box_estimated_list_height (VirtualizingListBox* self,
                                                   guint* top,
                                                   guint* bottom,
                                                   guint* visible_widgets);
VALA_EXTERN VirtualizingListBoxRow* virtualizing_list_box_get_row_at_y (VirtualizingListBox* self,
                                                            gint y);
static void virtualizing_list_box_on_multipress_pressed (VirtualizingListBox* self,
                                                  gint n_press,
                                                  gdouble x,
                                                  gdouble y);
VALA_EXTERN gboolean virtualizing_list_box_get_activate_on_single_click (VirtualizingListBox* self);
VALA_EXTERN GObject* virtualizing_list_box_row_get_model_item (VirtualizingListBoxRow* self);
static void virtualizing_list_box_get_current_selection_modifiers (VirtualizingListBox* self,
                                                            gboolean* modify,
                                                            gboolean* extend);
static void virtualizing_list_box_on_multipress_released (VirtualizingListBox* self,
                                                   gint n_press,
                                                   gdouble x,
                                                   gdouble y);
static void virtualizing_list_box_select_and_activate (VirtualizingListBox* self,
                                                VirtualizingListBoxRow* row,
                                                gboolean grab_focus);
static GdkEvent* _vala_GdkEvent_copy (GdkEvent* self);
static void virtualizing_list_box_update_selection (VirtualizingListBox* self,
                                             VirtualizingListBoxRow* row,
                                             gboolean modify,
                                             gboolean extend,
                                             gboolean grab_cursor);
static void _vala_GdkEvent_free (GdkEvent* self);
static void _vala_GdkEventSequence_free (GdkEventSequence* self);
VALA_EXTERN void virtualizing_list_box_update_cursor (VirtualizingListBox* self,
                                          GObject* item,
                                          gboolean grab_focus);
VALA_EXTERN GtkSelectionMode virtualizing_list_box_get_selection_mode (VirtualizingListBox* self);
VALA_EXTERN gboolean virtualizing_list_box_row_get_selectable (VirtualizingListBoxRow* self);
VALA_EXTERN void virtualizing_list_box_select_row (VirtualizingListBox* self,
                                       VirtualizingListBoxRow* row);
static gboolean virtualizing_list_box_unselect_all_internal (VirtualizingListBox* self);
VALA_EXTERN void virtualizing_list_box_model_set_item_selected (VirtualizingListBoxModel* self,
                                                    GObject* item,
                                                    gboolean selected);
static void virtualizing_list_box_set_selected_row (VirtualizingListBox* self,
                                             GObject* value);
VALA_EXTERN GObject* virtualizing_list_box_get_selected_row (VirtualizingListBox* self);
static void virtualizing_list_box_select_all_between (VirtualizingListBox* self,
                                               GObject* from,
                                               GObject* to,
                                               gboolean modify);
VALA_EXTERN GeeArrayList* virtualizing_list_box_model_get_items_between (VirtualizingListBoxModel* self,
                                                             GObject* from,
                                                             GObject* to);
VALA_EXTERN void virtualizing_list_box_select_row_at_index (VirtualizingListBox* self,
                                                gint index);
static VirtualizingListBoxRow* virtualizing_list_box_ensure_index_visible (VirtualizingListBox* self,
                                                                    gint index);
VALA_EXTERN gint virtualizing_list_box_model_get_index_of (VirtualizingListBoxModel* self,
                                               GObject* item);
VALA_EXTERN void virtualizing_list_box_model_unselect_all (VirtualizingListBoxModel* self);
static gboolean virtualizing_list_box_real_focus (GtkWidget* base,
                                           GtkDirectionType direction);
VALA_EXTERN gint virtualizing_list_box_model_get_index_of_item_before (VirtualizingListBoxModel* self,
                                                           GObject* item);
VALA_EXTERN gint virtualizing_list_box_model_get_index_of_item_after (VirtualizingListBoxModel* self,
                                                          GObject* item);
static gboolean virtualizing_list_box_real_get_border (GtkScrollable* base,
                                                GtkBorder* border);
VALA_EXTERN GeeHashSet* virtualizing_list_box_get_selected_rows (VirtualizingListBox* self);
VALA_EXTERN GeeHashSet* virtualizing_list_box_model_get_selected_rows (VirtualizingListBoxModel* self);
VALA_EXTERN VirtualizingListBox* virtualizing_list_box_new (void);
VALA_EXTERN VirtualizingListBox* virtualizing_list_box_construct (GType object_type);
VALA_EXTERN void virtualizing_list_box_set_model (VirtualizingListBox* self,
                                      VirtualizingListBoxModel* value);
static void _virtualizing_list_box_on_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                         guint position,
                                                                         guint removed,
                                                                         guint added,
                                                                         gpointer self);
VALA_EXTERN void virtualizing_list_box_set_vadjustment (VirtualizingListBox* self,
                                            GtkAdjustment* value);
static void _virtualizing_list_box_on_adjustment_value_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                                      gpointer self);
static void _virtualizing_list_box_on_adjustment_page_size_changed_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self);
VALA_EXTERN VirtualizingListBoxRow* virtualizing_list_box_get_selected_row_widget (VirtualizingListBox* self);
VALA_EXTERN GtkAdjustment* virtualizing_list_box_get_hadjustment (VirtualizingListBox* self);
VALA_EXTERN void virtualizing_list_box_set_hadjustment (VirtualizingListBox* self,
                                            GtkAdjustment* value);
VALA_EXTERN GtkScrollablePolicy virtualizing_list_box_get_hscroll_policy (VirtualizingListBox* self);
VALA_EXTERN void virtualizing_list_box_set_hscroll_policy (VirtualizingListBox* self,
                                               GtkScrollablePolicy value);
VALA_EXTERN GtkScrollablePolicy virtualizing_list_box_get_vscroll_policy (VirtualizingListBox* self);
VALA_EXTERN void virtualizing_list_box_set_vscroll_policy (VirtualizingListBox* self,
                                               GtkScrollablePolicy value);
VALA_EXTERN void virtualizing_list_box_set_activate_on_single_click (VirtualizingListBox* self,
                                                         gboolean value);
VALA_EXTERN void virtualizing_list_box_set_selection_mode (VirtualizingListBox* self,
                                               GtkSelectionMode value);
static GObject * virtualizing_list_box_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _virtualizing_list_box_on_multipress_pressed_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                                   gint n_press,
                                                                                   gdouble x,
                                                                                   gdouble y,
                                                                                   gpointer self);
static void _virtualizing_list_box_on_multipress_released_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                                     gint n_press,
                                                                                     gdouble x,
                                                                                     gdouble y,
                                                                                     gpointer self);
static void virtualizing_list_box_finalize (GObject * obj);
static GType virtualizing_list_box_get_type_once (void);
static void _vala_virtualizing_list_box_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_virtualizing_list_box_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
virtualizing_list_box_get_instance_private (VirtualizingListBox* self)
{
	return G_STRUCT_MEMBER_P (self, VirtualizingListBox_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
virtualizing_list_box_real_realize (GtkWidget* base)
{
	VirtualizingListBox * self;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GdkWindowAttr attr = {0};
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp4_;
	GdkVisual* _tmp5_;
	GdkWindowAttributesType attr_types = 0U;
	GdkWindow* window = NULL;
	GdkWindow* _tmp6_;
	GdkWindowAttr _tmp7_;
	GdkWindow* _tmp8_;
	GdkWindow* _tmp9_;
	GdkWindowAttr _tmp10_;
	GdkWindow* _tmp11_;
	GdkWindow* _tmp12_;
	GdkWindow* _tmp13_;
	self = (VirtualizingListBox*) base;
	gtk_widget_set_realized ((GtkWidget*) self, TRUE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	memset (&attr, 0, sizeof (GdkWindowAttr));
	_tmp1_ = allocation;
	attr.x = _tmp1_.x;
	_tmp2_ = allocation;
	attr.y = _tmp2_.y;
	_tmp3_ = allocation;
	attr.width = _tmp3_.width;
	_tmp4_ = allocation;
	attr.height = _tmp4_.height;
	attr.window_type = GDK_WINDOW_CHILD;
	attr.event_mask = (gint) GDK_ALL_EVENTS_MASK;
	attr.wclass = GDK_INPUT_OUTPUT;
	_tmp5_ = gtk_widget_get_visual ((GtkWidget*) self);
	attr.visual = _tmp5_;
	attr_types = (GDK_WA_X | GDK_WA_Y) | GDK_WA_VISUAL;
	_tmp6_ = gtk_widget_get_parent_window ((GtkWidget*) self);
	_tmp7_ = attr;
	_tmp8_ = gdk_window_new (_tmp6_, &_tmp7_, attr_types);
	window = _tmp8_;
	_tmp9_ = _g_object_ref0 (window);
	gtk_widget_set_window ((GtkWidget*) self, _tmp9_);
	gtk_widget_register_window ((GtkWidget*) self, window);
	attr.height = 1;
	_tmp10_ = attr;
	_tmp11_ = gdk_window_new (window, &_tmp10_, attr_types);
	_g_object_unref0 (self->priv->bin_window);
	self->priv->bin_window = _tmp11_;
	_tmp12_ = self->priv->bin_window;
	gtk_widget_register_window ((GtkWidget*) self, _tmp12_);
	_tmp13_ = self->priv->bin_window;
	gdk_window_show (_tmp13_);
	_g_object_unref0 (window);
}

static void
virtualizing_list_box_real_size_allocate (GtkWidget* base,
                                          GtkAllocation* allocation)
{
	VirtualizingListBox * self;
	gboolean height_changed = FALSE;
	GtkAllocation _tmp0_;
	gboolean width_changed = FALSE;
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GtkAdjustment* _tmp10_;
	GtkAdjustment* _tmp11_;
	gboolean _tmp12_ = FALSE;
	self = (VirtualizingListBox*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	height_changed = _tmp0_.height != gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp1_ = *allocation;
	width_changed = _tmp1_.width != gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp2_ = *allocation;
	gtk_widget_set_allocation ((GtkWidget*) self, &_tmp2_);
	virtualizing_list_box_position_children (self);
	if (gtk_widget_get_realized ((GtkWidget*) self)) {
		GdkWindow* _tmp3_;
		GtkAllocation _tmp4_;
		GtkAllocation _tmp5_;
		GtkAllocation _tmp6_;
		GtkAllocation _tmp7_;
		_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp4_ = *allocation;
		_tmp5_ = *allocation;
		_tmp6_ = *allocation;
		_tmp7_ = *allocation;
		gdk_window_move_resize (_tmp3_, _tmp4_.x, _tmp5_.y, _tmp6_.width, _tmp7_.height);
		virtualizing_list_box_update_bin_window (self, -1);
	}
	_tmp10_ = virtualizing_list_box_get_vadjustment (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		_tmp9_ = height_changed;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = width_changed;
	}
	if (_tmp8_) {
		virtualizing_list_box_configure_adjustment (self);
	}
	if (height_changed) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = width_changed;
	}
	if (_tmp12_) {
		virtualizing_list_box_ensure_visible_widgets (self, FALSE);
	}
}

static void
virtualizing_list_box_real_map (GtkWidget* base)
{
	VirtualizingListBox * self;
	self = (VirtualizingListBox*) base;
	GTK_WIDGET_CLASS (virtualizing_list_box_parent_class)->map ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
	virtualizing_list_box_ensure_visible_widgets (self, FALSE);
}

static void
virtualizing_list_box_real_remove (GtkContainer* base,
                                   GtkWidget* w)
{
	VirtualizingListBox * self;
	GtkContainer* _tmp0_;
	self = (VirtualizingListBox*) base;
	g_return_if_fail (w != NULL);
	_tmp0_ = gtk_widget_get_parent (w);
	_vala_assert (_tmp0_ == G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), "w.get_parent () == this");
}

static void
virtualizing_list_box_real_forall_internal (GtkContainer* base,
                                            gboolean include_internals,
                                            GtkCallback callback,
                                            gpointer callback_target)
{
	VirtualizingListBox * self;
	self = (VirtualizingListBox*) base;
	{
		GeeArrayList* _child_list = NULL;
		GeeArrayList* _tmp0_;
		gint _child_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _child_index = 0;
		_tmp0_ = self->priv->current_widgets;
		_child_list = _tmp0_;
		_tmp1_ = _child_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_child_size = _tmp3_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			VirtualizingListBoxRow* child = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			VirtualizingListBoxRow* _tmp8_;
			_child_index = _child_index + 1;
			_tmp4_ = _child_index;
			_tmp5_ = _child_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _child_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _child_index);
			child = (VirtualizingListBoxRow*) _tmp7_;
			_tmp8_ = child;
			callback ((GtkWidget*) _tmp8_, callback_target);
			_g_object_unref0 (child);
		}
	}
}

static GType
virtualizing_list_box_real_child_type (GtkContainer* base)
{
	VirtualizingListBox * self;
	GType result;
	self = (VirtualizingListBox*) base;
	result = TYPE_VIRTUALIZING_LIST_BOX_ROW;
	return result;
}

static VirtualizingListBoxRow*
virtualizing_list_box_get_widget (VirtualizingListBox* self,
                                  guint index)
{
	GObject* item = NULL;
	VirtualizingListBoxModel* _tmp0_;
	VirtualizingListBoxModel* _tmp1_;
	GObject* _tmp2_;
	GObject* _tmp3_;
	VirtualizingListBoxRow* old_widget = NULL;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	VirtualizingListBoxRow* new_widget = NULL;
	VirtualizingListBoxRowFactoryMethod _tmp14_;
	gpointer _tmp14__target;
	GObject* _tmp15_;
	VirtualizingListBoxRow* _tmp16_;
	VirtualizingListBoxRow* _tmp17_;
	VirtualizingListBoxModel* _tmp18_;
	VirtualizingListBoxModel* _tmp19_;
	GObject* _tmp20_;
	VirtualizingListBoxRow* _tmp23_;
	GObject* _tmp24_;
	VirtualizingListBoxRow* _tmp25_;
	VirtualizingListBoxRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = virtualizing_list_box_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_list_model_get_object ((GListModel*) _tmp1_, index);
	item = _tmp2_;
	_tmp3_ = item;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_object_unref0 (item);
		return result;
	}
	old_widget = NULL;
	_tmp4_ = self->priv->recycled_widgets;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gpointer _tmp11_;
		GeeArrayList* _tmp12_;
		VirtualizingListBoxRow* _tmp13_;
		_tmp7_ = self->priv->recycled_widgets;
		_tmp8_ = self->priv->recycled_widgets;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp10_ - 1);
		_g_object_unref0 (old_widget);
		old_widget = (VirtualizingListBoxRow*) _tmp11_;
		_tmp12_ = self->priv->recycled_widgets;
		_tmp13_ = old_widget;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp12_, _tmp13_);
	}
	_tmp14_ = self->factory_func;
	_tmp14__target = self->factory_func_target;
	_tmp15_ = item;
	_tmp16_ = old_widget;
	_tmp17_ = _tmp14_ (_tmp15_, _tmp16_, _tmp14__target);
	new_widget = _tmp17_;
	_tmp18_ = virtualizing_list_box_get_model (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = item;
	if (virtualizing_list_box_model_get_item_selected (_tmp19_, _tmp20_)) {
		VirtualizingListBoxRow* _tmp21_;
		_tmp21_ = new_widget;
		gtk_widget_set_state_flags ((GtkWidget*) _tmp21_, GTK_STATE_FLAG_SELECTED, FALSE);
	} else {
		VirtualizingListBoxRow* _tmp22_;
		_tmp22_ = new_widget;
		gtk_widget_unset_state_flags ((GtkWidget*) _tmp22_, GTK_STATE_FLAG_SELECTED);
	}
	_tmp23_ = new_widget;
	_tmp24_ = item;
	virtualizing_list_box_row_set_model_item (_tmp23_, _tmp24_);
	_tmp25_ = new_widget;
	gtk_widget_show ((GtkWidget*) _tmp25_);
	result = new_widget;
	_g_object_unref0 (old_widget);
	_g_object_unref0 (item);
	return result;
}

static void
virtualizing_list_box_on_items_changed (VirtualizingListBox* self,
                                        guint position,
                                        guint removed,
                                        guint added)
{
	gboolean _tmp0_ = FALSE;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	g_return_if_fail (self != NULL);
	if (position >= self->priv->shown_to) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = virtualizing_list_box_get_bin_window_full (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		_tmp3_ = virtualizing_list_box_get_vadjustment (self);
		_tmp4_ = _tmp3_;
		if (_tmp4_ == NULL) {
			gtk_widget_queue_resize ((GtkWidget*) self);
		} else {
			virtualizing_list_box_configure_adjustment (self);
		}
		return;
	}
	virtualizing_list_box_remove_all_widgets (self);
	self->priv->shown_to = self->priv->shown_from;
	virtualizing_list_box_update_bin_window (self, -1);
	virtualizing_list_box_ensure_visible_widgets (self, TRUE);
	_tmp5_ = virtualizing_list_box_get_vadjustment (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
}

static inline gint
virtualizing_list_box_widget_y (VirtualizingListBox* self,
                                gint index)
{
	gint y = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	y = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp2_;
				gpointer _tmp3_;
				VirtualizingListBoxRow* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < index)) {
					break;
				}
				_tmp2_ = self->priv->current_widgets;
				_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, i);
				_tmp4_ = (VirtualizingListBoxRow*) _tmp3_;
				y += virtualizing_list_box_get_widget_height (self, (GtkWidget*) _tmp4_);
				_g_object_unref0 (_tmp4_);
			}
		}
	}
	result = y;
	return result;
}

static gint
virtualizing_list_box_get_widget_height (VirtualizingListBox* self,
                                         GtkWidget* w)
{
	gint min = 0;
	gint _tmp0_ = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (w != NULL, 0);
	gtk_widget_get_preferred_height_for_width (w, gtk_widget_get_allocated_width ((GtkWidget*) self), &_tmp0_, NULL);
	min = _tmp0_;
	result = min;
	return result;
}

static void
virtualizing_list_box_position_children (VirtualizingListBox* self)
{
	GtkAllocation allocation = {0};
	GtkAllocation child_allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_ = {0};
	gint y = 0;
	GtkAdjustment* _tmp2_;
	GtkAdjustment* _tmp3_;
	GtkAllocation _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_.x = 0;
	child_allocation = _tmp0_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp1_);
	allocation = _tmp1_;
	y = 0;
	_tmp2_ = virtualizing_list_box_get_vadjustment (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GtkAllocation _tmp4_;
		_tmp4_ = allocation;
		y = _tmp4_.y;
	}
	child_allocation.x = 0;
	_tmp5_ = allocation;
	if (_tmp5_.width > 0) {
		GtkAllocation _tmp6_;
		_tmp6_ = allocation;
		child_allocation.width = _tmp6_.width;
	} else {
		child_allocation.width = 1;
	}
	{
		GeeArrayList* _child_list = NULL;
		GeeArrayList* _tmp7_;
		gint _child_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _child_index = 0;
		_tmp7_ = self->priv->current_widgets;
		_child_list = _tmp7_;
		_tmp8_ = _child_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_child_size = _tmp10_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			VirtualizingListBoxRow* child = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			VirtualizingListBoxRow* _tmp15_;
			gint _tmp16_ = 0;
			VirtualizingListBoxRow* _tmp17_;
			GtkAllocation _tmp18_;
			gint _tmp19_ = 0;
			GtkAllocation _tmp20_;
			VirtualizingListBoxRow* _tmp21_;
			GtkAllocation _tmp22_;
			GtkAllocation _tmp23_;
			_child_index = _child_index + 1;
			_tmp11_ = _child_index;
			_tmp12_ = _child_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _child_list;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _child_index);
			child = (VirtualizingListBoxRow*) _tmp14_;
			_tmp15_ = child;
			gtk_widget_get_preferred_height_for_width ((GtkWidget*) _tmp15_, gtk_widget_get_allocated_width ((GtkWidget*) self), &_tmp16_, NULL);
			child_allocation.height = _tmp16_;
			_tmp17_ = child;
			_tmp18_ = child_allocation;
			gtk_widget_get_preferred_width_for_height ((GtkWidget*) _tmp17_, _tmp18_.height, &_tmp19_, NULL);
			child_allocation.width = _tmp19_;
			_tmp20_ = child_allocation;
			child_allocation.width = MAX (_tmp20_.width, gtk_widget_get_allocated_width ((GtkWidget*) self));
			child_allocation.y = y;
			_tmp21_ = child;
			_tmp22_ = child_allocation;
			gtk_widget_size_allocate ((GtkWidget*) _tmp21_, &_tmp22_);
			_tmp23_ = child_allocation;
			y += _tmp23_.height;
			_g_object_unref0 (child);
		}
	}
}

static void
virtualizing_list_box_update_bin_window (VirtualizingListBox* self,
                                         gint new_bin_height)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint h = 0;
	gboolean _tmp11_ = FALSE;
	GdkWindow* _tmp12_;
	g_return_if_fail (self != NULL);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	if (new_bin_height == -1) {
		_tmp1_ = 0;
	} else {
		_tmp1_ = new_bin_height;
	}
	h = _tmp1_;
	if (new_bin_height == -1) {
		{
			GeeArrayList* _w_list = NULL;
			GeeArrayList* _tmp2_;
			gint _w_size = 0;
			GeeArrayList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _w_index = 0;
			_tmp2_ = self->priv->current_widgets;
			_w_list = _tmp2_;
			_tmp3_ = _w_list;
			_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_w_size = _tmp5_;
			_w_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				VirtualizingListBoxRow* w = NULL;
				GeeArrayList* _tmp8_;
				gpointer _tmp9_;
				VirtualizingListBoxRow* _tmp10_;
				_w_index = _w_index + 1;
				_tmp6_ = _w_index;
				_tmp7_ = _w_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _w_list;
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _w_index);
				w = (VirtualizingListBoxRow*) _tmp9_;
				_tmp10_ = w;
				h += virtualizing_list_box_get_widget_height (self, (GtkWidget*) _tmp10_);
				_g_object_unref0 (w);
			}
		}
	}
	if (h == 0) {
		h = 1;
	}
	_tmp12_ = self->priv->bin_window;
	if (h != gdk_window_get_height (_tmp12_)) {
		_tmp11_ = TRUE;
	} else {
		GtkAllocation _tmp13_;
		GdkWindow* _tmp14_;
		_tmp13_ = allocation;
		_tmp14_ = self->priv->bin_window;
		_tmp11_ = _tmp13_.width != gdk_window_get_width (_tmp14_);
	}
	if (_tmp11_) {
		GdkWindow* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		GtkAllocation _tmp18_;
		_tmp15_ = self->priv->bin_window;
		_tmp16_ = virtualizing_list_box_get_bin_y (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = allocation;
		gdk_window_move_resize (_tmp15_, 0, _tmp17_, _tmp18_.width, h);
	} else {
		GdkWindow* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp19_ = self->priv->bin_window;
		_tmp20_ = virtualizing_list_box_get_bin_y (self);
		_tmp21_ = _tmp20_;
		gdk_window_move (_tmp19_, 0, _tmp21_);
	}
}

static void
virtualizing_list_box_remove_all_widgets (VirtualizingListBox* self)
{
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _w_list = NULL;
		GeeArrayList* _tmp0_;
		gint _w_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _w_index = 0;
		_tmp0_ = self->priv->current_widgets;
		_w_list = _tmp0_;
		_tmp1_ = _w_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_w_size = _tmp3_;
		_w_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			VirtualizingListBoxRow* w = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			VirtualizingListBoxRow* _tmp8_;
			_w_index = _w_index + 1;
			_tmp4_ = _w_index;
			_tmp5_ = _w_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _w_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _w_index);
			w = (VirtualizingListBoxRow*) _tmp7_;
			_tmp8_ = w;
			gtk_widget_unparent ((GtkWidget*) _tmp8_);
			_g_object_unref0 (w);
		}
	}
	_tmp9_ = self->priv->recycled_widgets;
	_tmp10_ = self->priv->current_widgets;
	gee_array_list_add_all (_tmp9_, (GeeCollection*) _tmp10_);
	_tmp11_ = self->priv->current_widgets;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp11_);
}

static void
virtualizing_list_box_remove_child_internal (VirtualizingListBox* self,
                                             VirtualizingListBoxRow* widget)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->current_widgets;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, widget);
	gtk_widget_set_state_flags ((GtkWidget*) widget, GTK_STATE_FLAG_NORMAL, TRUE);
	gtk_widget_unparent ((GtkWidget*) widget);
	_tmp1_ = self->priv->recycled_widgets;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, widget);
}

static void
virtualizing_list_box_on_adjustment_value_changed (VirtualizingListBox* self)
{
	g_return_if_fail (self != NULL);
	virtualizing_list_box_ensure_visible_widgets (self, FALSE);
}

static void
virtualizing_list_box_on_adjustment_page_size_changed (VirtualizingListBox* self)
{
	gdouble max_value = 0.0;
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	GtkAdjustment* _tmp8_;
	GtkAdjustment* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	g_return_if_fail (self != NULL);
	if (!gtk_widget_get_mapped ((GtkWidget*) self)) {
		return;
	}
	_tmp0_ = virtualizing_list_box_get_vadjustment (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_upper (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = virtualizing_list_box_get_vadjustment (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_adjustment_get_page_size (_tmp5_);
	_tmp7_ = _tmp6_;
	max_value = _tmp3_ - _tmp7_;
	_tmp8_ = virtualizing_list_box_get_vadjustment (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_adjustment_get_value (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ > max_value) {
		virtualizing_list_box_set_value (self, max_value);
	}
	virtualizing_list_box_configure_adjustment (self);
}

static void
virtualizing_list_box_insert_child_internal (VirtualizingListBox* self,
                                             VirtualizingListBoxRow* widget,
                                             gint index)
{
	GdkWindow* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->bin_window;
	gtk_widget_set_parent_window ((GtkWidget*) widget, _tmp0_);
	gtk_widget_set_parent ((GtkWidget*) widget, (GtkWidget*) ((GtkContainer*) self));
	_tmp1_ = self->priv->current_widgets;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp1_, index, widget);
}

static gboolean
virtualizing_list_box_remove_top_widgets (VirtualizingListBox* self,
                                          gint* bin_height)
{
	gboolean removed = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	removed = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				VirtualizingListBoxRow* w = NULL;
				GeeArrayList* _tmp5_;
				gpointer _tmp6_;
				gint w_height = 0;
				VirtualizingListBoxRow* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->current_widgets;
				_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->current_widgets;
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, i);
				w = (VirtualizingListBoxRow*) _tmp6_;
				_tmp7_ = w;
				w_height = virtualizing_list_box_get_widget_height (self, (GtkWidget*) _tmp7_);
				_tmp8_ = virtualizing_list_box_get_bin_y (self);
				_tmp9_ = _tmp8_;
				if (((_tmp9_ + virtualizing_list_box_widget_y (self, i)) + w_height) < 0) {
					gdouble _tmp10_;
					VirtualizingListBoxRow* _tmp11_;
					guint _tmp12_;
					_tmp10_ = self->priv->_bin_y_diff;
					virtualizing_list_box_set_bin_y_diff (self, _tmp10_ + w_height);
					*bin_height = (*bin_height) - w_height;
					_tmp11_ = w;
					virtualizing_list_box_remove_child_internal (self, _tmp11_);
					_tmp12_ = self->priv->shown_from;
					self->priv->shown_from = _tmp12_ + 1;
					removed = TRUE;
				} else {
					_g_object_unref0 (w);
					break;
				}
				_g_object_unref0 (w);
			}
		}
	}
	result = removed;
	return result;
}

static gboolean
virtualizing_list_box_insert_top_widgets (VirtualizingListBox* self,
                                          gint* bin_height)
{
	gboolean added = FALSE;
	gint _tmp9_;
	gint _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	added = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		guint _tmp3_;
		VirtualizingListBoxRow* new_widget = NULL;
		VirtualizingListBoxRow* _tmp4_;
		VirtualizingListBoxRow* _tmp5_;
		VirtualizingListBoxRow* _tmp6_;
		gint min = 0;
		VirtualizingListBoxRow* _tmp7_;
		gdouble _tmp8_;
		if (self->priv->shown_from > ((guint) 0)) {
			gint _tmp1_;
			gint _tmp2_;
			_tmp1_ = virtualizing_list_box_get_bin_y (self);
			_tmp2_ = _tmp1_;
			_tmp0_ = _tmp2_ >= 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp3_ = self->priv->shown_from;
		self->priv->shown_from = _tmp3_ - 1;
		_tmp4_ = virtualizing_list_box_get_widget (self, self->priv->shown_from);
		new_widget = _tmp4_;
		_tmp5_ = new_widget;
		if (_tmp5_ == NULL) {
			_g_object_unref0 (new_widget);
			continue;
		}
		_tmp6_ = new_widget;
		virtualizing_list_box_insert_child_internal (self, _tmp6_, 0);
		_tmp7_ = new_widget;
		min = virtualizing_list_box_get_widget_height (self, (GtkWidget*) _tmp7_);
		_tmp8_ = self->priv->_bin_y_diff;
		virtualizing_list_box_set_bin_y_diff (self, _tmp8_ - min);
		*bin_height = (*bin_height) + min;
		added = TRUE;
		_g_object_unref0 (new_widget);
	}
	_tmp9_ = virtualizing_list_box_get_bin_y (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 0) {
		virtualizing_list_box_set_bin_y_diff (self, (gdouble) 0);
		self->priv->block = TRUE;
		virtualizing_list_box_set_value (self, 0.0);
		self->priv->block = FALSE;
	}
	result = added;
	return result;
}

static gboolean
virtualizing_list_box_remove_bottom_widgets (VirtualizingListBox* self,
                                             gint* bin_height)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = self->priv->current_widgets;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		i = _tmp2_ - 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				VirtualizingListBoxRow* w = NULL;
				GeeArrayList* _tmp5_;
				gpointer _tmp6_;
				gint widget_y = 0;
				gint _tmp7_;
				gint _tmp8_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ - 1;
				}
				_tmp3_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp5_ = self->priv->current_widgets;
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, i);
				w = (VirtualizingListBoxRow*) _tmp6_;
				_tmp7_ = virtualizing_list_box_get_bin_y (self);
				_tmp8_ = _tmp7_;
				widget_y = _tmp8_ + virtualizing_list_box_widget_y (self, i);
				if (widget_y > gtk_widget_get_allocated_height ((GtkWidget*) self)) {
					gint w_height = 0;
					VirtualizingListBoxRow* _tmp9_;
					VirtualizingListBoxRow* _tmp10_;
					guint _tmp11_;
					_tmp9_ = w;
					w_height = virtualizing_list_box_get_widget_height (self, (GtkWidget*) _tmp9_);
					_tmp10_ = w;
					virtualizing_list_box_remove_child_internal (self, _tmp10_);
					*bin_height = (*bin_height) - w_height;
					_tmp11_ = self->priv->shown_to;
					self->priv->shown_to = _tmp11_ - 1;
				} else {
					_g_object_unref0 (w);
					break;
				}
				_g_object_unref0 (w);
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
virtualizing_list_box_insert_bottom_widgets (VirtualizingListBox* self,
                                             gint* bin_height)
{
	gboolean added = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	added = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gint _tmp1_;
		gint _tmp2_;
		VirtualizingListBoxRow* new_widget = NULL;
		VirtualizingListBoxRow* _tmp5_;
		VirtualizingListBoxRow* _tmp6_;
		VirtualizingListBoxRow* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint min = 0;
		VirtualizingListBoxRow* _tmp12_;
		guint _tmp13_;
		_tmp1_ = virtualizing_list_box_get_bin_y (self);
		_tmp2_ = _tmp1_;
		if ((_tmp2_ + (*bin_height)) <= gtk_widget_get_allocated_height ((GtkWidget*) self)) {
			VirtualizingListBoxModel* _tmp3_;
			VirtualizingListBoxModel* _tmp4_;
			_tmp3_ = virtualizing_list_box_get_model (self);
			_tmp4_ = _tmp3_;
			_tmp0_ = self->priv->shown_to < virtualizing_list_box_model_get_n_items (_tmp4_);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = virtualizing_list_box_get_widget (self, self->priv->shown_to);
		new_widget = _tmp5_;
		_tmp6_ = new_widget;
		if (_tmp6_ == NULL) {
			guint _tmp7_;
			_tmp7_ = self->priv->shown_to;
			self->priv->shown_to = _tmp7_ + 1;
			_g_object_unref0 (new_widget);
			continue;
		}
		_tmp8_ = new_widget;
		_tmp9_ = self->priv->current_widgets;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		virtualizing_list_box_insert_child_internal (self, _tmp8_, _tmp11_);
		_tmp12_ = new_widget;
		min = virtualizing_list_box_get_widget_height (self, (GtkWidget*) _tmp12_);
		*bin_height = (*bin_height) + min;
		added = TRUE;
		_tmp13_ = self->priv->shown_to;
		self->priv->shown_to = _tmp13_ + 1;
		_g_object_unref0 (new_widget);
	}
	result = added;
	return result;
}

static void
virtualizing_list_box_ensure_visible_widgets (VirtualizingListBox* self,
                                              gboolean model_changed)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint widget_height = 0;
	gint bin_height = 0;
	GdkWindow* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gint _tmp7_;
	gboolean top_removed = FALSE;
	gboolean _tmp34_;
	gboolean top_added = FALSE;
	gboolean _tmp35_;
	gboolean bottom_removed = FALSE;
	gboolean _tmp36_;
	gboolean bottom_added = FALSE;
	gboolean _tmp37_;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean widgets_changed = FALSE;
	gboolean _tmp42_ = FALSE;
	GtkAdjustment* _tmp43_;
	GtkAdjustment* _tmp44_;
	g_return_if_fail (self != NULL);
	if (!gtk_widget_get_mapped ((GtkWidget*) self)) {
		_tmp1_ = TRUE;
	} else {
		VirtualizingListBoxModel* _tmp2_;
		VirtualizingListBoxModel* _tmp3_;
		_tmp2_ = virtualizing_list_box_get_model (self);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->block;
	}
	if (_tmp0_) {
		return;
	}
	widget_height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp4_ = self->priv->bin_window;
	bin_height = gdk_window_get_height (_tmp4_);
	if (bin_height == 1) {
		bin_height = 0;
	}
	_tmp6_ = virtualizing_list_box_get_bin_y (self);
	_tmp7_ = _tmp6_;
	if ((_tmp7_ + bin_height) < 0) {
		_tmp5_ = TRUE;
	} else {
		gint _tmp8_;
		gint _tmp9_;
		_tmp8_ = virtualizing_list_box_get_bin_y (self);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_ >= widget_height;
	}
	if (_tmp5_) {
		gint estimated_widget_height = 0;
		gdouble percentage = 0.0;
		GtkAdjustment* _tmp10_;
		GtkAdjustment* _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
		GtkAdjustment* _tmp14_;
		GtkAdjustment* _tmp15_;
		gdouble _tmp16_;
		gdouble _tmp17_;
		guint top_widget_index = 0U;
		VirtualizingListBoxModel* _tmp18_;
		VirtualizingListBoxModel* _tmp19_;
		VirtualizingListBoxModel* _tmp20_;
		VirtualizingListBoxModel* _tmp21_;
		estimated_widget_height = virtualizing_list_box_estimated_widget_height (self);
		virtualizing_list_box_remove_all_widgets (self);
		bin_height = 0;
		_tmp10_ = virtualizing_list_box_get_vadjustment (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = gtk_adjustment_get_value (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = virtualizing_list_box_get_vadjustment (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = gtk_adjustment_get_upper (_tmp15_);
		_tmp17_ = _tmp16_;
		percentage = _tmp13_ / _tmp17_;
		_tmp18_ = virtualizing_list_box_get_model (self);
		_tmp19_ = _tmp18_;
		top_widget_index = (guint) (virtualizing_list_box_model_get_n_items (_tmp19_) * percentage);
		_tmp20_ = virtualizing_list_box_get_model (self);
		_tmp21_ = _tmp20_;
		if (top_widget_index > virtualizing_list_box_model_get_n_items (_tmp21_)) {
			VirtualizingListBoxModel* _tmp22_;
			VirtualizingListBoxModel* _tmp23_;
			VirtualizingListBoxModel* _tmp24_;
			VirtualizingListBoxModel* _tmp25_;
			GtkAdjustment* _tmp26_;
			GtkAdjustment* _tmp27_;
			gdouble _tmp28_;
			gdouble _tmp29_;
			GtkAdjustment* _tmp30_;
			GtkAdjustment* _tmp31_;
			gdouble _tmp32_;
			gdouble _tmp33_;
			_tmp22_ = virtualizing_list_box_get_model (self);
			_tmp23_ = _tmp22_;
			self->priv->shown_to = virtualizing_list_box_model_get_n_items (_tmp23_);
			_tmp24_ = virtualizing_list_box_get_model (self);
			_tmp25_ = _tmp24_;
			self->priv->shown_from = virtualizing_list_box_model_get_n_items (_tmp25_);
			_tmp26_ = virtualizing_list_box_get_vadjustment (self);
			_tmp27_ = _tmp26_;
			_tmp28_ = gtk_adjustment_get_value (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = virtualizing_list_box_get_vadjustment (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = gtk_adjustment_get_page_size (_tmp31_);
			_tmp33_ = _tmp32_;
			virtualizing_list_box_set_bin_y_diff (self, _tmp29_ + _tmp33_);
		} else {
			self->priv->shown_from = top_widget_index;
			self->priv->shown_to = top_widget_index;
			virtualizing_list_box_set_bin_y_diff (self, (gdouble) (top_widget_index * estimated_widget_height));
		}
	}
	_tmp34_ = virtualizing_list_box_remove_top_widgets (self, &bin_height);
	top_removed = _tmp34_;
	_tmp35_ = virtualizing_list_box_insert_top_widgets (self, &bin_height);
	top_added = _tmp35_;
	_tmp36_ = virtualizing_list_box_remove_bottom_widgets (self, &bin_height);
	bottom_removed = _tmp36_;
	_tmp37_ = virtualizing_list_box_insert_bottom_widgets (self, &bin_height);
	bottom_added = _tmp37_;
	if (top_removed) {
		_tmp41_ = TRUE;
	} else {
		_tmp41_ = top_added;
	}
	if (_tmp41_) {
		_tmp40_ = TRUE;
	} else {
		_tmp40_ = bottom_removed;
	}
	if (_tmp40_) {
		_tmp39_ = TRUE;
	} else {
		_tmp39_ = bottom_added;
	}
	if (_tmp39_) {
		_tmp38_ = TRUE;
	} else {
		_tmp38_ = model_changed;
	}
	widgets_changed = _tmp38_;
	_tmp43_ = virtualizing_list_box_get_vadjustment (self);
	_tmp44_ = _tmp43_;
	if (_tmp44_ != NULL) {
		_tmp42_ = widgets_changed;
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		guint top_part = 0U;
		guint widget_part = 0U;
		guint bottom_part = 0U;
		guint new_upper = 0U;
		guint _tmp45_ = 0U;
		guint _tmp46_ = 0U;
		guint _tmp47_ = 0U;
		guint _tmp48_;
		GtkAdjustment* _tmp49_;
		gdouble _tmp50_;
		gdouble _tmp51_;
		gdouble _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		GtkAdjustment* _tmp63_;
		GtkAdjustment* _tmp64_;
		gdouble _tmp65_;
		gdouble _tmp66_;
		gdouble _tmp67_;
		gint _tmp69_;
		gint _tmp70_;
		_tmp48_ = virtualizing_list_box_estimated_list_height (self, &_tmp45_, &_tmp46_, &_tmp47_);
		top_part = _tmp45_;
		bottom_part = _tmp46_;
		widget_part = _tmp47_;
		new_upper = _tmp48_;
		_tmp49_ = self->priv->_vadjustment;
		_tmp50_ = gtk_adjustment_get_upper (_tmp49_);
		_tmp51_ = _tmp50_;
		if (((gdouble) new_upper) > _tmp51_) {
			GtkAdjustment* _tmp52_;
			GtkAdjustment* _tmp53_;
			gdouble _tmp54_;
			gdouble _tmp55_;
			_tmp52_ = virtualizing_list_box_get_vadjustment (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = gtk_adjustment_get_value (_tmp53_);
			_tmp55_ = _tmp54_;
			virtualizing_list_box_set_bin_y_diff (self, MAX ((gdouble) top_part, _tmp55_));
		} else {
			GtkAdjustment* _tmp56_;
			GtkAdjustment* _tmp57_;
			gdouble _tmp58_;
			gdouble _tmp59_;
			_tmp56_ = virtualizing_list_box_get_vadjustment (self);
			_tmp57_ = _tmp56_;
			_tmp58_ = gtk_adjustment_get_value (_tmp57_);
			_tmp59_ = _tmp58_;
			virtualizing_list_box_set_bin_y_diff (self, MIN ((gdouble) top_part, _tmp59_));
		}
		virtualizing_list_box_configure_adjustment (self);
		_tmp60_ = self->priv->_bin_y_diff;
		_tmp61_ = virtualizing_list_box_get_bin_y (self);
		_tmp62_ = _tmp61_;
		virtualizing_list_box_set_value (self, _tmp60_ - _tmp62_);
		_tmp63_ = virtualizing_list_box_get_vadjustment (self);
		_tmp64_ = _tmp63_;
		_tmp65_ = gtk_adjustment_get_value (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = self->priv->_bin_y_diff;
		if (_tmp66_ < _tmp67_) {
			gdouble _tmp68_;
			_tmp68_ = self->priv->_bin_y_diff;
			virtualizing_list_box_set_value (self, _tmp68_);
		}
		_tmp69_ = virtualizing_list_box_get_bin_y (self);
		_tmp70_ = _tmp69_;
		if (_tmp70_ > 0) {
			GtkAdjustment* _tmp71_;
			GtkAdjustment* _tmp72_;
			gdouble _tmp73_;
			gdouble _tmp74_;
			_tmp71_ = virtualizing_list_box_get_vadjustment (self);
			_tmp72_ = _tmp71_;
			_tmp73_ = gtk_adjustment_get_value (_tmp72_);
			_tmp74_ = _tmp73_;
			virtualizing_list_box_set_bin_y_diff (self, _tmp74_);
		}
	}
	virtualizing_list_box_configure_adjustment (self);
	virtualizing_list_box_update_bin_window (self, bin_height);
	virtualizing_list_box_position_children (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gint
virtualizing_list_box_estimated_widget_height (VirtualizingListBox* self)
{
	gint average_widget_height = 0;
	gint used_widgets = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	average_widget_height = 0;
	used_widgets = 0;
	{
		GeeArrayList* _w_list = NULL;
		GeeArrayList* _tmp0_;
		gint _w_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _w_index = 0;
		_tmp0_ = self->priv->current_widgets;
		_w_list = _tmp0_;
		_tmp1_ = _w_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_w_size = _tmp3_;
		_w_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			VirtualizingListBoxRow* w = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			VirtualizingListBoxRow* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_w_index = _w_index + 1;
			_tmp4_ = _w_index;
			_tmp5_ = _w_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _w_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _w_index);
			w = (VirtualizingListBoxRow*) _tmp7_;
			_tmp8_ = w;
			_tmp9_ = gtk_widget_get_visible ((GtkWidget*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_) {
				VirtualizingListBoxRow* _tmp11_;
				gint _tmp12_;
				_tmp11_ = w;
				average_widget_height += virtualizing_list_box_get_widget_height (self, (GtkWidget*) _tmp11_);
				_tmp12_ = used_widgets;
				used_widgets = _tmp12_ + 1;
			}
			_g_object_unref0 (w);
		}
	}
	if (used_widgets > 0) {
		average_widget_height /= used_widgets;
	} else {
		average_widget_height = self->priv->last_valid_widget_height;
	}
	self->priv->last_valid_widget_height = average_widget_height;
	result = average_widget_height;
	return result;
}

static void
virtualizing_list_box_configure_adjustment (VirtualizingListBox* self)
{
	gint widget_height = 0;
	guint list_height = 0U;
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GtkAdjustment* _tmp8_;
	GtkAdjustment* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	GtkAdjustment* _tmp14_;
	GtkAdjustment* _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	GtkAdjustment* _tmp18_;
	GtkAdjustment* _tmp19_;
	gdouble _tmp20_;
	gdouble _tmp21_;
	GtkAdjustment* _tmp22_;
	GtkAdjustment* _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	g_return_if_fail (self != NULL);
	widget_height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	list_height = virtualizing_list_box_estimated_list_height (self, NULL, NULL, NULL);
	_tmp0_ = virtualizing_list_box_get_vadjustment (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_upper (_tmp1_);
	_tmp3_ = _tmp2_;
	if (((guint) ((gint) _tmp3_)) != MAX (list_height, (guint) widget_height)) {
		GtkAdjustment* _tmp4_;
		GtkAdjustment* _tmp5_;
		_tmp4_ = virtualizing_list_box_get_vadjustment (self);
		_tmp5_ = _tmp4_;
		gtk_adjustment_set_upper (_tmp5_, (gdouble) MAX (list_height, (guint) widget_height));
	} else {
		if (list_height == ((guint) 0)) {
			GtkAdjustment* _tmp6_;
			GtkAdjustment* _tmp7_;
			_tmp6_ = virtualizing_list_box_get_vadjustment (self);
			_tmp7_ = _tmp6_;
			gtk_adjustment_set_upper (_tmp7_, (gdouble) widget_height);
		}
	}
	_tmp8_ = virtualizing_list_box_get_vadjustment (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_adjustment_get_page_size (_tmp9_);
	_tmp11_ = _tmp10_;
	if (((gint) _tmp11_) != widget_height) {
		GtkAdjustment* _tmp12_;
		GtkAdjustment* _tmp13_;
		_tmp12_ = virtualizing_list_box_get_vadjustment (self);
		_tmp13_ = _tmp12_;
		gtk_adjustment_set_page_size (_tmp13_, (gdouble) widget_height);
	}
	_tmp14_ = virtualizing_list_box_get_vadjustment (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = gtk_adjustment_get_value (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = virtualizing_list_box_get_vadjustment (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = gtk_adjustment_get_upper (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = virtualizing_list_box_get_vadjustment (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = gtk_adjustment_get_page_size (_tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp17_ > (_tmp21_ - _tmp25_)) {
		gdouble v = 0.0;
		GtkAdjustment* _tmp26_;
		GtkAdjustment* _tmp27_;
		gdouble _tmp28_;
		gdouble _tmp29_;
		GtkAdjustment* _tmp30_;
		GtkAdjustment* _tmp31_;
		gdouble _tmp32_;
		gdouble _tmp33_;
		_tmp26_ = virtualizing_list_box_get_vadjustment (self);
		_tmp27_ = _tmp26_;
		_tmp28_ = gtk_adjustment_get_upper (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = virtualizing_list_box_get_vadjustment (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = gtk_adjustment_get_page_size (_tmp31_);
		_tmp33_ = _tmp32_;
		v = _tmp29_ - _tmp33_;
		virtualizing_list_box_set_value (self, v);
	}
}

static void
virtualizing_list_box_set_value (VirtualizingListBox* self,
                                 gdouble v)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = virtualizing_list_box_get_vadjustment (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	if (v == _tmp3_) {
		return;
	}
	self->priv->block = TRUE;
	_tmp4_ = virtualizing_list_box_get_vadjustment (self);
	_tmp5_ = _tmp4_;
	gtk_adjustment_set_value (_tmp5_, v);
	self->priv->block = FALSE;
}

static guint
virtualizing_list_box_estimated_list_height (VirtualizingListBox* self,
                                             guint* top,
                                             guint* bottom,
                                             guint* visible_widgets)
{
	guint _vala_top = 0U;
	guint _vala_bottom = 0U;
	guint _vala_visible_widgets = 0U;
	VirtualizingListBoxModel* _tmp0_;
	VirtualizingListBoxModel* _tmp1_;
	gint widget_height = 0;
	guint top_widgets = 0U;
	guint bottom_widgets = 0U;
	VirtualizingListBoxModel* _tmp2_;
	VirtualizingListBoxModel* _tmp3_;
	gint exact_height = 0;
	guint h = 0U;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = virtualizing_list_box_get_model (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		_vala_top = (guint) 0;
		_vala_bottom = (guint) 0;
		_vala_visible_widgets = (guint) 0;
		result = (guint) 0;
		if (top) {
			*top = _vala_top;
		}
		if (bottom) {
			*bottom = _vala_bottom;
		}
		if (visible_widgets) {
			*visible_widgets = _vala_visible_widgets;
		}
		return result;
	}
	widget_height = virtualizing_list_box_estimated_widget_height (self);
	top_widgets = self->priv->shown_from;
	_tmp2_ = virtualizing_list_box_get_model (self);
	_tmp3_ = _tmp2_;
	bottom_widgets = virtualizing_list_box_model_get_n_items (_tmp3_) - self->priv->shown_to;
	exact_height = 0;
	{
		GeeArrayList* _w_list = NULL;
		GeeArrayList* _tmp4_;
		gint _w_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _w_index = 0;
		_tmp4_ = self->priv->current_widgets;
		_w_list = _tmp4_;
		_tmp5_ = _w_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_w_size = _tmp7_;
		_w_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			VirtualizingListBoxRow* w = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			gint h = 0;
			VirtualizingListBoxRow* _tmp12_;
			_w_index = _w_index + 1;
			_tmp8_ = _w_index;
			_tmp9_ = _w_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _w_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _w_index);
			w = (VirtualizingListBoxRow*) _tmp11_;
			_tmp12_ = w;
			h = virtualizing_list_box_get_widget_height (self, (GtkWidget*) _tmp12_);
			exact_height += h;
			_g_object_unref0 (w);
		}
	}
	_vala_top = top_widgets * widget_height;
	_vala_bottom = bottom_widgets * widget_height;
	_vala_visible_widgets = (guint) exact_height;
	h = (_vala_top + _vala_bottom) + _vala_visible_widgets;
	result = h;
	if (top) {
		*top = _vala_top;
	}
	if (bottom) {
		*bottom = _vala_bottom;
	}
	if (visible_widgets) {
		*visible_widgets = _vala_visible_widgets;
	}
	return result;
}

VirtualizingListBoxRow*
virtualizing_list_box_get_row_at_y (VirtualizingListBox* self,
                                    gint y)
{
	GtkAllocation alloc = {0};
	VirtualizingListBoxRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeArrayList* _row_list = NULL;
		GeeArrayList* _tmp0_;
		gint _row_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _row_index = 0;
		_tmp0_ = self->priv->current_widgets;
		_row_list = _tmp0_;
		_tmp1_ = _row_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_row_size = _tmp3_;
		_row_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			VirtualizingListBoxRow* row = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			VirtualizingListBoxRow* _tmp8_;
			GtkAllocation _tmp9_ = {0};
			gboolean _tmp10_ = FALSE;
			GtkAllocation _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_row_index = _row_index + 1;
			_tmp4_ = _row_index;
			_tmp5_ = _row_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _row_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _row_index);
			row = (VirtualizingListBoxRow*) _tmp7_;
			_tmp8_ = row;
			gtk_widget_get_allocation ((GtkWidget*) _tmp8_, &_tmp9_);
			alloc = _tmp9_;
			_tmp11_ = alloc;
			_tmp12_ = virtualizing_list_box_get_bin_y (self);
			_tmp13_ = _tmp12_;
			if (y >= (_tmp11_.y + _tmp13_)) {
				GtkAllocation _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				GtkAllocation _tmp17_;
				_tmp14_ = alloc;
				_tmp15_ = virtualizing_list_box_get_bin_y (self);
				_tmp16_ = _tmp15_;
				_tmp17_ = alloc;
				_tmp10_ = y <= ((_tmp14_.y + _tmp16_) + _tmp17_.height);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				VirtualizingListBoxRow* return_value = NULL;
				VirtualizingListBoxRow* _tmp18_;
				VirtualizingListBoxRow* _tmp19_;
				_tmp18_ = row;
				return_value = _tmp18_;
				_tmp19_ = return_value;
				result = _tmp19_;
				_g_object_unref0 (row);
				return result;
			}
			_g_object_unref0 (row);
		}
	}
	result = NULL;
	return result;
}

static void
virtualizing_list_box_on_multipress_pressed (VirtualizingListBox* self,
                                             gint n_press,
                                             gdouble x,
                                             gdouble y)
{
	VirtualizingListBoxRow* row = NULL;
	VirtualizingListBoxRow* _tmp0_;
	VirtualizingListBoxRow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	VirtualizingListBoxRow* _tmp3_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->active_row);
	self->priv->active_row = NULL;
	_tmp0_ = virtualizing_list_box_get_row_at_y (self, (gint) y);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	row = _tmp1_;
	_tmp3_ = row;
	if (_tmp3_ != NULL) {
		VirtualizingListBoxRow* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = row;
		_tmp5_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		VirtualizingListBoxRow* _tmp7_;
		VirtualizingListBoxRow* _tmp8_;
		VirtualizingListBoxRow* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = row;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (self->priv->active_row);
		self->priv->active_row = _tmp8_;
		_tmp9_ = row;
		gtk_widget_set_state_flags ((GtkWidget*) _tmp9_, GTK_STATE_FLAG_ACTIVE, FALSE);
		if (n_press == 2) {
			gboolean _tmp11_;
			_tmp11_ = self->priv->_activate_on_single_click;
			_tmp10_ = !_tmp11_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			VirtualizingListBoxRow* _tmp12_;
			GObject* _tmp13_;
			GObject* _tmp14_;
			_tmp12_ = row;
			_tmp13_ = virtualizing_list_box_row_get_model_item (_tmp12_);
			_tmp14_ = _tmp13_;
			g_signal_emit (self, virtualizing_list_box_signals[VIRTUALIZING_LIST_BOX_ROW_ACTIVATED_SIGNAL], 0, _tmp14_);
		}
	}
	_g_object_unref0 (row);
}

static void
virtualizing_list_box_get_current_selection_modifiers (VirtualizingListBox* self,
                                                       gboolean* modify,
                                                       gboolean* extend)
{
	gboolean _vala_modify = FALSE;
	gboolean _vala_extend = FALSE;
	GdkModifierType state = 0U;
	GdkModifierType mask = 0U;
	GdkModifierType _tmp0_ = 0U;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_vala_modify = FALSE;
	_vala_extend = FALSE;
	_tmp1_ = gtk_get_current_event_state (&_tmp0_);
	state = _tmp0_;
	if (_tmp1_) {
		mask = gtk_widget_get_modifier_mask ((GtkWidget*) self, GDK_MODIFIER_INTENT_MODIFY_SELECTION);
		if ((state & mask) == mask) {
			_vala_modify = TRUE;
		}
		mask = gtk_widget_get_modifier_mask ((GtkWidget*) self, GDK_MODIFIER_INTENT_EXTEND_SELECTION);
		if ((state & mask) == mask) {
			_vala_extend = TRUE;
		}
	}
	if (modify) {
		*modify = _vala_modify;
	}
	if (extend) {
		*extend = _vala_extend;
	}
}

static GdkEvent*
_vala_GdkEvent_copy (GdkEvent* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEvent_copy0 (gpointer self)
{
	return self ? _vala_GdkEvent_copy (self) : NULL;
}

static void
_vala_GdkEvent_free (GdkEvent* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static void
_vala_GdkEventSequence_free (GdkEventSequence* self)
{
	g_boxed_free (gdk_event_sequence_get_type (), self);
}

static void
virtualizing_list_box_on_multipress_released (VirtualizingListBox* self,
                                              gint n_press,
                                              gdouble x,
                                              gdouble y)
{
	VirtualizingListBoxRow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_row;
	if (_tmp0_ != NULL) {
		gboolean focus_on_click = FALSE;
		VirtualizingListBoxRow* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		VirtualizingListBoxRow* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp1_ = self->priv->active_row;
		_tmp2_ = gtk_widget_get_focus_on_click ((GtkWidget*) _tmp1_);
		_tmp3_ = _tmp2_;
		focus_on_click = _tmp3_;
		_tmp4_ = self->priv->active_row;
		gtk_widget_unset_state_flags ((GtkWidget*) _tmp4_, GTK_STATE_FLAG_ACTIVE);
		if (n_press == 1) {
			gboolean _tmp6_;
			_tmp6_ = self->priv->_activate_on_single_click;
			_tmp5_ = _tmp6_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			VirtualizingListBoxRow* _tmp7_;
			_tmp7_ = self->priv->active_row;
			virtualizing_list_box_select_and_activate (self, _tmp7_, focus_on_click);
		} else {
			gboolean modify = FALSE;
			gboolean extend = FALSE;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			GdkEventSequence* sequence = NULL;
			GtkGestureMultiPress* _tmp10_;
			GdkEventSequence* _tmp11_;
			GdkEvent* event = NULL;
			GtkGestureMultiPress* _tmp12_;
			GdkEventSequence* _tmp13_;
			GdkEvent* _tmp14_;
			GdkEvent* _tmp15_;
			GdkInputSource source = 0;
			GdkEvent* _tmp16_;
			GdkDevice* _tmp17_;
			VirtualizingListBoxRow* _tmp18_;
			virtualizing_list_box_get_current_selection_modifiers (self, &_tmp8_, &_tmp9_);
			modify = _tmp8_;
			extend = _tmp9_;
			_tmp10_ = self->priv->multipress;
			_tmp11_ = gtk_gesture_single_get_current_sequence ((GtkGestureSingle*) _tmp10_);
			sequence = _tmp11_;
			_tmp12_ = self->priv->multipress;
			_tmp13_ = sequence;
			_tmp14_ = gtk_gesture_get_last_event ((GtkGesture*) _tmp12_, _tmp13_);
			_tmp15_ = __vala_GdkEvent_copy0 (_tmp14_);
			event = _tmp15_;
			_tmp16_ = event;
			_tmp17_ = gdk_event_get_source_device (_tmp16_);
			source = gdk_device_get_source (_tmp17_);
			if (source == GDK_SOURCE_TOUCHSCREEN) {
				modify = !modify;
			}
			_tmp18_ = self->priv->active_row;
			virtualizing_list_box_update_selection (self, _tmp18_, modify, extend, focus_on_click);
			__vala_GdkEvent_free0 (event);
			__vala_GdkEventSequence_free0 (sequence);
		}
	}
}

static void
virtualizing_list_box_update_selection (VirtualizingListBox* self,
                                        VirtualizingListBoxRow* row,
                                        gboolean modify,
                                        gboolean extend,
                                        gboolean grab_cursor)
{
	GObject* _tmp0_;
	GObject* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkSelectionMode _tmp3_;
	GtkSelectionMode _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = virtualizing_list_box_row_get_model_item (row);
	_tmp1_ = _tmp0_;
	virtualizing_list_box_update_cursor (self, _tmp1_, grab_cursor);
	_tmp3_ = self->priv->_selection_mode;
	if (_tmp3_ == GTK_SELECTION_NONE) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = virtualizing_list_box_row_get_selectable (row);
		_tmp5_ = _tmp4_;
		_tmp2_ = !_tmp5_;
	}
	if (_tmp2_) {
		return;
	}
	_tmp6_ = self->priv->_selection_mode;
	if (_tmp6_ == GTK_SELECTION_BROWSE) {
		virtualizing_list_box_select_row (self, row);
	} else {
		GtkSelectionMode _tmp7_;
		_tmp7_ = self->priv->_selection_mode;
		if (_tmp7_ == GTK_SELECTION_SINGLE) {
			gboolean was_selected = FALSE;
			VirtualizingListBoxModel* _tmp8_;
			VirtualizingListBoxModel* _tmp9_;
			GObject* _tmp10_;
			GObject* _tmp11_;
			gboolean _tmp12_ = FALSE;
			gboolean select = FALSE;
			VirtualizingListBoxModel* _tmp13_;
			VirtualizingListBoxModel* _tmp14_;
			GObject* _tmp15_;
			GObject* _tmp16_;
			GObject* _tmp17_ = NULL;
			GObject* _tmp20_;
			_tmp8_ = virtualizing_list_box_get_model (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = virtualizing_list_box_row_get_model_item (row);
			_tmp11_ = _tmp10_;
			was_selected = virtualizing_list_box_model_get_item_selected (_tmp9_, _tmp11_);
			virtualizing_list_box_unselect_all_internal (self);
			if (modify) {
				_tmp12_ = !was_selected;
			} else {
				_tmp12_ = TRUE;
			}
			select = _tmp12_;
			_tmp13_ = virtualizing_list_box_get_model (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = virtualizing_list_box_row_get_model_item (row);
			_tmp16_ = _tmp15_;
			virtualizing_list_box_model_set_item_selected (_tmp14_, _tmp16_, select);
			if (select) {
				GObject* _tmp18_;
				GObject* _tmp19_;
				_tmp18_ = virtualizing_list_box_row_get_model_item (row);
				_tmp19_ = _tmp18_;
				_tmp17_ = _tmp19_;
			} else {
				_tmp17_ = NULL;
			}
			virtualizing_list_box_set_selected_row (self, _tmp17_);
			if (select) {
				gtk_widget_set_state_flags ((GtkWidget*) row, GTK_STATE_FLAG_SELECTED, FALSE);
			} else {
				gtk_widget_unset_state_flags ((GtkWidget*) row, GTK_STATE_FLAG_SELECTED);
			}
			_tmp20_ = self->priv->_selected_row;
			g_signal_emit (self, virtualizing_list_box_signals[VIRTUALIZING_LIST_BOX_ROW_SELECTED_SIGNAL], 0, _tmp20_);
		} else {
			if (extend) {
				GObject* selected = NULL;
				GObject* _tmp21_;
				GObject* _tmp22_;
				GObject* _tmp23_;
				_tmp21_ = self->priv->_selected_row;
				_tmp22_ = _g_object_ref0 (_tmp21_);
				selected = _tmp22_;
				virtualizing_list_box_unselect_all_internal (self);
				_tmp23_ = selected;
				if (_tmp23_ == NULL) {
					virtualizing_list_box_select_row (self, row);
				} else {
					GObject* _tmp24_;
					GObject* _tmp25_;
					GObject* _tmp26_;
					_tmp24_ = selected;
					_tmp25_ = virtualizing_list_box_row_get_model_item (row);
					_tmp26_ = _tmp25_;
					virtualizing_list_box_select_all_between (self, _tmp24_, _tmp26_, FALSE);
				}
				_g_object_unref0 (selected);
			} else {
				if (modify) {
					gboolean selected = FALSE;
					VirtualizingListBoxModel* _tmp27_;
					VirtualizingListBoxModel* _tmp28_;
					GObject* _tmp29_;
					GObject* _tmp30_;
					VirtualizingListBoxModel* _tmp31_;
					VirtualizingListBoxModel* _tmp32_;
					GObject* _tmp33_;
					GObject* _tmp34_;
					_tmp27_ = virtualizing_list_box_get_model (self);
					_tmp28_ = _tmp27_;
					_tmp29_ = virtualizing_list_box_row_get_model_item (row);
					_tmp30_ = _tmp29_;
					selected = virtualizing_list_box_model_get_item_selected (_tmp28_, _tmp30_);
					if (selected) {
						gtk_widget_unset_state_flags ((GtkWidget*) row, GTK_STATE_FLAG_SELECTED);
					} else {
						gtk_widget_set_state_flags ((GtkWidget*) row, GTK_STATE_FLAG_SELECTED, FALSE);
					}
					_tmp31_ = virtualizing_list_box_get_model (self);
					_tmp32_ = _tmp31_;
					_tmp33_ = virtualizing_list_box_row_get_model_item (row);
					_tmp34_ = _tmp33_;
					virtualizing_list_box_model_set_item_selected (_tmp32_, _tmp34_, !selected);
				} else {
					virtualizing_list_box_unselect_all_internal (self);
					virtualizing_list_box_select_row (self, row);
				}
			}
		}
	}
}

static void
virtualizing_list_box_select_all_between (VirtualizingListBox* self,
                                          GObject* from,
                                          GObject* to,
                                          gboolean modify)
{
	GeeArrayList* items = NULL;
	VirtualizingListBoxModel* _tmp0_;
	VirtualizingListBoxModel* _tmp1_;
	GeeArrayList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (from != NULL);
	g_return_if_fail (to != NULL);
	_tmp0_ = virtualizing_list_box_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = virtualizing_list_box_model_get_items_between (_tmp1_, from, to);
	items = _tmp2_;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp3_;
		gint _item_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _item_index = 0;
		_tmp3_ = items;
		_item_list = _tmp3_;
		_tmp4_ = _item_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_item_size = _tmp6_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			GObject* item = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			VirtualizingListBoxModel* _tmp11_;
			VirtualizingListBoxModel* _tmp12_;
			GObject* _tmp13_;
			_item_index = _item_index + 1;
			_tmp7_ = _item_index;
			_tmp8_ = _item_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _item_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _item_index);
			item = (GObject*) _tmp10_;
			_tmp11_ = virtualizing_list_box_get_model (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = item;
			virtualizing_list_box_model_set_item_selected (_tmp12_, _tmp13_, TRUE);
			_g_object_unref0 (item);
		}
	}
	{
		GeeArrayList* _row_list = NULL;
		GeeArrayList* _tmp14_;
		gint _row_size = 0;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _row_index = 0;
		_tmp14_ = self->priv->current_widgets;
		_row_list = _tmp14_;
		_tmp15_ = _row_list;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_row_size = _tmp17_;
		_row_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			VirtualizingListBoxRow* row = NULL;
			GeeArrayList* _tmp20_;
			gpointer _tmp21_;
			GeeArrayList* _tmp22_;
			VirtualizingListBoxRow* _tmp23_;
			GObject* _tmp24_;
			GObject* _tmp25_;
			_row_index = _row_index + 1;
			_tmp18_ = _row_index;
			_tmp19_ = _row_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _row_list;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _row_index);
			row = (VirtualizingListBoxRow*) _tmp21_;
			_tmp22_ = items;
			_tmp23_ = row;
			_tmp24_ = virtualizing_list_box_row_get_model_item (_tmp23_);
			_tmp25_ = _tmp24_;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp22_, _tmp25_)) {
				VirtualizingListBoxRow* _tmp26_;
				_tmp26_ = row;
				gtk_widget_set_state_flags ((GtkWidget*) _tmp26_, GTK_STATE_FLAG_SELECTED, FALSE);
			}
			_g_object_unref0 (row);
		}
	}
	_g_object_unref0 (items);
}

void
virtualizing_list_box_select_row_at_index (VirtualizingListBox* self,
                                           gint index)
{
	VirtualizingListBoxRow* row = NULL;
	VirtualizingListBoxRow* _tmp0_;
	VirtualizingListBoxRow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = virtualizing_list_box_ensure_index_visible (self, index);
	row = _tmp0_;
	_tmp1_ = row;
	if (_tmp1_ != NULL) {
		VirtualizingListBoxRow* _tmp2_;
		_tmp2_ = row;
		virtualizing_list_box_select_and_activate (self, _tmp2_, TRUE);
	}
	_g_object_unref0 (row);
}

static void
virtualizing_list_box_select_and_activate (VirtualizingListBox* self,
                                           VirtualizingListBoxRow* row,
                                           gboolean grab_focus)
{
	GObject* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GObject* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	virtualizing_list_box_select_row (self, row);
	_tmp0_ = virtualizing_list_box_row_get_model_item (row);
	_tmp1_ = _tmp0_;
	virtualizing_list_box_update_cursor (self, _tmp1_, grab_focus);
	_tmp2_ = virtualizing_list_box_row_get_model_item (row);
	_tmp3_ = _tmp2_;
	g_signal_emit (self, virtualizing_list_box_signals[VIRTUALIZING_LIST_BOX_ROW_ACTIVATED_SIGNAL], 0, _tmp3_);
}

void
virtualizing_list_box_update_cursor (VirtualizingListBox* self,
                                     GObject* item,
                                     gboolean grab_focus)
{
	VirtualizingListBoxRow* row = NULL;
	VirtualizingListBoxModel* _tmp0_;
	VirtualizingListBoxModel* _tmp1_;
	VirtualizingListBoxRow* _tmp2_;
	gboolean _tmp3_ = FALSE;
	VirtualizingListBoxRow* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = virtualizing_list_box_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = virtualizing_list_box_ensure_index_visible (self, virtualizing_list_box_model_get_index_of (_tmp1_, item));
	row = _tmp2_;
	_tmp4_ = row;
	if (_tmp4_ != NULL) {
		_tmp3_ = grab_focus;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		VirtualizingListBoxRow* _tmp5_;
		_tmp5_ = row;
		gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
	}
	_g_object_unref0 (row);
}

static VirtualizingListBoxRow*
virtualizing_list_box_ensure_index_visible (VirtualizingListBox* self,
                                            gint index)
{
	guint n_items = 0U;
	VirtualizingListBoxModel* _tmp0_;
	VirtualizingListBoxModel* _tmp1_;
	guint index_max = 0U;
	VirtualizingListBoxRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (index < 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = virtualizing_list_box_get_model (self);
	_tmp1_ = _tmp0_;
	n_items = virtualizing_list_box_model_get_n_items (_tmp1_);
	if (n_items == ((guint) 0)) {
		result = NULL;
		return result;
	}
	index_max = n_items - 1;
	if (((guint) index) > index_max) {
		result = NULL;
		return result;
	}
	if (index == 0) {
		virtualizing_list_box_set_value (self, 0.0);
		virtualizing_list_box_ensure_visible_widgets (self, FALSE);
		{
			GeeArrayList* _row_list = NULL;
			GeeArrayList* _tmp2_;
			gint _row_size = 0;
			GeeArrayList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _row_index = 0;
			_tmp2_ = self->priv->current_widgets;
			_row_list = _tmp2_;
			_tmp3_ = _row_list;
			_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_row_size = _tmp5_;
			_row_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				VirtualizingListBoxRow* row = NULL;
				GeeArrayList* _tmp8_;
				gpointer _tmp9_;
				VirtualizingListBoxModel* _tmp10_;
				VirtualizingListBoxModel* _tmp11_;
				VirtualizingListBoxRow* _tmp12_;
				GObject* _tmp13_;
				GObject* _tmp14_;
				_row_index = _row_index + 1;
				_tmp6_ = _row_index;
				_tmp7_ = _row_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _row_list;
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _row_index);
				row = (VirtualizingListBoxRow*) _tmp9_;
				_tmp10_ = virtualizing_list_box_get_model (self);
				_tmp11_ = _tmp10_;
				_tmp12_ = row;
				_tmp13_ = virtualizing_list_box_row_get_model_item (_tmp12_);
				_tmp14_ = _tmp13_;
				if (index == virtualizing_list_box_model_get_index_of (_tmp11_, _tmp14_)) {
					result = row;
					return result;
				}
				_g_object_unref0 (row);
			}
		}
	}
	if (((guint) index) == index_max) {
		GtkAdjustment* _tmp15_;
		GtkAdjustment* _tmp16_;
		gdouble _tmp17_;
		gdouble _tmp18_;
		_tmp15_ = virtualizing_list_box_get_vadjustment (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = gtk_adjustment_get_upper (_tmp16_);
		_tmp18_ = _tmp17_;
		virtualizing_list_box_set_value (self, _tmp18_);
		virtualizing_list_box_ensure_visible_widgets (self, FALSE);
		{
			GeeArrayList* _row_list = NULL;
			GeeArrayList* _tmp19_;
			gint _row_size = 0;
			GeeArrayList* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint _row_index = 0;
			_tmp19_ = self->priv->current_widgets;
			_row_list = _tmp19_;
			_tmp20_ = _row_list;
			_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
			_tmp22_ = _tmp21_;
			_row_size = _tmp22_;
			_row_index = -1;
			while (TRUE) {
				gint _tmp23_;
				gint _tmp24_;
				VirtualizingListBoxRow* row = NULL;
				GeeArrayList* _tmp25_;
				gpointer _tmp26_;
				VirtualizingListBoxModel* _tmp27_;
				VirtualizingListBoxModel* _tmp28_;
				VirtualizingListBoxRow* _tmp29_;
				GObject* _tmp30_;
				GObject* _tmp31_;
				_row_index = _row_index + 1;
				_tmp23_ = _row_index;
				_tmp24_ = _row_size;
				if (!(_tmp23_ < _tmp24_)) {
					break;
				}
				_tmp25_ = _row_list;
				_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _row_index);
				row = (VirtualizingListBoxRow*) _tmp26_;
				_tmp27_ = virtualizing_list_box_get_model (self);
				_tmp28_ = _tmp27_;
				_tmp29_ = row;
				_tmp30_ = virtualizing_list_box_row_get_model_item (_tmp29_);
				_tmp31_ = _tmp30_;
				if (index == virtualizing_list_box_model_get_index_of (_tmp28_, _tmp31_)) {
					result = row;
					return result;
				}
				_g_object_unref0 (row);
			}
		}
	}
	while (TRUE) {
		GtkAdjustment* _tmp32_;
		GtkAdjustment* _tmp33_;
		gdouble _tmp34_;
		gdouble _tmp35_;
		if (!(((guint) index) <= self->priv->shown_from)) {
			break;
		}
		_tmp32_ = virtualizing_list_box_get_vadjustment (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = gtk_adjustment_get_value (_tmp33_);
		_tmp35_ = _tmp34_;
		gtk_adjustment_set_value (_tmp33_, _tmp35_ - 1);
		virtualizing_list_box_ensure_visible_widgets (self, FALSE);
	}
	while (TRUE) {
		GtkAdjustment* _tmp36_;
		GtkAdjustment* _tmp37_;
		gdouble _tmp38_;
		gdouble _tmp39_;
		if (!(((guint) (index + 1)) >= self->priv->shown_to)) {
			break;
		}
		_tmp36_ = virtualizing_list_box_get_vadjustment (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = gtk_adjustment_get_value (_tmp37_);
		_tmp39_ = _tmp38_;
		gtk_adjustment_set_value (_tmp37_, _tmp39_ + 1);
		virtualizing_list_box_ensure_visible_widgets (self, FALSE);
	}
	{
		GeeArrayList* _row_list = NULL;
		GeeArrayList* _tmp40_;
		gint _row_size = 0;
		GeeArrayList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _row_index = 0;
		_tmp40_ = self->priv->current_widgets;
		_row_list = _tmp40_;
		_tmp41_ = _row_list;
		_tmp42_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_row_size = _tmp43_;
		_row_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			VirtualizingListBoxRow* row = NULL;
			GeeArrayList* _tmp46_;
			gpointer _tmp47_;
			VirtualizingListBoxModel* _tmp48_;
			VirtualizingListBoxModel* _tmp49_;
			VirtualizingListBoxRow* _tmp50_;
			GObject* _tmp51_;
			GObject* _tmp52_;
			_row_index = _row_index + 1;
			_tmp44_ = _row_index;
			_tmp45_ = _row_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _row_list;
			_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, _row_index);
			row = (VirtualizingListBoxRow*) _tmp47_;
			_tmp48_ = virtualizing_list_box_get_model (self);
			_tmp49_ = _tmp48_;
			_tmp50_ = row;
			_tmp51_ = virtualizing_list_box_row_get_model_item (_tmp50_);
			_tmp52_ = _tmp51_;
			if (index == virtualizing_list_box_model_get_index_of (_tmp49_, _tmp52_)) {
				result = row;
				return result;
			}
			_g_object_unref0 (row);
		}
	}
	result = NULL;
	return result;
}

void
virtualizing_list_box_select_row (VirtualizingListBox* self,
                                  VirtualizingListBoxRow* row)
{
	gboolean _tmp0_ = FALSE;
	VirtualizingListBoxModel* _tmp1_;
	VirtualizingListBoxModel* _tmp2_;
	GtkSelectionMode _tmp4_;
	VirtualizingListBoxModel* _tmp5_;
	VirtualizingListBoxModel* _tmp6_;
	GObject* _tmp7_;
	GObject* _tmp8_;
	GObject* _tmp9_;
	GObject* _tmp10_;
	GObject* _tmp11_;
	GObject* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp1_ = virtualizing_list_box_get_model (self);
	_tmp2_ = _tmp1_;
	if (virtualizing_list_box_model_get_item_selected (_tmp2_, (GObject*) row)) {
		_tmp0_ = TRUE;
	} else {
		GtkSelectionMode _tmp3_;
		_tmp3_ = self->priv->_selection_mode;
		_tmp0_ = _tmp3_ == GTK_SELECTION_NONE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->_selection_mode;
	if (_tmp4_ != GTK_SELECTION_MULTIPLE) {
		virtualizing_list_box_unselect_all_internal (self);
	}
	_tmp5_ = virtualizing_list_box_get_model (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = virtualizing_list_box_row_get_model_item (row);
	_tmp8_ = _tmp7_;
	virtualizing_list_box_model_set_item_selected (_tmp6_, _tmp8_, TRUE);
	gtk_widget_set_state_flags ((GtkWidget*) row, GTK_STATE_FLAG_SELECTED, FALSE);
	_tmp9_ = virtualizing_list_box_row_get_model_item (row);
	_tmp10_ = _tmp9_;
	virtualizing_list_box_set_selected_row (self, _tmp10_);
	_tmp11_ = virtualizing_list_box_row_get_model_item (row);
	_tmp12_ = _tmp11_;
	g_signal_emit (self, virtualizing_list_box_signals[VIRTUALIZING_LIST_BOX_ROW_SELECTED_SIGNAL], 0, _tmp12_);
	g_signal_emit (self, virtualizing_list_box_signals[VIRTUALIZING_LIST_BOX_SELECTED_ROWS_CHANGED_SIGNAL], 0);
}

static gboolean
virtualizing_list_box_unselect_all_internal (VirtualizingListBox* self)
{
	GtkSelectionMode _tmp0_;
	VirtualizingListBoxModel* _tmp10_;
	VirtualizingListBoxModel* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_selection_mode;
	if (_tmp0_ == GTK_SELECTION_NONE) {
		result = FALSE;
		return result;
	}
	{
		GeeArrayList* _row_list = NULL;
		GeeArrayList* _tmp1_;
		gint _row_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _row_index = 0;
		_tmp1_ = self->priv->current_widgets;
		_row_list = _tmp1_;
		_tmp2_ = _row_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_row_size = _tmp4_;
		_row_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			VirtualizingListBoxRow* row = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			VirtualizingListBoxRow* _tmp9_;
			_row_index = _row_index + 1;
			_tmp5_ = _row_index;
			_tmp6_ = _row_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _row_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _row_index);
			row = (VirtualizingListBoxRow*) _tmp8_;
			_tmp9_ = row;
			gtk_widget_unset_state_flags ((GtkWidget*) _tmp9_, GTK_STATE_FLAG_SELECTED);
			_g_object_unref0 (row);
		}
	}
	_tmp10_ = virtualizing_list_box_get_model (self);
	_tmp11_ = _tmp10_;
	virtualizing_list_box_model_unselect_all (_tmp11_);
	virtualizing_list_box_set_selected_row (self, NULL);
	result = TRUE;
	return result;
}

static gboolean
virtualizing_list_box_real_focus (GtkWidget* base,
                                  GtkDirectionType direction)
{
	VirtualizingListBox * self;
	VirtualizingListBoxRow* focus_child = NULL;
	GtkWidget* _tmp0_;
	VirtualizingListBoxRow* _tmp1_;
	gint next_focus_index = 0;
	gboolean _tmp2_ = FALSE;
	VirtualizingListBoxRow* _tmp3_;
	VirtualizingListBoxRow* widget = NULL;
	VirtualizingListBoxRow* _tmp31_;
	VirtualizingListBoxRow* _tmp32_;
	gboolean result;
	self = (VirtualizingListBox*) base;
	_tmp0_ = gtk_container_get_focus_child ((GtkContainer*) self);
	_tmp1_ = _g_object_ref0 (IS_VIRTUALIZING_LIST_BOX_ROW (_tmp0_) ? ((VirtualizingListBoxRow*) _tmp0_) : NULL);
	focus_child = _tmp1_;
	next_focus_index = -1;
	_tmp3_ = focus_child;
	if (_tmp3_ != NULL) {
		VirtualizingListBoxRow* _tmp4_;
		GObject* _tmp5_;
		GObject* _tmp6_;
		_tmp4_ = focus_child;
		_tmp5_ = virtualizing_list_box_row_get_model_item (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		VirtualizingListBoxRow* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = focus_child;
		if (gtk_widget_child_focus ((GtkWidget*) _tmp7_, direction)) {
			result = TRUE;
			_g_object_unref0 (focus_child);
			return result;
		}
		if (direction == GTK_DIR_UP) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = direction == GTK_DIR_TAB_BACKWARD;
		}
		if (_tmp8_) {
			VirtualizingListBoxModel* _tmp9_;
			VirtualizingListBoxModel* _tmp10_;
			VirtualizingListBoxRow* _tmp11_;
			GObject* _tmp12_;
			GObject* _tmp13_;
			_tmp9_ = virtualizing_list_box_get_model (self);
			_tmp10_ = _tmp9_;
			_tmp11_ = focus_child;
			_tmp12_ = virtualizing_list_box_row_get_model_item (_tmp11_);
			_tmp13_ = _tmp12_;
			next_focus_index = virtualizing_list_box_model_get_index_of_item_before (_tmp10_, _tmp13_);
		} else {
			gboolean _tmp14_ = FALSE;
			if (direction == GTK_DIR_DOWN) {
				_tmp14_ = TRUE;
			} else {
				_tmp14_ = direction == GTK_DIR_TAB_FORWARD;
			}
			if (_tmp14_) {
				VirtualizingListBoxModel* _tmp15_;
				VirtualizingListBoxModel* _tmp16_;
				VirtualizingListBoxRow* _tmp17_;
				GObject* _tmp18_;
				GObject* _tmp19_;
				_tmp15_ = virtualizing_list_box_get_model (self);
				_tmp16_ = _tmp15_;
				_tmp17_ = focus_child;
				_tmp18_ = virtualizing_list_box_row_get_model_item (_tmp17_);
				_tmp19_ = _tmp18_;
				next_focus_index = virtualizing_list_box_model_get_index_of_item_after (_tmp16_, _tmp19_);
			}
		}
	} else {
		gboolean _tmp20_ = FALSE;
		if (direction == GTK_DIR_UP) {
			_tmp20_ = TRUE;
		} else {
			_tmp20_ = direction == GTK_DIR_TAB_BACKWARD;
		}
		if (_tmp20_) {
			VirtualizingListBoxModel* _tmp21_;
			VirtualizingListBoxModel* _tmp22_;
			VirtualizingListBoxRow* _tmp23_;
			GObject* _tmp24_;
			GObject* _tmp25_;
			_tmp21_ = virtualizing_list_box_get_model (self);
			_tmp22_ = _tmp21_;
			_tmp23_ = focus_child;
			_tmp24_ = virtualizing_list_box_row_get_model_item (_tmp23_);
			_tmp25_ = _tmp24_;
			next_focus_index = virtualizing_list_box_model_get_index_of (_tmp22_, _tmp25_);
			if (next_focus_index == -1) {
				VirtualizingListBoxModel* _tmp26_;
				VirtualizingListBoxModel* _tmp27_;
				_tmp26_ = virtualizing_list_box_get_model (self);
				_tmp27_ = _tmp26_;
				next_focus_index = ((gint) virtualizing_list_box_model_get_n_items (_tmp27_)) - 1;
			}
		} else {
			VirtualizingListBoxModel* _tmp28_;
			VirtualizingListBoxModel* _tmp29_;
			VirtualizingListBoxRow* _tmp30_;
			_tmp28_ = virtualizing_list_box_get_model (self);
			_tmp29_ = _tmp28_;
			_tmp30_ = focus_child;
			next_focus_index = virtualizing_list_box_model_get_index_of (_tmp29_, (GObject*) _tmp30_);
			if (next_focus_index == -1) {
				next_focus_index = 0;
			}
		}
	}
	if (next_focus_index == -1) {
		if (gtk_widget_keynav_failed ((GtkWidget*) self, direction)) {
			result = TRUE;
			_g_object_unref0 (focus_child);
			return result;
		}
		result = FALSE;
		_g_object_unref0 (focus_child);
		return result;
	}
	_tmp31_ = virtualizing_list_box_ensure_index_visible (self, next_focus_index);
	widget = _tmp31_;
	_tmp32_ = widget;
	if (_tmp32_ != NULL) {
		VirtualizingListBoxRow* _tmp33_;
		_tmp33_ = widget;
		virtualizing_list_box_update_selection (self, _tmp33_, FALSE, FALSE, TRUE);
		result = TRUE;
		_g_object_unref0 (widget);
		_g_object_unref0 (focus_child);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (widget);
	_g_object_unref0 (focus_child);
	return result;
}

static gboolean
virtualizing_list_box_real_get_border (GtkScrollable* base,
                                       GtkBorder* border)
{
	VirtualizingListBox * self;
	GtkBorder _vala_border = {0};
	gboolean result;
	self = (VirtualizingListBox*) base;
	memset (&_vala_border, 0, sizeof (GtkBorder));
	result = FALSE;
	if (border) {
		*border = _vala_border;
	}
	return result;
}

GeeHashSet*
virtualizing_list_box_get_selected_rows (VirtualizingListBox* self)
{
	VirtualizingListBoxModel* _tmp0_;
	VirtualizingListBoxModel* _tmp1_;
	GeeHashSet* _tmp2_;
	GeeHashSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = virtualizing_list_box_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = virtualizing_list_box_model_get_selected_rows (_tmp1_);
	result = _tmp2_;
	return result;
}

VirtualizingListBox*
virtualizing_list_box_construct (GType object_type)
{
	VirtualizingListBox * self = NULL;
	self = (VirtualizingListBox*) g_object_new (object_type, NULL);
	return self;
}

VirtualizingListBox*
virtualizing_list_box_new (void)
{
	return virtualizing_list_box_construct (TYPE_VIRTUALIZING_LIST_BOX);
}

VirtualizingListBoxModel*
virtualizing_list_box_get_model (VirtualizingListBox* self)
{
	VirtualizingListBoxModel* result;
	VirtualizingListBoxModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}

static void
_virtualizing_list_box_on_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                    guint position,
                                                                    guint removed,
                                                                    guint added,
                                                                    gpointer self)
{
	virtualizing_list_box_on_items_changed ((VirtualizingListBox*) self, position, removed, added);
}

void
virtualizing_list_box_set_model (VirtualizingListBox* self,
                                 VirtualizingListBoxModel* value)
{
	VirtualizingListBoxModel* _tmp0_;
	VirtualizingListBoxModel* _tmp3_;
	VirtualizingListBoxModel* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_model;
	if (_tmp0_ != NULL) {
		VirtualizingListBoxModel* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->_model;
		g_signal_parse_name ("items-changed", g_list_model_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GListModel*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _virtualizing_list_box_on_items_changed_g_list_model_items_changed, self);
	}
	_tmp3_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp3_;
	_tmp4_ = self->priv->_model;
	g_signal_connect_object ((GListModel*) _tmp4_, "items-changed", (GCallback) _virtualizing_list_box_on_items_changed_g_list_model_items_changed, self, 0);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_MODEL_PROPERTY]);
}

GtkAdjustment*
virtualizing_list_box_get_vadjustment (VirtualizingListBox* self)
{
	GtkAdjustment* result;
	GtkAdjustment* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_vadjustment;
	result = _tmp0_;
	return result;
}

static void
_virtualizing_list_box_on_adjustment_value_changed_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                                 gpointer self)
{
	virtualizing_list_box_on_adjustment_value_changed ((VirtualizingListBox*) self);
}

static void
_virtualizing_list_box_on_adjustment_page_size_changed_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self)
{
	virtualizing_list_box_on_adjustment_page_size_changed ((VirtualizingListBox*) self);
}

void
virtualizing_list_box_set_vadjustment (VirtualizingListBox* self,
                                       GtkAdjustment* value)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp6_;
	GtkAdjustment* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_vadjustment;
	if (_tmp0_ != NULL) {
		GtkAdjustment* _tmp1_;
		guint _tmp2_;
		GtkAdjustment* _tmp3_;
		guint _tmp4_;
		GQuark _tmp5_;
		_tmp1_ = self->priv->_vadjustment;
		g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _virtualizing_list_box_on_adjustment_value_changed_gtk_adjustment_value_changed, self);
		_tmp3_ = self->priv->_vadjustment;
		g_signal_parse_name ("notify::page-size", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _virtualizing_list_box_on_adjustment_page_size_changed_g_object_notify, self);
	}
	_tmp6_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_vadjustment);
	self->priv->_vadjustment = _tmp6_;
	_tmp7_ = self->priv->_vadjustment;
	if (_tmp7_ != NULL) {
		GtkAdjustment* _tmp8_;
		GtkAdjustment* _tmp9_;
		_tmp8_ = self->priv->_vadjustment;
		g_signal_connect_object (_tmp8_, "value-changed", (GCallback) _virtualizing_list_box_on_adjustment_value_changed_gtk_adjustment_value_changed, self, 0);
		_tmp9_ = self->priv->_vadjustment;
		g_signal_connect_object ((GObject*) _tmp9_, "notify::page-size", (GCallback) _virtualizing_list_box_on_adjustment_page_size_changed_g_object_notify, self, 0);
		virtualizing_list_box_configure_adjustment (self);
	}
	g_object_notify_by_pspec ((GObject *) self, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_VADJUSTMENT_PROPERTY]);
}

static gint
virtualizing_list_box_get_bin_y (VirtualizingListBox* self)
{
	gint result;
	gint y = 0;
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	y = 0;
	_tmp0_ = virtualizing_list_box_get_vadjustment (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GtkAdjustment* _tmp2_;
		GtkAdjustment* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		_tmp2_ = virtualizing_list_box_get_vadjustment (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = gtk_adjustment_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		y = -((gint) _tmp5_);
	}
	_tmp6_ = self->priv->_bin_y_diff;
	result = y + ((gint) _tmp6_);
	return result;
}

static gboolean
virtualizing_list_box_get_bin_window_full (VirtualizingListBox* self)
{
	gboolean result;
	gint bin_height = 0;
	gint widget_height = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	bin_height = 0;
	if (gtk_widget_get_realized ((GtkWidget*) self)) {
		GdkWindow* _tmp0_;
		_tmp0_ = self->priv->bin_window;
		bin_height = gdk_window_get_height (_tmp0_);
	}
	widget_height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = virtualizing_list_box_get_bin_y (self);
	_tmp3_ = _tmp2_;
	if ((_tmp3_ + bin_height) > widget_height) {
		_tmp1_ = TRUE;
	} else {
		VirtualizingListBoxModel* _tmp4_;
		VirtualizingListBoxModel* _tmp5_;
		_tmp4_ = virtualizing_list_box_get_model (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = (self->priv->shown_to - self->priv->shown_from) == virtualizing_list_box_model_get_n_items (_tmp5_);
	}
	result = _tmp1_;
	return result;
}

VirtualizingListBoxRow*
virtualizing_list_box_get_selected_row_widget (VirtualizingListBox* self)
{
	VirtualizingListBoxRow* result;
	GObject* item = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_row;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	item = _tmp1_;
	{
		GeeArrayList* _child_list = NULL;
		GeeArrayList* _tmp2_;
		gint _child_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _child_index = 0;
		_tmp2_ = self->priv->current_widgets;
		_child_list = _tmp2_;
		_tmp3_ = _child_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_child_size = _tmp5_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			VirtualizingListBoxRow* child = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			VirtualizingListBoxRow* _tmp10_;
			GObject* _tmp11_;
			GObject* _tmp12_;
			GObject* _tmp13_;
			_child_index = _child_index + 1;
			_tmp6_ = _child_index;
			_tmp7_ = _child_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _child_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _child_index);
			child = (VirtualizingListBoxRow*) _tmp9_;
			_tmp10_ = child;
			_tmp11_ = virtualizing_list_box_row_get_model_item (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = item;
			if (_tmp12_ == _tmp13_) {
				VirtualizingListBoxRow* _tmp14_;
				_tmp14_ = child;
				result = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_VIRTUALIZING_LIST_BOX_ROW, VirtualizingListBoxRow);
				_g_object_unref0 (child);
				_g_object_unref0 (item);
				return result;
			}
			_g_object_unref0 (child);
		}
	}
	result = NULL;
	_g_object_unref0 (item);
	return result;
}

GtkAdjustment*
virtualizing_list_box_get_hadjustment (VirtualizingListBox* self)
{
	GtkAdjustment* result;
	GtkAdjustment* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hadjustment;
	result = _tmp0_;
	return result;
}

void
virtualizing_list_box_set_hadjustment (VirtualizingListBox* self,
                                       GtkAdjustment* value)
{
	GtkAdjustment* old_value;
	g_return_if_fail (self != NULL);
	old_value = virtualizing_list_box_get_hadjustment (self);
	if (old_value != value) {
		GtkAdjustment* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_hadjustment);
		self->priv->_hadjustment = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_HADJUSTMENT_PROPERTY]);
	}
}

GtkScrollablePolicy
virtualizing_list_box_get_hscroll_policy (VirtualizingListBox* self)
{
	GtkScrollablePolicy result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_hscroll_policy;
	return result;
}

void
virtualizing_list_box_set_hscroll_policy (VirtualizingListBox* self,
                                          GtkScrollablePolicy value)
{
	GtkScrollablePolicy old_value;
	g_return_if_fail (self != NULL);
	old_value = virtualizing_list_box_get_hscroll_policy (self);
	if (old_value != value) {
		self->priv->_hscroll_policy = value;
		g_object_notify_by_pspec ((GObject *) self, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_HSCROLL_POLICY_PROPERTY]);
	}
}

GtkScrollablePolicy
virtualizing_list_box_get_vscroll_policy (VirtualizingListBox* self)
{
	GtkScrollablePolicy result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_vscroll_policy;
	return result;
}

void
virtualizing_list_box_set_vscroll_policy (VirtualizingListBox* self,
                                          GtkScrollablePolicy value)
{
	GtkScrollablePolicy old_value;
	g_return_if_fail (self != NULL);
	old_value = virtualizing_list_box_get_vscroll_policy (self);
	if (old_value != value) {
		self->priv->_vscroll_policy = value;
		g_object_notify_by_pspec ((GObject *) self, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_VSCROLL_POLICY_PROPERTY]);
	}
}

gboolean
virtualizing_list_box_get_activate_on_single_click (VirtualizingListBox* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_activate_on_single_click;
	return result;
}

void
virtualizing_list_box_set_activate_on_single_click (VirtualizingListBox* self,
                                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = virtualizing_list_box_get_activate_on_single_click (self);
	if (old_value != value) {
		self->priv->_activate_on_single_click = value;
		g_object_notify_by_pspec ((GObject *) self, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_ACTIVATE_ON_SINGLE_CLICK_PROPERTY]);
	}
}

GtkSelectionMode
virtualizing_list_box_get_selection_mode (VirtualizingListBox* self)
{
	GtkSelectionMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_selection_mode;
	return result;
}

void
virtualizing_list_box_set_selection_mode (VirtualizingListBox* self,
                                          GtkSelectionMode value)
{
	GtkSelectionMode old_value;
	g_return_if_fail (self != NULL);
	old_value = virtualizing_list_box_get_selection_mode (self);
	if (old_value != value) {
		self->priv->_selection_mode = value;
		g_object_notify_by_pspec ((GObject *) self, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_SELECTION_MODE_PROPERTY]);
	}
}

static gdouble
virtualizing_list_box_get_bin_y_diff (VirtualizingListBox* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_bin_y_diff;
	return result;
}

static void
virtualizing_list_box_set_bin_y_diff (VirtualizingListBox* self,
                                      gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_bin_y_diff = value;
}

GObject*
virtualizing_list_box_get_selected_row (VirtualizingListBox* self)
{
	GObject* result;
	GObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_row;
	result = _tmp0_;
	return result;
}

static void
virtualizing_list_box_set_selected_row (VirtualizingListBox* self,
                                        GObject* value)
{
	GObject* old_value;
	g_return_if_fail (self != NULL);
	old_value = virtualizing_list_box_get_selected_row (self);
	if (old_value != value) {
		GObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selected_row);
		self->priv->_selected_row = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_SELECTED_ROW_PROPERTY]);
	}
}

static void
_virtualizing_list_box_on_multipress_pressed_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                              gint n_press,
                                                                              gdouble x,
                                                                              gdouble y,
                                                                              gpointer self)
{
	virtualizing_list_box_on_multipress_pressed ((VirtualizingListBox*) self, n_press, x, y);
}

static void
_virtualizing_list_box_on_multipress_released_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                                gint n_press,
                                                                                gdouble x,
                                                                                gdouble y,
                                                                                gpointer self)
{
	virtualizing_list_box_on_multipress_released ((VirtualizingListBox*) self, n_press, x, y);
}

static GObject *
virtualizing_list_box_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	VirtualizingListBox * self;
	GtkGestureMultiPress* _tmp0_;
	GtkGestureMultiPress* _tmp1_;
	GtkGestureMultiPress* _tmp2_;
	GtkGestureMultiPress* _tmp3_;
	GtkGestureMultiPress* _tmp4_;
	GtkGestureMultiPress* _tmp5_;
	parent_class = G_OBJECT_CLASS (virtualizing_list_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIRTUALIZING_LIST_BOX, VirtualizingListBox);
	_tmp0_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->multipress);
	self->priv->multipress = _tmp0_;
	_tmp1_ = self->priv->multipress;
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp1_, GTK_PHASE_BUBBLE);
	_tmp2_ = self->priv->multipress;
	gtk_gesture_single_set_touch_only ((GtkGestureSingle*) _tmp2_, FALSE);
	_tmp3_ = self->priv->multipress;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp3_, (guint) GDK_BUTTON_PRIMARY);
	_tmp4_ = self->priv->multipress;
	g_signal_connect_object (_tmp4_, "pressed", (GCallback) _virtualizing_list_box_on_multipress_pressed_gtk_gesture_multi_press_pressed, self, 0);
	_tmp5_ = self->priv->multipress;
	g_signal_connect_object (_tmp5_, "released", (GCallback) _virtualizing_list_box_on_multipress_released_gtk_gesture_multi_press_released, self, 0);
	return obj;
}

static void
virtualizing_list_box_class_init (VirtualizingListBoxClass * klass,
                                  gpointer klass_data)
{
	virtualizing_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &VirtualizingListBox_private_offset);
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget*)) virtualizing_list_box_real_realize;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) virtualizing_list_box_real_size_allocate;
	((GtkWidgetClass *) klass)->map = (void (*) (GtkWidget*)) virtualizing_list_box_real_map;
	((GtkContainerClass *) klass)->remove = (void (*) (GtkContainer*, GtkWidget*)) virtualizing_list_box_real_remove;
	((GtkContainerClass *) klass)->forall = (void (*) (GtkContainer*, gboolean, GtkCallback, gpointer)) virtualizing_list_box_real_forall_internal;
	((GtkContainerClass *) klass)->child_type = (GType (*) (GtkContainer*)) virtualizing_list_box_real_child_type;
	((GtkWidgetClass *) klass)->focus = (gboolean (*) (GtkWidget*, GtkDirectionType)) virtualizing_list_box_real_focus;
	G_OBJECT_CLASS (klass)->get_property = _vala_virtualizing_list_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_virtualizing_list_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = virtualizing_list_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = virtualizing_list_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VIRTUALIZING_LIST_BOX_MODEL_PROPERTY, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", TYPE_VIRTUALIZING_LIST_BOX_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VIRTUALIZING_LIST_BOX_VADJUSTMENT_PROPERTY, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_VADJUSTMENT_PROPERTY] = g_param_spec_object ("vadjustment", "vadjustment", "vadjustment", gtk_adjustment_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VIRTUALIZING_LIST_BOX_SELECTED_ROW_WIDGET_PROPERTY, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_SELECTED_ROW_WIDGET_PROPERTY] = g_param_spec_object ("selected-row-widget", "selected-row-widget", "selected-row-widget", TYPE_VIRTUALIZING_LIST_BOX_ROW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VIRTUALIZING_LIST_BOX_HADJUSTMENT_PROPERTY, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_HADJUSTMENT_PROPERTY] = g_param_spec_object ("hadjustment", "hadjustment", "hadjustment", gtk_adjustment_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VIRTUALIZING_LIST_BOX_HSCROLL_POLICY_PROPERTY, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_HSCROLL_POLICY_PROPERTY] = g_param_spec_enum ("hscroll-policy", "hscroll-policy", "hscroll-policy", gtk_scrollable_policy_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VIRTUALIZING_LIST_BOX_VSCROLL_POLICY_PROPERTY, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_VSCROLL_POLICY_PROPERTY] = g_param_spec_enum ("vscroll-policy", "vscroll-policy", "vscroll-policy", gtk_scrollable_policy_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VIRTUALIZING_LIST_BOX_ACTIVATE_ON_SINGLE_CLICK_PROPERTY, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_ACTIVATE_ON_SINGLE_CLICK_PROPERTY] = g_param_spec_boolean ("activate-on-single-click", "activate-on-single-click", "activate-on-single-click", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VIRTUALIZING_LIST_BOX_SELECTION_MODE_PROPERTY, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_SELECTION_MODE_PROPERTY] = g_param_spec_enum ("selection-mode", "selection-mode", "selection-mode", gtk_selection_mode_get_type (), GTK_SELECTION_SINGLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VIRTUALIZING_LIST_BOX_SELECTED_ROW_PROPERTY, virtualizing_list_box_properties[VIRTUALIZING_LIST_BOX_SELECTED_ROW_PROPERTY] = g_param_spec_object ("selected-row", "selected-row", "selected-row", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	virtualizing_list_box_signals[VIRTUALIZING_LIST_BOX_ROW_ACTIVATED_SIGNAL] = g_signal_new ("row-activated", TYPE_VIRTUALIZING_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_OBJECT);
	virtualizing_list_box_signals[VIRTUALIZING_LIST_BOX_ROW_SELECTED_SIGNAL] = g_signal_new ("row-selected", TYPE_VIRTUALIZING_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_OBJECT);
	virtualizing_list_box_signals[VIRTUALIZING_LIST_BOX_SELECTED_ROWS_CHANGED_SIGNAL] = g_signal_new ("selected-rows-changed", TYPE_VIRTUALIZING_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "list");
}

static void
virtualizing_list_box_gtk_scrollable_interface_init (GtkScrollableInterface * iface,
                                                     gpointer iface_data)
{
	virtualizing_list_box_gtk_scrollable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_border = (gboolean (*) (GtkScrollable*, GtkBorder*)) virtualizing_list_box_real_get_border;
}

static void
virtualizing_list_box_instance_init (VirtualizingListBox * self,
                                     gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = virtualizing_list_box_get_instance_private (self);
	self->priv->_selection_mode = GTK_SELECTION_SINGLE;
	_tmp0_ = gee_array_list_new (TYPE_VIRTUALIZING_LIST_BOX_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->current_widgets = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_VIRTUALIZING_LIST_BOX_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->recycled_widgets = _tmp1_;
	self->priv->last_valid_widget_height = 1;
}

static void
virtualizing_list_box_finalize (GObject * obj)
{
	VirtualizingListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIRTUALIZING_LIST_BOX, VirtualizingListBox);
	(self->factory_func_target_destroy_notify == NULL) ? NULL : (self->factory_func_target_destroy_notify (self->factory_func_target), NULL);
	self->factory_func = NULL;
	self->factory_func_target = NULL;
	self->factory_func_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_vadjustment);
	_g_object_unref0 (self->priv->_hadjustment);
	_g_object_unref0 (self->priv->_selected_row);
	_g_object_unref0 (self->priv->current_widgets);
	_g_object_unref0 (self->priv->recycled_widgets);
	_g_object_unref0 (self->priv->bin_window);
	_g_object_unref0 (self->priv->active_row);
	_g_object_unref0 (self->priv->multipress);
	G_OBJECT_CLASS (virtualizing_list_box_parent_class)->finalize (obj);
}

static GType
virtualizing_list_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VirtualizingListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) virtualizing_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VirtualizingListBox), 0, (GInstanceInitFunc) virtualizing_list_box_instance_init, NULL };
	static const GInterfaceInfo gtk_scrollable_info = { (GInterfaceInitFunc) virtualizing_list_box_gtk_scrollable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType virtualizing_list_box_type_id;
	virtualizing_list_box_type_id = g_type_register_static (gtk_container_get_type (), "VirtualizingListBox", &g_define_type_info, 0);
	g_type_add_interface_static (virtualizing_list_box_type_id, gtk_scrollable_get_type (), &gtk_scrollable_info);
	VirtualizingListBox_private_offset = g_type_add_instance_private (virtualizing_list_box_type_id, sizeof (VirtualizingListBoxPrivate));
	return virtualizing_list_box_type_id;
}

GType
virtualizing_list_box_get_type (void)
{
	static volatile gsize virtualizing_list_box_type_id__once = 0;
	if (g_once_init_enter (&virtualizing_list_box_type_id__once)) {
		GType virtualizing_list_box_type_id;
		virtualizing_list_box_type_id = virtualizing_list_box_get_type_once ();
		g_once_init_leave (&virtualizing_list_box_type_id__once, virtualizing_list_box_type_id);
	}
	return virtualizing_list_box_type_id__once;
}

static void
_vala_virtualizing_list_box_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	VirtualizingListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_VIRTUALIZING_LIST_BOX, VirtualizingListBox);
	switch (property_id) {
		case VIRTUALIZING_LIST_BOX_MODEL_PROPERTY:
		g_value_set_object (value, virtualizing_list_box_get_model (self));
		break;
		case VIRTUALIZING_LIST_BOX_VADJUSTMENT_PROPERTY:
		g_value_set_object (value, virtualizing_list_box_get_vadjustment (self));
		break;
		case VIRTUALIZING_LIST_BOX_SELECTED_ROW_WIDGET_PROPERTY:
		g_value_set_object (value, virtualizing_list_box_get_selected_row_widget (self));
		break;
		case VIRTUALIZING_LIST_BOX_HADJUSTMENT_PROPERTY:
		g_value_set_object (value, virtualizing_list_box_get_hadjustment (self));
		break;
		case VIRTUALIZING_LIST_BOX_HSCROLL_POLICY_PROPERTY:
		g_value_set_enum (value, virtualizing_list_box_get_hscroll_policy (self));
		break;
		case VIRTUALIZING_LIST_BOX_VSCROLL_POLICY_PROPERTY:
		g_value_set_enum (value, virtualizing_list_box_get_vscroll_policy (self));
		break;
		case VIRTUALIZING_LIST_BOX_ACTIVATE_ON_SINGLE_CLICK_PROPERTY:
		g_value_set_boolean (value, virtualizing_list_box_get_activate_on_single_click (self));
		break;
		case VIRTUALIZING_LIST_BOX_SELECTION_MODE_PROPERTY:
		g_value_set_enum (value, virtualizing_list_box_get_selection_mode (self));
		break;
		case VIRTUALIZING_LIST_BOX_SELECTED_ROW_PROPERTY:
		g_value_set_object (value, virtualizing_list_box_get_selected_row (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_virtualizing_list_box_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	VirtualizingListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_VIRTUALIZING_LIST_BOX, VirtualizingListBox);
	switch (property_id) {
		case VIRTUALIZING_LIST_BOX_MODEL_PROPERTY:
		virtualizing_list_box_set_model (self, g_value_get_object (value));
		break;
		case VIRTUALIZING_LIST_BOX_VADJUSTMENT_PROPERTY:
		virtualizing_list_box_set_vadjustment (self, g_value_get_object (value));
		break;
		case VIRTUALIZING_LIST_BOX_HADJUSTMENT_PROPERTY:
		virtualizing_list_box_set_hadjustment (self, g_value_get_object (value));
		break;
		case VIRTUALIZING_LIST_BOX_HSCROLL_POLICY_PROPERTY:
		virtualizing_list_box_set_hscroll_policy (self, g_value_get_enum (value));
		break;
		case VIRTUALIZING_LIST_BOX_VSCROLL_POLICY_PROPERTY:
		virtualizing_list_box_set_vscroll_policy (self, g_value_get_enum (value));
		break;
		case VIRTUALIZING_LIST_BOX_ACTIVATE_ON_SINGLE_CLICK_PROPERTY:
		virtualizing_list_box_set_activate_on_single_click (self, g_value_get_boolean (value));
		break;
		case VIRTUALIZING_LIST_BOX_SELECTION_MODE_PROPERTY:
		virtualizing_list_box_set_selection_mode (self, g_value_get_enum (value));
		break;
		case VIRTUALIZING_LIST_BOX_SELECTED_ROW_PROPERTY:
		virtualizing_list_box_set_selected_row (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

