// python wrapper for vtkSMMaterialLibraryProxy
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkPVSession.h"
#include "vtkSMMaterialLibraryProxy.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMMaterialLibraryProxy(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMMaterialLibraryProxy_ClassNew(); }


static PyObject *
PyvtkSMMaterialLibraryProxy_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMMaterialLibraryProxy::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMMaterialLibraryProxy_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMMaterialLibraryProxy *op = static_cast<vtkSMMaterialLibraryProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMMaterialLibraryProxy::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMMaterialLibraryProxy_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMMaterialLibraryProxy *tempr = vtkSMMaterialLibraryProxy::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMMaterialLibraryProxy_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMMaterialLibraryProxy *op = static_cast<vtkSMMaterialLibraryProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMMaterialLibraryProxy *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMMaterialLibraryProxy::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMMaterialLibraryProxy_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMMaterialLibraryProxy::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMMaterialLibraryProxy_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMMaterialLibraryProxy *op = static_cast<vtkSMMaterialLibraryProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMMaterialLibraryProxy::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMMaterialLibraryProxy_Synchronize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Synchronize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMMaterialLibraryProxy *op = static_cast<vtkSMMaterialLibraryProxy *>(vp);

  vtkPVSession::ServerFlags temp0 = vtkPVSession::RENDER_SERVER_ROOT;
  vtkPVSession::ServerFlags temp1 = vtkPVSession::CLIENT;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 2) &&
      (ap.NoArgsLeft() || ap.GetEnumValue(temp0, "vtkPVSession.ServerFlags")) &&
      (ap.NoArgsLeft() || ap.GetEnumValue(temp1, "vtkPVSession.ServerFlags")))
  {
    if (ap.IsBound())
    {
      op->Synchronize(temp0, temp1);
    }
    else
    {
      op->vtkSMMaterialLibraryProxy::Synchronize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMMaterialLibraryProxy_LoadDefaultMaterials(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadDefaultMaterials");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMMaterialLibraryProxy *op = static_cast<vtkSMMaterialLibraryProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LoadDefaultMaterials();
    }
    else
    {
      op->vtkSMMaterialLibraryProxy::LoadDefaultMaterials();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMMaterialLibraryProxy_LoadMaterials(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadMaterials");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMMaterialLibraryProxy *op = static_cast<vtkSMMaterialLibraryProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->LoadMaterials(temp0);
    }
    else
    {
      op->vtkSMMaterialLibraryProxy::LoadMaterials(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMMaterialLibraryProxy_UpdateVTKObjects(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateVTKObjects");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMMaterialLibraryProxy *op = static_cast<vtkSMMaterialLibraryProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UpdateVTKObjects();
    }
    else
    {
      op->vtkSMMaterialLibraryProxy::UpdateVTKObjects();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMMaterialLibraryProxy_Methods[] = {
  {"IsTypeOf", PyvtkSMMaterialLibraryProxy_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMMaterialLibraryProxy_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMMaterialLibraryProxy_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMMaterialLibraryProxy\nC++: static vtkSMMaterialLibraryProxy *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMMaterialLibraryProxy_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMMaterialLibraryProxy\nC++: vtkSMMaterialLibraryProxy *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMMaterialLibraryProxy_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMMaterialLibraryProxy_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Synchronize", PyvtkSMMaterialLibraryProxy_Synchronize, METH_VARARGS,
   "Synchronize(self, from_:vtkPVSession.ServerFlags=...,\n    to:vtkPVSession.ServerFlags=...) -> None\nC++: void Synchronize(\n    vtkPVSession::ServerFlags from=vtkPVSession::RENDER_SERVER_ROOT,\n     vtkPVSession::ServerFlags to=vtkPVSession::CLIENT)\n\nCopies the Material library on the root node of server to the\nclient by default. You can also specify the start and end\nlocation with from and to arguments.\n"},
  {"LoadDefaultMaterials", PyvtkSMMaterialLibraryProxy_LoadDefaultMaterials, METH_VARARGS,
   "LoadDefaultMaterials(self) -> None\nC++: void LoadDefaultMaterials()\n\nReads default materials on the process.\n"},
  {"LoadMaterials", PyvtkSMMaterialLibraryProxy_LoadMaterials, METH_VARARGS,
   "LoadMaterials(self, __a:str) -> None\nC++: void LoadMaterials(const char *)\n\nReads and specified materials.\n"},
  {"UpdateVTKObjects", PyvtkSMMaterialLibraryProxy_UpdateVTKObjects, METH_VARARGS,
   "UpdateVTKObjects(self) -> None\nC++: void UpdateVTKObjects() override;\n\nOverridden to control load from server file system.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMMaterialLibraryProxy_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMMaterialLibraryProxy_Doc =
  "vtkSMMaterialLibraryProxy - proxy for a camera.\n\n"
  "Superclass: vtkSMProxy\n\n"
  "This a proxy for controlling vtkOSPRayMaterialLibraries on various\n"
  "nodes. In particular we use it to ensure that all rendering processes\n"
  "have a consistent set of materials.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMMaterialLibraryProxy_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMMaterialLibraryProxy", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMMaterialLibraryProxy_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMMaterialLibraryProxy_StaticNew()
{
  return vtkSMMaterialLibraryProxy::New();
}

PyObject *PyvtkSMMaterialLibraryProxy_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMMaterialLibraryProxy_Type, PyvtkSMMaterialLibraryProxy_Methods,
    "vtkSMMaterialLibraryProxy",
 &PyvtkSMMaterialLibraryProxy_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSMProxy");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMMaterialLibraryProxy_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMMaterialLibraryProxy(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMMaterialLibraryProxy_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMMaterialLibraryProxy", o) != 0)
  {
    Py_DECREF(o);
  }

}

