// content/browser/process_internals/process_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_H_
#define CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/browser/process_internals/process_internals.mojom-shared.h"
#include "content/browser/process_internals/process_internals.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace mojom {

class ProcessInternalsHandlerProxy;

template <typename ImplRefTraits>
class ProcessInternalsHandlerStub;

class ProcessInternalsHandlerRequestValidator;
class ProcessInternalsHandlerResponseValidator;


class  ProcessInternalsHandler
    : public ProcessInternalsHandlerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ProcessInternalsHandlerInterfaceBase;
  using Proxy_ = ProcessInternalsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProcessInternalsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = ProcessInternalsHandlerRequestValidator;
  using ResponseValidator_ = ProcessInternalsHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetIsolationModeMinVersion = 0,
    kGetUserTriggeredIsolatedOriginsMinVersion = 0,
    kGetGloballyIsolatedOriginsMinVersion = 0,
    kGetAllWebContentsInfoMinVersion = 0,
  };
  virtual ~ProcessInternalsHandler() {}


  using GetIsolationModeCallback = base::OnceCallback<void(const std::string&)>;
  
  virtual void GetIsolationMode(GetIsolationModeCallback callback) = 0;


  using GetUserTriggeredIsolatedOriginsCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  
  virtual void GetUserTriggeredIsolatedOrigins(GetUserTriggeredIsolatedOriginsCallback callback) = 0;


  using GetGloballyIsolatedOriginsCallback = base::OnceCallback<void(std::vector<IsolatedOriginInfoPtr>)>;
  
  virtual void GetGloballyIsolatedOrigins(GetGloballyIsolatedOriginsCallback callback) = 0;


  using GetAllWebContentsInfoCallback = base::OnceCallback<void(std::vector<WebContentsInfoPtr>)>;
  
  virtual void GetAllWebContentsInfo(GetAllWebContentsInfoCallback callback) = 0;
};



class  ProcessInternalsHandlerProxy
    : public ProcessInternalsHandler {
 public:
  using InterfaceType = ProcessInternalsHandler;

  explicit ProcessInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetIsolationMode(GetIsolationModeCallback callback) final;
  
  void GetUserTriggeredIsolatedOrigins(GetUserTriggeredIsolatedOriginsCallback callback) final;
  
  void GetGloballyIsolatedOrigins(GetGloballyIsolatedOriginsCallback callback) final;
  
  void GetAllWebContentsInfo(GetAllWebContentsInfoCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ProcessInternalsHandlerStubDispatch {
 public:
  static bool Accept(ProcessInternalsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProcessInternalsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProcessInternalsHandler>>
class ProcessInternalsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProcessInternalsHandlerStub() {}
  ~ProcessInternalsHandlerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProcessInternalsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProcessInternalsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProcessInternalsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProcessInternalsHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  IsolatedOriginInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IsolatedOriginInfo, T>::value>;
  using DataView = IsolatedOriginInfoDataView;
  using Data_ = internal::IsolatedOriginInfo_Data;

  template <typename... Args>
  static IsolatedOriginInfoPtr New(Args&&... args) {
    return IsolatedOriginInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IsolatedOriginInfoPtr From(const U& u) {
    return mojo::TypeConverter<IsolatedOriginInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IsolatedOriginInfo>::Convert(*this);
  }


  IsolatedOriginInfo();

  IsolatedOriginInfo(
      const std::string& origin,
      const std::string& source);

  ~IsolatedOriginInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IsolatedOriginInfoPtr>
  IsolatedOriginInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IsolatedOriginInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IsolatedOriginInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IsolatedOriginInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IsolatedOriginInfo_UnserializedMessageContext<
            UserType, IsolatedOriginInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<IsolatedOriginInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return IsolatedOriginInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IsolatedOriginInfo_UnserializedMessageContext<
            UserType, IsolatedOriginInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IsolatedOriginInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string origin;
  
  std::string source;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IsolatedOriginInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IsolatedOriginInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IsolatedOriginInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IsolatedOriginInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  SiteInstanceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SiteInstanceInfo, T>::value>;
  using DataView = SiteInstanceInfoDataView;
  using Data_ = internal::SiteInstanceInfo_Data;

  template <typename... Args>
  static SiteInstanceInfoPtr New(Args&&... args) {
    return SiteInstanceInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SiteInstanceInfoPtr From(const U& u) {
    return mojo::TypeConverter<SiteInstanceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SiteInstanceInfo>::Convert(*this);
  }


  SiteInstanceInfo();

  SiteInstanceInfo(
      int32_t id,
      bool locked,
      const base::Optional<::GURL>& site_url,
      const base::Optional<::GURL>& process_lock_url,
      bool is_origin_keyed);

  ~SiteInstanceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SiteInstanceInfoPtr>
  SiteInstanceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SiteInstanceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteInstanceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SiteInstanceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SiteInstanceInfo_UnserializedMessageContext<
            UserType, SiteInstanceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SiteInstanceInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SiteInstanceInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SiteInstanceInfo_UnserializedMessageContext<
            UserType, SiteInstanceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SiteInstanceInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t id;
  
  bool locked;
  
  base::Optional<::GURL> site_url;
  
  base::Optional<::GURL> process_lock_url;
  
  bool is_origin_keyed;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SiteInstanceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SiteInstanceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SiteInstanceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SiteInstanceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FrameInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameInfo, T>::value>;
  using DataView = FrameInfoDataView;
  using Data_ = internal::FrameInfo_Data;

  template <typename... Args>
  static FrameInfoPtr New(Args&&... args) {
    return FrameInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameInfoPtr From(const U& u) {
    return mojo::TypeConverter<FrameInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameInfo>::Convert(*this);
  }


  FrameInfo();

  FrameInfo(
      int32_t routing_id,
      int32_t process_id,
      SiteInstanceInfoPtr site_instance,
      const base::Optional<::GURL>& last_committed_url,
      std::vector<FrameInfoPtr> subframes,
      bool is_bfcached);

  ~FrameInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameInfoPtr>
  FrameInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameInfo_UnserializedMessageContext<
            UserType, FrameInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FrameInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return FrameInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameInfo_UnserializedMessageContext<
            UserType, FrameInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t routing_id;
  
  int32_t process_id;
  
  SiteInstanceInfoPtr site_instance;
  
  base::Optional<::GURL> last_committed_url;
  
  std::vector<FrameInfoPtr> subframes;
  
  bool is_bfcached;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(FrameInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebContentsInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebContentsInfo, T>::value>;
  using DataView = WebContentsInfoDataView;
  using Data_ = internal::WebContentsInfo_Data;

  template <typename... Args>
  static WebContentsInfoPtr New(Args&&... args) {
    return WebContentsInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebContentsInfoPtr From(const U& u) {
    return mojo::TypeConverter<WebContentsInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebContentsInfo>::Convert(*this);
  }


  WebContentsInfo();

  WebContentsInfo(
      const std::string& title,
      FrameInfoPtr root_frame,
      std::vector<FrameInfoPtr> bfcached_root_frames);

  ~WebContentsInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebContentsInfoPtr>
  WebContentsInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebContentsInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebContentsInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebContentsInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebContentsInfo_UnserializedMessageContext<
            UserType, WebContentsInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WebContentsInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return WebContentsInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebContentsInfo_UnserializedMessageContext<
            UserType, WebContentsInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebContentsInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string title;
  
  FrameInfoPtr root_frame;
  
  std::vector<FrameInfoPtr> bfcached_root_frames;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(WebContentsInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebContentsInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebContentsInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebContentsInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebContentsInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
SiteInstanceInfoPtr SiteInstanceInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(locked),
      mojo::Clone(site_url),
      mojo::Clone(process_lock_url),
      mojo::Clone(is_origin_keyed)
  );
}

template <typename T, SiteInstanceInfo::EnableIfSame<T>*>
bool SiteInstanceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->locked, other_struct.locked))
    return false;
  if (!mojo::Equals(this->site_url, other_struct.site_url))
    return false;
  if (!mojo::Equals(this->process_lock_url, other_struct.process_lock_url))
    return false;
  if (!mojo::Equals(this->is_origin_keyed, other_struct.is_origin_keyed))
    return false;
  return true;
}

template <typename T, SiteInstanceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.id, rhs.id))
    return true;
  if (std::less<>{}(rhs.id, lhs.id))
    return false;
  if (std::less<>{}(lhs.locked, rhs.locked))
    return true;
  if (std::less<>{}(rhs.locked, lhs.locked))
    return false;
  if (std::less<>{}(lhs.site_url, rhs.site_url))
    return true;
  if (std::less<>{}(rhs.site_url, lhs.site_url))
    return false;
  if (std::less<>{}(lhs.process_lock_url, rhs.process_lock_url))
    return true;
  if (std::less<>{}(rhs.process_lock_url, lhs.process_lock_url))
    return false;
  if (std::less<>{}(lhs.is_origin_keyed, rhs.is_origin_keyed))
    return true;
  if (std::less<>{}(rhs.is_origin_keyed, lhs.is_origin_keyed))
    return false;
  return false;
}
template <typename StructPtrType>
FrameInfoPtr FrameInfo::Clone() const {
  return New(
      mojo::Clone(routing_id),
      mojo::Clone(process_id),
      mojo::Clone(site_instance),
      mojo::Clone(last_committed_url),
      mojo::Clone(subframes),
      mojo::Clone(is_bfcached)
  );
}

template <typename T, FrameInfo::EnableIfSame<T>*>
bool FrameInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->routing_id, other_struct.routing_id))
    return false;
  if (!mojo::Equals(this->process_id, other_struct.process_id))
    return false;
  if (!mojo::Equals(this->site_instance, other_struct.site_instance))
    return false;
  if (!mojo::Equals(this->last_committed_url, other_struct.last_committed_url))
    return false;
  if (!mojo::Equals(this->subframes, other_struct.subframes))
    return false;
  if (!mojo::Equals(this->is_bfcached, other_struct.is_bfcached))
    return false;
  return true;
}

template <typename T, FrameInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.routing_id, rhs.routing_id))
    return true;
  if (std::less<>{}(rhs.routing_id, lhs.routing_id))
    return false;
  if (std::less<>{}(lhs.process_id, rhs.process_id))
    return true;
  if (std::less<>{}(rhs.process_id, lhs.process_id))
    return false;
  if (std::less<>{}(lhs.site_instance, rhs.site_instance))
    return true;
  if (std::less<>{}(rhs.site_instance, lhs.site_instance))
    return false;
  if (std::less<>{}(lhs.last_committed_url, rhs.last_committed_url))
    return true;
  if (std::less<>{}(rhs.last_committed_url, lhs.last_committed_url))
    return false;
  if (std::less<>{}(lhs.subframes, rhs.subframes))
    return true;
  if (std::less<>{}(rhs.subframes, lhs.subframes))
    return false;
  if (std::less<>{}(lhs.is_bfcached, rhs.is_bfcached))
    return true;
  if (std::less<>{}(rhs.is_bfcached, lhs.is_bfcached))
    return false;
  return false;
}
template <typename StructPtrType>
WebContentsInfoPtr WebContentsInfo::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(root_frame),
      mojo::Clone(bfcached_root_frames)
  );
}

template <typename T, WebContentsInfo::EnableIfSame<T>*>
bool WebContentsInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->root_frame, other_struct.root_frame))
    return false;
  if (!mojo::Equals(this->bfcached_root_frames, other_struct.bfcached_root_frames))
    return false;
  return true;
}

template <typename T, WebContentsInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.title, rhs.title))
    return true;
  if (std::less<>{}(rhs.title, lhs.title))
    return false;
  if (std::less<>{}(lhs.root_frame, rhs.root_frame))
    return true;
  if (std::less<>{}(rhs.root_frame, lhs.root_frame))
    return false;
  if (std::less<>{}(lhs.bfcached_root_frames, rhs.bfcached_root_frames))
    return true;
  if (std::less<>{}(rhs.bfcached_root_frames, lhs.bfcached_root_frames))
    return false;
  return false;
}
template <typename StructPtrType>
IsolatedOriginInfoPtr IsolatedOriginInfo::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(source)
  );
}

template <typename T, IsolatedOriginInfo::EnableIfSame<T>*>
bool IsolatedOriginInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  return true;
}

template <typename T, IsolatedOriginInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.origin, rhs.origin))
    return true;
  if (std::less<>{}(rhs.origin, lhs.origin))
    return false;
  if (std::less<>{}(lhs.source, rhs.source))
    return true;
  if (std::less<>{}(rhs.source, lhs.source))
    return false;
  return false;
}


}  // namespace mojom

namespace mojo {


template <>
struct  StructTraits<::mojom::SiteInstanceInfo::DataView,
                                         ::mojom::SiteInstanceInfoPtr> {
  static bool IsNull(const ::mojom::SiteInstanceInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::SiteInstanceInfoPtr* output) { output->reset(); }

  static decltype(::mojom::SiteInstanceInfo::id) id(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->id;
  }

  static decltype(::mojom::SiteInstanceInfo::locked) locked(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->locked;
  }

  static const decltype(::mojom::SiteInstanceInfo::site_url)& site_url(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->site_url;
  }

  static const decltype(::mojom::SiteInstanceInfo::process_lock_url)& process_lock_url(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->process_lock_url;
  }

  static decltype(::mojom::SiteInstanceInfo::is_origin_keyed) is_origin_keyed(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->is_origin_keyed;
  }

  static bool Read(::mojom::SiteInstanceInfo::DataView input, ::mojom::SiteInstanceInfoPtr* output);
};


template <>
struct  StructTraits<::mojom::FrameInfo::DataView,
                                         ::mojom::FrameInfoPtr> {
  static bool IsNull(const ::mojom::FrameInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::FrameInfoPtr* output) { output->reset(); }

  static decltype(::mojom::FrameInfo::routing_id) routing_id(
      const ::mojom::FrameInfoPtr& input) {
    return input->routing_id;
  }

  static decltype(::mojom::FrameInfo::process_id) process_id(
      const ::mojom::FrameInfoPtr& input) {
    return input->process_id;
  }

  static const decltype(::mojom::FrameInfo::site_instance)& site_instance(
      const ::mojom::FrameInfoPtr& input) {
    return input->site_instance;
  }

  static const decltype(::mojom::FrameInfo::last_committed_url)& last_committed_url(
      const ::mojom::FrameInfoPtr& input) {
    return input->last_committed_url;
  }

  static const decltype(::mojom::FrameInfo::subframes)& subframes(
      const ::mojom::FrameInfoPtr& input) {
    return input->subframes;
  }

  static decltype(::mojom::FrameInfo::is_bfcached) is_bfcached(
      const ::mojom::FrameInfoPtr& input) {
    return input->is_bfcached;
  }

  static bool Read(::mojom::FrameInfo::DataView input, ::mojom::FrameInfoPtr* output);
};


template <>
struct  StructTraits<::mojom::WebContentsInfo::DataView,
                                         ::mojom::WebContentsInfoPtr> {
  static bool IsNull(const ::mojom::WebContentsInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::WebContentsInfoPtr* output) { output->reset(); }

  static const decltype(::mojom::WebContentsInfo::title)& title(
      const ::mojom::WebContentsInfoPtr& input) {
    return input->title;
  }

  static const decltype(::mojom::WebContentsInfo::root_frame)& root_frame(
      const ::mojom::WebContentsInfoPtr& input) {
    return input->root_frame;
  }

  static const decltype(::mojom::WebContentsInfo::bfcached_root_frames)& bfcached_root_frames(
      const ::mojom::WebContentsInfoPtr& input) {
    return input->bfcached_root_frames;
  }

  static bool Read(::mojom::WebContentsInfo::DataView input, ::mojom::WebContentsInfoPtr* output);
};


template <>
struct  StructTraits<::mojom::IsolatedOriginInfo::DataView,
                                         ::mojom::IsolatedOriginInfoPtr> {
  static bool IsNull(const ::mojom::IsolatedOriginInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::IsolatedOriginInfoPtr* output) { output->reset(); }

  static const decltype(::mojom::IsolatedOriginInfo::origin)& origin(
      const ::mojom::IsolatedOriginInfoPtr& input) {
    return input->origin;
  }

  static const decltype(::mojom::IsolatedOriginInfo::source)& source(
      const ::mojom::IsolatedOriginInfoPtr& input) {
    return input->source;
  }

  static bool Read(::mojom::IsolatedOriginInfo::DataView input, ::mojom::IsolatedOriginInfoPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_H_