// third_party/blink/public/mojom/websockets/websocket_connector.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/websockets/websocket_connector.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/websockets/websocket_connector.mojom-params-data.h"
#include "third_party/blink/public/mojom/websockets/websocket_connector.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/websockets/websocket_connector.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBSOCKETS_WEBSOCKET_CONNECTOR_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBSOCKETS_WEBSOCKET_CONNECTOR_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char WebSocketConnector::Name_[] = "blink.mojom.WebSocketConnector";

WebSocketConnectorProxy::WebSocketConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketConnectorProxy::Connect(
    const ::GURL& in_url, const std::vector<std::string>& in_requested_protocols, const ::net::SiteForCookies& in_site_for_cookies, const base::Optional<std::string>& in_user_agent, ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> in_handshake_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebSocketConnector::Connect", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->BeginArray("requested_protocols");
      for (const auto& item0 : in_requested_protocols) {
        raw_value->AppendString(item0);
      }
      raw_value->EndArray();
      raw_value->SetString("site_for_cookies", base::trace_event::ValueToString(in_site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
      if (in_user_agent.has_value()) {
        raw_value->SetString("user_agent", in_user_agent.value());
      } else {
        raw_value->SetString("user_agent", "base::nullopt");
      }
      raw_value->SetBoolean("handshake_client", in_handshake_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebSocketConnector_Connect_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::WebSocketConnector_Connect_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in WebSocketConnector.Connect request");
  typename decltype(params->requested_protocols)::BaseType::BufferWriter
      requested_protocols_writer;
  const mojo::internal::ContainerValidateParams requested_protocols_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_requested_protocols, buffer, &requested_protocols_writer, &requested_protocols_validate_params,
      &serialization_context);
  params->requested_protocols.Set(
      requested_protocols_writer.is_null() ? nullptr : requested_protocols_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->requested_protocols.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requested_protocols in WebSocketConnector.Connect request");
  typename decltype(params->site_for_cookies)::BaseType::BufferWriter
      site_for_cookies_writer;
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies, buffer, &site_for_cookies_writer, &serialization_context);
  params->site_for_cookies.Set(
      site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in WebSocketConnector.Connect request");
  typename decltype(params->user_agent)::BaseType::BufferWriter
      user_agent_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_user_agent, buffer, &user_agent_writer, &serialization_context);
  params->user_agent.Set(
      user_agent_writer.is_null() ? nullptr : user_agent_writer.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebSocketHandshakeClientInterfaceBase>>(
      in_handshake_client, &params->handshake_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->handshake_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid handshake_client in WebSocketConnector.Connect request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketConnector::Name_);
  message.set_method_name("Connect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebSocketConnectorStubDispatch::Accept(
    WebSocketConnector* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWebSocketConnector_Connect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebSocketConnector::Connect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebSocketConnector::Connect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebSocketConnector_Connect_Params_Data* params =
          reinterpret_cast<internal::WebSocketConnector_Connect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      std::vector<std::string> p_requested_protocols{};
      ::net::SiteForCookies p_site_for_cookies{};
      base::Optional<std::string> p_user_agent{};
      ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> p_handshake_client{};
      WebSocketConnector_Connect_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadRequestedProtocols(&p_requested_protocols))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadUserAgent(&p_user_agent))
        success = false;
      if (success) {
        p_handshake_client =
            input_data_view.TakeHandshakeClient<decltype(p_handshake_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketConnector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(
std::move(p_url), 
std::move(p_requested_protocols), 
std::move(p_site_for_cookies), 
std::move(p_user_agent), 
std::move(p_handshake_client));
      return true;
    }
  }
  return false;
}

// static
bool WebSocketConnectorStubDispatch::AcceptWithResponder(
    WebSocketConnector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebSocketConnector_Connect_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kWebSocketConnectorValidationInfo[] = {
    {&internal::WebSocketConnector_Connect_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebSocketConnectorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WebSocketConnector::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kWebSocketConnectorValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif