/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, channels, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_channels_fading_model = R"doc(fading simulator

This block implements a basic fading model simulator that can be used to help evaluate, design, and test various signals, waveforms, and algorithms.

Constructor Specific Documentation:

Build the channel simulator.

Args:
    N : the number of sinusoids to use in simulating the channel; 8 is a good value
    fDTs : normalized maximum Doppler frequency, fD * Ts
    LOS : include Line-of-Site path? selects between Rayleigh (NLOS) and Rician (LOS) models
    K : Rician factor (ratio of the specular power to the scattered power)
    seed : a random number to seed the noise generators)doc";


static const char* __doc_gr_channels_fading_model_fading_model_0 = R"doc()doc";


static const char* __doc_gr_channels_fading_model_fading_model_1 = R"doc()doc";


static const char* __doc_gr_channels_fading_model_make = R"doc(fading simulator

This block implements a basic fading model simulator that can be used to help evaluate, design, and test various signals, waveforms, and algorithms.

Constructor Specific Documentation:

Build the channel simulator.

Args:
    N : the number of sinusoids to use in simulating the channel; 8 is a good value
    fDTs : normalized maximum Doppler frequency, fD * Ts
    LOS : include Line-of-Site path? selects between Rayleigh (NLOS) and Rician (LOS) models
    K : Rician factor (ratio of the specular power to the scattered power)
    seed : a random number to seed the noise generators)doc";


static const char* __doc_gr_channels_fading_model_fDTs = R"doc()doc";


static const char* __doc_gr_channels_fading_model_K = R"doc()doc";


static const char* __doc_gr_channels_fading_model_step = R"doc()doc";


static const char* __doc_gr_channels_fading_model_set_fDTs = R"doc()doc";


static const char* __doc_gr_channels_fading_model_set_K = R"doc()doc";


static const char* __doc_gr_channels_fading_model_set_step = R"doc()doc";
