/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#pragma once

#include <rtl/string.hxx>
#include <svx/svxdlg.hxx>
#include <vcl/weld.hxx>

class SvxInsRowColDlg : public weld::GenericDialogController
{
private:
    std::unique_ptr<weld::SpinButton> m_xCountEdit;
    std::unique_ptr<weld::RadioButton> m_xBeforeBtn;
    std::unique_ptr<weld::RadioButton> m_xAfterBtn;

public:
    SvxInsRowColDlg(weld::Window* pParent, bool bCol, const OUString& rHelpId);

    bool isInsertBefore() const;
    sal_uInt16 getInsertCount() const;
};

class SvxAbstractInsRowColDlg_Impl final : public SvxAbstractInsRowColDlg
{
    std::shared_ptr<SvxInsRowColDlg> m_xDlg;

public:
    explicit SvxAbstractInsRowColDlg_Impl(std::shared_ptr<SvxInsRowColDlg> p)
        : m_xDlg(std::move(p))
    {
    }
    virtual short Execute() override;
    virtual bool StartExecuteAsync(AsyncContext& rCtx) override;
    virtual bool isInsertBefore() const override;
    virtual sal_uInt16 getInsertCount() const override;
};

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
