// python wrapper for vtkUnstructuredGridVolumeRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkUnstructuredGridVolumeRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkUnstructuredGridVolumeRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkUnstructuredGridVolumeRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkVolumeRepresentation_ClassNew
extern "C" { PyObject *PyvtkVolumeRepresentation_ClassNew(); }
#define DECLARED_PyvtkVolumeRepresentation_ClassNew
#endif

static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkUnstructuredGridVolumeRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkUnstructuredGridVolumeRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkUnstructuredGridVolumeRepresentation *tempr = vtkUnstructuredGridVolumeRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkUnstructuredGridVolumeRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkUnstructuredGridVolumeRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkUnstructuredGridVolumeRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkUnstructuredGridVolumeRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_AddVolumeMapper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddVolumeMapper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  const char *temp0 = nullptr;
  vtkAbstractVolumeMapper *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAbstractVolumeMapper"))
  {
    if (ap.IsBound())
    {
      op->AddVolumeMapper(temp0, temp1);
    }
    else
    {
      op->vtkUnstructuredGridVolumeRepresentation::AddVolumeMapper(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_SetActiveVolumeMapper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActiveVolumeMapper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActiveVolumeMapper(temp0);
    }
    else
    {
      op->vtkUnstructuredGridVolumeRepresentation::SetActiveVolumeMapper(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_GetActiveVolumeMapper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveVolumeMapper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAbstractVolumeMapper *tempr = (ap.IsBound() ?
      op->GetActiveVolumeMapper() :
      op->vtkUnstructuredGridVolumeRepresentation::GetActiveVolumeMapper());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_ProcessViewRequest(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessViewRequest");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  vtkInformationRequestKey *temp0 = nullptr;
  vtkInformation *temp1 = nullptr;
  vtkInformation *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformationRequestKey") &&
      ap.GetVTKObject(temp1, "vtkInformation") &&
      ap.GetVTKObject(temp2, "vtkInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->ProcessViewRequest(temp0, temp1, temp2) :
      op->vtkUnstructuredGridVolumeRepresentation::ProcessViewRequest(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_SetActiveAssembly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActiveAssembly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActiveAssembly(temp0);
    }
    else
    {
      op->vtkUnstructuredGridVolumeRepresentation::SetActiveAssembly(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_AddBlockSelector(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddBlockSelector");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AddBlockSelector(temp0);
    }
    else
    {
      op->vtkUnstructuredGridVolumeRepresentation::AddBlockSelector(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_RemoveAllBlockSelectors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllBlockSelectors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllBlockSelectors();
    }
    else
    {
      op->vtkUnstructuredGridVolumeRepresentation::RemoveAllBlockSelectors();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_SetSamplingDimensions_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSamplingDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  const size_t size0 = 3;
  int temp0[3];
  int save0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetSamplingDimensions(temp0);
    }
    else
    {
      op->vtkUnstructuredGridVolumeRepresentation::SetSamplingDimensions(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_SetSamplingDimensions_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSamplingDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  int temp0;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSamplingDimensions(temp0, temp1, temp2);
    }
    else
    {
      op->vtkUnstructuredGridVolumeRepresentation::SetSamplingDimensions(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_SetSamplingDimensions(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkUnstructuredGridVolumeRepresentation_SetSamplingDimensions_s1(self, args);
    case 3:
      return PyvtkUnstructuredGridVolumeRepresentation_SetSamplingDimensions_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSamplingDimensions");
  return nullptr;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_SetUseDataPartitions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseDataPartitions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseDataPartitions(temp0);
    }
    else
    {
      op->vtkUnstructuredGridVolumeRepresentation::SetUseDataPartitions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkUnstructuredGridVolumeRepresentation_GetUseDataPartitions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseDataPartitions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkUnstructuredGridVolumeRepresentation *op = static_cast<vtkUnstructuredGridVolumeRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseDataPartitions() :
      op->vtkUnstructuredGridVolumeRepresentation::GetUseDataPartitions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkUnstructuredGridVolumeRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkUnstructuredGridVolumeRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkUnstructuredGridVolumeRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkUnstructuredGridVolumeRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkUnstructuredGridVolumeRepresentation\nC++: static vtkUnstructuredGridVolumeRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkUnstructuredGridVolumeRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkUnstructuredGridVolumeRepresentation\nC++: vtkUnstructuredGridVolumeRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkUnstructuredGridVolumeRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkUnstructuredGridVolumeRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"AddVolumeMapper", PyvtkUnstructuredGridVolumeRepresentation_AddVolumeMapper, METH_VARARGS,
   "AddVolumeMapper(self, name:str, __b:vtkAbstractVolumeMapper)\n    -> None\nC++: void AddVolumeMapper(const char *name,\n    vtkAbstractVolumeMapper *)\n\nRegister a volume mapper with the representation.\n"},
  {"SetActiveVolumeMapper", PyvtkUnstructuredGridVolumeRepresentation_SetActiveVolumeMapper, METH_VARARGS,
   "SetActiveVolumeMapper(self, __a:str) -> None\nC++: virtual void SetActiveVolumeMapper(const char *)\n\nSet the active volume mapper to use.\n"},
  {"GetActiveVolumeMapper", PyvtkUnstructuredGridVolumeRepresentation_GetActiveVolumeMapper, METH_VARARGS,
   "GetActiveVolumeMapper(self) -> vtkAbstractVolumeMapper\nC++: vtkAbstractVolumeMapper *GetActiveVolumeMapper()\n\n"},
  {"ProcessViewRequest", PyvtkUnstructuredGridVolumeRepresentation_ProcessViewRequest, METH_VARARGS,
   "ProcessViewRequest(self, request_type:vtkInformationRequestKey,\n    inInfo:vtkInformation, outInfo:vtkInformation) -> int\nC++: int ProcessViewRequest(\n    vtkInformationRequestKey *request_type,\n    vtkInformation *inInfo, vtkInformation *outInfo) override;\n\nvtkAlgorithm::ProcessRequest() equivalent for rendering passes.\nThis is typically called by the vtkView to request meta-data from\nthe representations or ask them to perform certain tasks e.g.\nPrepareForRendering.\n"},
  {"SetActiveAssembly", PyvtkUnstructuredGridVolumeRepresentation_SetActiveAssembly, METH_VARARGS,
   "SetActiveAssembly(self, __a:str) -> None\nC++: void SetActiveAssembly(const char *)\n\nForwarded to vtkVolumeRepresentationPreprocessor. Controls which\nblocks in a composite dataset are rendered.\n"},
  {"AddBlockSelector", PyvtkUnstructuredGridVolumeRepresentation_AddBlockSelector, METH_VARARGS,
   "AddBlockSelector(self, __a:str) -> None\nC++: void AddBlockSelector(const char *)\n\n"},
  {"RemoveAllBlockSelectors", PyvtkUnstructuredGridVolumeRepresentation_RemoveAllBlockSelectors, METH_VARARGS,
   "RemoveAllBlockSelectors(self) -> None\nC++: void RemoveAllBlockSelectors()\n\n"},
  {"SetSamplingDimensions", PyvtkUnstructuredGridVolumeRepresentation_SetSamplingDimensions, METH_VARARGS,
   "SetSamplingDimensions(self, dims:[int, int, int]) -> None\nC++: void SetSamplingDimensions(int dims[3])\nSetSamplingDimensions(self, xdim:int, ydim:int, zdim:int) -> None\nC++: void SetSamplingDimensions(int xdim, int ydim, int zdim)\n\n"},
  {"SetUseDataPartitions", PyvtkUnstructuredGridVolumeRepresentation_SetUseDataPartitions, METH_VARARGS,
   "SetUseDataPartitions(self, __a:bool) -> None\nC++: virtual void SetUseDataPartitions(bool)\n\nSpecify whether or not to redistribute the data. The default is\nfalse since that is the only way in general to guarantee correct\nrendering. Can set to true if all rendered data sets are based on\nthe same data partitioning in order to save on the data\nredistribution.\n"},
  {"GetUseDataPartitions", PyvtkUnstructuredGridVolumeRepresentation_GetUseDataPartitions, METH_VARARGS,
   "GetUseDataPartitions(self) -> bool\nC++: virtual bool GetUseDataPartitions()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkUnstructuredGridVolumeRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("active_volume_mapper"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkUnstructuredGridVolumeRepresentation_SetActiveVolumeMapper(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkUnstructuredGridVolumeRepresentation_SetActiveVolumeMapper(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActiveVolumeMapper\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_assembly"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkUnstructuredGridVolumeRepresentation_SetActiveAssembly(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkUnstructuredGridVolumeRepresentation_SetActiveAssembly(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetActiveAssembly\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sampling_dimensions"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkUnstructuredGridVolumeRepresentation_SetSamplingDimensions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkUnstructuredGridVolumeRepresentation_SetSamplingDimensions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSamplingDimensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_data_partitions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkUnstructuredGridVolumeRepresentation_GetUseDataPartitions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkUnstructuredGridVolumeRepresentation_SetUseDataPartitions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkUnstructuredGridVolumeRepresentation_SetUseDataPartitions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseDataPartitions/SetUseDataPartitions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_volume_mapper"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkUnstructuredGridVolumeRepresentation_GetActiveVolumeMapper(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveVolumeMapper\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkUnstructuredGridVolumeRepresentation_Doc =
  "vtkUnstructuredGridVolumeRepresentation - representation for showing\nvtkUnstructuredGrid datasets as volumes.\n\n"
  "Superclass: vtkVolumeRepresentation\n\n"
  "vtkUnstructuredGridVolumeRepresentation is a representation for\n"
  "volume rendering vtkUnstructuredGrid datasets. It simply renders a\n"
  "translucent surface for LOD i.e. interactive rendering.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkUnstructuredGridVolumeRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkUnstructuredGridVolumeRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkUnstructuredGridVolumeRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkUnstructuredGridVolumeRepresentation_StaticNew()
{
  return vtkUnstructuredGridVolumeRepresentation::New();
}

PyObject *PyvtkUnstructuredGridVolumeRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkUnstructuredGridVolumeRepresentation_Type, PyvtkUnstructuredGridVolumeRepresentation_Methods,
    "vtkUnstructuredGridVolumeRepresentation",
 &PyvtkUnstructuredGridVolumeRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkVolumeRepresentation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkUnstructuredGridVolumeRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkUnstructuredGridVolumeRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkUnstructuredGridVolumeRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkUnstructuredGridVolumeRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

