// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

// clang-format off
#pragma once

#include <aotriton/config.h>
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/dtypes.h>
#include <aotriton/runtime.h>
#include <aotriton/util.h>
#include <functional>
#include <string>
#include <vector>

#if 1
namespace AOTRITON_NS::v3::flash {
    struct OpAttnFwdParams;
}
#endif

namespace AOTRITON_NS::v3::flash {

#if 1
using AOTRITON_NS::v3::flash::OpAttnFwdParams;
#else
// The parameter class must be defined here when
// There is no common operator for attn_fwd.
struct OpAttnFwdParams {
    const TensorView<4>* Q;
    const TensorView<4>* K;
    const TensorView<4>* V;
    const TensorView<4>* B;
    const TensorView<2>* A;
    float                Sm_scale;
    const TensorView<2>* L;
    const TensorView<4>* Out;
    int8_t               Q_descale;
    int8_t               K_descale;
    int8_t               P_scale;
    int8_t               P_descale;
    int8_t               V_descale;
    int32_t              Num_head_q;
    int32_t              Num_head_k;
    int32_t              Num_seqlens;
    const TensorView<1>* cu_seqlens_q;
    const TensorView<1>* cu_seqlens_k;
    int32_t              Max_seqlen_q;
    int32_t              Max_seqlen_k;
    int16_t              BLOCK_DMODEL;
    int32_t              Head_dim;
    bool                 PADDED_HEAD;
    bool                 ENABLE_DROPOUT;
    float                dropout_p;
    const TensorView<0>* philox_seed_ptr;
    const TensorView<0>* philox_offset1;
    uint64_t             philox_offset2;
    const TensorView<0>* philox_seed_output;
    const TensorView<0>* philox_offset_output;
    bool                 RETURN_ENCODED_SOFTMAX;
    const TensorView<4>* encoded_softmax;
    int8_t               CAUSAL_TYPE;
    int32_t              Window_left;
    int32_t              Window_right;
    int8_t               BIAS_TYPE;
    bool                 USE_ALIBI;
    bool                 INT8;
    bool                 INT8_KV;
    bool                 USE_P_SCALE;
    const TensorView<0>* persistent_atomic_counter;
    int32_t              Num_CU;
    int32_t              Batch;
};
#endif

struct AttnFwdContext {
    const OpAttnFwdParams *params = nullptr;
    // Performance related arguments for current selection
    int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;

    TritonKernel* kernel_on_device = nullptr;
    int pp_args_index = -1;
    std::string_view package_path;
    std::string_view func_name;
    std::string_view arch_name;
    // Note to save ELF space, this object is constructed on the fly.
    const char* _debug_kernel_name = nullptr;
#if AOTRITON_BUILD_FOR_TUNING
    int _has_preferred_kernel = -1; // For C++ based autotune database generation
    int _total_number_of_kernels = -1;
    const char* _preferred_kernel_psels = nullptr;
    const char* _preferred_kernel_copts = nullptr;
    bool peek_kernel_image = false;
#endif

    hipError_t lookup_optimal(Gpu gpu);
    hipError_t launch(hipStream_t stream) const;

    dim3 grid_calculator() const;
    std::function<dim3(const AttnFwdContext&)> custom_grid_calculator;

    int64_t godel_number() const;
    static std::tuple<int, int> get_archmod_number(Gpu gpu);
    static constexpr int kMaxGodelNumber = 576;

    typedef void (*AutoTuneTableEntry)(AttnFwdContext& context, int mod_number);
    static AutoTuneTableEntry autotune_table[][ kMaxGodelNumber ];
};

struct AttnFwdMetadata {
    // Note: FEAT_CHOICES here
    static const std::vector<std::string>& get_Q_choices();
    static const std::vector<std::string>& get_Sm_scale_choices();
    static const std::vector<std::string>& get_L_choices();
    static const std::vector<int>& get_Q_descale_choices();
    static const std::vector<std::string>& get_Num_head_q_choices();
    static const std::vector<std::string>& get_cu_seqlens_q_choices();
    static const std::vector<int>& get_BLOCK_DMODEL_choices();
    static const std::vector<bool>& get_PADDED_HEAD_choices();
    static const std::vector<bool>& get_ENABLE_DROPOUT_choices();
    static const std::vector<bool>& get_RETURN_ENCODED_SOFTMAX_choices();
    static const std::vector<int>& get_CAUSAL_TYPE_choices();
    static const std::vector<int>& get_BIAS_TYPE_choices();
    static const std::vector<bool>& get_USE_ALIBI_choices();
    static const std::vector<bool>& get_INT8_choices();
    static const std::vector<std::string>& get_Num_CU_choices();
};

namespace autotune {

extern const char attn_fwd_packed_string[];

extern int attn_fwd__lut_lambda__0(const OpAttnFwdParams& params, int mod_number, int8_t lut[1][10][10]);
extern int attn_fwd__lut_lambda__1(const OpAttnFwdParams& params, int mod_number, int8_t lut[1][1]);

void Autotune_attn_fwd__A0__F0(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F1(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F2(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F4(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F5(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F6(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F8(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F9(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F10(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F12(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F13(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F14(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F16(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F17(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F18(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F20(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F21(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F22(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F24(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F25(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F26(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F28(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F29(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F30(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F32(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F33(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F34(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F36(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F37(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F38(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F40(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F41(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F42(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F44(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F45(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F46(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F48(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F49(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F50(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F52(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F53(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F54(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F56(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F57(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F58(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F60(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F61(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F62(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F64(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F65(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F66(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F68(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F69(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F70(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F72(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F73(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F74(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F76(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F77(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F78(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F80(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F81(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F82(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F84(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F85(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F86(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F88(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F89(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F90(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F92(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F93(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F94(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F96(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F97(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F98(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F100(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F101(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F102(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F104(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F105(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F106(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F108(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F109(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F110(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F112(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F113(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F114(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F116(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F117(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F118(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F120(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F121(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F122(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F124(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F125(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F126(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F128(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F129(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F130(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F132(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F133(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F134(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F136(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F137(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F138(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F140(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F141(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F142(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F144(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F145(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F146(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F148(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F149(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F150(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F152(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F153(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F154(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F156(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F157(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F158(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F160(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F161(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F162(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F164(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F165(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F166(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F168(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F169(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F170(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F172(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F173(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F174(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F176(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F177(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F178(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F180(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F181(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F182(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F184(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F185(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F186(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F188(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F189(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F190(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F192(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F193(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F194(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F196(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F197(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F198(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F200(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F201(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F202(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F204(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F205(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F206(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F208(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F209(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F210(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F212(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F213(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F214(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F216(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F217(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F218(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F220(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F221(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F222(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F224(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F225(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F226(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F228(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F229(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F230(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F232(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F233(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F234(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F236(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F237(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F238(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F240(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F241(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F242(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F244(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F245(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F246(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F248(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F249(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F250(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F252(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F253(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F254(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F256(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F257(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F258(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F260(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F261(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F262(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F264(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F265(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F266(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F268(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F269(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F270(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F272(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F273(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F274(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F276(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F277(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F278(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F280(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F281(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F282(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F284(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F285(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F286(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F288(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F289(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F290(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F292(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F293(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F294(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F296(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F297(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F298(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F300(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F301(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F302(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F304(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F305(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F306(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F308(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F309(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F310(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F312(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F313(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F314(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F316(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F317(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F318(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F320(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F321(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F322(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F324(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F325(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F326(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F328(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F329(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F330(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F332(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F333(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F334(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F336(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F337(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F338(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F340(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F341(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F342(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F344(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F345(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F346(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F348(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F349(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F350(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F352(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F353(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F354(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F356(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F357(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F358(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F360(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F361(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F362(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F364(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F365(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F366(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F368(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F369(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F370(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F372(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F373(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F374(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F376(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F377(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F378(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F380(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F381(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F382(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F384(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F385(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F386(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F388(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F389(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F390(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F392(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F393(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F394(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F396(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F397(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F398(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F400(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F401(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F402(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F404(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F405(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F406(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F408(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F409(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F410(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F412(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F413(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F414(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F416(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F417(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F418(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F420(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F421(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F422(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F424(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F425(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F426(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F428(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F429(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F430(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F432(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F433(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F434(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F436(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F437(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F438(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F440(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F441(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F442(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F444(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F445(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F446(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F448(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F449(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F450(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F452(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F453(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F454(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F456(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F457(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F458(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F460(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F461(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F462(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F464(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F465(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F466(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F468(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F469(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F470(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F472(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F473(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F474(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F476(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F477(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F478(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F480(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F481(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F482(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F484(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F485(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F486(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F488(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F489(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F490(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F492(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F493(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F494(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F496(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F497(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F498(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F500(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F501(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F502(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F504(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F505(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F506(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F508(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F509(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F510(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F512(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F513(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F514(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F516(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F517(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F518(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F520(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F521(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F522(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F524(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F525(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F526(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F528(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F529(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F530(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F532(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F533(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F534(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F536(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F537(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F538(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F540(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F541(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F542(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F544(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F545(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F546(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F548(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F549(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F550(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F552(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F553(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F554(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F556(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F557(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F558(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F560(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F561(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F562(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F564(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F565(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F566(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F568(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F569(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F570(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F572(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F573(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A0__F574(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F0(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F1(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F2(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F4(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F5(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F6(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F8(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F9(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F10(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F12(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F13(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F14(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F16(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F17(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F18(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F20(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F21(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F22(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F24(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F25(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F26(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F28(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F29(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F30(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F32(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F33(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F34(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F36(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F37(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F38(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F40(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F41(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F42(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F44(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F45(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F46(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F48(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F49(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F50(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F52(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F53(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F54(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F56(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F57(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F58(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F60(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F61(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F62(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F64(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F65(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F66(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F68(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F69(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F70(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F72(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F73(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F74(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F76(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F77(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F78(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F80(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F81(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F82(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F84(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F85(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F86(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F88(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F89(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F90(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F92(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F93(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F94(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F96(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F97(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F98(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F100(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F101(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F102(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F104(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F105(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F106(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F108(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F109(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F110(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F112(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F113(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F114(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F116(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F117(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F118(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F120(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F121(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F122(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F124(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F125(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F126(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F128(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F129(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F130(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F132(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F133(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F134(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F136(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F137(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F138(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F140(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F141(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F142(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F144(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F145(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F146(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F148(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F149(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F150(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F152(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F153(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F154(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F156(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F157(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F158(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F160(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F161(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F162(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F164(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F165(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F166(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F168(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F169(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F170(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F172(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F173(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F174(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F176(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F177(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F178(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F180(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F181(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F182(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F184(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F185(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F186(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F188(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F189(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F190(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F192(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F193(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F194(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F196(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F197(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F198(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F200(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F201(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F202(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F204(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F205(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F206(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F208(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F209(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F210(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F212(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F213(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F214(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F216(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F217(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F218(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F220(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F221(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F222(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F224(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F225(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F226(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F228(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F229(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F230(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F232(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F233(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F234(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F236(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F237(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F238(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F240(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F241(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F242(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F244(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F245(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F246(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F248(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F249(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F250(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F252(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F253(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F254(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F256(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F257(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F258(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F260(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F261(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F262(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F264(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F265(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F266(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F268(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F269(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F270(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F272(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F273(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F274(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F276(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F277(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F278(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F280(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F281(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F282(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F284(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F285(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F286(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F288(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F289(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F290(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F292(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F293(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F294(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F296(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F297(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F298(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F300(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F301(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F302(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F304(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F305(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F306(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F308(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F309(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F310(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F312(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F313(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F314(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F316(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F317(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F318(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F320(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F321(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F322(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F324(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F325(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F326(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F328(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F329(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F330(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F332(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F333(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F334(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F336(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F337(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F338(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F340(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F341(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F342(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F344(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F345(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F346(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F348(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F349(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F350(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F352(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F353(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F354(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F356(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F357(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F358(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F360(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F361(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F362(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F364(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F365(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F366(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F368(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F369(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F370(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F372(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F373(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F374(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F376(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F377(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F378(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F380(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F381(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F382(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F384(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F385(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F386(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F388(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F389(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F390(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F392(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F393(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F394(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F396(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F397(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F398(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F400(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F401(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F402(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F404(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F405(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F406(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F408(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F409(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F410(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F412(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F413(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F414(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F416(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F417(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F418(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F420(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F421(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F422(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F424(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F425(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F426(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F428(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F429(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F430(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F432(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F433(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F434(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F436(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F437(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F438(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F440(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F441(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F442(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F444(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F445(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F446(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F448(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F449(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F450(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F452(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F453(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F454(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F456(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F457(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F458(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F460(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F461(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F462(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F464(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F465(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F466(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F468(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F469(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F470(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F472(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F473(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F474(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F476(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F477(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F478(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F480(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F481(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F482(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F484(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F485(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F486(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F488(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F489(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F490(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F492(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F493(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F494(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F496(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F497(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F498(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F500(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F501(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F502(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F504(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F505(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F506(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F508(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F509(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F510(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F512(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F513(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F514(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F516(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F517(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F518(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F520(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F521(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F522(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F524(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F525(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F526(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F528(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F529(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F530(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F532(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F533(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F534(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F536(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F537(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F538(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F540(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F541(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F542(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F544(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F545(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F546(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F548(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F549(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F550(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F552(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F553(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F554(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F556(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F557(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F558(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F560(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F561(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F562(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F564(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F565(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F566(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F568(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F569(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F570(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F572(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F573(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A1__F574(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F0(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F1(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F2(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F4(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F5(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F6(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F8(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F9(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F10(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F12(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F13(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F14(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F16(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F17(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F18(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F20(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F21(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F22(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F24(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F25(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F26(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F28(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F29(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F30(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F32(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F33(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F34(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F36(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F37(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F38(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F40(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F41(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F42(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F44(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F45(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F46(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F48(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F49(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F50(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F52(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F53(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F54(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F56(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F57(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F58(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F60(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F61(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F62(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F64(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F65(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F66(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F68(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F69(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F70(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F72(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F73(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F74(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F76(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F77(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F78(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F80(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F81(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F82(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F84(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F85(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F86(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F88(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F89(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F90(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F92(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F93(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F94(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F96(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F97(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F98(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F100(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F101(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F102(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F104(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F105(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F106(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F108(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F109(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F110(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F112(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F113(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F114(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F116(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F117(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F118(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F120(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F121(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F122(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F124(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F125(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F126(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F128(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F129(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F130(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F132(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F133(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F134(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F136(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F137(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F138(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F140(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F141(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F142(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F144(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F145(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F146(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F148(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F149(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F150(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F152(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F153(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F154(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F156(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F157(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F158(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F160(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F161(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F162(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F164(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F165(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F166(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F168(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F169(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F170(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F172(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F173(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F174(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F176(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F177(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F178(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F180(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F181(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F182(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F184(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F185(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F186(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F188(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F189(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F190(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F192(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F193(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F194(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F196(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F197(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F198(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F200(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F201(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F202(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F204(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F205(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F206(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F208(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F209(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F210(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F212(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F213(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F214(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F216(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F217(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F218(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F220(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F221(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F222(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F224(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F225(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F226(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F228(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F229(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F230(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F232(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F233(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F234(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F236(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F237(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F238(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F240(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F241(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F242(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F244(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F245(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F246(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F248(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F249(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F250(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F252(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F253(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F254(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F256(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F257(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F258(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F260(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F261(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F262(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F264(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F265(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F266(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F268(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F269(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F270(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F272(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F273(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F274(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F276(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F277(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F278(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F280(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F281(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F282(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F284(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F285(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F286(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F288(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F289(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F290(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F292(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F293(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F294(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F296(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F297(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F298(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F300(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F301(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F302(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F304(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F305(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F306(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F308(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F309(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F310(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F312(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F313(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F314(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F316(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F317(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F318(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F320(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F321(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F322(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F324(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F325(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F326(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F328(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F329(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F330(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F332(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F333(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F334(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F336(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F337(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F338(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F340(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F341(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F342(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F344(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F345(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F346(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F348(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F349(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F350(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F352(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F353(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F354(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F356(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F357(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F358(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F360(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F361(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F362(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F364(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F365(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F366(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F368(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F369(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F370(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F372(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F373(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F374(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F376(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F377(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F378(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F380(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F381(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F382(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F384(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F385(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F386(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F388(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F389(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F390(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F392(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F393(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F394(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F396(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F397(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F398(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F400(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F401(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F402(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F404(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F405(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F406(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F408(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F409(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F410(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F412(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F413(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F414(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F416(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F417(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F418(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F420(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F421(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F422(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F424(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F425(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F426(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F428(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F429(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F430(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F432(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F433(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F434(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F436(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F437(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F438(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F440(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F441(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F442(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F444(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F445(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F446(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F448(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F449(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F450(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F452(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F453(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F454(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F456(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F457(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F458(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F460(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F461(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F462(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F464(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F465(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F466(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F468(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F469(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F470(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F472(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F473(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F474(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F476(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F477(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F478(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F480(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F481(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F482(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F484(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F485(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F486(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F488(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F489(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F490(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F492(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F493(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F494(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F496(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F497(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F498(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F500(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F501(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F502(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F504(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F505(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F506(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F508(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F509(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F510(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F512(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F513(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F514(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F516(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F517(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F518(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F520(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F521(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F522(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F524(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F525(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F526(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F528(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F529(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F530(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F532(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F533(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F534(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F536(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F537(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F538(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F540(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F541(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F542(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F544(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F545(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F546(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F548(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F549(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F550(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F552(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F553(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F554(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F556(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F557(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F558(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F560(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F561(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F562(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F564(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F565(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F566(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F568(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F569(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F570(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F572(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F573(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A2__F574(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F0(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F1(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F2(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F4(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F5(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F6(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F8(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F9(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F10(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F12(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F13(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F14(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F16(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F17(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F18(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F20(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F21(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F22(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F24(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F25(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F26(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F28(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F29(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F30(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F32(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F33(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F34(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F36(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F37(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F38(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F40(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F41(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F42(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F44(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F45(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F46(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F48(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F49(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F50(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F52(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F53(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F54(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F56(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F57(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F58(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F60(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F61(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F62(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F64(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F65(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F66(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F68(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F69(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F70(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F72(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F73(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F74(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F76(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F77(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F78(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F80(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F81(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F82(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F84(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F85(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F86(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F88(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F89(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F90(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F92(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F93(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F94(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F96(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F97(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F98(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F100(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F101(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F102(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F104(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F105(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F106(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F108(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F109(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F110(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F112(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F113(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F114(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F116(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F117(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F118(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F120(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F121(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F122(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F124(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F125(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F126(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F128(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F129(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F130(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F132(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F133(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F134(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F136(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F137(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F138(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F140(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F141(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F142(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F144(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F145(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F146(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F148(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F149(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F150(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F152(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F153(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F154(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F156(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F157(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F158(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F160(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F161(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F162(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F164(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F165(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F166(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F168(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F169(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F170(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F172(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F173(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F174(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F176(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F177(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F178(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F180(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F181(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F182(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F184(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F185(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F186(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F188(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F189(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F190(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F192(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F193(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F194(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F196(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F197(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F198(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F200(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F201(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F202(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F204(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F205(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F206(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F208(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F209(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F210(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F212(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F213(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F214(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F216(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F217(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F218(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F220(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F221(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F222(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F224(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F225(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F226(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F228(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F229(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F230(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F232(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F233(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F234(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F236(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F237(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F238(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F240(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F241(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F242(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F244(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F245(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F246(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F248(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F249(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F250(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F252(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F253(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F254(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F256(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F257(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F258(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F260(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F261(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F262(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F264(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F265(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F266(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F268(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F269(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F270(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F272(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F273(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F274(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F276(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F277(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F278(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F280(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F281(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F282(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F284(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F285(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F286(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F288(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F289(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F290(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F292(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F293(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F294(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F296(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F297(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F298(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F300(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F301(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F302(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F304(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F305(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F306(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F308(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F309(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F310(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F312(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F313(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F314(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F316(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F317(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F318(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F320(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F321(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F322(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F324(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F325(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F326(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F328(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F329(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F330(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F332(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F333(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F334(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F336(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F337(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F338(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F340(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F341(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F342(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F344(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F345(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F346(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F348(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F349(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F350(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F352(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F353(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F354(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F356(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F357(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F358(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F360(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F361(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F362(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F364(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F365(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F366(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F368(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F369(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F370(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F372(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F373(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F374(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F376(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F377(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F378(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F380(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F381(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F382(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F384(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F385(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F386(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F388(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F389(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F390(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F392(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F393(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F394(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F396(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F397(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F398(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F400(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F401(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F402(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F404(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F405(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F406(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F408(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F409(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F410(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F412(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F413(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F414(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F416(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F417(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F418(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F420(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F421(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F422(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F424(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F425(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F426(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F428(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F429(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F430(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F432(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F433(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F434(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F436(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F437(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F438(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F440(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F441(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F442(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F444(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F445(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F446(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F448(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F449(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F450(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F452(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F453(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F454(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F456(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F457(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F458(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F460(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F461(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F462(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F464(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F465(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F466(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F468(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F469(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F470(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F472(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F473(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F474(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F476(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F477(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F478(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F480(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F481(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F482(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F484(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F485(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F486(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F488(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F489(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F490(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F492(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F493(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F494(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F496(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F497(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F498(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F500(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F501(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F502(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F504(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F505(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F506(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F508(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F509(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F510(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F512(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F513(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F514(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F516(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F517(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F518(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F520(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F521(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F522(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F524(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F525(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F526(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F528(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F529(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F530(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F532(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F533(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F534(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F536(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F537(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F538(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F540(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F541(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F542(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F544(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F545(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F546(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F548(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F549(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F550(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F552(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F553(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F554(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F556(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F557(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F558(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F560(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F561(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F562(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F564(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F565(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F566(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F568(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F569(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F570(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F572(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F573(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A3__F574(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F0(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F1(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F2(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F4(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F5(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F6(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F8(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F9(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F10(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F12(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F13(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F14(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F16(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F17(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F18(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F20(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F21(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F22(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F24(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F25(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F26(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F28(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F29(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F30(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F32(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F33(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F34(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F36(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F37(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F38(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F40(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F41(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F42(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F44(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F45(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F46(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F48(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F49(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F50(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F52(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F53(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F54(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F56(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F57(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F58(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F60(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F61(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F62(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F64(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F65(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F66(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F68(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F69(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F70(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F72(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F73(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F74(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F76(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F77(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F78(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F80(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F81(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F82(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F84(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F85(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F86(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F88(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F89(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F90(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F92(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F93(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F94(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F96(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F97(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F98(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F100(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F101(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F102(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F104(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F105(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F106(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F108(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F109(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F110(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F112(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F113(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F114(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F116(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F117(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F118(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F120(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F121(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F122(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F124(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F125(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F126(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F128(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F129(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F130(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F132(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F133(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F134(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F136(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F137(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F138(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F140(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F141(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F142(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F144(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F145(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F146(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F148(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F149(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F150(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F152(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F153(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F154(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F156(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F157(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F158(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F160(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F161(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F162(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F164(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F165(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F166(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F168(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F169(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F170(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F172(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F173(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F174(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F176(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F177(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F178(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F180(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F181(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F182(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F184(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F185(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F186(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F188(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F189(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F190(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F192(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F193(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F194(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F196(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F197(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F198(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F200(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F201(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F202(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F204(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F205(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F206(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F208(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F209(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F210(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F212(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F213(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F214(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F216(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F217(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F218(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F220(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F221(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F222(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F224(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F225(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F226(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F228(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F229(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F230(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F232(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F233(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F234(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F236(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F237(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F238(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F240(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F241(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F242(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F244(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F245(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F246(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F248(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F249(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F250(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F252(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F253(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F254(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F256(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F257(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F258(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F260(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F261(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F262(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F264(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F265(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F266(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F268(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F269(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F270(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F272(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F273(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F274(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F276(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F277(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F278(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F280(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F281(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F282(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F284(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F285(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F286(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F288(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F289(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F290(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F292(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F293(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F294(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F296(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F297(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F298(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F300(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F301(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F302(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F304(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F305(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F306(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F308(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F309(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F310(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F312(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F313(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F314(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F316(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F317(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F318(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F320(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F321(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F322(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F324(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F325(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F326(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F328(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F329(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F330(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F332(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F333(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F334(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F336(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F337(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F338(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F340(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F341(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F342(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F344(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F345(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F346(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F348(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F349(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F350(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F352(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F353(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F354(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F356(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F357(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F358(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F360(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F361(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F362(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F364(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F365(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F366(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F368(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F369(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F370(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F372(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F373(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F374(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F376(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F377(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F378(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F380(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F381(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F382(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F384(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F385(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F386(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F388(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F389(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F390(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F392(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F393(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F394(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F396(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F397(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F398(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F400(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F401(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F402(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F404(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F405(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F406(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F408(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F409(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F410(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F412(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F413(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F414(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F416(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F417(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F418(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F420(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F421(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F422(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F424(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F425(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F426(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F428(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F429(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F430(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F432(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F433(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F434(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F436(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F437(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F438(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F440(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F441(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F442(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F444(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F445(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F446(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F448(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F449(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F450(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F452(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F453(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F454(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F456(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F457(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F458(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F460(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F461(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F462(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F464(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F465(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F466(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F468(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F469(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F470(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F472(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F473(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F474(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F476(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F477(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F478(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F480(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F481(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F482(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F484(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F485(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F486(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F488(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F489(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F490(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F492(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F493(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F494(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F496(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F497(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F498(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F500(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F501(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F502(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F504(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F505(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F506(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F508(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F509(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F510(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F512(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F513(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F514(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F516(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F517(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F518(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F520(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F521(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F522(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F524(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F525(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F526(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F528(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F529(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F530(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F532(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F533(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F534(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F536(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F537(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F538(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F540(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F541(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F542(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F544(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F545(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F546(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F548(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F549(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F550(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F552(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F553(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F554(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F556(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F557(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F558(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F560(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F561(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F562(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F564(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F565(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F566(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F568(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F569(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F570(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F572(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F573(AttnFwdContext& params, int mod_number);
void Autotune_attn_fwd__A4__F574(AttnFwdContext& params, int mod_number);

}


}

// vim: set fileencoding=utf-8

