// components/services/storage/public/mojom/cache_storage_control.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/cache_storage_control.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/cache_storage_control.mojom-params-data.h"
#include "components/services/storage/public/mojom/cache_storage_control.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/cache_storage_control.mojom-import-headers.h"
#include "components/services/storage/public/mojom/cache_storage_control.mojom-test-utils.h"


namespace storage::mojom {
const char CacheStorageObserver::Name_[] = "storage.mojom.CacheStorageObserver";

CacheStorageObserver::IPCStableHashFunction CacheStorageObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CacheStorageObserver>(message.name())) {
    case messages::CacheStorageObserver::kOnCacheListChanged: {
      return &CacheStorageObserver::OnCacheListChanged_Sym::IPCStableHash;
    }
    case messages::CacheStorageObserver::kOnCacheContentChanged: {
      return &CacheStorageObserver::OnCacheContentChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CacheStorageObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CacheStorageObserver>(message.name())) {
      case messages::CacheStorageObserver::kOnCacheListChanged:
            return "Receive storage::mojom::CacheStorageObserver::OnCacheListChanged";
      case messages::CacheStorageObserver::kOnCacheContentChanged:
            return "Receive storage::mojom::CacheStorageObserver::OnCacheContentChanged";
    }
  } else {
    switch (static_cast<messages::CacheStorageObserver>(message.name())) {
      case messages::CacheStorageObserver::kOnCacheListChanged:
            return "Receive reply storage::mojom::CacheStorageObserver::OnCacheListChanged";
      case messages::CacheStorageObserver::kOnCacheContentChanged:
            return "Receive reply storage::mojom::CacheStorageObserver::OnCacheContentChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CacheStorageObserver::OnCacheListChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::CacheStorageObserver::OnCacheListChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CacheStorageObserver::OnCacheContentChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::CacheStorageObserver::OnCacheContentChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CacheStorageObserverProxy::CacheStorageObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CacheStorageObserverProxy::OnCacheListChanged(
    const ::storage::BucketLocator& in_bucket_locator) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::CacheStorageObserver::OnCacheListChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_locator"), in_bucket_locator,
                        "<value of type const ::storage::BucketLocator&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageObserver::kOnCacheListChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::CacheStorageObserver_OnCacheListChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_locator)::BaseType> bucket_locator_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView>(
      in_bucket_locator, bucket_locator_fragment);
  params->bucket_locator.Set(
      bucket_locator_fragment.is_null() ? nullptr : bucket_locator_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bucket_locator.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucket_locator in CacheStorageObserver.OnCacheListChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageObserver::Name_);
  message.set_method_name("OnCacheListChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CacheStorageObserverProxy::OnCacheContentChanged(
    const ::storage::BucketLocator& in_bucket_locator, const std::string& in_cache_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::CacheStorageObserver::OnCacheContentChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_locator"), in_bucket_locator,
                        "<value of type const ::storage::BucketLocator&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_name"), in_cache_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageObserver::kOnCacheContentChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::CacheStorageObserver_OnCacheContentChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_locator)::BaseType> bucket_locator_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView>(
      in_bucket_locator, bucket_locator_fragment);
  params->bucket_locator.Set(
      bucket_locator_fragment.is_null() ? nullptr : bucket_locator_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bucket_locator.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucket_locator in CacheStorageObserver.OnCacheContentChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->cache_name)::BaseType> cache_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_cache_name, cache_name_fragment);
  params->cache_name.Set(
      cache_name_fragment.is_null() ? nullptr : cache_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cache_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cache_name in CacheStorageObserver.OnCacheContentChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageObserver::Name_);
  message.set_method_name("OnCacheContentChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CacheStorageObserverStubDispatch::Accept(
    CacheStorageObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CacheStorageObserver>(message->header()->name)) {
    case messages::CacheStorageObserver::kOnCacheListChanged: {
      DCHECK(message->is_serialized());
      internal::CacheStorageObserver_OnCacheListChanged_Params_Data* params =
          reinterpret_cast<internal::CacheStorageObserver_OnCacheListChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CacheStorageObserver.0
      bool success = true;
      ::storage::BucketLocator p_bucket_locator{};
      CacheStorageObserver_OnCacheListChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketLocator(&p_bucket_locator))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCacheListChanged(        
        std::move(p_bucket_locator));
      return true;
    }
    case messages::CacheStorageObserver::kOnCacheContentChanged: {
      DCHECK(message->is_serialized());
      internal::CacheStorageObserver_OnCacheContentChanged_Params_Data* params =
          reinterpret_cast<internal::CacheStorageObserver_OnCacheContentChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CacheStorageObserver.1
      bool success = true;
      ::storage::BucketLocator p_bucket_locator{};
      std::string p_cache_name{};
      CacheStorageObserver_OnCacheContentChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketLocator(&p_bucket_locator))
        success = false;
      if (success && !input_data_view.ReadCacheName(&p_cache_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCacheContentChanged(        
        std::move(p_bucket_locator), 
        std::move(p_cache_name));
      return true;
    }
  }
  return false;
}

// static
bool CacheStorageObserverStubDispatch::AcceptWithResponder(
    CacheStorageObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CacheStorageObserver>(message->header()->name)) {
    case messages::CacheStorageObserver::kOnCacheListChanged: {
      break;
    }
    case messages::CacheStorageObserver::kOnCacheContentChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCacheStorageObserverValidationInfo[] = {
    {base::to_underlying(messages::CacheStorageObserver::kOnCacheListChanged),
     { &internal::CacheStorageObserver_OnCacheListChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CacheStorageObserver::kOnCacheContentChanged),
     { &internal::CacheStorageObserver_OnCacheContentChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CacheStorageObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::CacheStorageObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCacheStorageObserverValidationInfo);
}

const char CacheStorageControl::Name_[] = "storage.mojom.CacheStorageControl";

CacheStorageControl::IPCStableHashFunction CacheStorageControl::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CacheStorageControl>(message.name())) {
    case messages::CacheStorageControl::kAddReceiver: {
      return &CacheStorageControl::AddReceiver_Sym::IPCStableHash;
    }
    case messages::CacheStorageControl::kAddObserver: {
      return &CacheStorageControl::AddObserver_Sym::IPCStableHash;
    }
    case messages::CacheStorageControl::kApplyPolicyUpdates: {
      return &CacheStorageControl::ApplyPolicyUpdates_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CacheStorageControl::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CacheStorageControl>(message.name())) {
      case messages::CacheStorageControl::kAddReceiver:
            return "Receive storage::mojom::CacheStorageControl::AddReceiver";
      case messages::CacheStorageControl::kAddObserver:
            return "Receive storage::mojom::CacheStorageControl::AddObserver";
      case messages::CacheStorageControl::kApplyPolicyUpdates:
            return "Receive storage::mojom::CacheStorageControl::ApplyPolicyUpdates";
    }
  } else {
    switch (static_cast<messages::CacheStorageControl>(message.name())) {
      case messages::CacheStorageControl::kAddReceiver:
            return "Receive reply storage::mojom::CacheStorageControl::AddReceiver";
      case messages::CacheStorageControl::kAddObserver:
            return "Receive reply storage::mojom::CacheStorageControl::AddObserver";
      case messages::CacheStorageControl::kApplyPolicyUpdates:
            return "Receive reply storage::mojom::CacheStorageControl::ApplyPolicyUpdates";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CacheStorageControl::AddReceiver_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::CacheStorageControl::AddReceiver");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CacheStorageControl::AddObserver_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::CacheStorageControl::AddObserver");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CacheStorageControl::ApplyPolicyUpdates_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::CacheStorageControl::ApplyPolicyUpdates");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CacheStorageControlProxy::CacheStorageControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CacheStorageControlProxy::AddReceiver(
    const ::network::CrossOriginEmbedderPolicy& in_cross_origin_embedder_policy, ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> in_coep_reporter, const ::network::DocumentIsolationPolicy& in_document_isolation_policy, ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter> in_dip_reporter, const ::storage::BucketLocator& in_bucket_locator, CacheStorageOwner in_owner, ::mojo::PendingReceiver<::blink::mojom::CacheStorage> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::CacheStorageControl::AddReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cross_origin_embedder_policy"), in_cross_origin_embedder_policy,
                        "<value of type const ::network::CrossOriginEmbedderPolicy&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("coep_reporter"), in_coep_reporter,
                        "<value of type ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_isolation_policy"), in_document_isolation_policy,
                        "<value of type const ::network::DocumentIsolationPolicy&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dip_reporter"), in_dip_reporter,
                        "<value of type ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_locator"), in_bucket_locator,
                        "<value of type const ::storage::BucketLocator&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("owner"), in_owner,
                        "<value of type CacheStorageOwner>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::CacheStorage>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageControl::kAddReceiver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::CacheStorageControl_AddReceiver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cross_origin_embedder_policy)::BaseType> cross_origin_embedder_policy_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
      in_cross_origin_embedder_policy, cross_origin_embedder_policy_fragment);
  params->cross_origin_embedder_policy.Set(
      cross_origin_embedder_policy_fragment.is_null() ? nullptr : cross_origin_embedder_policy_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cross_origin_embedder_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cross_origin_embedder_policy in CacheStorageControl.AddReceiver request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CrossOriginEmbedderPolicyReporterInterfaceBase>>(
      in_coep_reporter, &params->coep_reporter, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->document_isolation_policy)::BaseType> document_isolation_policy_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::DocumentIsolationPolicyDataView>(
      in_document_isolation_policy, document_isolation_policy_fragment);
  params->document_isolation_policy.Set(
      document_isolation_policy_fragment.is_null() ? nullptr : document_isolation_policy_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->document_isolation_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_isolation_policy in CacheStorageControl.AddReceiver request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DocumentIsolationPolicyReporterInterfaceBase>>(
      in_dip_reporter, &params->dip_reporter, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_locator)::BaseType> bucket_locator_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView>(
      in_bucket_locator, bucket_locator_fragment);
  params->bucket_locator.Set(
      bucket_locator_fragment.is_null() ? nullptr : bucket_locator_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bucket_locator.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucket_locator in CacheStorageControl.AddReceiver request");
  mojo::internal::Serialize<::storage::mojom::CacheStorageOwner>(
      in_owner, &params->owner);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::CacheStorageInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in CacheStorageControl.AddReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageControl::Name_);
  message.set_method_name("AddReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CacheStorageControlProxy::AddObserver(
    ::mojo::PendingRemote<CacheStorageObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::CacheStorageControl::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<CacheStorageObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageControl::kAddObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::CacheStorageControl_AddObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::CacheStorageObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in CacheStorageControl.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageControl::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CacheStorageControlProxy::ApplyPolicyUpdates(
    std::vector<::storage::mojom::StoragePolicyUpdatePtr> in_policy_updates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::CacheStorageControl::ApplyPolicyUpdates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_updates"), in_policy_updates,
                        "<value of type std::vector<::storage::mojom::StoragePolicyUpdatePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CacheStorageControl::kApplyPolicyUpdates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::CacheStorageControl_ApplyPolicyUpdates_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->policy_updates)::BaseType>
      policy_updates_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& policy_updates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::StoragePolicyUpdateDataView>>(
      in_policy_updates, policy_updates_fragment, &policy_updates_validate_params);
  params->policy_updates.Set(
      policy_updates_fragment.is_null() ? nullptr : policy_updates_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_updates.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_updates in CacheStorageControl.ApplyPolicyUpdates request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageControl::Name_);
  message.set_method_name("ApplyPolicyUpdates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CacheStorageControlStubDispatch::Accept(
    CacheStorageControl* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CacheStorageControl>(message->header()->name)) {
    case messages::CacheStorageControl::kAddReceiver: {
      DCHECK(message->is_serialized());
      internal::CacheStorageControl_AddReceiver_Params_Data* params =
          reinterpret_cast<internal::CacheStorageControl_AddReceiver_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CacheStorageControl.0
      bool success = true;
      ::network::CrossOriginEmbedderPolicy p_cross_origin_embedder_policy{};
      ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> p_coep_reporter{};
      ::network::DocumentIsolationPolicy p_document_isolation_policy{};
      ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter> p_dip_reporter{};
      ::storage::BucketLocator p_bucket_locator{};
      CacheStorageOwner p_owner{};
      ::mojo::PendingReceiver<::blink::mojom::CacheStorage> p_receiver{};
      CacheStorageControl_AddReceiver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCrossOriginEmbedderPolicy(&p_cross_origin_embedder_policy))
        success = false;
      if (success) {
        p_coep_reporter =
            input_data_view.TakeCoepReporter<decltype(p_coep_reporter)>();
      }
      if (success && !input_data_view.ReadDocumentIsolationPolicy(&p_document_isolation_policy))
        success = false;
      if (success) {
        p_dip_reporter =
            input_data_view.TakeDipReporter<decltype(p_dip_reporter)>();
      }
      if (success && !input_data_view.ReadBucketLocator(&p_bucket_locator))
        success = false;
      if (success && !input_data_view.ReadOwner(&p_owner))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageControl::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddReceiver(        
        std::move(p_cross_origin_embedder_policy), 
        std::move(p_coep_reporter), 
        std::move(p_document_isolation_policy), 
        std::move(p_dip_reporter), 
        std::move(p_bucket_locator), 
        std::move(p_owner), 
        std::move(p_receiver));
      return true;
    }
    case messages::CacheStorageControl::kAddObserver: {
      DCHECK(message->is_serialized());
      internal::CacheStorageControl_AddObserver_Params_Data* params =
          reinterpret_cast<internal::CacheStorageControl_AddObserver_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CacheStorageControl.1
      bool success = true;
      ::mojo::PendingRemote<CacheStorageObserver> p_observer{};
      CacheStorageControl_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageControl::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::CacheStorageControl::kApplyPolicyUpdates: {
      DCHECK(message->is_serialized());
      internal::CacheStorageControl_ApplyPolicyUpdates_Params_Data* params =
          reinterpret_cast<internal::CacheStorageControl_ApplyPolicyUpdates_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CacheStorageControl.2
      bool success = true;
      std::vector<::storage::mojom::StoragePolicyUpdatePtr> p_policy_updates{};
      CacheStorageControl_ApplyPolicyUpdates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolicyUpdates(&p_policy_updates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageControl::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyPolicyUpdates(        
        std::move(p_policy_updates));
      return true;
    }
  }
  return false;
}

// static
bool CacheStorageControlStubDispatch::AcceptWithResponder(
    CacheStorageControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CacheStorageControl>(message->header()->name)) {
    case messages::CacheStorageControl::kAddReceiver: {
      break;
    }
    case messages::CacheStorageControl::kAddObserver: {
      break;
    }
    case messages::CacheStorageControl::kApplyPolicyUpdates: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCacheStorageControlValidationInfo[] = {
    {base::to_underlying(messages::CacheStorageControl::kAddReceiver),
     { &internal::CacheStorageControl_AddReceiver_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CacheStorageControl::kAddObserver),
     { &internal::CacheStorageControl_AddObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CacheStorageControl::kApplyPolicyUpdates),
     { &internal::CacheStorageControl_ApplyPolicyUpdates_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CacheStorageControlRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::CacheStorageControl::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCacheStorageControlValidationInfo);
}



}  // storage::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void CacheStorageObserverInterceptorForTesting::OnCacheListChanged(const ::storage::BucketLocator& bucket_locator) {
  GetForwardingInterface()->OnCacheListChanged(
    std::move(bucket_locator)
    );
}
void CacheStorageObserverInterceptorForTesting::OnCacheContentChanged(const ::storage::BucketLocator& bucket_locator, const std::string& cache_name) {
  GetForwardingInterface()->OnCacheContentChanged(
    std::move(bucket_locator)
    , 
    std::move(cache_name)
    );
}
CacheStorageObserverAsyncWaiter::CacheStorageObserverAsyncWaiter(
    CacheStorageObserver* proxy) : proxy_(proxy) {}

CacheStorageObserverAsyncWaiter::~CacheStorageObserverAsyncWaiter() = default;




void CacheStorageControlInterceptorForTesting::AddReceiver(const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy, ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> coep_reporter, const ::network::DocumentIsolationPolicy& document_isolation_policy, ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter> dip_reporter, const ::storage::BucketLocator& bucket_locator, CacheStorageOwner owner, ::mojo::PendingReceiver<::blink::mojom::CacheStorage> receiver) {
  GetForwardingInterface()->AddReceiver(
    std::move(cross_origin_embedder_policy)
    , 
    std::move(coep_reporter)
    , 
    std::move(document_isolation_policy)
    , 
    std::move(dip_reporter)
    , 
    std::move(bucket_locator)
    , 
    std::move(owner)
    , 
    std::move(receiver)
    );
}
void CacheStorageControlInterceptorForTesting::AddObserver(::mojo::PendingRemote<CacheStorageObserver> observer) {
  GetForwardingInterface()->AddObserver(
    std::move(observer)
    );
}
void CacheStorageControlInterceptorForTesting::ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates) {
  GetForwardingInterface()->ApplyPolicyUpdates(
    std::move(policy_updates)
    );
}
CacheStorageControlAsyncWaiter::CacheStorageControlAsyncWaiter(
    CacheStorageControl* proxy) : proxy_(proxy) {}

CacheStorageControlAsyncWaiter::~CacheStorageControlAsyncWaiter() = default;






}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif