// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Log_h
#define content_protocol_Log_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/runtime.h"
#include "content/browser/devtools/protocol/network.h"

namespace content {
namespace protocol {
namespace Log {
class LogEntry;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class CONTENT_EXPORT LogEntry : public ::crdtp::ProtocolObject<LogEntry> {
public:
    ~LogEntry() override { }

    struct CONTENT_EXPORT SourceEnum {
        static const char* Xml;
        static const char* Javascript;
        static const char* Network;
        static const char* Storage;
        static const char* Appcache;
        static const char* Rendering;
        static const char* Security;
        static const char* Deprecation;
        static const char* Worker;
        static const char* Violation;
        static const char* Intervention;
        static const char* Recommendation;
        static const char* Other;
    }; // SourceEnum

    String GetSource() { return m_source; }
    void SetSource(const String& value) { m_source = value; }

    struct CONTENT_EXPORT LevelEnum {
        static const char* Verbose;
        static const char* Info;
        static const char* Warning;
        static const char* Error;
    }; // LevelEnum

    String GetLevel() { return m_level; }
    void SetLevel(const String& value) { m_level = value; }

    String GetText() { return m_text; }
    void SetText(const String& value) { m_text = value; }

    struct CONTENT_EXPORT CategoryEnum {
        static const char* Cors;
    }; // CategoryEnum

    bool HasCategory() { return !!m_category; }
    String GetCategory(const String& defaultValue) const {
       return m_category.value_or(defaultValue);
    }
    const std::optional<String>& GetCategory() const {
       return m_category;
    }
    void SetCategory(const String& value) { m_category = value; }

    double GetTimestamp() { return m_timestamp; }
    void SetTimestamp(double value) { m_timestamp = value; }

    bool HasUrl() { return !!m_url; }
    String GetUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    const std::optional<String>& GetUrl() const {
       return m_url;
    }
    void SetUrl(const String& value) { m_url = value; }

    bool HasLineNumber() { return !!m_lineNumber; }
    int GetLineNumber(int defaultValue) const {
       return m_lineNumber.value_or(defaultValue);
    }
    const std::optional<int>& GetLineNumber() const {
       return m_lineNumber;
    }
    void SetLineNumber(int value) { m_lineNumber = value; }

    bool HasStackTrace() { return !!m_stackTrace; }
    protocol::Runtime::StackTrace* GetStackTrace(protocol::Runtime::StackTrace* defaultValue) {
       return m_stackTrace ? m_stackTrace.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::StackTrace>& GetStackTrace() const {
       return m_stackTrace;
    }
    void SetStackTrace(std::unique_ptr<protocol::Runtime::StackTrace> value) { m_stackTrace = std::move(value); }

    bool HasNetworkRequestId() { return !!m_networkRequestId; }
    String GetNetworkRequestId(const String& defaultValue) const {
       return m_networkRequestId.value_or(defaultValue);
    }
    const std::optional<String>& GetNetworkRequestId() const {
       return m_networkRequestId;
    }
    void SetNetworkRequestId(const String& value) { m_networkRequestId = value; }

    bool HasWorkerId() { return !!m_workerId; }
    String GetWorkerId(const String& defaultValue) const {
       return m_workerId.value_or(defaultValue);
    }
    const std::optional<String>& GetWorkerId() const {
       return m_workerId;
    }
    void SetWorkerId(const String& value) { m_workerId = value; }

    bool HasArgs() { return !!m_args; }
    protocol::Array<protocol::Runtime::RemoteObject>* GetArgs(protocol::Array<protocol::Runtime::RemoteObject>* defaultValue) {
       return m_args ? m_args.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Runtime::RemoteObject>>& GetArgs() const {
       return m_args;
    }
    void SetArgs(std::unique_ptr<protocol::Array<protocol::Runtime::RemoteObject>> value) { m_args = std::move(value); }

    template<int STATE>
    class LogEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceSet = 1 << 1,
            LevelSet = 1 << 2,
            TextSet = 1 << 3,
            TimestampSet = 1 << 4,
            AllFieldsSet = (SourceSet | LevelSet | TextSet | TimestampSet | 0)};


        LogEntryBuilder<STATE | SourceSet>& SetSource(const String& value)
        {
            static_assert(!(STATE & SourceSet), "property source should not be set yet");
            m_result->SetSource(value);
            return castState<SourceSet>();
        }

        LogEntryBuilder<STATE | LevelSet>& SetLevel(const String& value)
        {
            static_assert(!(STATE & LevelSet), "property level should not be set yet");
            m_result->SetLevel(value);
            return castState<LevelSet>();
        }

        LogEntryBuilder<STATE | TextSet>& SetText(const String& value)
        {
            static_assert(!(STATE & TextSet), "property text should not be set yet");
            m_result->SetText(value);
            return castState<TextSet>();
        }

        LogEntryBuilder<STATE>& SetCategory(const String& value)
        {
            m_result->SetCategory(value);
            return *this;
        }

        LogEntryBuilder<STATE | TimestampSet>& SetTimestamp(double value)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp should not be set yet");
            m_result->SetTimestamp(value);
            return castState<TimestampSet>();
        }

        LogEntryBuilder<STATE>& SetUrl(const String& value)
        {
            m_result->SetUrl(value);
            return *this;
        }

        LogEntryBuilder<STATE>& SetLineNumber(int value)
        {
            m_result->SetLineNumber(value);
            return *this;
        }

        LogEntryBuilder<STATE>& SetStackTrace(std::unique_ptr<protocol::Runtime::StackTrace> value)
        {
            m_result->SetStackTrace(std::move(value));
            return *this;
        }

        LogEntryBuilder<STATE>& SetNetworkRequestId(const String& value)
        {
            m_result->SetNetworkRequestId(value);
            return *this;
        }

        LogEntryBuilder<STATE>& SetWorkerId(const String& value)
        {
            m_result->SetWorkerId(value);
            return *this;
        }

        LogEntryBuilder<STATE>& SetArgs(std::unique_ptr<protocol::Array<protocol::Runtime::RemoteObject>> value)
        {
            m_result->SetArgs(std::move(value));
            return *this;
        }

        std::unique_ptr<LogEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LogEntry;
        LogEntryBuilder() : m_result(new LogEntry()) { }

        template<int STEP> LogEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LogEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Log::LogEntry> m_result;
    };

    static LogEntryBuilder<0> Create()
    {
        return LogEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LogEntry()
    {
          m_timestamp = 0;
    }

    String m_source;
    String m_level;
    String m_text;
    std::optional<String> m_category;
    double m_timestamp;
    std::optional<String> m_url;
    std::optional<int> m_lineNumber;
    std::unique_ptr<protocol::Runtime::StackTrace> m_stackTrace;
    std::optional<String> m_networkRequestId;
    std::optional<String> m_workerId;
    std::unique_ptr<protocol::Array<protocol::Runtime::RemoteObject>> m_args;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse Enable() = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void EntryAdded(std::unique_ptr<protocol::Log::LogEntry> entry);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Log
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Log_h)
