// extensions/common/mojom/service_worker_host.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_SERVICE_WORKER_HOST_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_SERVICE_WORKER_HOST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/service_worker_host.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/service_worker_host.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/service_worker_host.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/uuid.mojom.h"
#include "extensions/common/mojom/event_dispatcher.mojom-forward.h"
#include "extensions/common/mojom/extra_response_data.mojom-forward.h"
#include "extensions/common/mojom/frame.mojom-forward.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "extensions/common/mojom/message_port.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace extensions::mojom {

class ServiceWorkerHostProxy;

template <typename ImplRefTraits>
class ServiceWorkerHostStub;

class ServiceWorkerHostRequestValidator;
class ServiceWorkerHostResponseValidator;


class ServiceWorkerHost
    : public ServiceWorkerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerHostInterfaceBase;
  using Proxy_ = ServiceWorkerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerHostStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerHostRequestValidator;
  using ResponseValidator_ = ServiceWorkerHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDidInitializeServiceWorkerContextMinVersion = 0,
    kDidStartServiceWorkerContextMinVersion = 0,
    kDidStopServiceWorkerContextMinVersion = 0,
    kRequestWorkerMinVersion = 0,
    kWorkerResponseAckMinVersion = 0,
    kOpenChannelToExtensionMinVersion = 0,
    kOpenChannelToNativeAppMinVersion = 0,
    kOpenChannelToTabMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidInitializeServiceWorkerContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidStartServiceWorkerContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidStopServiceWorkerContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestWorker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WorkerResponseAck_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenChannelToExtension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenChannelToNativeApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenChannelToTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerHost() = default;

  
  virtual void DidInitializeServiceWorkerContext(const std::string& extension_id, int64_t service_worker_version_id, int32_t worker_thread_id, const ::blink::ServiceWorkerToken& service_worker_token, ::mojo::PendingAssociatedRemote<::extensions::mojom::EventDispatcher> event_dispatcher) = 0;

  
  virtual void DidStartServiceWorkerContext(const std::string& extension_id, const ::base::UnguessableToken& activation_token, const ::GURL& service_worker_scope, int64_t service_worker_version_id, int32_t worker_thread_id) = 0;

  
  virtual void DidStopServiceWorkerContext(const std::string& extension_id, const ::base::UnguessableToken& activation_token, const ::GURL& service_worker_scope, int64_t service_worker_version_id, int32_t worker_thread_id) = 0;


  using RequestWorkerCallback = base::OnceCallback<void(bool, ::base::Value::List, const std::string&, ::extensions::mojom::ExtraResponseDataPtr)>;
  
  virtual void RequestWorker(::extensions::mojom::RequestParamsPtr params, RequestWorkerCallback callback) = 0;

  
  virtual void WorkerResponseAck(const ::base::Uuid& request_uuid) = 0;

  
  virtual void OpenChannelToExtension(::extensions::mojom::ExternalConnectionInfoPtr info, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) = 0;

  
  virtual void OpenChannelToNativeApp(const std::string& native_app_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) = 0;

  
  virtual void OpenChannelToTab(int32_t tab_id, int32_t frame_id, const std::optional<std::string>& document_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) = 0;
};



class  ServiceWorkerHostProxy
    : public ServiceWorkerHost {
 public:
  using InterfaceType = ServiceWorkerHost;

  explicit ServiceWorkerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidInitializeServiceWorkerContext(const std::string& extension_id, int64_t service_worker_version_id, int32_t worker_thread_id, const ::blink::ServiceWorkerToken& service_worker_token, ::mojo::PendingAssociatedRemote<::extensions::mojom::EventDispatcher> event_dispatcher) final;
  
  void DidStartServiceWorkerContext(const std::string& extension_id, const ::base::UnguessableToken& activation_token, const ::GURL& service_worker_scope, int64_t service_worker_version_id, int32_t worker_thread_id) final;
  
  void DidStopServiceWorkerContext(const std::string& extension_id, const ::base::UnguessableToken& activation_token, const ::GURL& service_worker_scope, int64_t service_worker_version_id, int32_t worker_thread_id) final;
  
  void RequestWorker(::extensions::mojom::RequestParamsPtr params, RequestWorkerCallback callback) final;
  
  void WorkerResponseAck(const ::base::Uuid& request_uuid) final;
  
  void OpenChannelToExtension(::extensions::mojom::ExternalConnectionInfoPtr info, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) final;
  
  void OpenChannelToNativeApp(const std::string& native_app_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) final;
  
  void OpenChannelToTab(int32_t tab_id, int32_t frame_id, const std::optional<std::string>& document_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ServiceWorkerHostStubDispatch {
 public:
  static bool Accept(ServiceWorkerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerHost>>
class ServiceWorkerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerHostStub() = default;
  ~ServiceWorkerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServiceWorkerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // extensions::mojom

namespace mojo {

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_SERVICE_WORKER_HOST_MOJOM_H_