// gpu/ipc/common/mailbox.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_MAILBOX_MOJOM_H_
#define GPU_IPC_COMMON_MAILBOX_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/mailbox.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/mailbox.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/mailbox.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "gpu/ipc/common/mailbox_mojom_traits.h"
#include "gpu/gpu_export.h"




namespace gpu::mojom {








class GPU_EXPORT Mailbox {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Mailbox, T>::value>;
  using DataView = MailboxDataView;
  using Data_ = internal::Mailbox_Data;

  template <typename... Args>
  static MailboxPtr New(Args&&... args) {
    return MailboxPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MailboxPtr From(const U& u) {
    return mojo::TypeConverter<MailboxPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Mailbox>::Convert(*this);
  }


  Mailbox();

  explicit Mailbox(
      std::vector<int8_t> name);


  ~Mailbox();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MailboxPtr>
  MailboxPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Mailbox::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Mailbox::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Mailbox::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Mailbox::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Mailbox::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Mailbox_UnserializedMessageContext<
            UserType, Mailbox::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Mailbox::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Mailbox::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Mailbox_UnserializedMessageContext<
            UserType, Mailbox::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Mailbox::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<int8_t> name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Mailbox::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Mailbox::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Mailbox::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Mailbox::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MailboxPtr Mailbox::Clone() const {
  return New(
      mojo::Clone(name)
  );
}

template <typename T, Mailbox::EnableIfSame<T>*>
bool Mailbox::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  return true;
}

template <typename T, Mailbox::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  return false;
}


}  // gpu::mojom

namespace mojo {


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::Mailbox::DataView,
                                         ::gpu::mojom::MailboxPtr> {
  static bool IsNull(const ::gpu::mojom::MailboxPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::MailboxPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::Mailbox::name)& name(
      const ::gpu::mojom::MailboxPtr& input) {
    return input->name;
  }

  static bool Read(::gpu::mojom::Mailbox::DataView input, ::gpu::mojom::MailboxPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_MAILBOX_MOJOM_H_