// services/device/public/mojom/geoposition.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/geoposition.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/geoposition.mojom-params-data.h"
#include "services/device/public/mojom/geoposition.mojom-shared-message-ids.h"

#include "services/device/public/mojom/geoposition.mojom-blink-import-headers.h"
#include "services/device/public/mojom/geoposition.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
const char kGeoPermissionDeniedErrorMessage[] = "User denied geolocation permission";
const char kGeoPositionUnavailableErrorMessage[] = "Position update is unavailable";
Geoposition::Geoposition()
    : latitude(kBadLatitudeLongitude),
      longitude(kBadLatitudeLongitude),
      altitude(kBadAltitude),
      accuracy(kBadAccuracy),
      altitude_accuracy(kBadAccuracy),
      heading(kBadHeading),
      speed(kBadSpeed),
      timestamp() {}

Geoposition::Geoposition(
    double latitude_in,
    double longitude_in,
    double altitude_in,
    double accuracy_in,
    double altitude_accuracy_in,
    double heading_in,
    double speed_in,
    ::base::Time timestamp_in)
    : latitude(std::move(latitude_in)),
      longitude(std::move(longitude_in)),
      altitude(std::move(altitude_in)),
      accuracy(std::move(accuracy_in)),
      altitude_accuracy(std::move(altitude_accuracy_in)),
      heading(std::move(heading_in)),
      speed(std::move(speed_in)),
      timestamp(std::move(timestamp_in)) {}

Geoposition::~Geoposition() = default;

void Geoposition::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latitude"), this->latitude,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "longitude"), this->longitude,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "altitude"), this->altitude,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accuracy"), this->accuracy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "altitude_accuracy"), this->altitude_accuracy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "heading"), this->heading,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "speed"), this->speed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Geoposition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GeopositionError::GeopositionError()
    : error_code(),
      error_message(),
      error_technical() {}

GeopositionError::GeopositionError(
    GeopositionErrorCode error_code_in,
    const WTF::String& error_message_in,
    const WTF::String& error_technical_in)
    : error_code(std::move(error_code_in)),
      error_message(std::move(error_message_in)),
      error_technical(std::move(error_technical_in)) {}

GeopositionError::~GeopositionError() = default;
size_t GeopositionError::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->error_code);
  seed = mojo::internal::WTFHash(seed, this->error_message);
  seed = mojo::internal::WTFHash(seed, this->error_technical);
  return seed;
}

void GeopositionError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_code"), this->error_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GeopositionErrorCode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_message"), this->error_message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_technical"), this->error_technical,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GeopositionError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GeopositionResult::GeopositionResult() : tag_(Tag::kPosition) {
  data_.position = new GeopositionPtr;
}

GeopositionResult::~GeopositionResult() {
  DestroyActive();
}


void GeopositionResult::set_position(
    GeopositionPtr position) {
  if (tag_ == Tag::kPosition) {
    *(data_.position) = std::move(position);
  } else {
    DestroyActive();
    tag_ = Tag::kPosition;
    data_.position = new GeopositionPtr(
        std::move(position));
  }
}
void GeopositionResult::set_error(
    GeopositionErrorPtr error) {
  if (tag_ == Tag::kError) {
    *(data_.error) = std::move(error);
  } else {
    DestroyActive();
    tag_ = Tag::kError;
    data_.error = new GeopositionErrorPtr(
        std::move(error));
  }
}

void GeopositionResult::DestroyActive() {
  switch (tag_) {

    case Tag::kPosition:

      delete data_.position;
      break;
    case Tag::kError:

      delete data_.error;
      break;
  }
}

bool GeopositionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // device::mojom::blink


namespace mojo {


// static
bool StructTraits<::device::mojom::blink::Geoposition::DataView, ::device::mojom::blink::GeopositionPtr>::Read(
    ::device::mojom::blink::Geoposition::DataView input,
    ::device::mojom::blink::GeopositionPtr* output) {
  bool success = true;
  ::device::mojom::blink::GeopositionPtr result(::device::mojom::blink::Geoposition::New());
  
      if (success)
        result->latitude = input.latitude();
      if (success)
        result->longitude = input.longitude();
      if (success)
        result->altitude = input.altitude();
      if (success)
        result->accuracy = input.accuracy();
      if (success)
        result->altitude_accuracy = input.altitude_accuracy();
      if (success)
        result->heading = input.heading();
      if (success)
        result->speed = input.speed();
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::GeopositionError::DataView, ::device::mojom::blink::GeopositionErrorPtr>::Read(
    ::device::mojom::blink::GeopositionError::DataView input,
    ::device::mojom::blink::GeopositionErrorPtr* output) {
  bool success = true;
  ::device::mojom::blink::GeopositionErrorPtr result(::device::mojom::blink::GeopositionError::New());
  
      if (success && !input.ReadErrorCode(&result->error_code))
        success = false;
      if (success && !input.ReadErrorMessage(&result->error_message))
        success = false;
      if (success && !input.ReadErrorTechnical(&result->error_technical))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::device::mojom::blink::GeopositionResult::DataView, ::device::mojom::blink::GeopositionResultPtr>::Read(
    ::device::mojom::blink::GeopositionResult::DataView input,
    ::device::mojom::blink::GeopositionResultPtr* output) {
  using UnionType = ::device::mojom::blink::GeopositionResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPosition: {
      ::device::mojom::blink::GeopositionPtr result_position;
      if (!input.ReadPosition(&result_position))
        return false;

      *output = UnionType::NewPosition(
          std::move(result_position));
      break;
    }
    case Tag::kError: {
      ::device::mojom::blink::GeopositionErrorPtr result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(
          std::move(result_error));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {




}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif