// services/network/public/mojom/reporting_service.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/reporting_service.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/reporting_service.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/reporting_service.mojom-blink-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/values.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class ReportingApiObserverProxy;

template <typename ImplRefTraits>
class ReportingApiObserverStub;

class ReportingApiObserverRequestValidator;


class BLINK_PLATFORM_EXPORT ReportingApiObserver
    : public ReportingApiObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ReportingApiObserverInterfaceBase;
  using Proxy_ = ReportingApiObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = ReportingApiObserverStub<ImplRefTraits>;

  using RequestValidator_ = ReportingApiObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnReportAddedMinVersion = 0,
    kOnReportUpdatedMinVersion = 0,
    kOnEndpointsUpdatedForOriginMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnReportAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReportUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnEndpointsUpdatedForOrigin_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ReportingApiObserver() = default;

  
  virtual void OnReportAdded(ReportingApiReportPtr report) = 0;

  
  virtual void OnReportUpdated(ReportingApiReportPtr report) = 0;

  
  virtual void OnEndpointsUpdatedForOrigin(WTF::Vector<ReportingApiEndpointPtr> endpoints) = 0;
};



class BLINK_PLATFORM_EXPORT ReportingApiObserverProxy
    : public ReportingApiObserver {
 public:
  using InterfaceType = ReportingApiObserver;

  explicit ReportingApiObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnReportAdded(ReportingApiReportPtr report) final;
  
  void OnReportUpdated(ReportingApiReportPtr report) final;
  
  void OnEndpointsUpdatedForOrigin(WTF::Vector<ReportingApiEndpointPtr> endpoints) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT ReportingApiObserverStubDispatch {
 public:
  static bool Accept(ReportingApiObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ReportingApiObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ReportingApiObserver>>
class ReportingApiObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ReportingApiObserverStub() = default;
  ~ReportingApiObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ReportingApiObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ReportingApiObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ReportingApiObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_PLATFORM_EXPORT ReportingApiReport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReportingApiReport, T>::value>;
  using DataView = ReportingApiReportDataView;
  using Data_ = internal::ReportingApiReport_Data;

  template <typename... Args>
  static ReportingApiReportPtr New(Args&&... args) {
    return ReportingApiReportPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReportingApiReportPtr From(const U& u) {
    return mojo::TypeConverter<ReportingApiReportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReportingApiReport>::Convert(*this);
  }


  ReportingApiReport();

  ReportingApiReport(
      const ::base::UnguessableToken& id,
      const ::blink::KURL& url,
      const WTF::String& group,
      const WTF::String& type,
      ::base::TimeTicks timestamp,
      int32_t depth,
      int32_t attempts,
      ::base::Value::Dict body,
      ReportingApiReportStatus status);

ReportingApiReport(const ReportingApiReport&) = delete;
ReportingApiReport& operator=(const ReportingApiReport&) = delete;

  ~ReportingApiReport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReportingApiReportPtr>
  ReportingApiReportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReportingApiReport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReportingApiReport::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReportingApiReport::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReportingApiReport::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReportingApiReport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReportingApiReport_UnserializedMessageContext<
            UserType, ReportingApiReport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReportingApiReport::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReportingApiReport::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReportingApiReport_UnserializedMessageContext<
            UserType, ReportingApiReport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReportingApiReport::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken id;
  
  ::blink::KURL url;
  
  WTF::String group;
  
  WTF::String type;
  
  ::base::TimeTicks timestamp;
  
  int32_t depth;
  
  int32_t attempts;
  
  ::base::Value::Dict body;
  
  ReportingApiReportStatus status;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReportingApiReport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReportingApiReport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReportingApiReport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReportingApiReport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT ReportingApiEndpoint {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReportingApiEndpoint, T>::value>;
  using DataView = ReportingApiEndpointDataView;
  using Data_ = internal::ReportingApiEndpoint_Data;

  template <typename... Args>
  static ReportingApiEndpointPtr New(Args&&... args) {
    return ReportingApiEndpointPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReportingApiEndpointPtr From(const U& u) {
    return mojo::TypeConverter<ReportingApiEndpointPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReportingApiEndpoint>::Convert(*this);
  }


  ReportingApiEndpoint();

  ReportingApiEndpoint(
      const ::blink::KURL& url,
      int32_t attempted_uploads,
      int32_t successful_uploads,
      int32_t attempted_reports,
      int32_t successful_reports,
      int32_t priority,
      int32_t weight,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& origin,
      const WTF::String& group_name,
      ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key,
      const std::optional<::base::UnguessableToken>& reporting_source);

ReportingApiEndpoint(const ReportingApiEndpoint&) = delete;
ReportingApiEndpoint& operator=(const ReportingApiEndpoint&) = delete;

  ~ReportingApiEndpoint();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReportingApiEndpointPtr>
  ReportingApiEndpointPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReportingApiEndpoint::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReportingApiEndpoint::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReportingApiEndpoint::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReportingApiEndpoint::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReportingApiEndpoint::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReportingApiEndpoint_UnserializedMessageContext<
            UserType, ReportingApiEndpoint::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReportingApiEndpoint::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReportingApiEndpoint::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReportingApiEndpoint_UnserializedMessageContext<
            UserType, ReportingApiEndpoint::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReportingApiEndpoint::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  int32_t attempted_uploads;
  
  int32_t successful_uploads;
  
  int32_t attempted_reports;
  
  int32_t successful_reports;
  
  int32_t priority;
  
  int32_t weight;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> origin;
  
  WTF::String group_name;
  
  ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key;
  
  std::optional<::base::UnguessableToken> reporting_source;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReportingApiEndpoint::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReportingApiEndpoint::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReportingApiEndpoint::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReportingApiEndpoint::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ReportingApiReportPtr ReportingApiReport::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(url),
      mojo::Clone(group),
      mojo::Clone(type),
      mojo::Clone(timestamp),
      mojo::Clone(depth),
      mojo::Clone(attempts),
      mojo::Clone(body),
      mojo::Clone(status)
  );
}

template <typename T, ReportingApiReport::EnableIfSame<T>*>
bool ReportingApiReport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->group, other_struct.group))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->depth, other_struct.depth))
    return false;
  if (!mojo::Equals(this->attempts, other_struct.attempts))
    return false;
  if (!mojo::Equals(this->body, other_struct.body))
    return false;
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  return true;
}

template <typename T, ReportingApiReport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.group < rhs.group)
    return true;
  if (rhs.group < lhs.group)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.depth < rhs.depth)
    return true;
  if (rhs.depth < lhs.depth)
    return false;
  if (lhs.attempts < rhs.attempts)
    return true;
  if (rhs.attempts < lhs.attempts)
    return false;
  if (lhs.body < rhs.body)
    return true;
  if (rhs.body < lhs.body)
    return false;
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  return false;
}
template <typename StructPtrType>
ReportingApiEndpointPtr ReportingApiEndpoint::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(attempted_uploads),
      mojo::Clone(successful_uploads),
      mojo::Clone(attempted_reports),
      mojo::Clone(successful_reports),
      mojo::Clone(priority),
      mojo::Clone(weight),
      mojo::Clone(origin),
      mojo::Clone(group_name),
      mojo::Clone(network_anonymization_key),
      mojo::Clone(reporting_source)
  );
}

template <typename T, ReportingApiEndpoint::EnableIfSame<T>*>
bool ReportingApiEndpoint::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->attempted_uploads, other_struct.attempted_uploads))
    return false;
  if (!mojo::Equals(this->successful_uploads, other_struct.successful_uploads))
    return false;
  if (!mojo::Equals(this->attempted_reports, other_struct.attempted_reports))
    return false;
  if (!mojo::Equals(this->successful_reports, other_struct.successful_reports))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  if (!mojo::Equals(this->weight, other_struct.weight))
    return false;
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->group_name, other_struct.group_name))
    return false;
  if (!mojo::Equals(this->network_anonymization_key, other_struct.network_anonymization_key))
    return false;
  if (!mojo::Equals(this->reporting_source, other_struct.reporting_source))
    return false;
  return true;
}

template <typename T, ReportingApiEndpoint::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.attempted_uploads < rhs.attempted_uploads)
    return true;
  if (rhs.attempted_uploads < lhs.attempted_uploads)
    return false;
  if (lhs.successful_uploads < rhs.successful_uploads)
    return true;
  if (rhs.successful_uploads < lhs.successful_uploads)
    return false;
  if (lhs.attempted_reports < rhs.attempted_reports)
    return true;
  if (rhs.attempted_reports < lhs.attempted_reports)
    return false;
  if (lhs.successful_reports < rhs.successful_reports)
    return true;
  if (rhs.successful_reports < lhs.successful_reports)
    return false;
  if (lhs.priority < rhs.priority)
    return true;
  if (rhs.priority < lhs.priority)
    return false;
  if (lhs.weight < rhs.weight)
    return true;
  if (rhs.weight < lhs.weight)
    return false;
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.group_name < rhs.group_name)
    return true;
  if (rhs.group_name < lhs.group_name)
    return false;
  if (lhs.network_anonymization_key < rhs.network_anonymization_key)
    return true;
  if (rhs.network_anonymization_key < lhs.network_anonymization_key)
    return false;
  if (lhs.reporting_source < rhs.reporting_source)
    return true;
  if (rhs.reporting_source < lhs.reporting_source)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ReportingApiReport::DataView,
                                         ::network::mojom::blink::ReportingApiReportPtr> {
  static bool IsNull(const ::network::mojom::blink::ReportingApiReportPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ReportingApiReportPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ReportingApiReport::id)& id(
      const ::network::mojom::blink::ReportingApiReportPtr& input) {
    return input->id;
  }

  static const decltype(::network::mojom::blink::ReportingApiReport::url)& url(
      const ::network::mojom::blink::ReportingApiReportPtr& input) {
    return input->url;
  }

  static const decltype(::network::mojom::blink::ReportingApiReport::group)& group(
      const ::network::mojom::blink::ReportingApiReportPtr& input) {
    return input->group;
  }

  static const decltype(::network::mojom::blink::ReportingApiReport::type)& type(
      const ::network::mojom::blink::ReportingApiReportPtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::blink::ReportingApiReport::timestamp)& timestamp(
      const ::network::mojom::blink::ReportingApiReportPtr& input) {
    return input->timestamp;
  }

  static decltype(::network::mojom::blink::ReportingApiReport::depth) depth(
      const ::network::mojom::blink::ReportingApiReportPtr& input) {
    return input->depth;
  }

  static decltype(::network::mojom::blink::ReportingApiReport::attempts) attempts(
      const ::network::mojom::blink::ReportingApiReportPtr& input) {
    return input->attempts;
  }

  static const decltype(::network::mojom::blink::ReportingApiReport::body)& body(
      const ::network::mojom::blink::ReportingApiReportPtr& input) {
    return input->body;
  }

  static decltype(::network::mojom::blink::ReportingApiReport::status) status(
      const ::network::mojom::blink::ReportingApiReportPtr& input) {
    return input->status;
  }

  static bool Read(::network::mojom::blink::ReportingApiReport::DataView input, ::network::mojom::blink::ReportingApiReportPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ReportingApiEndpoint::DataView,
                                         ::network::mojom::blink::ReportingApiEndpointPtr> {
  static bool IsNull(const ::network::mojom::blink::ReportingApiEndpointPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ReportingApiEndpointPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ReportingApiEndpoint::url)& url(
      const ::network::mojom::blink::ReportingApiEndpointPtr& input) {
    return input->url;
  }

  static decltype(::network::mojom::blink::ReportingApiEndpoint::attempted_uploads) attempted_uploads(
      const ::network::mojom::blink::ReportingApiEndpointPtr& input) {
    return input->attempted_uploads;
  }

  static decltype(::network::mojom::blink::ReportingApiEndpoint::successful_uploads) successful_uploads(
      const ::network::mojom::blink::ReportingApiEndpointPtr& input) {
    return input->successful_uploads;
  }

  static decltype(::network::mojom::blink::ReportingApiEndpoint::attempted_reports) attempted_reports(
      const ::network::mojom::blink::ReportingApiEndpointPtr& input) {
    return input->attempted_reports;
  }

  static decltype(::network::mojom::blink::ReportingApiEndpoint::successful_reports) successful_reports(
      const ::network::mojom::blink::ReportingApiEndpointPtr& input) {
    return input->successful_reports;
  }

  static decltype(::network::mojom::blink::ReportingApiEndpoint::priority) priority(
      const ::network::mojom::blink::ReportingApiEndpointPtr& input) {
    return input->priority;
  }

  static decltype(::network::mojom::blink::ReportingApiEndpoint::weight) weight(
      const ::network::mojom::blink::ReportingApiEndpointPtr& input) {
    return input->weight;
  }

  static const decltype(::network::mojom::blink::ReportingApiEndpoint::origin)& origin(
      const ::network::mojom::blink::ReportingApiEndpointPtr& input) {
    return input->origin;
  }

  static const decltype(::network::mojom::blink::ReportingApiEndpoint::group_name)& group_name(
      const ::network::mojom::blink::ReportingApiEndpointPtr& input) {
    return input->group_name;
  }

  static const decltype(::network::mojom::blink::ReportingApiEndpoint::network_anonymization_key)& network_anonymization_key(
      const ::network::mojom::blink::ReportingApiEndpointPtr& input) {
    return input->network_anonymization_key;
  }

  static const decltype(::network::mojom::blink::ReportingApiEndpoint::reporting_source)& reporting_source(
      const ::network::mojom::blink::ReportingApiEndpointPtr& input) {
    return input->reporting_source;
  }

  static bool Read(::network::mojom::blink::ReportingApiEndpoint::DataView input, ::network::mojom::blink::ReportingApiEndpointPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_BLINK_H_