// services/network/public/mojom/udp_socket.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/udp_socket.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/optional_bool.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class UDPSocketOptionsDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::UDPSocketOptionsDataView> {
  using Data = ::network::mojom::internal::UDPSocketOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class UDPSocketInterfaceBase {};

using UDPSocketPtrDataView =
    mojo::InterfacePtrDataView<UDPSocketInterfaceBase>;
using UDPSocketRequestDataView =
    mojo::InterfaceRequestDataView<UDPSocketInterfaceBase>;
using UDPSocketAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UDPSocketInterfaceBase>;
using UDPSocketAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UDPSocketInterfaceBase>;
class UDPSocketListenerInterfaceBase {};

using UDPSocketListenerPtrDataView =
    mojo::InterfacePtrDataView<UDPSocketListenerInterfaceBase>;
using UDPSocketListenerRequestDataView =
    mojo::InterfaceRequestDataView<UDPSocketListenerInterfaceBase>;
using UDPSocketListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UDPSocketListenerInterfaceBase>;
using UDPSocketListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UDPSocketListenerInterfaceBase>;


class UDPSocketOptionsDataView {
 public:
  UDPSocketOptionsDataView() = default;

  UDPSocketOptionsDataView(
      internal::UDPSocketOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool allow_address_reuse() const {
    return data_->allow_address_reuse;
  }
  bool allow_broadcast() const {
    return data_->allow_broadcast;
  }
  bool allow_address_sharing_for_multicast() const {
    return data_->allow_address_sharing_for_multicast;
  }
  uint32_t multicast_interface() const {
    return data_->multicast_interface;
  }
  uint32_t multicast_time_to_live() const {
    return data_->multicast_time_to_live;
  }
  bool multicast_loopback_mode() const {
    return data_->multicast_loopback_mode;
  }
  int32_t send_buffer_size() const {
    return data_->send_buffer_size;
  }
  int32_t receive_buffer_size() const {
    return data_->receive_buffer_size;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadIpv6Only(UserType* output) const {
    auto data_value = data_->ipv6_only;
    return mojo::internal::Deserialize<::network::mojom::OptionalBool>(
        data_value, output);
  }
  ::network::mojom::OptionalBool ipv6_only() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::OptionalBool>(data_->ipv6_only));
  }
 private:
  internal::UDPSocketOptions_Data* data_ = nullptr;
};


}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::UDPSocketOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::UDPSocketOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::UDPSocketOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->allow_address_reuse = Traits::allow_address_reuse(input);
    fragment->allow_broadcast = Traits::allow_broadcast(input);
    fragment->allow_address_sharing_for_multicast = Traits::allow_address_sharing_for_multicast(input);
    fragment->multicast_interface = Traits::multicast_interface(input);
    fragment->multicast_time_to_live = Traits::multicast_time_to_live(input);
    fragment->multicast_loopback_mode = Traits::multicast_loopback_mode(input);
    fragment->send_buffer_size = Traits::send_buffer_size(input);
    fragment->receive_buffer_size = Traits::receive_buffer_size(input);
    mojo::internal::Serialize<::network::mojom::OptionalBool>(
        Traits::ipv6_only(input), &fragment->ipv6_only);
  }

  static bool Deserialize(::network::mojom::internal::UDPSocketOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::UDPSocketOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {




}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_SHARED_H_