// services/viz/public/mojom/compositing/filter_operation.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/filter_operation.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/filter_operation.mojom-params-data.h"
namespace viz {
namespace mojom {

NOINLINE static const char* FilterTypeToStringHelper(FilterType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FilterType::GRAYSCALE:
      return "GRAYSCALE";
    case FilterType::SEPIA:
      return "SEPIA";
    case FilterType::SATURATE:
      return "SATURATE";
    case FilterType::HUE_ROTATE:
      return "HUE_ROTATE";
    case FilterType::INVERT:
      return "INVERT";
    case FilterType::BRIGHTNESS:
      return "BRIGHTNESS";
    case FilterType::CONTRAST:
      return "CONTRAST";
    case FilterType::OPACITY:
      return "OPACITY";
    case FilterType::BLUR:
      return "BLUR";
    case FilterType::DROP_SHADOW:
      return "DROP_SHADOW";
    case FilterType::COLOR_MATRIX:
      return "COLOR_MATRIX";
    case FilterType::ZOOM:
      return "ZOOM";
    case FilterType::REFERENCE:
      return "REFERENCE";
    case FilterType::SATURATING_BRIGHTNESS:
      return "SATURATING_BRIGHTNESS";
    case FilterType::ALPHA_THRESHOLD:
      return "ALPHA_THRESHOLD";
    case FilterType::OFFSET:
      return "{OFFSET, FILTER_TYPE_LAST}";
    default:
      return nullptr;
  }
}

std::string FilterTypeToString(FilterType value) {
  const char *str = FilterTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FilterType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FilterType value) {
  return os << FilterTypeToString(value);
}

namespace internal {


// static
bool FilterOperation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FilterOperation_Data* object =
      static_cast<const FilterOperation_Data*>(data);


  if (!::viz::mojom::internal::FilterType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->offset, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->offset, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->drop_shadow_color, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->drop_shadow_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_filter, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_filter, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& matrix_validate_params =
      mojo::internal::GetArrayValidator<20, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->matrix, validation_context,
                                         &matrix_validate_params)) {
    return false;
  }


  if (!::skia::mojom::internal::TileMode_Data
        ::Validate(object->blur_tile_mode, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& shape_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->shape, validation_context,
                                         &shape_validate_params)) {
    return false;
  }

  return true;
}

FilterOperation_Data::FilterOperation_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::FilterType>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::FilterType value) {
  return std::move(context).WriteString(::viz::mojom::FilterTypeToString(value));
}

} // namespace perfetto