// services/viz/public/mojom/compositing/frame_deadline.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_DEADLINE_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_DEADLINE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/frame_deadline.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"







namespace viz::mojom {
class FrameDeadlineDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::FrameDeadlineDataView> {
  using Data = ::viz::mojom::internal::FrameDeadline_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class FrameDeadlineDataView {
 public:
  FrameDeadlineDataView() = default;

  FrameDeadlineDataView(
      internal::FrameDeadline_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameStartTime(UserType* output) {
    
    auto* pointer = data_->frame_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  uint32_t deadline_in_frames() const {
    return data_->deadline_in_frames;
  }
  inline void GetFrameIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameInterval(UserType* output) {
    
    auto* pointer = data_->frame_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool use_default_lower_bound_deadline() const {
    return data_->use_default_lower_bound_deadline;
  }
 private:
  internal::FrameDeadline_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::FrameDeadlineDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::FrameDeadlineDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::FrameDeadline_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame_start_time(input)) in_frame_start_time = Traits::frame_start_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_start_time)::BaseType> frame_start_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_frame_start_time, frame_start_time_fragment);
    fragment->frame_start_time.Set(
        frame_start_time_fragment.is_null() ? nullptr : frame_start_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_start_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_start_time in FrameDeadline struct");
    fragment->deadline_in_frames = Traits::deadline_in_frames(input);
    decltype(Traits::frame_interval(input)) in_frame_interval = Traits::frame_interval(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_interval)::BaseType> frame_interval_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_frame_interval, frame_interval_fragment);
    fragment->frame_interval.Set(
        frame_interval_fragment.is_null() ? nullptr : frame_interval_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_interval.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_interval in FrameDeadline struct");
    fragment->use_default_lower_bound_deadline = Traits::use_default_lower_bound_deadline(input);
  }

  static bool Deserialize(::viz::mojom::internal::FrameDeadline_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::FrameDeadlineDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void FrameDeadlineDataView::GetFrameStartTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->frame_start_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void FrameDeadlineDataView::GetFrameIntervalDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->frame_interval.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_DEADLINE_MOJOM_SHARED_H_