// services/viz/public/mojom/compositing/shared_image_format.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/shared_image_format.mojom-params-data.h"
namespace viz {
namespace mojom {

NOINLINE static const char* PlaneConfigToStringHelper(PlaneConfig value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PlaneConfig::kY_U_V:
      return "kY_U_V";
    case PlaneConfig::kY_V_U:
      return "kY_V_U";
    case PlaneConfig::kY_UV:
      return "kY_UV";
    case PlaneConfig::kY_UV_A:
      return "kY_UV_A";
    case PlaneConfig::kY_U_V_A:
      return "kY_U_V_A";
    default:
      return nullptr;
  }
}

std::string PlaneConfigToString(PlaneConfig value) {
  const char *str = PlaneConfigToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PlaneConfig value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PlaneConfig value) {
  return os << PlaneConfigToString(value);
}

NOINLINE static const char* SubsamplingToStringHelper(Subsampling value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Subsampling::k420:
      return "k420";
    case Subsampling::k422:
      return "k422";
    case Subsampling::k444:
      return "k444";
    default:
      return nullptr;
  }
}

std::string SubsamplingToString(Subsampling value) {
  const char *str = SubsamplingToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Subsampling value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Subsampling value) {
  return os << SubsamplingToString(value);
}

NOINLINE static const char* ChannelFormatToStringHelper(ChannelFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ChannelFormat::k8:
      return "k8";
    case ChannelFormat::k10:
      return "k10";
    case ChannelFormat::k16:
      return "k16";
    case ChannelFormat::k16F:
      return "k16F";
    default:
      return nullptr;
  }
}

std::string ChannelFormatToString(ChannelFormat value) {
  const char *str = ChannelFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ChannelFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ChannelFormat value) {
  return os << ChannelFormatToString(value);
}

namespace internal {
// static
bool SharedImageFormat_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SharedImageFormat_Data* object = static_cast<const SharedImageFormat_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SharedImageFormat_Tag::kSingleplanarFormat: {


      if (!::viz::mojom::internal::SingleplanarFormat_Data
            ::Validate(object->data.f_singleplanar_format, validation_context))
        return false;
      return true;
    }
    case SharedImageFormat_Tag::kMultiplanarFormat: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_multiplanar_format, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_multiplanar_format, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SharedImageFormat");
      return false;
    }
  }
}


// static
bool MultiplanarFormat_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MultiplanarFormat_Data* object =
      static_cast<const MultiplanarFormat_Data*>(data);


  if (!::viz::mojom::internal::PlaneConfig_Data
        ::Validate(object->plane_config, validation_context))
    return false;


  if (!::viz::mojom::internal::Subsampling_Data
        ::Validate(object->subsampling, validation_context))
    return false;


  if (!::viz::mojom::internal::ChannelFormat_Data
        ::Validate(object->channel_format, validation_context))
    return false;

  return true;
}

MultiplanarFormat_Data::MultiplanarFormat_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::PlaneConfig>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::PlaneConfig value) {
  return std::move(context).WriteString(::viz::mojom::PlaneConfigToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::Subsampling>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::Subsampling value) {
  return std::move(context).WriteString(::viz::mojom::SubsamplingToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::ChannelFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::ChannelFormat value) {
  return std::move(context).WriteString(::viz::mojom::ChannelFormatToString(value));
}

} // namespace perfetto