// third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {
// static
bool FileSystemAccessChangeType_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const FileSystemAccessChangeType_Data* object = static_cast<const FileSystemAccessChangeType_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case FileSystemAccessChangeType_Tag::kAppeared: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_appeared, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_appeared, validation_context))
        return false;
      return true;
    }
    case FileSystemAccessChangeType_Tag::kDisappeared: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_disappeared, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_disappeared, validation_context))
        return false;
      return true;
    }
    case FileSystemAccessChangeType_Tag::kErrored: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_errored, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_errored, validation_context))
        return false;
      return true;
    }
    case FileSystemAccessChangeType_Tag::kModified: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_modified, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_modified, validation_context))
        return false;
      return true;
    }
    case FileSystemAccessChangeType_Tag::kMoved: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_moved, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_moved, validation_context))
        return false;
      return true;
    }
    case FileSystemAccessChangeType_Tag::kUnknown: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_unknown, 6, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_unknown, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in FileSystemAccessChangeType");
      return false;
    }
  }
}


// static
bool FileSystemAccessChangeTypeAppeared_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessChangeTypeAppeared_Data* object =
      static_cast<const FileSystemAccessChangeTypeAppeared_Data*>(data);

  return true;
}

FileSystemAccessChangeTypeAppeared_Data::FileSystemAccessChangeTypeAppeared_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessChangeTypeDisappeared_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessChangeTypeDisappeared_Data* object =
      static_cast<const FileSystemAccessChangeTypeDisappeared_Data*>(data);

  return true;
}

FileSystemAccessChangeTypeDisappeared_Data::FileSystemAccessChangeTypeDisappeared_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessChangeTypeErrored_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessChangeTypeErrored_Data* object =
      static_cast<const FileSystemAccessChangeTypeErrored_Data*>(data);

  return true;
}

FileSystemAccessChangeTypeErrored_Data::FileSystemAccessChangeTypeErrored_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessChangeTypeModified_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessChangeTypeModified_Data* object =
      static_cast<const FileSystemAccessChangeTypeModified_Data*>(data);

  return true;
}

FileSystemAccessChangeTypeModified_Data::FileSystemAccessChangeTypeModified_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessChangeTypeMoved_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessChangeTypeMoved_Data* object =
      static_cast<const FileSystemAccessChangeTypeMoved_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& former_relative_path_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->former_relative_path, validation_context,
                                         &former_relative_path_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessChangeTypeMoved_Data::FileSystemAccessChangeTypeMoved_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessChangeTypeUnknown_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessChangeTypeUnknown_Data* object =
      static_cast<const FileSystemAccessChangeTypeUnknown_Data*>(data);

  return true;
}

FileSystemAccessChangeTypeUnknown_Data::FileSystemAccessChangeTypeUnknown_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessChangeMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessChangeMetadata_Data* object =
      static_cast<const FileSystemAccessChangeMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->changed_entry, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->changed_entry, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_path, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& relative_path_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->relative_path, validation_context,
                                         &relative_path_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessChangeMetadata_Data::FileSystemAccessChangeMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessChange_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessChange_Data* object =
      static_cast<const FileSystemAccessChange_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->type, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->type, validation_context))
    return false;

  return true;
}

FileSystemAccessChange_Data::FileSystemAccessChange_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemAccessObserver_OnFileChanges_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemAccessObserver_OnFileChanges_Params_Data* object =
      static_cast<const FileSystemAccessObserver_OnFileChanges_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->changes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& changes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->changes, validation_context,
                                         &changes_validate_params)) {
    return false;
  }

  return true;
}

FileSystemAccessObserver_OnFileChanges_Params_Data::FileSystemAccessObserver_OnFileChanges_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink