// third_party/blink/public/mojom/payments/payment_request.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/payments/payment_request.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/payments/payment_request.mojom-params-data.h"
#include "third_party/blink/public/mojom/payments/payment_request.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/payments/payment_request.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/payments/payment_request.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace payments::mojom::blink {
PaymentResponse::PaymentResponse()
    : method_name(),
      stringified_details(),
      shipping_address(),
      shipping_option(),
      payer(),
      get_assertion_authenticator_response() {}

PaymentResponse::PaymentResponse(
    const WTF::String& method_name_in,
    const WTF::String& stringified_details_in,
    ::payments::mojom::blink::PaymentAddressPtr shipping_address_in,
    const WTF::String& shipping_option_in,
    PayerDetailPtr payer_in,
    ::blink::mojom::blink::GetAssertionAuthenticatorResponsePtr get_assertion_authenticator_response_in)
    : method_name(std::move(method_name_in)),
      stringified_details(std::move(stringified_details_in)),
      shipping_address(std::move(shipping_address_in)),
      shipping_option(std::move(shipping_option_in)),
      payer(std::move(payer_in)),
      get_assertion_authenticator_response(std::move(get_assertion_authenticator_response_in)) {}

PaymentResponse::~PaymentResponse() = default;

void PaymentResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method_name"), this->method_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stringified_details"), this->stringified_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_address"), this->shipping_address,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::blink::PaymentAddressPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_option"), this->shipping_option,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payer"), this->payer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PayerDetailPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "get_assertion_authenticator_response"), this->get_assertion_authenticator_response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::GetAssertionAuthenticatorResponsePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PayerDetail::PayerDetail()
    : email(),
      name(),
      phone() {}

PayerDetail::PayerDetail(
    const WTF::String& email_in,
    const WTF::String& name_in,
    const WTF::String& phone_in)
    : email(std::move(email_in)),
      name(std::move(name_in)),
      phone(std::move(phone_in)) {}

PayerDetail::~PayerDetail() = default;

void PayerDetail::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "email"), this->email,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "phone"), this->phone,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PayerDetail::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentItem::PaymentItem()
    : label(),
      amount(),
      pending() {}

PaymentItem::PaymentItem(
    const WTF::String& label_in,
    ::payments::mojom::blink::PaymentCurrencyAmountPtr amount_in,
    bool pending_in)
    : label(std::move(label_in)),
      amount(std::move(amount_in)),
      pending(std::move(pending_in)) {}

PaymentItem::~PaymentItem() = default;
size_t PaymentItem::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->label);
  seed = mojo::internal::WTFHash(seed, this->amount);
  seed = mojo::internal::WTFHash(seed, this->pending);
  return seed;
}

void PaymentItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "amount"), this->amount,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::blink::PaymentCurrencyAmountPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pending"), this->pending,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentShippingOption::PaymentShippingOption()
    : id(),
      label(),
      amount(),
      selected() {}

PaymentShippingOption::PaymentShippingOption(
    const WTF::String& id_in,
    const WTF::String& label_in,
    ::payments::mojom::blink::PaymentCurrencyAmountPtr amount_in,
    bool selected_in)
    : id(std::move(id_in)),
      label(std::move(label_in)),
      amount(std::move(amount_in)),
      selected(std::move(selected_in)) {}

PaymentShippingOption::~PaymentShippingOption() = default;
size_t PaymentShippingOption::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->id);
  seed = mojo::internal::WTFHash(seed, this->label);
  seed = mojo::internal::WTFHash(seed, this->amount);
  seed = mojo::internal::WTFHash(seed, this->selected);
  return seed;
}

void PaymentShippingOption::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "amount"), this->amount,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::blink::PaymentCurrencyAmountPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected"), this->selected,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentShippingOption::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SecurePaymentConfirmationRequest::SecurePaymentConfirmationRequest()
    : credential_ids(),
      challenge(),
      instrument(),
      timeout(),
      payee_origin(),
      payee_name(),
      rp_id(),
      extensions(),
      show_opt_out(),
      network_info(),
      issuer_info() {}

SecurePaymentConfirmationRequest::SecurePaymentConfirmationRequest(
    WTF::Vector<WTF::Vector<uint8_t>> credential_ids_in,
    WTF::Vector<uint8_t> challenge_in,
    ::blink::mojom::blink::PaymentCredentialInstrumentPtr instrument_in,
    std::optional<::base::TimeDelta> timeout_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& payee_origin_in,
    const WTF::String& payee_name_in,
    const WTF::String& rp_id_in,
    ::blink::mojom::blink::AuthenticationExtensionsClientInputsPtr extensions_in,
    bool show_opt_out_in,
    NetworkOrIssuerInformationPtr network_info_in,
    NetworkOrIssuerInformationPtr issuer_info_in)
    : credential_ids(std::move(credential_ids_in)),
      challenge(std::move(challenge_in)),
      instrument(std::move(instrument_in)),
      timeout(std::move(timeout_in)),
      payee_origin(std::move(payee_origin_in)),
      payee_name(std::move(payee_name_in)),
      rp_id(std::move(rp_id_in)),
      extensions(std::move(extensions_in)),
      show_opt_out(std::move(show_opt_out_in)),
      network_info(std::move(network_info_in)),
      issuer_info(std::move(issuer_info_in)) {}

SecurePaymentConfirmationRequest::~SecurePaymentConfirmationRequest() = default;

void SecurePaymentConfirmationRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credential_ids"), this->credential_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "challenge"), this->challenge,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instrument"), this->instrument,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::PaymentCredentialInstrumentPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timeout"), this->timeout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payee_origin"), this->payee_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payee_name"), this->payee_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rp_id"), this->rp_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extensions"), this->extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::AuthenticationExtensionsClientInputsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_opt_out"), this->show_opt_out,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "network_info"), this->network_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NetworkOrIssuerInformationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuer_info"), this->issuer_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NetworkOrIssuerInformationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SecurePaymentConfirmationRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkOrIssuerInformation::NetworkOrIssuerInformation()
    : name(),
      icon() {}

NetworkOrIssuerInformation::NetworkOrIssuerInformation(
    const WTF::String& name_in,
    const ::blink::KURL& icon_in)
    : name(std::move(name_in)),
      icon(std::move(icon_in)) {}

NetworkOrIssuerInformation::~NetworkOrIssuerInformation() = default;

void NetworkOrIssuerInformation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NetworkOrIssuerInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentMethodData::PaymentMethodData()
    : supported_method(),
      stringified_data(),
      environment(),
      min_google_play_services_version(),
      api_version(),
      supported_networks(),
      secure_payment_confirmation() {}

PaymentMethodData::PaymentMethodData(
    const WTF::String& supported_method_in,
    const WTF::String& stringified_data_in,
    AndroidPayEnvironment environment_in,
    int32_t min_google_play_services_version_in,
    int32_t api_version_in,
    WTF::Vector<BasicCardNetwork> supported_networks_in,
    SecurePaymentConfirmationRequestPtr secure_payment_confirmation_in)
    : supported_method(std::move(supported_method_in)),
      stringified_data(std::move(stringified_data_in)),
      environment(std::move(environment_in)),
      min_google_play_services_version(std::move(min_google_play_services_version_in)),
      api_version(std::move(api_version_in)),
      supported_networks(std::move(supported_networks_in)),
      secure_payment_confirmation(std::move(secure_payment_confirmation_in)) {}

PaymentMethodData::~PaymentMethodData() = default;

void PaymentMethodData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_method"), this->supported_method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stringified_data"), this->stringified_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "environment"), this->environment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AndroidPayEnvironment>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_google_play_services_version"), this->min_google_play_services_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "api_version"), this->api_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_networks"), this->supported_networks,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<BasicCardNetwork>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure_payment_confirmation"), this->secure_payment_confirmation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SecurePaymentConfirmationRequestPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentMethodData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentDetailsModifier::PaymentDetailsModifier()
    : total(),
      additional_display_items(),
      method_data() {}

PaymentDetailsModifier::PaymentDetailsModifier(
    PaymentItemPtr total_in,
    WTF::Vector<PaymentItemPtr> additional_display_items_in,
    PaymentMethodDataPtr method_data_in)
    : total(std::move(total_in)),
      additional_display_items(std::move(additional_display_items_in)),
      method_data(std::move(method_data_in)) {}

PaymentDetailsModifier::~PaymentDetailsModifier() = default;

void PaymentDetailsModifier::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total"), this->total,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PaymentItemPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_display_items"), this->additional_display_items,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<PaymentItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method_data"), this->method_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PaymentMethodDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentDetailsModifier::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentDetails::PaymentDetails()
    : total(),
      display_items(),
      shipping_options(),
      modifiers(),
      error(""),
      shipping_address_errors(),
      id(),
      stringified_payment_method_errors() {}

PaymentDetails::PaymentDetails(
    PaymentItemPtr total_in,
    std::optional<WTF::Vector<PaymentItemPtr>> display_items_in,
    std::optional<WTF::Vector<PaymentShippingOptionPtr>> shipping_options_in,
    std::optional<WTF::Vector<PaymentDetailsModifierPtr>> modifiers_in,
    const WTF::String& error_in,
    ::payments::mojom::blink::AddressErrorsPtr shipping_address_errors_in,
    const WTF::String& id_in,
    const WTF::String& stringified_payment_method_errors_in)
    : total(std::move(total_in)),
      display_items(std::move(display_items_in)),
      shipping_options(std::move(shipping_options_in)),
      modifiers(std::move(modifiers_in)),
      error(std::move(error_in)),
      shipping_address_errors(std::move(shipping_address_errors_in)),
      id(std::move(id_in)),
      stringified_payment_method_errors(std::move(stringified_payment_method_errors_in)) {}

PaymentDetails::~PaymentDetails() = default;

void PaymentDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total"), this->total,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PaymentItemPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_items"), this->display_items,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WTF::Vector<PaymentItemPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_options"), this->shipping_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WTF::Vector<PaymentShippingOptionPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modifiers"), this->modifiers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WTF::Vector<PaymentDetailsModifierPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_address_errors"), this->shipping_address_errors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::blink::AddressErrorsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stringified_payment_method_errors"), this->stringified_payment_method_errors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentOptions::PaymentOptions()
    : request_payer_name(),
      request_payer_email(),
      request_payer_phone(),
      request_shipping(),
      shipping_type() {}

PaymentOptions::PaymentOptions(
    bool request_payer_name_in,
    bool request_payer_email_in,
    bool request_payer_phone_in,
    bool request_shipping_in,
    PaymentShippingType shipping_type_in)
    : request_payer_name(std::move(request_payer_name_in)),
      request_payer_email(std::move(request_payer_email_in)),
      request_payer_phone(std::move(request_payer_phone_in)),
      request_shipping(std::move(request_shipping_in)),
      shipping_type(std::move(shipping_type_in)) {}

PaymentOptions::~PaymentOptions() = default;
size_t PaymentOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->request_payer_name);
  seed = mojo::internal::WTFHash(seed, this->request_payer_email);
  seed = mojo::internal::WTFHash(seed, this->request_payer_phone);
  seed = mojo::internal::WTFHash(seed, this->request_shipping);
  seed = mojo::internal::WTFHash(seed, this->shipping_type);
  return seed;
}

void PaymentOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_payer_name"), this->request_payer_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_payer_email"), this->request_payer_email,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_payer_phone"), this->request_payer_phone,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_shipping"), this->request_shipping,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_type"), this->shipping_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PaymentShippingType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PaymentRequestClient::Name_[] = "payments.mojom.PaymentRequestClient";

PaymentRequestClient::IPCStableHashFunction PaymentRequestClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PaymentRequestClient>(message.name())) {
    case messages::PaymentRequestClient::kOnPaymentMethodChange: {
      return &PaymentRequestClient::OnPaymentMethodChange_Sym::IPCStableHash;
    }
    case messages::PaymentRequestClient::kOnShippingAddressChange: {
      return &PaymentRequestClient::OnShippingAddressChange_Sym::IPCStableHash;
    }
    case messages::PaymentRequestClient::kOnShippingOptionChange: {
      return &PaymentRequestClient::OnShippingOptionChange_Sym::IPCStableHash;
    }
    case messages::PaymentRequestClient::kOnPayerDetailChange: {
      return &PaymentRequestClient::OnPayerDetailChange_Sym::IPCStableHash;
    }
    case messages::PaymentRequestClient::kOnPaymentResponse: {
      return &PaymentRequestClient::OnPaymentResponse_Sym::IPCStableHash;
    }
    case messages::PaymentRequestClient::kOnError: {
      return &PaymentRequestClient::OnError_Sym::IPCStableHash;
    }
    case messages::PaymentRequestClient::kOnComplete: {
      return &PaymentRequestClient::OnComplete_Sym::IPCStableHash;
    }
    case messages::PaymentRequestClient::kOnAbort: {
      return &PaymentRequestClient::OnAbort_Sym::IPCStableHash;
    }
    case messages::PaymentRequestClient::kOnCanMakePayment: {
      return &PaymentRequestClient::OnCanMakePayment_Sym::IPCStableHash;
    }
    case messages::PaymentRequestClient::kOnHasEnrolledInstrument: {
      return &PaymentRequestClient::OnHasEnrolledInstrument_Sym::IPCStableHash;
    }
    case messages::PaymentRequestClient::kWarnNoFavicon: {
      return &PaymentRequestClient::WarnNoFavicon_Sym::IPCStableHash;
    }
    case messages::PaymentRequestClient::kAllowConnectToSource: {
      return &PaymentRequestClient::AllowConnectToSource_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PaymentRequestClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PaymentRequestClient>(message.name())) {
      case messages::PaymentRequestClient::kOnPaymentMethodChange:
            return "Receive payments::mojom::PaymentRequestClient::OnPaymentMethodChange";
      case messages::PaymentRequestClient::kOnShippingAddressChange:
            return "Receive payments::mojom::PaymentRequestClient::OnShippingAddressChange";
      case messages::PaymentRequestClient::kOnShippingOptionChange:
            return "Receive payments::mojom::PaymentRequestClient::OnShippingOptionChange";
      case messages::PaymentRequestClient::kOnPayerDetailChange:
            return "Receive payments::mojom::PaymentRequestClient::OnPayerDetailChange";
      case messages::PaymentRequestClient::kOnPaymentResponse:
            return "Receive payments::mojom::PaymentRequestClient::OnPaymentResponse";
      case messages::PaymentRequestClient::kOnError:
            return "Receive payments::mojom::PaymentRequestClient::OnError";
      case messages::PaymentRequestClient::kOnComplete:
            return "Receive payments::mojom::PaymentRequestClient::OnComplete";
      case messages::PaymentRequestClient::kOnAbort:
            return "Receive payments::mojom::PaymentRequestClient::OnAbort";
      case messages::PaymentRequestClient::kOnCanMakePayment:
            return "Receive payments::mojom::PaymentRequestClient::OnCanMakePayment";
      case messages::PaymentRequestClient::kOnHasEnrolledInstrument:
            return "Receive payments::mojom::PaymentRequestClient::OnHasEnrolledInstrument";
      case messages::PaymentRequestClient::kWarnNoFavicon:
            return "Receive payments::mojom::PaymentRequestClient::WarnNoFavicon";
      case messages::PaymentRequestClient::kAllowConnectToSource:
            return "Receive payments::mojom::PaymentRequestClient::AllowConnectToSource";
    }
  } else {
    switch (static_cast<messages::PaymentRequestClient>(message.name())) {
      case messages::PaymentRequestClient::kOnPaymentMethodChange:
            return "Receive reply payments::mojom::PaymentRequestClient::OnPaymentMethodChange";
      case messages::PaymentRequestClient::kOnShippingAddressChange:
            return "Receive reply payments::mojom::PaymentRequestClient::OnShippingAddressChange";
      case messages::PaymentRequestClient::kOnShippingOptionChange:
            return "Receive reply payments::mojom::PaymentRequestClient::OnShippingOptionChange";
      case messages::PaymentRequestClient::kOnPayerDetailChange:
            return "Receive reply payments::mojom::PaymentRequestClient::OnPayerDetailChange";
      case messages::PaymentRequestClient::kOnPaymentResponse:
            return "Receive reply payments::mojom::PaymentRequestClient::OnPaymentResponse";
      case messages::PaymentRequestClient::kOnError:
            return "Receive reply payments::mojom::PaymentRequestClient::OnError";
      case messages::PaymentRequestClient::kOnComplete:
            return "Receive reply payments::mojom::PaymentRequestClient::OnComplete";
      case messages::PaymentRequestClient::kOnAbort:
            return "Receive reply payments::mojom::PaymentRequestClient::OnAbort";
      case messages::PaymentRequestClient::kOnCanMakePayment:
            return "Receive reply payments::mojom::PaymentRequestClient::OnCanMakePayment";
      case messages::PaymentRequestClient::kOnHasEnrolledInstrument:
            return "Receive reply payments::mojom::PaymentRequestClient::OnHasEnrolledInstrument";
      case messages::PaymentRequestClient::kWarnNoFavicon:
            return "Receive reply payments::mojom::PaymentRequestClient::WarnNoFavicon";
      case messages::PaymentRequestClient::kAllowConnectToSource:
            return "Receive reply payments::mojom::PaymentRequestClient::AllowConnectToSource";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PaymentRequestClient::OnPaymentMethodChange_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequestClient::OnPaymentMethodChange");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequestClient::OnShippingAddressChange_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequestClient::OnShippingAddressChange");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequestClient::OnShippingOptionChange_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequestClient::OnShippingOptionChange");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequestClient::OnPayerDetailChange_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequestClient::OnPayerDetailChange");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequestClient::OnPaymentResponse_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequestClient::OnPaymentResponse");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequestClient::OnError_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequestClient::OnError");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequestClient::OnComplete_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequestClient::OnComplete");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequestClient::OnAbort_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequestClient::OnAbort");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequestClient::OnCanMakePayment_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequestClient::OnCanMakePayment");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequestClient::OnHasEnrolledInstrument_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequestClient::OnHasEnrolledInstrument");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequestClient::WarnNoFavicon_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequestClient::WarnNoFavicon");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequestClient::AllowConnectToSource_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequestClient::AllowConnectToSource");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PaymentRequestClient_AllowConnectToSource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentRequestClient_AllowConnectToSource_ForwardToCallback(
      PaymentRequestClient::AllowConnectToSourceCallback callback
      ) : callback_(std::move(callback)) {
  }

  PaymentRequestClient_AllowConnectToSource_ForwardToCallback(const PaymentRequestClient_AllowConnectToSource_ForwardToCallback&) = delete;
  PaymentRequestClient_AllowConnectToSource_ForwardToCallback& operator=(const PaymentRequestClient_AllowConnectToSource_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PaymentRequestClient::AllowConnectToSourceCallback callback_;
};

PaymentRequestClientProxy::PaymentRequestClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaymentRequestClientProxy::OnPaymentMethodChange(
    const WTF::String& in_method_name, const WTF::String& in_stringified_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequestClient::OnPaymentMethodChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method_name"), in_method_name,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stringified_details"), in_stringified_details,
                        "<value of type const WTF::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequestClient::kOnPaymentMethodChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnPaymentMethodChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->method_name)::BaseType> method_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_method_name, method_name_fragment);
  params->method_name.Set(
      method_name_fragment.is_null() ? nullptr : method_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->method_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_name in PaymentRequestClient.OnPaymentMethodChange request");
  mojo::internal::MessageFragment<
      typename decltype(params->stringified_details)::BaseType> stringified_details_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_stringified_details, stringified_details_fragment);
  params->stringified_details.Set(
      stringified_details_fragment.is_null() ? nullptr : stringified_details_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->stringified_details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stringified_details in PaymentRequestClient.OnPaymentMethodChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnPaymentMethodChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestClientProxy::OnShippingAddressChange(
    ::payments::mojom::blink::PaymentAddressPtr in_address) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequestClient::OnShippingAddressChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address"), in_address,
                        "<value of type ::payments::mojom::blink::PaymentAddressPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequestClient::kOnShippingAddressChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnShippingAddressChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->address)::BaseType> address_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentAddressDataView>(
      in_address, address_fragment);
  params->address.Set(
      address_fragment.is_null() ? nullptr : address_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null address in PaymentRequestClient.OnShippingAddressChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnShippingAddressChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestClientProxy::OnShippingOptionChange(
    const WTF::String& in_shipping_option_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequestClient::OnShippingOptionChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shipping_option_id"), in_shipping_option_id,
                        "<value of type const WTF::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequestClient::kOnShippingOptionChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnShippingOptionChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->shipping_option_id)::BaseType> shipping_option_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_shipping_option_id, shipping_option_id_fragment);
  params->shipping_option_id.Set(
      shipping_option_id_fragment.is_null() ? nullptr : shipping_option_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shipping_option_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shipping_option_id in PaymentRequestClient.OnShippingOptionChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnShippingOptionChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestClientProxy::OnPayerDetailChange(
    PayerDetailPtr in_detail) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequestClient::OnPayerDetailChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("detail"), in_detail,
                        "<value of type PayerDetailPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequestClient::kOnPayerDetailChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnPayerDetailChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->detail)::BaseType> detail_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PayerDetailDataView>(
      in_detail, detail_fragment);
  params->detail.Set(
      detail_fragment.is_null() ? nullptr : detail_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->detail.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null detail in PaymentRequestClient.OnPayerDetailChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnPayerDetailChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestClientProxy::OnPaymentResponse(
    PaymentResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequestClient::OnPaymentResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type PaymentResponsePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequestClient::kOnPaymentResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnPaymentResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentResponseDataView>(
      in_response, response_fragment);
  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in PaymentRequestClient.OnPaymentResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnPaymentResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestClientProxy::OnError(
    PaymentErrorReason in_error, const WTF::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequestClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type PaymentErrorReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const WTF::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequestClient::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::PaymentErrorReason>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, error_message_fragment);
  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in PaymentRequestClient.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestClientProxy::OnComplete(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send payments::mojom::PaymentRequestClient::OnComplete");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequestClient::kOnComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnComplete_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestClientProxy::OnAbort(
    bool in_aborted_successfully) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequestClient::OnAbort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("aborted_successfully"), in_aborted_successfully,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequestClient::kOnAbort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnAbort_Params_Data> params(
          message);
  params.Allocate();
  params->aborted_successfully = in_aborted_successfully;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnAbort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestClientProxy::OnCanMakePayment(
    CanMakePaymentQueryResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequestClient::OnCanMakePayment", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CanMakePaymentQueryResult>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequestClient::kOnCanMakePayment), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnCanMakePayment_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::CanMakePaymentQueryResult>(
      in_result, &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnCanMakePayment");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestClientProxy::OnHasEnrolledInstrument(
    HasEnrolledInstrumentQueryResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequestClient::OnHasEnrolledInstrument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type HasEnrolledInstrumentQueryResult>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequestClient::kOnHasEnrolledInstrument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_OnHasEnrolledInstrument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::HasEnrolledInstrumentQueryResult>(
      in_result, &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnHasEnrolledInstrument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestClientProxy::WarnNoFavicon(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send payments::mojom::PaymentRequestClient::WarnNoFavicon");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequestClient::kWarnNoFavicon), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_WarnNoFavicon_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("WarnNoFavicon");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestClientProxy::AllowConnectToSource(
    const ::blink::KURL& in_url, const ::blink::KURL& in_url_before_redirects, bool in_did_follow_redirect, AllowConnectToSourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequestClient::AllowConnectToSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_before_redirects"), in_url_before_redirects,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("did_follow_redirect"), in_did_follow_redirect,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequestClient::kAllowConnectToSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_AllowConnectToSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PaymentRequestClient.AllowConnectToSource request");
  mojo::internal::MessageFragment<
      typename decltype(params->url_before_redirects)::BaseType> url_before_redirects_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url_before_redirects, url_before_redirects_fragment);
  params->url_before_redirects.Set(
      url_before_redirects_fragment.is_null() ? nullptr : url_before_redirects_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url_before_redirects.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_before_redirects in PaymentRequestClient.AllowConnectToSource request");
  params->did_follow_redirect = in_did_follow_redirect;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("AllowConnectToSource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentRequestClient_AllowConnectToSource_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PaymentRequestClient_AllowConnectToSource_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PaymentRequestClient::AllowConnectToSourceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PaymentRequestClient_AllowConnectToSource_ProxyToResponder> proxy(
        new PaymentRequestClient_AllowConnectToSource_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PaymentRequestClient_AllowConnectToSource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentRequestClient_AllowConnectToSource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PaymentRequestClient_AllowConnectToSource_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentRequestClient::AllowConnectToSourceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_allow);
};

bool PaymentRequestClient_AllowConnectToSource_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PaymentRequestClient_AllowConnectToSource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentRequestClient_AllowConnectToSource_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PaymentRequestClient.11
  bool success = true;
  bool p_allow{};
  PaymentRequestClient_AllowConnectToSource_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_allow = input_data_view.allow();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentRequestClient::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_allow));
  return true;
}

void PaymentRequestClient_AllowConnectToSource_ProxyToResponder::Run(
    bool in_allow) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply payments::mojom::PaymentRequestClient::AllowConnectToSource", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow"), in_allow,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequestClient::kAllowConnectToSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequestClient_AllowConnectToSource_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->allow = in_allow;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("AllowConnectToSource");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PaymentRequestClientStubDispatch::Accept(
    PaymentRequestClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PaymentRequestClient>(message->header()->name)) {
    case messages::PaymentRequestClient::kOnPaymentMethodChange: {
      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnPaymentMethodChange_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnPaymentMethodChange_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequestClient.0
      bool success = true;
      WTF::String p_method_name{};
      WTF::String p_stringified_details{};
      PaymentRequestClient_OnPaymentMethodChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMethodName(&p_method_name))
        success = false;
      if (success && !input_data_view.ReadStringifiedDetails(&p_stringified_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPaymentMethodChange(        
        std::move(p_method_name), 
        std::move(p_stringified_details));
      return true;
    }
    case messages::PaymentRequestClient::kOnShippingAddressChange: {
      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnShippingAddressChange_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnShippingAddressChange_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequestClient.1
      bool success = true;
      ::payments::mojom::blink::PaymentAddressPtr p_address{};
      PaymentRequestClient_OnShippingAddressChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddress(&p_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnShippingAddressChange(        
        std::move(p_address));
      return true;
    }
    case messages::PaymentRequestClient::kOnShippingOptionChange: {
      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnShippingOptionChange_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnShippingOptionChange_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequestClient.2
      bool success = true;
      WTF::String p_shipping_option_id{};
      PaymentRequestClient_OnShippingOptionChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadShippingOptionId(&p_shipping_option_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnShippingOptionChange(        
        std::move(p_shipping_option_id));
      return true;
    }
    case messages::PaymentRequestClient::kOnPayerDetailChange: {
      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnPayerDetailChange_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnPayerDetailChange_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequestClient.3
      bool success = true;
      PayerDetailPtr p_detail{};
      PaymentRequestClient_OnPayerDetailChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetail(&p_detail))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPayerDetailChange(        
        std::move(p_detail));
      return true;
    }
    case messages::PaymentRequestClient::kOnPaymentResponse: {
      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnPaymentResponse_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnPaymentResponse_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequestClient.4
      bool success = true;
      PaymentResponsePtr p_response{};
      PaymentRequestClient_OnPaymentResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPaymentResponse(        
        std::move(p_response));
      return true;
    }
    case messages::PaymentRequestClient::kOnError: {
      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnError_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnError_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequestClient.5
      bool success = true;
      PaymentErrorReason p_error{};
      WTF::String p_error_message{};
      PaymentRequestClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_error), 
        std::move(p_error_message));
      return true;
    }
    case messages::PaymentRequestClient::kOnComplete: {
      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequestClient.6
      bool success = true;
      PaymentRequestClient_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(        );
      return true;
    }
    case messages::PaymentRequestClient::kOnAbort: {
      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnAbort_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnAbort_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequestClient.7
      bool success = true;
      bool p_aborted_successfully{};
      PaymentRequestClient_OnAbort_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_aborted_successfully = input_data_view.aborted_successfully();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAbort(        
        std::move(p_aborted_successfully));
      return true;
    }
    case messages::PaymentRequestClient::kOnCanMakePayment: {
      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnCanMakePayment_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnCanMakePayment_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequestClient.8
      bool success = true;
      CanMakePaymentQueryResult p_result{};
      PaymentRequestClient_OnCanMakePayment_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCanMakePayment(        
        std::move(p_result));
      return true;
    }
    case messages::PaymentRequestClient::kOnHasEnrolledInstrument: {
      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnHasEnrolledInstrument_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnHasEnrolledInstrument_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequestClient.9
      bool success = true;
      HasEnrolledInstrumentQueryResult p_result{};
      PaymentRequestClient_OnHasEnrolledInstrument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHasEnrolledInstrument(        
        std::move(p_result));
      return true;
    }
    case messages::PaymentRequestClient::kWarnNoFavicon: {
      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_WarnNoFavicon_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_WarnNoFavicon_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequestClient.10
      bool success = true;
      PaymentRequestClient_WarnNoFavicon_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WarnNoFavicon(        );
      return true;
    }
    case messages::PaymentRequestClient::kAllowConnectToSource: {
      break;
    }
  }
  return false;
}

// static
bool PaymentRequestClientStubDispatch::AcceptWithResponder(
    PaymentRequestClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PaymentRequestClient>(message->header()->name)) {
    case messages::PaymentRequestClient::kOnPaymentMethodChange: {
      break;
    }
    case messages::PaymentRequestClient::kOnShippingAddressChange: {
      break;
    }
    case messages::PaymentRequestClient::kOnShippingOptionChange: {
      break;
    }
    case messages::PaymentRequestClient::kOnPayerDetailChange: {
      break;
    }
    case messages::PaymentRequestClient::kOnPaymentResponse: {
      break;
    }
    case messages::PaymentRequestClient::kOnError: {
      break;
    }
    case messages::PaymentRequestClient::kOnComplete: {
      break;
    }
    case messages::PaymentRequestClient::kOnAbort: {
      break;
    }
    case messages::PaymentRequestClient::kOnCanMakePayment: {
      break;
    }
    case messages::PaymentRequestClient::kOnHasEnrolledInstrument: {
      break;
    }
    case messages::PaymentRequestClient::kWarnNoFavicon: {
      break;
    }
    case messages::PaymentRequestClient::kAllowConnectToSource: {
      internal::PaymentRequestClient_AllowConnectToSource_Params_Data* params =
          reinterpret_cast<
              internal::PaymentRequestClient_AllowConnectToSource_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PaymentRequestClient.11
      bool success = true;
      ::blink::KURL p_url{};
      ::blink::KURL p_url_before_redirects{};
      bool p_did_follow_redirect{};
      PaymentRequestClient_AllowConnectToSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadUrlBeforeRedirects(&p_url_before_redirects))
        success = false;
      if (success)
        p_did_follow_redirect = input_data_view.did_follow_redirect();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 11, false);
        return false;
      }
      PaymentRequestClient::AllowConnectToSourceCallback callback =
          PaymentRequestClient_AllowConnectToSource_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllowConnectToSource(        
        std::move(p_url), 
        std::move(p_url_before_redirects), 
        std::move(p_did_follow_redirect), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPaymentRequestClientValidationInfo[] = {
    { &internal::PaymentRequestClient_OnPaymentMethodChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequestClient_OnShippingAddressChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequestClient_OnShippingOptionChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequestClient_OnPayerDetailChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequestClient_OnPaymentResponse_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequestClient_OnError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequestClient_OnComplete_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequestClient_OnAbort_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequestClient_OnCanMakePayment_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequestClient_OnHasEnrolledInstrument_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequestClient_WarnNoFavicon_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequestClient_AllowConnectToSource_Params_Data::Validate,
     &internal::PaymentRequestClient_AllowConnectToSource_ResponseParams_Data::Validate},
};

bool PaymentRequestClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::PaymentRequestClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPaymentRequestClientValidationInfo);
}

bool PaymentRequestClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::PaymentRequestClient::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPaymentRequestClientValidationInfo);
}
const char PaymentRequest::Name_[] = "payments.mojom.PaymentRequest";

PaymentRequest::IPCStableHashFunction PaymentRequest::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PaymentRequest>(message.name())) {
    case messages::PaymentRequest::kInit: {
      return &PaymentRequest::Init_Sym::IPCStableHash;
    }
    case messages::PaymentRequest::kShow: {
      return &PaymentRequest::Show_Sym::IPCStableHash;
    }
    case messages::PaymentRequest::kUpdateWith: {
      return &PaymentRequest::UpdateWith_Sym::IPCStableHash;
    }
    case messages::PaymentRequest::kOnPaymentDetailsNotUpdated: {
      return &PaymentRequest::OnPaymentDetailsNotUpdated_Sym::IPCStableHash;
    }
    case messages::PaymentRequest::kAbort: {
      return &PaymentRequest::Abort_Sym::IPCStableHash;
    }
    case messages::PaymentRequest::kComplete: {
      return &PaymentRequest::Complete_Sym::IPCStableHash;
    }
    case messages::PaymentRequest::kRetry: {
      return &PaymentRequest::Retry_Sym::IPCStableHash;
    }
    case messages::PaymentRequest::kCanMakePayment: {
      return &PaymentRequest::CanMakePayment_Sym::IPCStableHash;
    }
    case messages::PaymentRequest::kHasEnrolledInstrument: {
      return &PaymentRequest::HasEnrolledInstrument_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PaymentRequest::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PaymentRequest>(message.name())) {
      case messages::PaymentRequest::kInit:
            return "Receive payments::mojom::PaymentRequest::Init";
      case messages::PaymentRequest::kShow:
            return "Receive payments::mojom::PaymentRequest::Show";
      case messages::PaymentRequest::kUpdateWith:
            return "Receive payments::mojom::PaymentRequest::UpdateWith";
      case messages::PaymentRequest::kOnPaymentDetailsNotUpdated:
            return "Receive payments::mojom::PaymentRequest::OnPaymentDetailsNotUpdated";
      case messages::PaymentRequest::kAbort:
            return "Receive payments::mojom::PaymentRequest::Abort";
      case messages::PaymentRequest::kComplete:
            return "Receive payments::mojom::PaymentRequest::Complete";
      case messages::PaymentRequest::kRetry:
            return "Receive payments::mojom::PaymentRequest::Retry";
      case messages::PaymentRequest::kCanMakePayment:
            return "Receive payments::mojom::PaymentRequest::CanMakePayment";
      case messages::PaymentRequest::kHasEnrolledInstrument:
            return "Receive payments::mojom::PaymentRequest::HasEnrolledInstrument";
    }
  } else {
    switch (static_cast<messages::PaymentRequest>(message.name())) {
      case messages::PaymentRequest::kInit:
            return "Receive reply payments::mojom::PaymentRequest::Init";
      case messages::PaymentRequest::kShow:
            return "Receive reply payments::mojom::PaymentRequest::Show";
      case messages::PaymentRequest::kUpdateWith:
            return "Receive reply payments::mojom::PaymentRequest::UpdateWith";
      case messages::PaymentRequest::kOnPaymentDetailsNotUpdated:
            return "Receive reply payments::mojom::PaymentRequest::OnPaymentDetailsNotUpdated";
      case messages::PaymentRequest::kAbort:
            return "Receive reply payments::mojom::PaymentRequest::Abort";
      case messages::PaymentRequest::kComplete:
            return "Receive reply payments::mojom::PaymentRequest::Complete";
      case messages::PaymentRequest::kRetry:
            return "Receive reply payments::mojom::PaymentRequest::Retry";
      case messages::PaymentRequest::kCanMakePayment:
            return "Receive reply payments::mojom::PaymentRequest::CanMakePayment";
      case messages::PaymentRequest::kHasEnrolledInstrument:
            return "Receive reply payments::mojom::PaymentRequest::HasEnrolledInstrument";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PaymentRequest::Init_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequest::Init");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequest::Show_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequest::Show");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequest::UpdateWith_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequest::UpdateWith");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequest::OnPaymentDetailsNotUpdated_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequest::OnPaymentDetailsNotUpdated");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequest::Abort_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequest::Abort");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequest::Complete_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequest::Complete");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequest::Retry_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequest::Retry");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequest::CanMakePayment_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequest::CanMakePayment");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PaymentRequest::HasEnrolledInstrument_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::PaymentRequest::HasEnrolledInstrument");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PaymentRequestProxy::PaymentRequestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaymentRequestProxy::Init(
    ::mojo::PendingRemote<PaymentRequestClient> in_client, WTF::Vector<PaymentMethodDataPtr> in_method_data, PaymentDetailsPtr in_details, PaymentOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequest::Init", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<PaymentRequestClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method_data"), in_method_data,
                        "<value of type WTF::Vector<PaymentMethodDataPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type PaymentDetailsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type PaymentOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequest::kInit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_Init_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::payments::mojom::PaymentRequestClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in PaymentRequest.Init request");
  mojo::internal::MessageFragment<
      typename decltype(params->method_data)::BaseType>
      method_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& method_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentMethodDataDataView>>(
      in_method_data, method_data_fragment, &method_data_validate_params);
  params->method_data.Set(
      method_data_fragment.is_null() ? nullptr : method_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->method_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_data in PaymentRequest.Init request");
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentDetailsDataView>(
      in_details, details_fragment);
  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in PaymentRequest.Init request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in PaymentRequest.Init request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Init");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestProxy::Show(
    bool in_wait_for_updated_details, bool in_had_user_activation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequest::Show", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wait_for_updated_details"), in_wait_for_updated_details,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("had_user_activation"), in_had_user_activation,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequest::kShow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_Show_Params_Data> params(
          message);
  params.Allocate();
  params->wait_for_updated_details = in_wait_for_updated_details;
  params->had_user_activation = in_had_user_activation;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Show");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestProxy::UpdateWith(
    PaymentDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequest::UpdateWith", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type PaymentDetailsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequest::kUpdateWith), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_UpdateWith_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentDetailsDataView>(
      in_details, details_fragment);
  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in PaymentRequest.UpdateWith request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("UpdateWith");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestProxy::OnPaymentDetailsNotUpdated(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send payments::mojom::PaymentRequest::OnPaymentDetailsNotUpdated");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequest::kOnPaymentDetailsNotUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("OnPaymentDetailsNotUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestProxy::Abort(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send payments::mojom::PaymentRequest::Abort");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequest::kAbort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_Abort_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestProxy::Complete(
    PaymentComplete in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequest::Complete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PaymentComplete>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequest::kComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_Complete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::PaymentComplete>(
      in_result, &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Complete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestProxy::Retry(
    ::payments::mojom::blink::PaymentValidationErrorsPtr in_errors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::PaymentRequest::Retry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("errors"), in_errors,
                        "<value of type ::payments::mojom::blink::PaymentValidationErrorsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequest::kRetry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_Retry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->errors)::BaseType> errors_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentValidationErrorsDataView>(
      in_errors, errors_fragment);
  params->errors.Set(
      errors_fragment.is_null() ? nullptr : errors_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->errors.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null errors in PaymentRequest.Retry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Retry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestProxy::CanMakePayment(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send payments::mojom::PaymentRequest::CanMakePayment");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequest::kCanMakePayment), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_CanMakePayment_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("CanMakePayment");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PaymentRequestProxy::HasEnrolledInstrument(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send payments::mojom::PaymentRequest::HasEnrolledInstrument");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PaymentRequest::kHasEnrolledInstrument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentRequest_HasEnrolledInstrument_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("HasEnrolledInstrument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PaymentRequestStubDispatch::Accept(
    PaymentRequest* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PaymentRequest>(message->header()->name)) {
    case messages::PaymentRequest::kInit: {
      DCHECK(message->is_serialized());
      internal::PaymentRequest_Init_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Init_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequest.0
      bool success = true;
      ::mojo::PendingRemote<PaymentRequestClient> p_client{};
      WTF::Vector<PaymentMethodDataPtr> p_method_data{};
      PaymentDetailsPtr p_details{};
      PaymentOptionsPtr p_options{};
      PaymentRequest_Init_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadMethodData(&p_method_data))
        success = false;
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Init(        
        std::move(p_client), 
        std::move(p_method_data), 
        std::move(p_details), 
        std::move(p_options));
      return true;
    }
    case messages::PaymentRequest::kShow: {
      DCHECK(message->is_serialized());
      internal::PaymentRequest_Show_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Show_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequest.1
      bool success = true;
      bool p_wait_for_updated_details{};
      bool p_had_user_activation{};
      PaymentRequest_Show_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_wait_for_updated_details = input_data_view.wait_for_updated_details();
      if (success)
        p_had_user_activation = input_data_view.had_user_activation();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Show(        
        std::move(p_wait_for_updated_details), 
        std::move(p_had_user_activation));
      return true;
    }
    case messages::PaymentRequest::kUpdateWith: {
      DCHECK(message->is_serialized());
      internal::PaymentRequest_UpdateWith_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_UpdateWith_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequest.2
      bool success = true;
      PaymentDetailsPtr p_details{};
      PaymentRequest_UpdateWith_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateWith(        
        std::move(p_details));
      return true;
    }
    case messages::PaymentRequest::kOnPaymentDetailsNotUpdated: {
      DCHECK(message->is_serialized());
      internal::PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequest.3
      bool success = true;
      PaymentRequest_OnPaymentDetailsNotUpdated_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPaymentDetailsNotUpdated(        );
      return true;
    }
    case messages::PaymentRequest::kAbort: {
      DCHECK(message->is_serialized());
      internal::PaymentRequest_Abort_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Abort_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequest.4
      bool success = true;
      PaymentRequest_Abort_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort(        );
      return true;
    }
    case messages::PaymentRequest::kComplete: {
      DCHECK(message->is_serialized());
      internal::PaymentRequest_Complete_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Complete_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequest.5
      bool success = true;
      PaymentComplete p_result{};
      PaymentRequest_Complete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Complete(        
        std::move(p_result));
      return true;
    }
    case messages::PaymentRequest::kRetry: {
      DCHECK(message->is_serialized());
      internal::PaymentRequest_Retry_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Retry_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequest.6
      bool success = true;
      ::payments::mojom::blink::PaymentValidationErrorsPtr p_errors{};
      PaymentRequest_Retry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadErrors(&p_errors))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Retry(        
        std::move(p_errors));
      return true;
    }
    case messages::PaymentRequest::kCanMakePayment: {
      DCHECK(message->is_serialized());
      internal::PaymentRequest_CanMakePayment_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_CanMakePayment_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequest.7
      bool success = true;
      PaymentRequest_CanMakePayment_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanMakePayment(        );
      return true;
    }
    case messages::PaymentRequest::kHasEnrolledInstrument: {
      DCHECK(message->is_serialized());
      internal::PaymentRequest_HasEnrolledInstrument_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_HasEnrolledInstrument_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PaymentRequest.8
      bool success = true;
      PaymentRequest_HasEnrolledInstrument_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasEnrolledInstrument(        );
      return true;
    }
  }
  return false;
}

// static
bool PaymentRequestStubDispatch::AcceptWithResponder(
    PaymentRequest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PaymentRequest>(message->header()->name)) {
    case messages::PaymentRequest::kInit: {
      break;
    }
    case messages::PaymentRequest::kShow: {
      break;
    }
    case messages::PaymentRequest::kUpdateWith: {
      break;
    }
    case messages::PaymentRequest::kOnPaymentDetailsNotUpdated: {
      break;
    }
    case messages::PaymentRequest::kAbort: {
      break;
    }
    case messages::PaymentRequest::kComplete: {
      break;
    }
    case messages::PaymentRequest::kRetry: {
      break;
    }
    case messages::PaymentRequest::kCanMakePayment: {
      break;
    }
    case messages::PaymentRequest::kHasEnrolledInstrument: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPaymentRequestValidationInfo[] = {
    { &internal::PaymentRequest_Init_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequest_Show_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequest_UpdateWith_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequest_Abort_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequest_Complete_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequest_Retry_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequest_CanMakePayment_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PaymentRequest_HasEnrolledInstrument_Params_Data::Validate,
     nullptr /* no response */},
};

bool PaymentRequestRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::PaymentRequest::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPaymentRequestValidationInfo);
}



}  // payments::mojom::blink


namespace mojo {


// static
bool StructTraits<::payments::mojom::blink::PaymentResponse::DataView, ::payments::mojom::blink::PaymentResponsePtr>::Read(
    ::payments::mojom::blink::PaymentResponse::DataView input,
    ::payments::mojom::blink::PaymentResponsePtr* output) {
  bool success = true;
  ::payments::mojom::blink::PaymentResponsePtr result(::payments::mojom::blink::PaymentResponse::New());
  
      if (success && !input.ReadMethodName(&result->method_name))
        success = false;
      if (success && !input.ReadStringifiedDetails(&result->stringified_details))
        success = false;
      if (success && !input.ReadShippingAddress(&result->shipping_address))
        success = false;
      if (success && !input.ReadShippingOption(&result->shipping_option))
        success = false;
      if (success && !input.ReadPayer(&result->payer))
        success = false;
      if (success && !input.ReadGetAssertionAuthenticatorResponse(&result->get_assertion_authenticator_response))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::blink::PayerDetail::DataView, ::payments::mojom::blink::PayerDetailPtr>::Read(
    ::payments::mojom::blink::PayerDetail::DataView input,
    ::payments::mojom::blink::PayerDetailPtr* output) {
  bool success = true;
  ::payments::mojom::blink::PayerDetailPtr result(::payments::mojom::blink::PayerDetail::New());
  
      if (success && !input.ReadEmail(&result->email))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadPhone(&result->phone))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::blink::PaymentItem::DataView, ::payments::mojom::blink::PaymentItemPtr>::Read(
    ::payments::mojom::blink::PaymentItem::DataView input,
    ::payments::mojom::blink::PaymentItemPtr* output) {
  bool success = true;
  ::payments::mojom::blink::PaymentItemPtr result(::payments::mojom::blink::PaymentItem::New());
  
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadAmount(&result->amount))
        success = false;
      if (success)
        result->pending = input.pending();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::blink::PaymentShippingOption::DataView, ::payments::mojom::blink::PaymentShippingOptionPtr>::Read(
    ::payments::mojom::blink::PaymentShippingOption::DataView input,
    ::payments::mojom::blink::PaymentShippingOptionPtr* output) {
  bool success = true;
  ::payments::mojom::blink::PaymentShippingOptionPtr result(::payments::mojom::blink::PaymentShippingOption::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadAmount(&result->amount))
        success = false;
      if (success)
        result->selected = input.selected();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::blink::SecurePaymentConfirmationRequest::DataView, ::payments::mojom::blink::SecurePaymentConfirmationRequestPtr>::Read(
    ::payments::mojom::blink::SecurePaymentConfirmationRequest::DataView input,
    ::payments::mojom::blink::SecurePaymentConfirmationRequestPtr* output) {
  bool success = true;
  ::payments::mojom::blink::SecurePaymentConfirmationRequestPtr result(::payments::mojom::blink::SecurePaymentConfirmationRequest::New());
  
      if (success && !input.ReadCredentialIds(&result->credential_ids))
        success = false;
      if (success && !input.ReadChallenge(&result->challenge))
        success = false;
      if (success && !input.ReadInstrument(&result->instrument))
        success = false;
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
      if (success && !input.ReadPayeeOrigin(&result->payee_origin))
        success = false;
      if (success && !input.ReadPayeeName(&result->payee_name))
        success = false;
      if (success && !input.ReadRpId(&result->rp_id))
        success = false;
      if (success && !input.ReadExtensions(&result->extensions))
        success = false;
      if (success)
        result->show_opt_out = input.show_opt_out();
      if (success && !input.ReadNetworkInfo(&result->network_info))
        success = false;
      if (success && !input.ReadIssuerInfo(&result->issuer_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::blink::NetworkOrIssuerInformation::DataView, ::payments::mojom::blink::NetworkOrIssuerInformationPtr>::Read(
    ::payments::mojom::blink::NetworkOrIssuerInformation::DataView input,
    ::payments::mojom::blink::NetworkOrIssuerInformationPtr* output) {
  bool success = true;
  ::payments::mojom::blink::NetworkOrIssuerInformationPtr result(::payments::mojom::blink::NetworkOrIssuerInformation::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::blink::PaymentMethodData::DataView, ::payments::mojom::blink::PaymentMethodDataPtr>::Read(
    ::payments::mojom::blink::PaymentMethodData::DataView input,
    ::payments::mojom::blink::PaymentMethodDataPtr* output) {
  bool success = true;
  ::payments::mojom::blink::PaymentMethodDataPtr result(::payments::mojom::blink::PaymentMethodData::New());
  
      if (success && !input.ReadSupportedMethod(&result->supported_method))
        success = false;
      if (success && !input.ReadStringifiedData(&result->stringified_data))
        success = false;
      if (success && !input.ReadEnvironment(&result->environment))
        success = false;
      if (success)
        result->min_google_play_services_version = input.min_google_play_services_version();
      if (success)
        result->api_version = input.api_version();
      if (success && !input.ReadSupportedNetworks(&result->supported_networks))
        success = false;
      if (success && !input.ReadSecurePaymentConfirmation(&result->secure_payment_confirmation))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::blink::PaymentDetailsModifier::DataView, ::payments::mojom::blink::PaymentDetailsModifierPtr>::Read(
    ::payments::mojom::blink::PaymentDetailsModifier::DataView input,
    ::payments::mojom::blink::PaymentDetailsModifierPtr* output) {
  bool success = true;
  ::payments::mojom::blink::PaymentDetailsModifierPtr result(::payments::mojom::blink::PaymentDetailsModifier::New());
  
      if (success && !input.ReadTotal(&result->total))
        success = false;
      if (success && !input.ReadAdditionalDisplayItems(&result->additional_display_items))
        success = false;
      if (success && !input.ReadMethodData(&result->method_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::blink::PaymentDetails::DataView, ::payments::mojom::blink::PaymentDetailsPtr>::Read(
    ::payments::mojom::blink::PaymentDetails::DataView input,
    ::payments::mojom::blink::PaymentDetailsPtr* output) {
  bool success = true;
  ::payments::mojom::blink::PaymentDetailsPtr result(::payments::mojom::blink::PaymentDetails::New());
  
      if (success && !input.ReadTotal(&result->total))
        success = false;
      if (success && !input.ReadDisplayItems(&result->display_items))
        success = false;
      if (success && !input.ReadShippingOptions(&result->shipping_options))
        success = false;
      if (success && !input.ReadModifiers(&result->modifiers))
        success = false;
      if (success && !input.ReadError(&result->error))
        success = false;
      if (success && !input.ReadShippingAddressErrors(&result->shipping_address_errors))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadStringifiedPaymentMethodErrors(&result->stringified_payment_method_errors))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::blink::PaymentOptions::DataView, ::payments::mojom::blink::PaymentOptionsPtr>::Read(
    ::payments::mojom::blink::PaymentOptions::DataView input,
    ::payments::mojom::blink::PaymentOptionsPtr* output) {
  bool success = true;
  ::payments::mojom::blink::PaymentOptionsPtr result(::payments::mojom::blink::PaymentOptions::New());
  
      if (success)
        result->request_payer_name = input.request_payer_name();
      if (success)
        result->request_payer_email = input.request_payer_email();
      if (success)
        result->request_payer_phone = input.request_payer_phone();
      if (success)
        result->request_shipping = input.request_shipping();
      if (success && !input.ReadShippingType(&result->shipping_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace payments::mojom::blink {


void PaymentRequestClientInterceptorForTesting::OnPaymentMethodChange(const WTF::String& method_name, const WTF::String& stringified_details) {
  GetForwardingInterface()->OnPaymentMethodChange(
    std::move(method_name)
    , 
    std::move(stringified_details)
    );
}
void PaymentRequestClientInterceptorForTesting::OnShippingAddressChange(::payments::mojom::blink::PaymentAddressPtr address) {
  GetForwardingInterface()->OnShippingAddressChange(
    std::move(address)
    );
}
void PaymentRequestClientInterceptorForTesting::OnShippingOptionChange(const WTF::String& shipping_option_id) {
  GetForwardingInterface()->OnShippingOptionChange(
    std::move(shipping_option_id)
    );
}
void PaymentRequestClientInterceptorForTesting::OnPayerDetailChange(PayerDetailPtr detail) {
  GetForwardingInterface()->OnPayerDetailChange(
    std::move(detail)
    );
}
void PaymentRequestClientInterceptorForTesting::OnPaymentResponse(PaymentResponsePtr response) {
  GetForwardingInterface()->OnPaymentResponse(
    std::move(response)
    );
}
void PaymentRequestClientInterceptorForTesting::OnError(PaymentErrorReason error, const WTF::String& error_message) {
  GetForwardingInterface()->OnError(
    std::move(error)
    , 
    std::move(error_message)
    );
}
void PaymentRequestClientInterceptorForTesting::OnComplete() {
  GetForwardingInterface()->OnComplete();
}
void PaymentRequestClientInterceptorForTesting::OnAbort(bool aborted_successfully) {
  GetForwardingInterface()->OnAbort(
    std::move(aborted_successfully)
    );
}
void PaymentRequestClientInterceptorForTesting::OnCanMakePayment(CanMakePaymentQueryResult result) {
  GetForwardingInterface()->OnCanMakePayment(
    std::move(result)
    );
}
void PaymentRequestClientInterceptorForTesting::OnHasEnrolledInstrument(HasEnrolledInstrumentQueryResult result) {
  GetForwardingInterface()->OnHasEnrolledInstrument(
    std::move(result)
    );
}
void PaymentRequestClientInterceptorForTesting::WarnNoFavicon() {
  GetForwardingInterface()->WarnNoFavicon();
}
void PaymentRequestClientInterceptorForTesting::AllowConnectToSource(const ::blink::KURL& url, const ::blink::KURL& url_before_redirects, bool did_follow_redirect, AllowConnectToSourceCallback callback) {
  GetForwardingInterface()->AllowConnectToSource(
    std::move(url)
    , 
    std::move(url_before_redirects)
    , 
    std::move(did_follow_redirect)
    , std::move(callback));
}
PaymentRequestClientAsyncWaiter::PaymentRequestClientAsyncWaiter(
    PaymentRequestClient* proxy) : proxy_(proxy) {}

PaymentRequestClientAsyncWaiter::~PaymentRequestClientAsyncWaiter() = default;

void PaymentRequestClientAsyncWaiter::AllowConnectToSource(
    const ::blink::KURL& url, const ::blink::KURL& url_before_redirects, bool did_follow_redirect, bool* out_allow) {
  base::RunLoop loop;
  proxy_->AllowConnectToSource(
      std::move(url),
      std::move(url_before_redirects),
      std::move(did_follow_redirect),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_allow
,
             bool allow) {*out_allow = std::move(allow);
            loop->Quit();
          },
          &loop,
          out_allow));
  loop.Run();
}

bool PaymentRequestClientAsyncWaiter::AllowConnectToSource(
    const ::blink::KURL& url, const ::blink::KURL& url_before_redirects, bool did_follow_redirect) {
  bool async_wait_result;
  AllowConnectToSource(std::move(url),std::move(url_before_redirects),std::move(did_follow_redirect),&async_wait_result);
  return async_wait_result;
}




void PaymentRequestInterceptorForTesting::Init(::mojo::PendingRemote<PaymentRequestClient> client, WTF::Vector<PaymentMethodDataPtr> method_data, PaymentDetailsPtr details, PaymentOptionsPtr options) {
  GetForwardingInterface()->Init(
    std::move(client)
    , 
    std::move(method_data)
    , 
    std::move(details)
    , 
    std::move(options)
    );
}
void PaymentRequestInterceptorForTesting::Show(bool wait_for_updated_details, bool had_user_activation) {
  GetForwardingInterface()->Show(
    std::move(wait_for_updated_details)
    , 
    std::move(had_user_activation)
    );
}
void PaymentRequestInterceptorForTesting::UpdateWith(PaymentDetailsPtr details) {
  GetForwardingInterface()->UpdateWith(
    std::move(details)
    );
}
void PaymentRequestInterceptorForTesting::OnPaymentDetailsNotUpdated() {
  GetForwardingInterface()->OnPaymentDetailsNotUpdated();
}
void PaymentRequestInterceptorForTesting::Abort() {
  GetForwardingInterface()->Abort();
}
void PaymentRequestInterceptorForTesting::Complete(PaymentComplete result) {
  GetForwardingInterface()->Complete(
    std::move(result)
    );
}
void PaymentRequestInterceptorForTesting::Retry(::payments::mojom::blink::PaymentValidationErrorsPtr errors) {
  GetForwardingInterface()->Retry(
    std::move(errors)
    );
}
void PaymentRequestInterceptorForTesting::CanMakePayment() {
  GetForwardingInterface()->CanMakePayment();
}
void PaymentRequestInterceptorForTesting::HasEnrolledInstrument() {
  GetForwardingInterface()->HasEnrolledInstrument();
}
PaymentRequestAsyncWaiter::PaymentRequestAsyncWaiter(
    PaymentRequest* proxy) : proxy_(proxy) {}

PaymentRequestAsyncWaiter::~PaymentRequestAsyncWaiter() = default;






}  // payments::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif