// third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_OPTIONS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_OPTIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class ServiceWorkerRegistrationOptionsDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRegistrationOptionsDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRegistrationOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ServiceWorkerUpdateViaCache : int32_t {
  
  kImports = 0,
  
  kAll = 1,
  
  kNone = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(SERVICE_WORKER_STORAGE_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ServiceWorkerUpdateViaCache value);
inline bool IsKnownEnumValue(ServiceWorkerUpdateViaCache value) {
  return internal::ServiceWorkerUpdateViaCache_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ServiceWorkerRegistrationOptionsDataView {
 public:
  ServiceWorkerRegistrationOptionsDataView() = default;

  ServiceWorkerRegistrationOptionsDataView(
      internal::ServiceWorkerRegistrationOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScopeDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScope(UserType* output) {
    
    auto* pointer = data_->scope.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::ScriptType>(
        data_value, output);
  }
  ::blink::mojom::ScriptType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ScriptType>(data_->type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUpdateViaCache(UserType* output) const {
    auto data_value = data_->update_via_cache;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerUpdateViaCache>(
        data_value, output);
  }
  ServiceWorkerUpdateViaCache update_via_cache() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ServiceWorkerUpdateViaCache>(data_->update_via_cache));
  }
 private:
  internal::ServiceWorkerRegistrationOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::ServiceWorkerUpdateViaCache>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ServiceWorkerUpdateViaCache> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerUpdateViaCache, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ServiceWorkerUpdateViaCache, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ServiceWorkerUpdateViaCache>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRegistrationOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRegistrationOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerRegistrationOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::scope(input)) in_scope = Traits::scope(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scope)::BaseType> scope_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_scope, scope_fragment);
    fragment->scope.Set(
        scope_fragment.is_null() ? nullptr : scope_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scope.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scope in ServiceWorkerRegistrationOptions struct");
    mojo::internal::Serialize<::blink::mojom::ScriptType>(
        Traits::type(input), &fragment->type);
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerUpdateViaCache>(
        Traits::update_via_cache(input), &fragment->update_via_cache);
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRegistrationOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRegistrationOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void ServiceWorkerRegistrationOptionsDataView::GetScopeDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->scope.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(SERVICE_WORKER_STORAGE_MOJOM_SHARED) TraceFormatTraits<::blink::mojom::ServiceWorkerUpdateViaCache> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ServiceWorkerUpdateViaCache value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_OPTIONS_MOJOM_SHARED_H_