/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkTransformToDisplacementFieldFilter.h"
#include "itkTransformToDisplacementFieldFilter.h"

// Additional include files
#include "sitkTransform.h"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
TransformToDisplacementFieldFilter::TransformToDisplacementFieldFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
TransformToDisplacementFieldFilter::~TransformToDisplacementFieldFilter() = default;

//
// ToString
//
std::string TransformToDisplacementFieldFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::TransformToDisplacementFieldFilter\n";
  out << "  OutputPixelType: ";
  this->ToStringHelper(out, this->m_OutputPixelType);
  out << std::endl;
  out << "  Size: ";
  this->ToStringHelper(out, this->m_Size);
  out << std::endl;
  out << "  OutputOrigin: ";
  this->ToStringHelper(out, this->m_OutputOrigin);
  out << std::endl;
  out << "  OutputSpacing: ";
  this->ToStringHelper(out, this->m_OutputSpacing);
  out << std::endl;
  out << "  OutputDirection: ";
  this->ToStringHelper(out, this->m_OutputDirection);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}


//
// Custom Methods
//

void TransformToDisplacementFieldFilter::SetReferenceImage(const Image & refImage )
{
  this->SetSize( refImage.GetSize() ); this->SetOutputOrigin( refImage.GetOrigin() ); this->SetOutputSpacing( refImage.GetSpacing() );this->SetOutputDirection( refImage.GetDirection() );
}


//
// Execute
//
Image TransformToDisplacementFieldFilter::Execute ( const Transform & transform )
{

  PixelIDValueEnum type = m_OutputPixelType;
  unsigned int dimension = m_Size.size();

  

    return this->m_MemberFactory->GetMemberFunction( type, dimension )( &transform );
}

//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image TransformToDisplacementFieldFilter::ExecuteInternal ( const Transform * inTransform )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  //Define output image type
  using OutputImageType =  itk::Image< Vector<typename NumericTraits<typename TImageType::PixelType>::ValueType, TImageType::ImageDimension >, TImageType::ImageDimension >;



  using FilterType = itk::TransformToDisplacementFieldFilter<OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inTransform != nullptr );
  const typename FilterType::TransformType *itkTx = dynamic_cast<const typename FilterType::TransformType *>(inTransform->GetITKBase() );
  if ( !itkTx )
    {
    sitkExceptionMacro( "Unexpected error converting transform! Possible miss matching dimensions!" );
    }
  else { filter->SetTransform( itkTx ); }


  
  typename FilterType::SizeType itkVecSize = sitkSTLVectorToITK<typename FilterType::SizeType>( this->GetSize() );
  filter->SetSize( itkVecSize );
  typename FilterType::PointType itkVecOutputOrigin = sitkSTLVectorToITK<typename FilterType::PointType>( this->GetOutputOrigin() );
  filter->SetOutputOrigin( itkVecOutputOrigin );
  typename FilterType::SpacingType itkVecOutputSpacing = sitkSTLVectorToITK<typename FilterType::SpacingType>( this->GetOutputSpacing() );
  filter->SetOutputSpacing( itkVecOutputSpacing );
  filter->SetOutputDirection( sitkSTLToITKDirection<typename FilterType::DirectionType>( this->m_OutputDirection ) );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------



//
// Function to run the Execute method of this filter
//
Image TransformToDisplacementField ( const Transform & transform, PixelIDValueEnum outputPixelType, std::vector<unsigned int> size, std::vector<double> outputOrigin, std::vector<double> outputSpacing, std::vector<double> outputDirection )
{
  TransformToDisplacementFieldFilter filter;
  filter.SetOutputPixelType( outputPixelType );
  filter.SetSize( size );
  filter.SetOutputOrigin( outputOrigin );
  filter.SetOutputSpacing( outputSpacing );
  filter.SetOutputDirection( outputDirection );

  return filter.Execute ( transform );
}

}
