/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkVectorIndexSelectionCastImageFilter.h"
#include "itkVectorIndexSelectionCastImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
VectorIndexSelectionCastImageFilter::VectorIndexSelectionCastImageFilter ()
{

  this->m_DualMemberFactory.reset( new detail::DualMemberFunctionFactory<MemberFunctionType>( this ) );
  using PixelIDTypeList2 = typelist2::append<BasicPixelIDTypeList,VectorPixelIDTypeList>::type;
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 3 > ();
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 2 > ();





}

//
// Destructor
//
VectorIndexSelectionCastImageFilter::~VectorIndexSelectionCastImageFilter() = default;

//
// ToString
//
std::string VectorIndexSelectionCastImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::VectorIndexSelectionCastImageFilter\n";
  out << "  Index: ";
  this->ToStringHelper(out, this->m_Index);
  out << std::endl;
  out << "  OutputPixelType: ";
  this->ToStringHelper(out, this->m_OutputPixelType);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}



//
// Execute
//
Image VectorIndexSelectionCastImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type1 = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();
  const PixelIDValueEnum type2 = (m_OutputPixelType != sitkUnknown) ? m_OutputPixelType : type1;

  return this->m_DualMemberFactory->GetMemberFunction( type1, type2, dimension )( image1 );
}

Image VectorIndexSelectionCastImageFilter::Execute ( Image&& image1 )
{
  Image &temp = image1;
  auto autoResetInPlace = make_scope_exit([this, &temp]{this->m_InPlace=false; Image moved(std::move(temp));});
  if (temp.IsUnique())
    {
    m_InPlace = true;
    }
  return this->Execute( image1 );
}


//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType, class TImageType2>
Image VectorIndexSelectionCastImageFilter::DualExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;
  using InputImageType2 = TImageType2;

  // Define output image type
  using OutputImageType =  itk::Image< typename InputImageType2::InternalPixelType, InputImageType::ImageDimension >;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType =  itk::VectorIndexSelectionCastImageFilter<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  filter->SetIndex ( this->m_Index );
  
  filter->SetInPlace( m_InPlace );
         



  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}




//-----------------------------------------------------------------------------

//
// Function to run the Execute method of this filter
//
Image VectorIndexSelectionCast ( const Image& image1, unsigned int index, PixelIDValueEnum outputPixelType )
{
  VectorIndexSelectionCastImageFilter filter;
  filter.SetIndex( index );  filter.SetOutputPixelType( outputPixelType );
  return filter.Execute ( image1 );
}
//
// Function to run the Execute method of this filter
//
Image VectorIndexSelectionCast ( Image&& image1, unsigned int index, PixelIDValueEnum outputPixelType )
{
  VectorIndexSelectionCastImageFilter filter;
  filter.SetIndex( index );  filter.SetOutputPixelType( outputPixelType );
  return filter.Execute ( std::move(image1) );
}

}
