/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLDrawInstancedBaseVertexBaseInstance.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebGLDrawInstancedBaseVertexBaseInstancePrototypeFunction_drawArraysInstancedBaseInstanceWEBGL);
static JSC_DECLARE_HOST_FUNCTION(jsWebGLDrawInstancedBaseVertexBaseInstancePrototypeFunction_drawElementsInstancedBaseVertexBaseInstanceWEBGL);

class JSWebGLDrawInstancedBaseVertexBaseInstancePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLDrawInstancedBaseVertexBaseInstancePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLDrawInstancedBaseVertexBaseInstancePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLDrawInstancedBaseVertexBaseInstancePrototype>(vm)) JSWebGLDrawInstancedBaseVertexBaseInstancePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLDrawInstancedBaseVertexBaseInstancePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLDrawInstancedBaseVertexBaseInstancePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLDrawInstancedBaseVertexBaseInstancePrototype, JSWebGLDrawInstancedBaseVertexBaseInstancePrototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSWebGLDrawInstancedBaseVertexBaseInstancePrototypeTableValues {
    HashTableValue { "drawArraysInstancedBaseInstanceWEBGL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLDrawInstancedBaseVertexBaseInstancePrototypeFunction_drawArraysInstancedBaseInstanceWEBGL, 5 } },
    HashTableValue { "drawElementsInstancedBaseVertexBaseInstanceWEBGL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLDrawInstancedBaseVertexBaseInstancePrototypeFunction_drawElementsInstancedBaseVertexBaseInstanceWEBGL, 7 } },
};

const ClassInfo JSWebGLDrawInstancedBaseVertexBaseInstancePrototype::s_info = { "WebGLDrawInstancedBaseVertexBaseInstance"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLDrawInstancedBaseVertexBaseInstancePrototype) };

void JSWebGLDrawInstancedBaseVertexBaseInstancePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLDrawInstancedBaseVertexBaseInstance::info(), JSWebGLDrawInstancedBaseVertexBaseInstancePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLDrawInstancedBaseVertexBaseInstance::s_info = { "WebGLDrawInstancedBaseVertexBaseInstance"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLDrawInstancedBaseVertexBaseInstance) };

JSWebGLDrawInstancedBaseVertexBaseInstance::JSWebGLDrawInstancedBaseVertexBaseInstance(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLDrawInstancedBaseVertexBaseInstance>&& impl)
    : JSDOMWrapper<WebGLDrawInstancedBaseVertexBaseInstance>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLDrawInstancedBaseVertexBaseInstance>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLDrawInstancedBaseVertexBaseInstance::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLDrawInstancedBaseVertexBaseInstancePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLDrawInstancedBaseVertexBaseInstancePrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLDrawInstancedBaseVertexBaseInstance::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLDrawInstancedBaseVertexBaseInstance>(vm, globalObject);
}

void JSWebGLDrawInstancedBaseVertexBaseInstance::destroy(JSC::JSCell* cell)
{
    JSWebGLDrawInstancedBaseVertexBaseInstance* thisObject = static_cast<JSWebGLDrawInstancedBaseVertexBaseInstance*>(cell);
    thisObject->JSWebGLDrawInstancedBaseVertexBaseInstance::~JSWebGLDrawInstancedBaseVertexBaseInstance();
}

static inline JSC::EncodedJSValue jsWebGLDrawInstancedBaseVertexBaseInstancePrototypeFunction_drawArraysInstancedBaseInstanceWEBGLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLDrawInstancedBaseVertexBaseInstance>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 5) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto modeConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (modeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto firstConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    if (firstConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto countConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument2.value());
    if (countConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto instanceCountConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument3.value());
    if (instanceCountConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto baseInstanceConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument4.value());
    if (baseInstanceConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawArraysInstancedBaseInstanceWEBGL(modeConversionResult.releaseReturnValue(), firstConversionResult.releaseReturnValue(), countConversionResult.releaseReturnValue(), instanceCountConversionResult.releaseReturnValue(), baseInstanceConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLDrawInstancedBaseVertexBaseInstancePrototypeFunction_drawArraysInstancedBaseInstanceWEBGL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLDrawInstancedBaseVertexBaseInstance>::call<jsWebGLDrawInstancedBaseVertexBaseInstancePrototypeFunction_drawArraysInstancedBaseInstanceWEBGLBody>(*lexicalGlobalObject, *callFrame, "drawArraysInstancedBaseInstanceWEBGL");
}

static inline JSC::EncodedJSValue jsWebGLDrawInstancedBaseVertexBaseInstancePrototypeFunction_drawElementsInstancedBaseVertexBaseInstanceWEBGLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLDrawInstancedBaseVertexBaseInstance>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 7) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto modeConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (modeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto countConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument1.value());
    if (countConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto typeConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto offsetConversionResult = convert<IDLLongLong>(*lexicalGlobalObject, argument3.value());
    if (offsetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto instanceCountConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    if (instanceCountConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto baseVertexConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument5.value());
    if (baseVertexConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto baseInstanceConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument6.value());
    if (baseInstanceConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawElementsInstancedBaseVertexBaseInstanceWEBGL(modeConversionResult.releaseReturnValue(), countConversionResult.releaseReturnValue(), typeConversionResult.releaseReturnValue(), offsetConversionResult.releaseReturnValue(), instanceCountConversionResult.releaseReturnValue(), baseVertexConversionResult.releaseReturnValue(), baseInstanceConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLDrawInstancedBaseVertexBaseInstancePrototypeFunction_drawElementsInstancedBaseVertexBaseInstanceWEBGL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLDrawInstancedBaseVertexBaseInstance>::call<jsWebGLDrawInstancedBaseVertexBaseInstancePrototypeFunction_drawElementsInstancedBaseVertexBaseInstanceWEBGLBody>(*lexicalGlobalObject, *callFrame, "drawElementsInstancedBaseVertexBaseInstanceWEBGL");
}

JSC::GCClient::IsoSubspace* JSWebGLDrawInstancedBaseVertexBaseInstance::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLDrawInstancedBaseVertexBaseInstance, UseCustomHeapCellType::No>(vm, "JSWebGLDrawInstancedBaseVertexBaseInstance"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLDrawInstancedBaseVertexBaseInstance.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLDrawInstancedBaseVertexBaseInstance = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLDrawInstancedBaseVertexBaseInstance.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLDrawInstancedBaseVertexBaseInstance = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLDrawInstancedBaseVertexBaseInstance::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLDrawInstancedBaseVertexBaseInstance*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLDrawInstancedBaseVertexBaseInstanceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsWebGLDrawInstancedBaseVertexBaseInstance = jsCast<JSWebGLDrawInstancedBaseVertexBaseInstance*>(handle.slot()->asCell());
    auto& owner = jsWebGLDrawInstancedBaseVertexBaseInstance->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsWebGLDrawInstancedBaseVertexBaseInstance"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLDrawInstancedBaseVertexBaseInstanceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLDrawInstancedBaseVertexBaseInstance = static_cast<JSWebGLDrawInstancedBaseVertexBaseInstance*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLDrawInstancedBaseVertexBaseInstance->protectedWrapped().ptr(), jsWebGLDrawInstancedBaseVertexBaseInstance);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLDrawInstancedBaseVertexBaseInstance@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore40WebGLDrawInstancedBaseVertexBaseInstanceE[]; }
#endif
template<std::same_as<WebGLDrawInstancedBaseVertexBaseInstance> T>
static inline void verifyVTable(WebGLDrawInstancedBaseVertexBaseInstance* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLDrawInstancedBaseVertexBaseInstance@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore40WebGLDrawInstancedBaseVertexBaseInstanceE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLDrawInstancedBaseVertexBaseInstance has subclasses. If WebGLDrawInstancedBaseVertexBaseInstance has subclasses that get passed
        // to toJS() we currently require WebGLDrawInstancedBaseVertexBaseInstance you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLDrawInstancedBaseVertexBaseInstance>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLDrawInstancedBaseVertexBaseInstance>(impl.ptr());
#endif
    return createWrapper<WebGLDrawInstancedBaseVertexBaseInstance>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLDrawInstancedBaseVertexBaseInstance& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLDrawInstancedBaseVertexBaseInstance* JSWebGLDrawInstancedBaseVertexBaseInstance::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLDrawInstancedBaseVertexBaseInstance*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
