/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_clock_recovery_mm_cc = R"doc(Mueller and M?ller (M&M) based clock recovery block with complex input, complex output.

This implements the Mueller and M?ller (M&M) discrete-time error-tracking synchronizer.


The peak to peak input signal amplitude must be symmetrical about zero, as the M&M timing error detector (TED) is a decision directed TED, and this block uses a symbol decision slicer referenced at zero.


The input signal peak amplitude should be controlled to a consistent level (e.g. +/- 1.0) before this block to achieve consistent results for given gain settings; as the TED's output error signal is directly affected by the input amplitude.


The input signal must have peaks in order for the TED to output a correct error signal. If the input signal pulses do not have peaks (e.g. rectangular pulses) the input signal should be conditioned with a matched pulse filter or other appropriate filter to peak the input pulses. For a rectangular base pulse that is N samples wide, the matched filter taps would be [1.0/float(N)]*N, or in other words a moving average over N samples.


This block will output samples at a rate of one sample per recovered symbol, and is thus not outputting at a constant rate.


Output symbols are not a subset of input, but may be interpolated.


The complex version here is based on: Modified Mueller and Muller clock recovery circuit:


G. R. Danesfahani, T.G. Jeans, \"Optimisation of modified Mueller
   and Muller algorithm,\" Electronics Letters, Vol. 31, no. 13, 22 June 1995, pp. 1032 - 1033.

Constructor Specific Documentation:

Make a M&M clock recovery block.

Args:
    omega : Initial estimate of samples per symbol
    gain_omega : Gain setting for omega update loop
    mu : Initial estimate of phase of sample
    gain_mu : Gain setting for mu update loop
    omega_relative_limit : limit on omega)doc";


static const char* __doc_gr_digital_clock_recovery_mm_cc_clock_recovery_mm_cc_0 =
    R"doc()doc";


static const char* __doc_gr_digital_clock_recovery_mm_cc_clock_recovery_mm_cc_1 =
    R"doc()doc";


static const char* __doc_gr_digital_clock_recovery_mm_cc_make = R"doc(Mueller and M?ller (M&M) based clock recovery block with complex input, complex output.

This implements the Mueller and M?ller (M&M) discrete-time error-tracking synchronizer.


The peak to peak input signal amplitude must be symmetrical about zero, as the M&M timing error detector (TED) is a decision directed TED, and this block uses a symbol decision slicer referenced at zero.


The input signal peak amplitude should be controlled to a consistent level (e.g. +/- 1.0) before this block to achieve consistent results for given gain settings; as the TED's output error signal is directly affected by the input amplitude.


The input signal must have peaks in order for the TED to output a correct error signal. If the input signal pulses do not have peaks (e.g. rectangular pulses) the input signal should be conditioned with a matched pulse filter or other appropriate filter to peak the input pulses. For a rectangular base pulse that is N samples wide, the matched filter taps would be [1.0/float(N)]*N, or in other words a moving average over N samples.


This block will output samples at a rate of one sample per recovered symbol, and is thus not outputting at a constant rate.


Output symbols are not a subset of input, but may be interpolated.


The complex version here is based on: Modified Mueller and Muller clock recovery circuit:


G. R. Danesfahani, T.G. Jeans, \"Optimisation of modified Mueller
   and Muller algorithm,\" Electronics Letters, Vol. 31, no. 13, 22 June 1995, pp. 1032 - 1033.

Constructor Specific Documentation:

Make a M&M clock recovery block.

Args:
    omega : Initial estimate of samples per symbol
    gain_omega : Gain setting for omega update loop
    mu : Initial estimate of phase of sample
    gain_mu : Gain setting for mu update loop
    omega_relative_limit : limit on omega)doc";


static const char* __doc_gr_digital_clock_recovery_mm_cc_mu = R"doc()doc";


static const char* __doc_gr_digital_clock_recovery_mm_cc_omega = R"doc()doc";


static const char* __doc_gr_digital_clock_recovery_mm_cc_gain_mu = R"doc()doc";


static const char* __doc_gr_digital_clock_recovery_mm_cc_gain_omega = R"doc()doc";


static const char* __doc_gr_digital_clock_recovery_mm_cc_set_verbose = R"doc()doc";


static const char* __doc_gr_digital_clock_recovery_mm_cc_set_gain_mu = R"doc()doc";


static const char* __doc_gr_digital_clock_recovery_mm_cc_set_gain_omega = R"doc()doc";


static const char* __doc_gr_digital_clock_recovery_mm_cc_set_mu = R"doc()doc";


static const char* __doc_gr_digital_clock_recovery_mm_cc_set_omega = R"doc()doc";
