/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_glfsr_source_b = R"doc(Galois LFSR pseudo-random source.

Constructor Specific Documentation:

Make a Galois LFSR pseudo-random source block.

Args:
    degree : Degree of shift register must be in [1, 32]. If mask is 0, the degree determines a default mask (see digital_impl_glfsr.cc for the mapping).
    repeat : Set to repeat sequence.
    mask : Allows a user-defined bit mask for indexes of the shift register to feed back.
    seed : Initial setting for values in shift register.)doc";


static const char* __doc_gr_digital_glfsr_source_b_glfsr_source_b_0 = R"doc()doc";


static const char* __doc_gr_digital_glfsr_source_b_glfsr_source_b_1 = R"doc()doc";


static const char* __doc_gr_digital_glfsr_source_b_make = R"doc(Galois LFSR pseudo-random source.

Constructor Specific Documentation:

Make a Galois LFSR pseudo-random source block.

Args:
    degree : Degree of shift register must be in [1, 32]. If mask is 0, the degree determines a default mask (see digital_impl_glfsr.cc for the mapping).
    repeat : Set to repeat sequence.
    mask : Allows a user-defined bit mask for indexes of the shift register to feed back.
    seed : Initial setting for values in shift register.)doc";


static const char* __doc_gr_digital_glfsr_source_b_period = R"doc()doc";


static const char* __doc_gr_digital_glfsr_source_b_mask = R"doc()doc";
