{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A structure used to store a rectangle used by AtkText.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Structs.TextRectangle
    ( 

-- * Exported types
    TextRectangle(..)                       ,
    newZeroTextRectangle                    ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveTextRectangleMethod              ,
#endif



 -- * Properties


-- ** height #attr:height#
-- | The height of a rectangle

    getTextRectangleHeight                  ,
    setTextRectangleHeight                  ,
#if defined(ENABLE_OVERLOADING)
    textRectangle_height                    ,
#endif


-- ** width #attr:width#
-- | The width of a rectangle

    getTextRectangleWidth                   ,
    setTextRectangleWidth                   ,
#if defined(ENABLE_OVERLOADING)
    textRectangle_width                     ,
#endif


-- ** x #attr:x#
-- | The horizontal coordinate of a rectangle

    getTextRectangleX                       ,
    setTextRectangleX                       ,
#if defined(ENABLE_OVERLOADING)
    textRectangle_x                         ,
#endif


-- ** y #attr:y#
-- | The vertical coordinate of a rectangle

    getTextRectangleY                       ,
    setTextRectangleY                       ,
#if defined(ENABLE_OVERLOADING)
    textRectangle_y                         ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype TextRectangle = TextRectangle (SP.ManagedPtr TextRectangle)
    deriving (Eq)

instance SP.ManagedPtrNewtype TextRectangle where
    toManagedPtr (TextRectangle p) = p

instance BoxedPtr TextRectangle where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr TextRectangle)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr TextRectangle where
    boxedPtrCalloc = callocBytes 16


-- | Construct a t'TextRectangle' struct initialized to zero.
newZeroTextRectangle :: MonadIO m => m TextRectangle
newZeroTextRectangle = liftIO $ boxedPtrCalloc >>= wrapPtr TextRectangle

instance tag ~ 'AttrSet => Constructible TextRectangle tag where
    new _ attrs = do
        o <- newZeroTextRectangle
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textRectangle #x
-- @
getTextRectangleX :: MonadIO m => TextRectangle -> m Int32
getTextRectangleX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textRectangle [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextRectangleX :: MonadIO m => TextRectangle -> Int32 -> m ()
setTextRectangleX s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data TextRectangleXFieldInfo
instance AttrInfo TextRectangleXFieldInfo where
    type AttrBaseTypeConstraint TextRectangleXFieldInfo = (~) TextRectangle
    type AttrAllowedOps TextRectangleXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TextRectangleXFieldInfo = (~) Int32
    type AttrTransferTypeConstraint TextRectangleXFieldInfo = (~)Int32
    type AttrTransferType TextRectangleXFieldInfo = Int32
    type AttrGetType TextRectangleXFieldInfo = Int32
    type AttrLabel TextRectangleXFieldInfo = "x"
    type AttrOrigin TextRectangleXFieldInfo = TextRectangle
    attrGet = getTextRectangleX
    attrSet = setTextRectangleX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.TextRectangle.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-TextRectangle.html#g:attr:x"
        })

textRectangle_x :: AttrLabelProxy "x"
textRectangle_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textRectangle #y
-- @
getTextRectangleY :: MonadIO m => TextRectangle -> m Int32
getTextRectangleY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textRectangle [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextRectangleY :: MonadIO m => TextRectangle -> Int32 -> m ()
setTextRectangleY s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data TextRectangleYFieldInfo
instance AttrInfo TextRectangleYFieldInfo where
    type AttrBaseTypeConstraint TextRectangleYFieldInfo = (~) TextRectangle
    type AttrAllowedOps TextRectangleYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TextRectangleYFieldInfo = (~) Int32
    type AttrTransferTypeConstraint TextRectangleYFieldInfo = (~)Int32
    type AttrTransferType TextRectangleYFieldInfo = Int32
    type AttrGetType TextRectangleYFieldInfo = Int32
    type AttrLabel TextRectangleYFieldInfo = "y"
    type AttrOrigin TextRectangleYFieldInfo = TextRectangle
    attrGet = getTextRectangleY
    attrSet = setTextRectangleY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.TextRectangle.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-TextRectangle.html#g:attr:y"
        })

textRectangle_y :: AttrLabelProxy "y"
textRectangle_y = AttrLabelProxy

#endif


-- | Get the value of the “@width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textRectangle #width
-- @
getTextRectangleWidth :: MonadIO m => TextRectangle -> m Int32
getTextRectangleWidth s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textRectangle [ #width 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextRectangleWidth :: MonadIO m => TextRectangle -> Int32 -> m ()
setTextRectangleWidth s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data TextRectangleWidthFieldInfo
instance AttrInfo TextRectangleWidthFieldInfo where
    type AttrBaseTypeConstraint TextRectangleWidthFieldInfo = (~) TextRectangle
    type AttrAllowedOps TextRectangleWidthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TextRectangleWidthFieldInfo = (~) Int32
    type AttrTransferTypeConstraint TextRectangleWidthFieldInfo = (~)Int32
    type AttrTransferType TextRectangleWidthFieldInfo = Int32
    type AttrGetType TextRectangleWidthFieldInfo = Int32
    type AttrLabel TextRectangleWidthFieldInfo = "width"
    type AttrOrigin TextRectangleWidthFieldInfo = TextRectangle
    attrGet = getTextRectangleWidth
    attrSet = setTextRectangleWidth
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.TextRectangle.width"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-TextRectangle.html#g:attr:width"
        })

textRectangle_width :: AttrLabelProxy "width"
textRectangle_width = AttrLabelProxy

#endif


-- | Get the value of the “@height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textRectangle #height
-- @
getTextRectangleHeight :: MonadIO m => TextRectangle -> m Int32
getTextRectangleHeight s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Int32
    return val

-- | Set the value of the “@height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textRectangle [ #height 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextRectangleHeight :: MonadIO m => TextRectangle -> Int32 -> m ()
setTextRectangleHeight s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data TextRectangleHeightFieldInfo
instance AttrInfo TextRectangleHeightFieldInfo where
    type AttrBaseTypeConstraint TextRectangleHeightFieldInfo = (~) TextRectangle
    type AttrAllowedOps TextRectangleHeightFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TextRectangleHeightFieldInfo = (~) Int32
    type AttrTransferTypeConstraint TextRectangleHeightFieldInfo = (~)Int32
    type AttrTransferType TextRectangleHeightFieldInfo = Int32
    type AttrGetType TextRectangleHeightFieldInfo = Int32
    type AttrLabel TextRectangleHeightFieldInfo = "height"
    type AttrOrigin TextRectangleHeightFieldInfo = TextRectangle
    attrGet = getTextRectangleHeight
    attrSet = setTextRectangleHeight
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.TextRectangle.height"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-TextRectangle.html#g:attr:height"
        })

textRectangle_height :: AttrLabelProxy "height"
textRectangle_height = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TextRectangle
type instance O.AttributeList TextRectangle = TextRectangleAttributeList
type TextRectangleAttributeList = ('[ '("x", TextRectangleXFieldInfo), '("y", TextRectangleYFieldInfo), '("width", TextRectangleWidthFieldInfo), '("height", TextRectangleHeightFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTextRectangleMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTextRectangleMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTextRectangleMethod t TextRectangle, O.OverloadedMethod info TextRectangle p) => OL.IsLabel t (TextRectangle -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTextRectangleMethod t TextRectangle, O.OverloadedMethod info TextRectangle p, R.HasField t TextRectangle p) => R.HasField t TextRectangle p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTextRectangleMethod t TextRectangle, O.OverloadedMethodInfo info TextRectangle) => OL.IsLabel t (O.MethodProxy info TextRectangle) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


