{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A point with two coordinates.
-- 
-- /Since: 1.0/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Structs.Point
    ( 

-- * Exported types
    Point(..)                               ,
    newZeroPoint                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [distance]("GI.Graphene.Structs.Point#g:method:distance"), [equal]("GI.Graphene.Structs.Point#g:method:equal"), [free]("GI.Graphene.Structs.Point#g:method:free"), [init]("GI.Graphene.Structs.Point#g:method:init"), [initFromPoint]("GI.Graphene.Structs.Point#g:method:initFromPoint"), [initFromVec2]("GI.Graphene.Structs.Point#g:method:initFromVec2"), [interpolate]("GI.Graphene.Structs.Point#g:method:interpolate"), [near]("GI.Graphene.Structs.Point#g:method:near"), [toVec2]("GI.Graphene.Structs.Point#g:method:toVec2").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolvePointMethod                      ,
#endif

-- ** alloc #method:alloc#

    pointAlloc                              ,


-- ** distance #method:distance#

#if defined(ENABLE_OVERLOADING)
    PointDistanceMethodInfo                 ,
#endif
    pointDistance                           ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    PointEqualMethodInfo                    ,
#endif
    pointEqual                              ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    PointFreeMethodInfo                     ,
#endif
    pointFree                               ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    PointInitMethodInfo                     ,
#endif
    pointInit                               ,


-- ** initFromPoint #method:initFromPoint#

#if defined(ENABLE_OVERLOADING)
    PointInitFromPointMethodInfo            ,
#endif
    pointInitFromPoint                      ,


-- ** initFromVec2 #method:initFromVec2#

#if defined(ENABLE_OVERLOADING)
    PointInitFromVec2MethodInfo             ,
#endif
    pointInitFromVec2                       ,


-- ** interpolate #method:interpolate#

#if defined(ENABLE_OVERLOADING)
    PointInterpolateMethodInfo              ,
#endif
    pointInterpolate                        ,


-- ** near #method:near#

#if defined(ENABLE_OVERLOADING)
    PointNearMethodInfo                     ,
#endif
    pointNear                               ,


-- ** toVec2 #method:toVec2#

#if defined(ENABLE_OVERLOADING)
    PointToVec2MethodInfo                   ,
#endif
    pointToVec2                             ,


-- ** zero #method:zero#

    pointZero                               ,




 -- * Properties


-- ** x #attr:x#
-- | the X coordinate of the point

    getPointX                               ,
#if defined(ENABLE_OVERLOADING)
    point_x                                 ,
#endif
    setPointX                               ,


-- ** y #attr:y#
-- | the Y coordinate of the point

    getPointY                               ,
#if defined(ENABLE_OVERLOADING)
    point_y                                 ,
#endif
    setPointY                               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2

#else
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2

#endif

-- | Memory-managed wrapper type.
newtype Point = Point (SP.ManagedPtr Point)
    deriving (Eq)

instance SP.ManagedPtrNewtype Point where
    toManagedPtr (Point p) = p

foreign import ccall "graphene_point_get_type" c_graphene_point_get_type :: 
    IO GType

type instance O.ParentTypes Point = '[]
instance O.HasParentTypes Point

instance B.Types.TypedObject Point where
    glibType = c_graphene_point_get_type

instance B.Types.GBoxed Point

-- | Convert t'Point' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Point) where
    gvalueGType_ = c_graphene_point_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Point)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Point)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Point ptr
        else return P.Nothing
        
    

-- | Construct a t'Point' struct initialized to zero.
newZeroPoint :: MonadIO m => m Point
newZeroPoint = liftIO $ callocBoxedBytes 8 >>= wrapBoxed Point

instance tag ~ 'AttrSet => Constructible Point tag where
    new _ attrs = do
        o <- newZeroPoint
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' point #x
-- @
getPointX :: MonadIO m => Point -> m Float
getPointX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' point [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setPointX :: MonadIO m => Point -> Float -> m ()
setPointX s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 0) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data PointXFieldInfo
instance AttrInfo PointXFieldInfo where
    type AttrBaseTypeConstraint PointXFieldInfo = (~) Point
    type AttrAllowedOps PointXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint PointXFieldInfo = (~) Float
    type AttrTransferTypeConstraint PointXFieldInfo = (~)Float
    type AttrTransferType PointXFieldInfo = Float
    type AttrGetType PointXFieldInfo = Float
    type AttrLabel PointXFieldInfo = "x"
    type AttrOrigin PointXFieldInfo = Point
    attrGet = getPointX
    attrSet = setPointX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point.html#g:attr:x"
        })

point_x :: AttrLabelProxy "x"
point_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' point #y
-- @
getPointY :: MonadIO m => Point -> m Float
getPointY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' point [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setPointY :: MonadIO m => Point -> Float -> m ()
setPointY s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 4) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data PointYFieldInfo
instance AttrInfo PointYFieldInfo where
    type AttrBaseTypeConstraint PointYFieldInfo = (~) Point
    type AttrAllowedOps PointYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint PointYFieldInfo = (~) Float
    type AttrTransferTypeConstraint PointYFieldInfo = (~)Float
    type AttrTransferType PointYFieldInfo = Float
    type AttrGetType PointYFieldInfo = Float
    type AttrLabel PointYFieldInfo = "y"
    type AttrOrigin PointYFieldInfo = Point
    attrGet = getPointY
    attrSet = setPointY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point.html#g:attr:y"
        })

point_y :: AttrLabelProxy "y"
point_y = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Point
type instance O.AttributeList Point = PointAttributeList
type PointAttributeList = ('[ '("x", PointXFieldInfo), '("y", PointYFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Point::alloc
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Point" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point_alloc" graphene_point_alloc :: 
    IO (Ptr Point)

-- | Allocates a new t'GI.Graphene.Structs.Point.Point' structure.
-- 
-- The coordinates of the returned point are (0, 0).
-- 
-- It\'s possible to chain this function with 'GI.Graphene.Structs.Point.pointInit'
-- or 'GI.Graphene.Structs.Point.pointInitFromPoint', e.g.:
-- 
-- 
-- === /C code/
-- >
-- >  graphene_point_t *
-- >  point_new (float x, float y)
-- >  {
-- >    return graphene_point_init (graphene_point_alloc (), x, y);
-- >  }
-- >
-- >  graphene_point_t *
-- >  point_copy (const graphene_point_t *p)
-- >  {
-- >    return graphene_point_init_from_point (graphene_point_alloc (), p);
-- >  }
-- 
-- 
-- /Since: 1.0/
pointAlloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Point
    -- ^ __Returns:__ the newly allocated t'GI.Graphene.Structs.Point.Point'.
    --   Use 'GI.Graphene.Structs.Point.pointFree' to free the resources allocated by
    --   this function.
pointAlloc  = liftIO $ do
    result <- graphene_point_alloc
    checkUnexpectedReturnNULL "pointAlloc" result
    result' <- (wrapBoxed Point) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Point::distance
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "d_x"
--           , argType = TBasicType TFloat
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "distance component on the X axis"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "d_y"
--           , argType = TBasicType TFloat
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "distance component on the Y axis"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point_distance" graphene_point_distance :: 
    Ptr Point ->                            -- a : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Point ->                            -- b : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr CFloat ->                           -- d_x : TBasicType TFloat
    Ptr CFloat ->                           -- d_y : TBasicType TFloat
    IO CFloat

-- | Computes the distance between /@a@/ and /@b@/.
-- 
-- /Since: 1.0/
pointDistance ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point
    -- ^ /@a@/: a t'GI.Graphene.Structs.Point.Point'
    -> Point
    -- ^ /@b@/: a t'GI.Graphene.Structs.Point.Point'
    -> m ((Float, Float, Float))
    -- ^ __Returns:__ the distance between the two points
pointDistance a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    dX <- allocMem :: IO (Ptr CFloat)
    dY <- allocMem :: IO (Ptr CFloat)
    result <- graphene_point_distance a' b' dX dY
    let result' = realToFrac result
    dX' <- peek dX
    let dX'' = realToFrac dX'
    dY' <- peek dY
    let dY'' = realToFrac dY'
    touchManagedPtr a
    touchManagedPtr b
    freeMem dX
    freeMem dY
    return (result', dX'', dY'')

#if defined(ENABLE_OVERLOADING)
data PointDistanceMethodInfo
instance (signature ~ (Point -> m ((Float, Float, Float))), MonadIO m) => O.OverloadedMethod PointDistanceMethodInfo Point signature where
    overloadedMethod = pointDistance

instance O.OverloadedMethodInfo PointDistanceMethodInfo Point where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point.pointDistance",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point.html#v:pointDistance"
        })


#endif

-- method Point::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point_equal" graphene_point_equal :: 
    Ptr Point ->                            -- a : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Point ->                            -- b : TInterface (Name {namespace = "Graphene", name = "Point"})
    IO CInt

-- | Checks if the two points /@a@/ and /@b@/ point to the same
-- coordinates.
-- 
-- This function accounts for floating point fluctuations; if
-- you want to control the fuzziness of the match, you can use
-- 'GI.Graphene.Structs.Point.pointNear' instead.
-- 
-- /Since: 1.0/
pointEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point
    -- ^ /@a@/: a t'GI.Graphene.Structs.Point.Point'
    -> Point
    -- ^ /@b@/: a t'GI.Graphene.Structs.Point.Point'
    -> m Bool
    -- ^ __Returns:__ @true@ if the points have the same coordinates
pointEqual a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_point_equal a' b'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data PointEqualMethodInfo
instance (signature ~ (Point -> m Bool), MonadIO m) => O.OverloadedMethod PointEqualMethodInfo Point signature where
    overloadedMethod = pointEqual

instance O.OverloadedMethodInfo PointEqualMethodInfo Point where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point.pointEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point.html#v:pointEqual"
        })


#endif

-- method Point::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point_free" graphene_point_free :: 
    Ptr Point ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Point"})
    IO ()

-- | Frees the resources allocated by 'GI.Graphene.Structs.Point.pointAlloc'.
-- 
-- /Since: 1.0/
pointFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point.Point'
    -> m ()
pointFree p = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    graphene_point_free p'
    touchManagedPtr p
    return ()

#if defined(ENABLE_OVERLOADING)
data PointFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod PointFreeMethodInfo Point signature where
    overloadedMethod = pointFree

instance O.OverloadedMethodInfo PointFreeMethodInfo Point where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point.pointFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point.html#v:pointFree"
        })


#endif

-- method Point::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the X coordinate" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the Y coordinate" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Point" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point_init" graphene_point_init :: 
    Ptr Point ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Point"})
    CFloat ->                               -- x : TBasicType TFloat
    CFloat ->                               -- y : TBasicType TFloat
    IO (Ptr Point)

-- | Initializes /@p@/ to the given /@x@/ and /@y@/ coordinates.
-- 
-- It\'s safe to call this function multiple times.
-- 
-- /Since: 1.0/
pointInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point.Point'
    -> Float
    -- ^ /@x@/: the X coordinate
    -> Float
    -- ^ /@y@/: the Y coordinate
    -> m Point
    -- ^ __Returns:__ the initialized point
pointInit p x y = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    let x' = realToFrac x
    let y' = realToFrac y
    result <- graphene_point_init p' x' y'
    checkUnexpectedReturnNULL "pointInit" result
    result' <- (newBoxed Point) result
    touchManagedPtr p
    return result'

#if defined(ENABLE_OVERLOADING)
data PointInitMethodInfo
instance (signature ~ (Float -> Float -> m Point), MonadIO m) => O.OverloadedMethod PointInitMethodInfo Point signature where
    overloadedMethod = pointInit

instance O.OverloadedMethodInfo PointInitMethodInfo Point where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point.pointInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point.html#v:pointInit"
        })


#endif

-- method Point::init_from_point
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_point_t to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Point" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point_init_from_point" graphene_point_init_from_point :: 
    Ptr Point ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Point ->                            -- src : TInterface (Name {namespace = "Graphene", name = "Point"})
    IO (Ptr Point)

-- | Initializes /@p@/ with the same coordinates of /@src@/.
-- 
-- /Since: 1.0/
pointInitFromPoint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point.Point'
    -> Point
    -- ^ /@src@/: the t'GI.Graphene.Structs.Point.Point' to use
    -> m Point
    -- ^ __Returns:__ the initialized point
pointInitFromPoint p src = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    src' <- unsafeManagedPtrGetPtr src
    result <- graphene_point_init_from_point p' src'
    checkUnexpectedReturnNULL "pointInitFromPoint" result
    result' <- (newBoxed Point) result
    touchManagedPtr p
    touchManagedPtr src
    return result'

#if defined(ENABLE_OVERLOADING)
data PointInitFromPointMethodInfo
instance (signature ~ (Point -> m Point), MonadIO m) => O.OverloadedMethod PointInitFromPointMethodInfo Point signature where
    overloadedMethod = pointInitFromPoint

instance O.OverloadedMethodInfo PointInitFromPointMethodInfo Point where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point.pointInitFromPoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point.html#v:pointInitFromPoint"
        })


#endif

-- method Point::init_from_vec2
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_point_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec2" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_vec2_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Point" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point_init_from_vec2" graphene_point_init_from_vec2 :: 
    Ptr Point ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Graphene.Vec2.Vec2 ->               -- src : TInterface (Name {namespace = "Graphene", name = "Vec2"})
    IO (Ptr Point)

-- | Initializes /@p@/ with the coordinates inside the given t'GI.Graphene.Structs.Vec2.Vec2'.
-- 
-- /Since: 1.4/
pointInitFromVec2 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point
    -- ^ /@p@/: the t'GI.Graphene.Structs.Point.Point' to initialize
    -> Graphene.Vec2.Vec2
    -- ^ /@src@/: a t'GI.Graphene.Structs.Vec2.Vec2'
    -> m Point
    -- ^ __Returns:__ the initialized point
pointInitFromVec2 p src = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    src' <- unsafeManagedPtrGetPtr src
    result <- graphene_point_init_from_vec2 p' src'
    checkUnexpectedReturnNULL "pointInitFromVec2" result
    result' <- (newBoxed Point) result
    touchManagedPtr p
    touchManagedPtr src
    return result'

#if defined(ENABLE_OVERLOADING)
data PointInitFromVec2MethodInfo
instance (signature ~ (Graphene.Vec2.Vec2 -> m Point), MonadIO m) => O.OverloadedMethod PointInitFromVec2MethodInfo Point signature where
    overloadedMethod = pointInitFromVec2

instance O.OverloadedMethodInfo PointInitFromVec2MethodInfo Point where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point.pointInitFromVec2",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point.html#v:pointInitFromVec2"
        })


#endif

-- method Point::interpolate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factor"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the linear interpolation factor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the interpolated\n  point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point_interpolate" graphene_point_interpolate :: 
    Ptr Point ->                            -- a : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Point ->                            -- b : TInterface (Name {namespace = "Graphene", name = "Point"})
    CDouble ->                              -- factor : TBasicType TDouble
    Ptr Point ->                            -- res : TInterface (Name {namespace = "Graphene", name = "Point"})
    IO ()

-- | Linearly interpolates the coordinates of /@a@/ and /@b@/ using the
-- given /@factor@/.
-- 
-- /Since: 1.0/
pointInterpolate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point
    -- ^ /@a@/: a t'GI.Graphene.Structs.Point.Point'
    -> Point
    -- ^ /@b@/: a t'GI.Graphene.Structs.Point.Point'
    -> Double
    -- ^ /@factor@/: the linear interpolation factor
    -> m (Point)
pointInterpolate a b factor = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    let factor' = realToFrac factor
    res <- SP.callocBoxedBytes 8 :: IO (Ptr Point)
    graphene_point_interpolate a' b' factor' res
    res' <- (wrapBoxed Point) res
    touchManagedPtr a
    touchManagedPtr b
    return res'

#if defined(ENABLE_OVERLOADING)
data PointInterpolateMethodInfo
instance (signature ~ (Point -> Double -> m (Point)), MonadIO m) => O.OverloadedMethod PointInterpolateMethodInfo Point signature where
    overloadedMethod = pointInterpolate

instance O.OverloadedMethodInfo PointInterpolateMethodInfo Point where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point.pointInterpolate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point.html#v:pointInterpolate"
        })


#endif

-- method Point::near
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "epsilon"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "threshold between the two points"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point_near" graphene_point_near :: 
    Ptr Point ->                            -- a : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Point ->                            -- b : TInterface (Name {namespace = "Graphene", name = "Point"})
    CFloat ->                               -- epsilon : TBasicType TFloat
    IO CInt

-- | Checks whether the two points /@a@/ and /@b@/ are within
-- the threshold of /@epsilon@/.
-- 
-- /Since: 1.0/
pointNear ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point
    -- ^ /@a@/: a t'GI.Graphene.Structs.Point.Point'
    -> Point
    -- ^ /@b@/: a t'GI.Graphene.Structs.Point.Point'
    -> Float
    -- ^ /@epsilon@/: threshold between the two points
    -> m Bool
    -- ^ __Returns:__ @true@ if the distance is within /@epsilon@/
pointNear a b epsilon = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    let epsilon' = realToFrac epsilon
    result <- graphene_point_near a' b' epsilon'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data PointNearMethodInfo
instance (signature ~ (Point -> Float -> m Bool), MonadIO m) => O.OverloadedMethod PointNearMethodInfo Point signature where
    overloadedMethod = pointNear

instance O.OverloadedMethodInfo PointNearMethodInfo Point where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point.pointNear",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point.html#v:pointNear"
        })


#endif

-- method Point::to_vec2
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "v"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec2" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the vertex"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point_to_vec2" graphene_point_to_vec2 :: 
    Ptr Point ->                            -- p : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Graphene.Vec2.Vec2 ->               -- v : TInterface (Name {namespace = "Graphene", name = "Vec2"})
    IO ()

-- | Stores the coordinates of the given t'GI.Graphene.Structs.Point.Point' into a
-- t'GI.Graphene.Structs.Vec2.Vec2'.
-- 
-- /Since: 1.4/
pointToVec2 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point.Point'
    -> m (Graphene.Vec2.Vec2)
pointToVec2 p = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    v <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Vec2.Vec2)
    graphene_point_to_vec2 p' v
    v' <- (wrapBoxed Graphene.Vec2.Vec2) v
    touchManagedPtr p
    return v'

#if defined(ENABLE_OVERLOADING)
data PointToVec2MethodInfo
instance (signature ~ (m (Graphene.Vec2.Vec2)), MonadIO m) => O.OverloadedMethod PointToVec2MethodInfo Point signature where
    overloadedMethod = pointToVec2

instance O.OverloadedMethodInfo PointToVec2MethodInfo Point where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point.pointToVec2",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point.html#v:pointToVec2"
        })


#endif

-- method Point::zero
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Point" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point_zero" graphene_point_zero :: 
    IO (Ptr Point)

-- | Returns a point fixed at (0, 0).
-- 
-- /Since: 1.0/
pointZero ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Point
    -- ^ __Returns:__ a fixed point
pointZero  = liftIO $ do
    result <- graphene_point_zero
    checkUnexpectedReturnNULL "pointZero" result
    result' <- (newBoxed Point) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolvePointMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePointMethod "distance" o = PointDistanceMethodInfo
    ResolvePointMethod "equal" o = PointEqualMethodInfo
    ResolvePointMethod "free" o = PointFreeMethodInfo
    ResolvePointMethod "init" o = PointInitMethodInfo
    ResolvePointMethod "initFromPoint" o = PointInitFromPointMethodInfo
    ResolvePointMethod "initFromVec2" o = PointInitFromVec2MethodInfo
    ResolvePointMethod "interpolate" o = PointInterpolateMethodInfo
    ResolvePointMethod "near" o = PointNearMethodInfo
    ResolvePointMethod "toVec2" o = PointToVec2MethodInfo
    ResolvePointMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePointMethod t Point, O.OverloadedMethod info Point p) => OL.IsLabel t (Point -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePointMethod t Point, O.OverloadedMethod info Point p, R.HasField t Point p) => R.HasField t Point p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePointMethod t Point, O.OverloadedMethodInfo info Point) => OL.IsLabel t (O.MethodProxy info Point) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


