// python wrapper for vtkPVProgressHandler
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVProgressHandler.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVProgressHandler(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVProgressHandler_ClassNew(); }


static PyObject *
PyvtkPVProgressHandler_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVProgressHandler::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVProgressHandler::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVProgressHandler *tempr = vtkPVProgressHandler::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVProgressHandler *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVProgressHandler::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVProgressHandler::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVProgressHandler::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_SetSession(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSession");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  vtkPVSession *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVSession"))
  {
    if (ap.IsBound())
    {
      op->SetSession(temp0);
    }
    else
    {
      op->vtkPVProgressHandler::SetSession(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_GetSession(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSession");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVSession *tempr = (ap.IsBound() ?
      op->GetSession() :
      op->vtkPVProgressHandler::GetSession());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_RegisterProgressEvent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterProgressEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  vtkObject *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkObject") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->RegisterProgressEvent(temp0, temp1);
    }
    else
    {
      op->vtkPVProgressHandler::RegisterProgressEvent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_PrepareProgress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PrepareProgress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PrepareProgress();
    }
    else
    {
      op->vtkPVProgressHandler::PrepareProgress();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_AddHandlers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddHandlers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AddHandlers();
    }
    else
    {
      op->vtkPVProgressHandler::AddHandlers();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_GetEnableProgress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableProgress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableProgress() :
      op->vtkPVProgressHandler::GetEnableProgress());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_CleanupPendingProgress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CleanupPendingProgress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CleanupPendingProgress();
    }
    else
    {
      op->vtkPVProgressHandler::CleanupPendingProgress();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_LocalCleanupPendingProgress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LocalCleanupPendingProgress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LocalCleanupPendingProgress();
    }
    else
    {
      op->vtkPVProgressHandler::LocalCleanupPendingProgress();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_SetProgressInterval(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProgressInterval");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetProgressInterval(temp0);
    }
    else
    {
      op->vtkPVProgressHandler::SetProgressInterval(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_GetProgressIntervalMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProgressIntervalMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetProgressIntervalMinValue() :
      op->vtkPVProgressHandler::GetProgressIntervalMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_GetProgressIntervalMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProgressIntervalMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetProgressIntervalMaxValue() :
      op->vtkPVProgressHandler::GetProgressIntervalMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_GetProgressInterval(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProgressInterval");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetProgressInterval() :
      op->vtkPVProgressHandler::GetProgressInterval());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_GetLastProgressText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastProgressText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetLastProgressText() :
      op->vtkPVProgressHandler::GetLastProgressText());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVProgressHandler_GetLastProgress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastProgress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVProgressHandler *op = static_cast<vtkPVProgressHandler *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetLastProgress() :
      op->vtkPVProgressHandler::GetLastProgress());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVProgressHandler_Methods[] = {
  {"IsTypeOf", PyvtkPVProgressHandler_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVProgressHandler_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVProgressHandler_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVProgressHandler\nC++: static vtkPVProgressHandler *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVProgressHandler_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVProgressHandler\nC++: vtkPVProgressHandler *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVProgressHandler_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVProgressHandler_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetSession", PyvtkPVProgressHandler_SetSession, METH_VARARGS,
   "SetSession(self, conn:vtkPVSession) -> None\nC++: void SetSession(vtkPVSession *conn)\n\nGet/Set the session. This is not reference-counted to avoid\ncycles.\n"},
  {"GetSession", PyvtkPVProgressHandler_GetSession, METH_VARARGS,
   "GetSession(self) -> vtkPVSession\nC++: virtual vtkPVSession *GetSession()\n\n"},
  {"RegisterProgressEvent", PyvtkPVProgressHandler_RegisterProgressEvent, METH_VARARGS,
   "RegisterProgressEvent(self, object:vtkObject, id:int) -> None\nC++: void RegisterProgressEvent(vtkObject *object, int id)\n\nListen to progress events from the object.\n"},
  {"PrepareProgress", PyvtkPVProgressHandler_PrepareProgress, METH_VARARGS,
   "PrepareProgress(self) -> None\nC++: void PrepareProgress()\n\nThis method resets all the progress counters and prepares\nprogress reporting. All progress events before this call are\nignored.\n"},
  {"AddHandlers", PyvtkPVProgressHandler_AddHandlers, METH_VARARGS,
   "AddHandlers(self) -> None\nC++: void AddHandlers()\n\nThis method add wrong tag event handlers and rmi call back for\nprogress related mathods\n"},
  {"GetEnableProgress", PyvtkPVProgressHandler_GetEnableProgress, METH_VARARGS,
   "GetEnableProgress(self) -> bool\nC++: bool GetEnableProgress()\n\nGet whether or not progress is currently enable and if this\nprogress handler is ready to receive progress events\n"},
  {"CleanupPendingProgress", PyvtkPVProgressHandler_CleanupPendingProgress, METH_VARARGS,
   "CleanupPendingProgress(self) -> None\nC++: void CleanupPendingProgress()\n\nThis method collects all outstanding progress messages. All\nprogress events after this call are ignored.\n"},
  {"LocalCleanupPendingProgress", PyvtkPVProgressHandler_LocalCleanupPendingProgress, METH_VARARGS,
   "LocalCleanupPendingProgress(self) -> None\nC++: void LocalCleanupPendingProgress()\n\nLocal cleanup of progress flags\n"},
  {"SetProgressInterval", PyvtkPVProgressHandler_SetProgressInterval, METH_VARARGS,
   "SetProgressInterval(self, _arg:float) -> None\nC++: virtual void SetProgressInterval(double _arg)\n\nGet/Set the progress interval in seconds. Progress events\noccurring more frequently than this interval are skipped. Default\nis 0.1 seconds on client and 1 second on server and batch\nprocesses.\n"},
  {"GetProgressIntervalMinValue", PyvtkPVProgressHandler_GetProgressIntervalMinValue, METH_VARARGS,
   "GetProgressIntervalMinValue(self) -> float\nC++: virtual double GetProgressIntervalMinValue()\n\n"},
  {"GetProgressIntervalMaxValue", PyvtkPVProgressHandler_GetProgressIntervalMaxValue, METH_VARARGS,
   "GetProgressIntervalMaxValue(self) -> float\nC++: virtual double GetProgressIntervalMaxValue()\n\n"},
  {"GetProgressInterval", PyvtkPVProgressHandler_GetProgressInterval, METH_VARARGS,
   "GetProgressInterval(self) -> float\nC++: virtual double GetProgressInterval()\n\n"},
  {"GetLastProgressText", PyvtkPVProgressHandler_GetLastProgressText, METH_VARARGS,
   "GetLastProgressText(self) -> str\nC++: virtual char *GetLastProgressText()\n\nThese are only valid in handler for the\nvtkCommand::ProgressEvent.\n"},
  {"GetLastProgress", PyvtkPVProgressHandler_GetLastProgress, METH_VARARGS,
   "GetLastProgress(self) -> int\nC++: virtual int GetLastProgress()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVProgressHandler_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("session"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVProgressHandler_GetSession(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVProgressHandler_SetSession(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVProgressHandler_SetSession(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSession/SetSession\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("progress_interval"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVProgressHandler_GetProgressInterval(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVProgressHandler_SetProgressInterval(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVProgressHandler_SetProgressInterval(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetProgressInterval/SetProgressInterval\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_progress_text"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVProgressHandler_GetLastProgressText(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLastProgressText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_progress"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVProgressHandler_GetEnableProgress(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEnableProgress\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_progress"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVProgressHandler_GetLastProgress(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLastProgress\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVProgressHandler_Doc =
  "vtkPVProgressHandler - progress handler.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkPVProgressHandler handles the progress messages. It handles\n"
  "progress in all configurations single process, client-server. It must\n"
  "be noted that when running in parallel, progress updates are fetched\n"
  "from the root node. Due to performance reasons, we no longer collect\n"
  "progress events (or messages) from satellites, only root-node events\n"
  "are reported back to the client. While this may not faithfully report\n"
  "the progress, this avoid nasty MPI issues that can be painful to\n"
  "debug and diagnose.\n\n"
  "Progress events are currently not supported in multi-clients mode.\n\n"
  "@par Events: vtkCommand::StartEvent\n"
  "\\li fired to indicate beginning of progress handling\n"
  "\\li calldata: vtkPVProgressHandler*\n"
  "vtkCommand::ProgressEvent\n"
  "\\li fired to indicate a progress event.\n"
  "\\li calldata: vtkPVProgressHandler*\n"
  "vtkCommand::EndEvent\n"
  "\\li fired to indicate end of progress handling\n"
  "\\li calldata: vtkPVProgressHandler*\n\n"
  "Starting ParaView 5.5, vtkCommand::MessageEvent is no longer fired.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVProgressHandler_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVProgressHandler", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVProgressHandler_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVProgressHandler_StaticNew()
{
  return vtkPVProgressHandler::New();
}

PyObject *PyvtkPVProgressHandler_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVProgressHandler_Type, PyvtkPVProgressHandler_Methods,
    "vtkPVProgressHandler",
 &PyvtkPVProgressHandler_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVProgressHandler_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVProgressHandler(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVProgressHandler_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVProgressHandler", o) != 0)
  {
    Py_DECREF(o);
  }

}

