// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: xds/core/v3/collection_entry.proto

package v3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on CollectionEntry with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *CollectionEntry) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CollectionEntry with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// CollectionEntryMultiError, or nil if none found.
func (m *CollectionEntry) ValidateAll() error {
	return m.validate(true)
}

func (m *CollectionEntry) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofResourceSpecifierPresent := false
	switch v := m.ResourceSpecifier.(type) {
	case *CollectionEntry_Locator:
		if v == nil {
			err := CollectionEntryValidationError{
				field:  "ResourceSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofResourceSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetLocator()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, CollectionEntryValidationError{
						field:  "Locator",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, CollectionEntryValidationError{
						field:  "Locator",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetLocator()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CollectionEntryValidationError{
					field:  "Locator",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *CollectionEntry_InlineEntry_:
		if v == nil {
			err := CollectionEntryValidationError{
				field:  "ResourceSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofResourceSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetInlineEntry()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, CollectionEntryValidationError{
						field:  "InlineEntry",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, CollectionEntryValidationError{
						field:  "InlineEntry",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetInlineEntry()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CollectionEntryValidationError{
					field:  "InlineEntry",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofResourceSpecifierPresent {
		err := CollectionEntryValidationError{
			field:  "ResourceSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return CollectionEntryMultiError(errors)
	}

	return nil
}

// CollectionEntryMultiError is an error wrapping multiple validation errors
// returned by CollectionEntry.ValidateAll() if the designated constraints
// aren't met.
type CollectionEntryMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CollectionEntryMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CollectionEntryMultiError) AllErrors() []error { return m }

// CollectionEntryValidationError is the validation error returned by
// CollectionEntry.Validate if the designated constraints aren't met.
type CollectionEntryValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CollectionEntryValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CollectionEntryValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CollectionEntryValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CollectionEntryValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CollectionEntryValidationError) ErrorName() string { return "CollectionEntryValidationError" }

// Error satisfies the builtin error interface
func (e CollectionEntryValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCollectionEntry.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CollectionEntryValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CollectionEntryValidationError{}

// Validate checks the field values on CollectionEntry_InlineEntry with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *CollectionEntry_InlineEntry) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CollectionEntry_InlineEntry with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// CollectionEntry_InlineEntryMultiError, or nil if none found.
func (m *CollectionEntry_InlineEntry) ValidateAll() error {
	return m.validate(true)
}

func (m *CollectionEntry_InlineEntry) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_CollectionEntry_InlineEntry_Name_Pattern.MatchString(m.GetName()) {
		err := CollectionEntry_InlineEntryValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[0-9a-zA-Z_\\\\-\\\\.~:]+$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Version

	if all {
		switch v := interface{}(m.GetResource()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CollectionEntry_InlineEntryValidationError{
					field:  "Resource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CollectionEntry_InlineEntryValidationError{
					field:  "Resource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetResource()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CollectionEntry_InlineEntryValidationError{
				field:  "Resource",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return CollectionEntry_InlineEntryMultiError(errors)
	}

	return nil
}

// CollectionEntry_InlineEntryMultiError is an error wrapping multiple
// validation errors returned by CollectionEntry_InlineEntry.ValidateAll() if
// the designated constraints aren't met.
type CollectionEntry_InlineEntryMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CollectionEntry_InlineEntryMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CollectionEntry_InlineEntryMultiError) AllErrors() []error { return m }

// CollectionEntry_InlineEntryValidationError is the validation error returned
// by CollectionEntry_InlineEntry.Validate if the designated constraints
// aren't met.
type CollectionEntry_InlineEntryValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CollectionEntry_InlineEntryValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CollectionEntry_InlineEntryValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CollectionEntry_InlineEntryValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CollectionEntry_InlineEntryValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CollectionEntry_InlineEntryValidationError) ErrorName() string {
	return "CollectionEntry_InlineEntryValidationError"
}

// Error satisfies the builtin error interface
func (e CollectionEntry_InlineEntryValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCollectionEntry_InlineEntry.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CollectionEntry_InlineEntryValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CollectionEntry_InlineEntryValidationError{}

var _CollectionEntry_InlineEntry_Name_Pattern = regexp.MustCompile("^[0-9a-zA-Z_\\-\\.~:]+$")
