﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>
#include <aws/imagebuilder/model/ComponentVersion.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace imagebuilder {
namespace Model {
class ListComponentsResult {
 public:
  AWS_IMAGEBUILDER_API ListComponentsResult() = default;
  AWS_IMAGEBUILDER_API ListComponentsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IMAGEBUILDER_API ListComponentsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The request ID that uniquely identifies this request.</p>
   */
  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListComponentsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of component semantic versions.</p>  <p>The semantic version
   * has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
   * assign values for the first three, and can filter on all of them.</p>
   */
  inline const Aws::Vector<ComponentVersion>& GetComponentVersionList() const { return m_componentVersionList; }
  template <typename ComponentVersionListT = Aws::Vector<ComponentVersion>>
  void SetComponentVersionList(ComponentVersionListT&& value) {
    m_componentVersionListHasBeenSet = true;
    m_componentVersionList = std::forward<ComponentVersionListT>(value);
  }
  template <typename ComponentVersionListT = Aws::Vector<ComponentVersion>>
  ListComponentsResult& WithComponentVersionList(ComponentVersionListT&& value) {
    SetComponentVersionList(std::forward<ComponentVersionListT>(value));
    return *this;
  }
  template <typename ComponentVersionListT = ComponentVersion>
  ListComponentsResult& AddComponentVersionList(ComponentVersionListT&& value) {
    m_componentVersionListHasBeenSet = true;
    m_componentVersionList.emplace_back(std::forward<ComponentVersionListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The next token used for paginated responses. When this field isn't empty,
   * there are additional elements that the service hasn't included in this request.
   * Use this token with the next request to retrieve additional objects.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListComponentsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;

  Aws::Vector<ComponentVersion> m_componentVersionList;
  bool m_componentVersionListHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace imagebuilder
}  // namespace Aws
