﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/detective/Detective_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Detective {
namespace Model {

/**
 * <p>Details new geolocations used either at the resource or account level. For
 * example, lists an observed geolocation that is an infrequent or unused location
 * based on previous user activity.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/NewGeolocationDetail">AWS
 * API Reference</a></p>
 */
class NewGeolocationDetail {
 public:
  AWS_DETECTIVE_API NewGeolocationDetail() = default;
  AWS_DETECTIVE_API NewGeolocationDetail(Aws::Utils::Json::JsonView jsonValue);
  AWS_DETECTIVE_API NewGeolocationDetail& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DETECTIVE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Location where the resource was accessed.</p>
   */
  inline const Aws::String& GetLocation() const { return m_location; }
  inline bool LocationHasBeenSet() const { return m_locationHasBeenSet; }
  template <typename LocationT = Aws::String>
  void SetLocation(LocationT&& value) {
    m_locationHasBeenSet = true;
    m_location = std::forward<LocationT>(value);
  }
  template <typename LocationT = Aws::String>
  NewGeolocationDetail& WithLocation(LocationT&& value) {
    SetLocation(std::forward<LocationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>IP address using which the resource was accessed.</p>
   */
  inline const Aws::String& GetIpAddress() const { return m_ipAddress; }
  inline bool IpAddressHasBeenSet() const { return m_ipAddressHasBeenSet; }
  template <typename IpAddressT = Aws::String>
  void SetIpAddress(IpAddressT&& value) {
    m_ipAddressHasBeenSet = true;
    m_ipAddress = std::forward<IpAddressT>(value);
  }
  template <typename IpAddressT = Aws::String>
  NewGeolocationDetail& WithIpAddress(IpAddressT&& value) {
    SetIpAddress(std::forward<IpAddressT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Checks if the geolocation is new for the entire account.</p>
   */
  inline bool GetIsNewForEntireAccount() const { return m_isNewForEntireAccount; }
  inline bool IsNewForEntireAccountHasBeenSet() const { return m_isNewForEntireAccountHasBeenSet; }
  inline void SetIsNewForEntireAccount(bool value) {
    m_isNewForEntireAccountHasBeenSet = true;
    m_isNewForEntireAccount = value;
  }
  inline NewGeolocationDetail& WithIsNewForEntireAccount(bool value) {
    SetIsNewForEntireAccount(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_location;

  Aws::String m_ipAddress;

  bool m_isNewForEntireAccount{false};
  bool m_locationHasBeenSet = false;
  bool m_ipAddressHasBeenSet = false;
  bool m_isNewForEntireAccountHasBeenSet = false;
};

}  // namespace Model
}  // namespace Detective
}  // namespace Aws
