/*
 * Decompiled with CFR 0.152.
 */
package app.f3d.F3D;

import java.util.List;

public class Interactor {
    private long mNativeAddress;

    Interactor(long l) {
        this.mNativeAddress = l;
    }

    public native Interactor initCommands();

    public native Interactor addCommand(String var1, CommandCallback var2);

    public native Interactor removeCommand(String var1);

    public native List<String> getCommandActions();

    public native boolean triggerCommand(String var1, boolean var2);

    public boolean triggerCommand(String string) {
        return this.triggerCommand(string, true);
    }

    public native Interactor initBindings();

    private native Interactor addBindingCommands(InteractionBind var1, List<String> var2, String var3, BindingType var4);

    public Interactor addBinding(InteractionBind interactionBind, List<String> list, String string, BindingType bindingType) {
        return this.addBindingCommands(interactionBind, list, string, bindingType);
    }

    public Interactor addBinding(InteractionBind interactionBind, List<String> list) {
        return this.addBindingCommands(interactionBind, list, "", BindingType.OTHER);
    }

    private native Interactor addBindingCommand(InteractionBind var1, String var2, String var3, BindingType var4);

    public Interactor addBinding(InteractionBind interactionBind, String string, String string2, BindingType bindingType) {
        return this.addBindingCommand(interactionBind, string, string2, bindingType);
    }

    public Interactor addBinding(InteractionBind interactionBind, String string) {
        return this.addBindingCommand(interactionBind, string, "", BindingType.OTHER);
    }

    public native Interactor removeBinding(InteractionBind var1);

    public native List<String> getBindGroups();

    public native List<InteractionBind> getBindsForGroup(String var1);

    public native List<InteractionBind> getBinds();

    public native BindingDocumentation getBindingDocumentation(InteractionBind var1);

    public native BindingType getBindingType(InteractionBind var1);

    public native Interactor toggleAnimation(AnimationDirection var1);

    public Interactor toggleAnimation() {
        return this.toggleAnimation(AnimationDirection.FORWARD);
    }

    public native Interactor startAnimation(AnimationDirection var1);

    public Interactor startAnimation() {
        return this.startAnimation(AnimationDirection.FORWARD);
    }

    public native Interactor stopAnimation();

    public native boolean isPlayingAnimation();

    public native AnimationDirection getAnimationDirection();

    public native Interactor enableCameraMovement();

    public native Interactor disableCameraMovement();

    public native Interactor triggerModUpdate(InputModifier var1);

    public native Interactor triggerMouseButton(InputAction var1, MouseButton var2);

    public native Interactor triggerMousePosition(double var1, double var3);

    public native Interactor triggerMouseWheel(WheelDirection var1);

    public native Interactor triggerKeyboardKey(InputAction var1, String var2);

    public native Interactor triggerTextCharacter(int var1);

    public native Interactor triggerEventLoop(double var1);

    public native boolean playInteraction(String var1, double var2);

    public boolean playInteraction(String string) {
        return this.playInteraction(string, 0.03333333333333333);
    }

    public native boolean recordInteraction(String var1);

    public native Interactor start(double var1);

    public Interactor start() {
        return this.start(0.03333333333333333);
    }

    public native Interactor stop();

    public native Interactor requestRender();

    public native Interactor requestStop();

    public static class InteractionBind
    implements Comparable<InteractionBind> {
        public ModifierKeys mod;
        public String inter;

        public InteractionBind() {
            this.mod = ModifierKeys.NONE;
            this.inter = "";
        }

        public InteractionBind(ModifierKeys modifierKeys, String string) {
            this.mod = modifierKeys;
            this.inter = string;
        }

        public String format() {
            switch (this.mod.ordinal()) {
                case 4: {
                    return "Ctrl+Shift+" + this.inter;
                }
                case 2: {
                    return "Ctrl+" + this.inter;
                }
                case 3: {
                    return "Shift+" + this.inter;
                }
                case 0: {
                    return "Any+" + this.inter;
                }
            }
            return this.inter;
        }

        public static InteractionBind parse(String string) {
            InteractionBind interactionBind = new InteractionBind();
            int n = string.lastIndexOf(43);
            if (n == -1) {
                interactionBind.inter = string;
            } else {
                interactionBind.inter = string.substring(n + 1);
                String string2 = string.substring(0, n);
                if (string2.equals("Ctrl+Shift")) {
                    interactionBind.mod = ModifierKeys.CTRL_SHIFT;
                } else if (string2.equals("Shift")) {
                    interactionBind.mod = ModifierKeys.SHIFT;
                } else if (string2.equals("Ctrl")) {
                    interactionBind.mod = ModifierKeys.CTRL;
                } else if (string2.equals("Any")) {
                    interactionBind.mod = ModifierKeys.ANY;
                } else if (string2.equals("None")) {
                    interactionBind.mod = ModifierKeys.NONE;
                }
            }
            return interactionBind;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            InteractionBind interactionBind = (InteractionBind)object;
            return this.mod == interactionBind.mod && this.inter.equals(interactionBind.inter);
        }

        @Override
        public int compareTo(InteractionBind interactionBind) {
            if (this.mod != interactionBind.mod) {
                return this.mod.compareTo(interactionBind.mod);
            }
            return this.inter.compareTo(interactionBind.inter);
        }
    }

    public static enum BindingType {
        CYCLIC,
        NUMERICAL,
        TOGGLE,
        OTHER;

    }

    public static enum AnimationDirection {
        FORWARD(0),
        BACKWARD(1);

        private final int value;

        private AnimationDirection(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public static AnimationDirection fromValue(int n) {
            for (AnimationDirection animationDirection : AnimationDirection.values()) {
                if (animationDirection.value != n) continue;
                return animationDirection;
            }
            throw new IllegalArgumentException("Invalid AnimationDirection value: " + n);
        }
    }

    public static interface CommandCallback {
        public void execute(List<String> var1);
    }

    public static class BindingDocumentation {
        public String documentation;
        public String currentValue;

        public BindingDocumentation(String string, String string2) {
            this.documentation = string;
            this.currentValue = string2;
        }
    }

    public static enum InputModifier {
        NONE,
        CTRL,
        SHIFT,
        CTRL_SHIFT;

    }

    public static enum InputAction {
        PRESS,
        RELEASE;

    }

    public static enum WheelDirection {
        FORWARD,
        BACKWARD,
        LEFT,
        RIGHT;

    }

    public static enum MouseButton {
        LEFT,
        RIGHT,
        MIDDLE;

    }

    public static enum ModifierKeys {
        ANY,
        NONE,
        CTRL,
        SHIFT,
        CTRL_SHIFT;

    }
}

