/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.Serializable;
import org.gradle.api.file.RelativePath;

public class RelativeFile
implements Serializable {
    private final File file;
    private final RelativePath relativePath;

    public RelativeFile(File file, RelativePath relativePath) {
        this.file = file;
        this.relativePath = relativePath;
    }

    public File getFile() {
        return this.file;
    }

    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    public File getBaseDir() {
        if (this.file == null || this.relativePath == null) {
            return null;
        }
        int relativeSegments = this.relativePath.getSegments().length;
        File parentFile = this.file;
        for (int i = 0; i < relativeSegments; ++i) {
            parentFile = parentFile.getParentFile();
        }
        return parentFile;
    }
}

