/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.wrapper.internal;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.DistributionLocator;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public class GradleVersionResolver {
    private final TextResourceFactory textResourceFactory;
    private @Nullable GradleVersion gradleVersion;
    private GradleVersionRequest gradleVersionRequest = new GradleVersionRequest(GradleVersion.current());

    public GradleVersionResolver(TextResourceFactory textResourceFactory) {
        this.textResourceFactory = textResourceFactory;
    }

    public GradleVersion getGradleVersion() {
        if (this.gradleVersion == null) {
            this.gradleVersion = this.resolve();
        }
        return this.gradleVersion;
    }

    public void setGradleVersionRequest(String request) {
        GradleVersionRequest gradleVersionRequest = new GradleVersionRequest(request);
        if (gradleVersionRequest.requestType == RequestType.VERSION) {
            this.gradleVersion = GradleVersionResolver.parseVersionString(request);
        } else if (!Objects.equals(this.gradleVersionRequest, gradleVersionRequest)) {
            this.gradleVersion = null;
            this.gradleVersionRequest = gradleVersionRequest;
        }
    }

    private GradleVersion resolve() {
        switch (this.gradleVersionRequest.requestType) {
            case DYNAMIC_VERSION: {
                String version = this.getSingleVersion(this.gradleVersionRequest.dynamicVersion);
                return GradleVersion.version((String)version);
            }
            case SEMANTIC_VERSION: {
                return this.resolveSemanticVersion(this.gradleVersionRequest.majorVersion, this.gradleVersionRequest.minorVersion);
            }
            case VERSION: {
                return GradleVersion.version((String)this.gradleVersionRequest.request);
            }
        }
        throw new IllegalArgumentException("Unknown request type: " + (Object)((Object)this.gradleVersionRequest.requestType));
    }

    private GradleVersion resolveSemanticVersion(Integer majorVersion, @Nullable Integer minorVersion) {
        Stream<GradleVersion> versions = this.getVersionsList(majorVersion.toString()).stream().map(v -> {
            try {
                return GradleVersion.version((String)v);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).filter(v -> v.isFinal() && v.getMajorVersion() == majorVersion.intValue());
        if (minorVersion == null) {
            return versions.max(GradleVersion::compareTo).orElseThrow(() -> new WrapperVersionException("Invalid version specified for argument '--gradle-version': no final version found for major version " + majorVersion, null));
        }
        return versions.filter(v -> GradleVersionResolver.getMinorVersion(v) == minorVersion).max(GradleVersion::compareTo).orElseThrow(() -> new WrapperVersionException("Invalid version specified for argument '--gradle-version': no final version found for version " + majorVersion + "." + minorVersion, null));
    }

    private static int getMinorVersion(GradleVersion version) {
        String[] versionParts = version.getBaseVersion().getVersion().split("\\.");
        if (versionParts.length > 1) {
            return Integer.parseInt(versionParts[1]);
        }
        return 0;
    }

    private String getApiEndpoint(String request) {
        return DistributionLocator.getBaseUrl() + "/versions/" + request;
    }

    private String getSingleVersion(DynamicVersion dynamicVersion) {
        try {
            return GradleVersionResolver.getVersion(this.textResourceFactory.fromUri((Object)this.getApiEndpoint(dynamicVersion.urlSuffix)).asString(), dynamicVersion.name);
        }
        catch (MissingResourceException e) {
            throw new WrapperVersionException("Unable to resolve Gradle version for '" + dynamicVersion.name + "'.", null);
        }
    }

    private List<String> getVersionsList(String majorVersion) {
        try {
            return GradleVersionResolver.getVersions(this.textResourceFactory.fromUri((Object)this.getApiEndpoint(majorVersion)).asString());
        }
        catch (MissingResourceException e) {
            throw new WrapperVersionException("Unable to resolve list of Gradle versions for '" + majorVersion + "'.", null);
        }
    }

    static String getVersion(String json, String request) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map map = (Map)new Gson().fromJson(json, type);
        String version = (String)map.get("version");
        if (version == null) {
            throw new GradleException("There is currently no version information available for '" + request + "'.");
        }
        return version;
    }

    static List<String> getVersions(String json) {
        Type type = new TypeToken<List<Map<String, String>>>(){}.getType();
        List map = (List)new Gson().fromJson(json, type);
        return map.stream().map(m -> (String)m.get("version")).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static GradleVersion parseVersionString(String gradleVersionString) {
        try {
            return GradleVersion.version((String)gradleVersionString);
        }
        catch (Exception e) {
            throw new WrapperVersionException("Invalid version specified for argument '--gradle-version'", e);
        }
    }

    @NullMarked
    private static class GradleVersionRequest {
        final String request;
        final RequestType requestType;
        @Nullable DynamicVersion dynamicVersion = null;
        @Nullable Integer majorVersion;
        @Nullable Integer minorVersion;
        private static final Pattern SEMVER_REQUEST = Pattern.compile("([0-9]+)(\\.([0-9]+))?");

        GradleVersionRequest(String request) {
            this.request = request;
            DynamicVersion dynamicVersion = DynamicVersion.findMatch(request);
            if (dynamicVersion != null) {
                this.requestType = RequestType.DYNAMIC_VERSION;
                this.dynamicVersion = dynamicVersion;
            } else {
                Matcher matcher = SEMVER_REQUEST.matcher(request);
                if (matcher.matches()) {
                    this.majorVersion = Integer.parseInt(matcher.group(1));
                    Integer n = this.minorVersion = matcher.group(3) != null ? Integer.valueOf(Integer.parseInt(matcher.group(3))) : null;
                    this.requestType = this.majorVersion >= 9 ? RequestType.SEMANTIC_VERSION : RequestType.VERSION;
                } else {
                    this.requestType = RequestType.VERSION;
                }
            }
        }

        GradleVersionRequest(GradleVersion gradleVersion) {
            this.request = gradleVersion.getVersion();
            this.requestType = RequestType.VERSION;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GradleVersionRequest)) {
                return false;
            }
            return Objects.equals(this.request, ((GradleVersionRequest)other).request);
        }

        public int hashCode() {
            return Objects.hashCode(this.request);
        }
    }

    @NullMarked
    private static enum RequestType {
        DYNAMIC_VERSION,
        SEMANTIC_VERSION,
        VERSION;

    }

    private static enum DynamicVersion {
        LATEST("latest", "current"),
        RELEASE_CANDIDATE("release-candidate", "release-candidate"),
        RELEASE_MILESTONE("release-milestone", "milestone"),
        RELEASE_NIGHTLY("release-nightly", "release-nightly"),
        NIGHTLY("nightly", "nightly");

        private final String name;
        private final String urlSuffix;

        private DynamicVersion(String name, String urlSuffix) {
            this.name = name;
            this.urlSuffix = urlSuffix;
        }

        public static @Nullable DynamicVersion findMatch(String version) {
            return Arrays.stream(DynamicVersion.values()).filter(dv -> dv.name.equals(version)).findFirst().orElse(null);
        }
    }

    public static final class WrapperVersionException
    extends GradleException
    implements ResolutionProvider {
        public WrapperVersionException(String message, @Nullable Throwable cause) {
            super(message, cause);
        }

        public List<String> getResolutions() {
            return Arrays.asList(WrapperVersionException.suggestActualVersion(), WrapperVersionException.suggestDynamicVersions());
        }

        private static String suggestActualVersion() {
            return "Specify a valid Gradle release listed on https://gradle.org/releases/.";
        }

        private static String suggestDynamicVersions() {
            String validStrings = Arrays.stream(DynamicVersion.values()).map(dv -> ((DynamicVersion)dv).name).map(s -> String.format("'%s'", s)).collect(Collectors.joining(", "));
            return String.format("Use one of the following dynamic version specifications: %s.", validStrings);
        }
    }
}

