/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonIntrospectionStrategy;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.introspection.IntrospectionError;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;

public abstract class ComparingNormalizedFields
implements RecursiveComparisonIntrospectionStrategy {
    private static final String NO_FIELD_FOUND = "Unable to find field in %s, fields tried: %s and %s";
    private final Map<Class<?>, Map<String, String>> originalFieldNameByNormalizedFieldNameByType = new ConcurrentHashMap();
    private final Map<Class<?>, Set<String>> fieldNamesPerClass = new ConcurrentHashMap();

    @Override
    public Set<String> getChildrenNodeNamesOf(Object node) {
        if (node == null) {
            return new HashSet<String>();
        }
        Class<?> nodeClass = node.getClass();
        Set<String> fieldsNames = Objects.getFieldsNames(nodeClass);
        return this.fieldNamesPerClass.computeIfAbsent(nodeClass, unused -> fieldsNames.stream().map(fieldsName -> this.normalize(nodeClass, (String)fieldsName)).collect(Collectors.toSet()));
    }

    protected abstract String normalizeFieldName(String var1);

    private String normalize(Class<?> nodeClass, String fieldName) {
        if (!this.originalFieldNameByNormalizedFieldNameByType.containsKey(nodeClass)) {
            this.originalFieldNameByNormalizedFieldNameByType.put(nodeClass, new HashMap());
        }
        String normalizedFieldName = this.normalizeFieldName(fieldName);
        this.originalFieldNameByNormalizedFieldNameByType.get(nodeClass).put(normalizedFieldName, fieldName);
        return normalizedFieldName;
    }

    @Override
    public Object getChildNodeValue(String fieldName, Object instance) {
        try {
            return PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, instance);
        }
        catch (Exception e) {
            String originalFieldName = this.getOriginalFieldName(fieldName, instance);
            try {
                return PropertyOrFieldSupport.COMPARISON.getSimpleValue(originalFieldName, instance);
            }
            catch (Exception ex) {
                throw new IntrospectionError(NO_FIELD_FOUND.formatted(instance, fieldName, originalFieldName), ex);
            }
        }
    }

    private String getOriginalFieldName(String fieldName, Object instance) {
        Class<?> instanceClass = instance.getClass();
        if (!this.originalFieldNameByNormalizedFieldNameByType.containsKey(instanceClass)) {
            this.getChildrenNodeNamesOf(instance);
        }
        return this.originalFieldNameByNormalizedFieldNameByType.get(instanceClass).get(fieldName);
    }

    @Override
    public String getDescription() {
        return "comparing normalized fields";
    }
}

