/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class SelectAllUtils {
    public static final String CLIENT_PROPERTY_ONLYONCE = "SelectAll.onlyOnce";
    private static FocusListener SELECT_ALL = new FocusAdapter(){

        @Override
        public void focusGained(final FocusEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object object = e.getSource();
                    if (object instanceof JTextComponent) {
                        ((JTextComponent)object).selectAll();
                        Object clientProperty = ((JTextComponent)object).getClientProperty(SelectAllUtils.CLIENT_PROPERTY_ONLYONCE);
                        if (Boolean.TRUE.equals(clientProperty)) {
                            ((JTextComponent)object).removeFocusListener(SELECT_ALL);
                        }
                    } else if (object instanceof Component) {
                        JideSwingUtilities.setRecursively((Component)object, new JideSwingUtilities.Handler(){

                            @Override
                            public boolean condition(Component c) {
                                return c instanceof JTextComponent;
                            }

                            @Override
                            public void action(Component c) {
                                ((JTextComponent)c).selectAll();
                                Object clientProperty = ((JTextComponent)c).getClientProperty(SelectAllUtils.CLIENT_PROPERTY_ONLYONCE);
                                if (Boolean.TRUE.equals(clientProperty)) {
                                    c.removeFocusListener(SELECT_ALL);
                                }
                            }

                            @Override
                            public void postAction(Component c) {
                            }
                        });
                    }
                }
            });
        }
    };

    public static void install(Component component) {
        SelectAllUtils.install(component, true);
    }

    public static void install(Component component, final boolean onlyOnce) {
        if (component instanceof JTextComponent) {
            if (onlyOnce) {
                ((JTextComponent)component).putClientProperty(CLIENT_PROPERTY_ONLYONCE, Boolean.TRUE);
            }
            component.addFocusListener(SELECT_ALL);
        } else {
            JideSwingUtilities.setRecursively(component, new JideSwingUtilities.Handler(){

                @Override
                public boolean condition(Component c) {
                    return c instanceof JTextComponent;
                }

                @Override
                public void action(Component c) {
                    if (onlyOnce) {
                        ((JTextComponent)c).putClientProperty(SelectAllUtils.CLIENT_PROPERTY_ONLYONCE, Boolean.TRUE);
                    }
                    c.addFocusListener(SELECT_ALL);
                }

                @Override
                public void postAction(Component c) {
                }
            });
        }
    }

    public static void uninstall(Component component) {
        if (component instanceof JTextComponent) {
            component.removeFocusListener(SELECT_ALL);
        } else {
            JideSwingUtilities.setRecursively(component, new JideSwingUtilities.Handler(){

                @Override
                public boolean condition(Component c) {
                    return c instanceof JTextComponent;
                }

                @Override
                public void action(Component c) {
                    c.removeFocusListener(SELECT_ALL);
                }

                @Override
                public void postAction(Component c) {
                }
            });
        }
    }
}

