/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.listener;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumnModel;
import mediathek.config.MVConfig;
import mediathek.tool.table.MVTable;
import org.jetbrains.annotations.NotNull;

public class BeobTableHeader
extends MouseAdapter {
    protected final MVTable tabelle;
    private final String[] columns;
    private final boolean[] spaltenAnzeigen;
    private final int[] hiddenColumns;
    private final int[] button;
    private final boolean displaySenderIconMenus;
    private final MVConfig.Configs configKey;
    private JCheckBoxMenuItem[] box;

    public BeobTableHeader(@NotNull MVTable tabelle, boolean[] spalten, int[] hiddenColumns, int[] bbutton, boolean displaySenderIconMenus, MVConfig.Configs configKey) {
        this.tabelle = tabelle;
        this.displaySenderIconMenus = displaySenderIconMenus;
        this.spaltenAnzeigen = spalten;
        this.hiddenColumns = hiddenColumns;
        this.configKey = configKey;
        this.button = bbutton;
        TableColumnModel colModel = tabelle.getTableHeader().getColumnModel();
        int colCount = colModel.getColumnCount();
        this.columns = new String[colCount];
        for (int index = 0; index < colCount; ++index) {
            this.columns[index] = (String)colModel.getColumn(index).getHeaderValue();
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.showMenu(arg0);
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.showMenu(arg0);
        }
    }

    private boolean immer(int i) {
        for (int ii : this.hiddenColumns) {
            if (i != ii) continue;
            return true;
        }
        return false;
    }

    protected void toggleButtonVisibility(boolean isSelected) {
        for (int i : this.button) {
            this.setSpalten(i, isSelected);
        }
    }

    protected void toggleSenderIconDisplay(boolean isSelected) {
        this.tabelle.setShowIcon(isSelected);
        this.setSpalten();
    }

    protected JPopupMenu prepareMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.box = new JCheckBoxMenuItem[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.immer(i)) continue;
            this.box[i] = new JCheckBoxMenuItem(this.columns[i]);
            this.box[i].setSelected(this.anzeigen(i));
            this.box[i].addActionListener(e -> this.setSpalten());
            jPopupMenu.add(this.box[i]);
        }
        if (this.button.length > 0) {
            jPopupMenu.addSeparator();
            JCheckBoxMenuItem item2 = new JCheckBoxMenuItem("Buttons anzeigen");
            item2.setSelected(this.anzeigen(this.button[0]));
            item2.addActionListener(e -> this.toggleButtonVisibility(item2.isSelected()));
            jPopupMenu.add(item2);
        }
        if (this.displaySenderIconMenus) {
            jPopupMenu.addSeparator();
            JCheckBoxMenuItem item3 = new JCheckBoxMenuItem("Sendericons anzeigen");
            item3.setSelected(this.tabelle.showSenderIcons());
            item3.addActionListener(e -> this.toggleSenderIconDisplay(item3.isSelected()));
            jPopupMenu.add(item3);
            JCheckBoxMenuItem item2 = new JCheckBoxMenuItem("kleine Sendericons anzeigen");
            item2.setSelected(this.tabelle.useSmallSenderIcons);
            if (!this.tabelle.showSenderIcons()) {
                item2.setEnabled(false);
            } else {
                item2.addActionListener(e -> {
                    this.tabelle.useSmallSenderIcons = item2.isSelected();
                    this.setSpalten();
                });
            }
            jPopupMenu.add(item2);
        }
        jPopupMenu.addSeparator();
        if (this.configKey != null) {
            JCheckBoxMenuItem itemBr = new JCheckBoxMenuItem("Zeilen umbrechen");
            itemBr.setSelected(this.tabelle.isLineBreak());
            itemBr.addActionListener(e -> {
                this.tabelle.setLineBreak(itemBr.isSelected());
                MVConfig.add(this.configKey, Boolean.toString(itemBr.isSelected()));
                this.setSpalten();
            });
            jPopupMenu.add(itemBr);
            jPopupMenu.addSeparator();
        }
        JMenuItem miResetColumns = new JMenuItem("Spalten zur\u00fccksetzen");
        miResetColumns.addActionListener(e -> this.tabelle.resetTabelle());
        jPopupMenu.add(miResetColumns);
        return jPopupMenu;
    }

    private void showMenu(MouseEvent evt) {
        JPopupMenu popupMenu = this.prepareMenu();
        popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private boolean anzeigen(int i) {
        return this.spaltenAnzeigen == null || this.spaltenAnzeigen[i];
    }

    private void setSpalten() {
        for (int i = 0; i < this.box.length; ++i) {
            if (this.box[i] == null) continue;
            this.spaltenAnzeigen[i] = this.box[i].isSelected();
        }
        this.tabelle.spaltenEinAus();
        this.tabelle.calculateRowHeight();
    }

    protected void setSpalten(int k, boolean anz) {
        this.spaltenAnzeigen[k] = anz;
        this.tabelle.spaltenEinAus();
    }
}

